/*
 * Decompiled with CFR 0.152.
 */
package com.ankushgrover.superlog;

import com.ankushgrover.superlog.ContextWrapper;
import com.ankushgrover.superlog.SuperLog;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class LogCatThread
extends Thread {
    private static final String processId = Integer.toString(android.os.Process.myPid());
    private final ContextWrapper wrapper;

    public LogCatThread(ContextWrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public void run() {
        super.run();
        try {
            String[] commands = new String[]{"logcat", "-v", "tag"};
            Process process = Runtime.getRuntime().exec(commands);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while (!this.isInterrupted()) {
                String line;
                while ((line = bufferedReader.readLine()) != null && !line.isEmpty()) {
                    SuperLog.log(this.getType(line), line, this.wrapper);
                }
                System.gc();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getType(String log) {
        switch (log.charAt(0)) {
            case 'D': {
                return 0;
            }
            case 'E': {
                return 1;
            }
            case 'W': {
                return 2;
            }
            case 'V': {
                return 3;
            }
            case 'I': {
                return 5;
            }
        }
        return 0;
    }
}

