/*
 * Decompiled with CFR 0.152.
 */
package com.ankushgrover.superlog.utils;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewAnimationUtils;
import com.ankushgrover.superlog.R;
import com.ankushgrover.superlog.SuperLog;
import com.ankushgrover.superlog.constants.SuperLogConstants;
import com.ankushgrover.superlog.constants.Type;
import java.io.InputStream;
import java.util.Properties;

public class Utils
implements SuperLogConstants {
    public static boolean isEmpty(String string) {
        return TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string.trim()) || "null".contentEquals(string.trim());
    }

    public static String getLogString(@NonNull String tag, @NonNull String message, @NonNull String timeStamp) {
        return String.format("%s %s: %s", timeStamp, tag, message);
    }

    public static String getLogStringForMail(@NonNull String tag, @NonNull String message, @NonNull String timeStamp, int type) {
        return String.format("%s %s/%s: %s \n", timeStamp, Character.valueOf(Utils.getLogType(type).getText().charAt(0)), tag, message);
    }

    public static Type getLogType(int type) {
        switch (type) {
            case 0: 
            case 4: {
                return new Type(R.color.debug, "DEBUG");
            }
            case 1: {
                return new Type(R.color.error, "ERROR");
            }
            case 3: {
                return new Type(R.color.verbose, "VERBOSE");
            }
            case 2: {
                return new Type(R.color.warn, "WARN");
            }
            case 5: {
                return new Type(R.color.info, "INFO");
            }
        }
        return new Type(R.color.verbose, "VERBOSE");
    }

    public static String[] getCredentials(Context context) {
        Properties properties = new Properties();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream stream = loader.getResourceAsStream("/temp.properties");
        try {
            properties.load(stream);
            String email = properties.getProperty("emailId");
            String pass = properties.getProperty("password");
            return new String[]{email, pass};
        }
        catch (Exception e) {
            e.printStackTrace();
            SuperLog.e("Error Fetching properties", "FAILED");
            return new String[]{"hello", "world"};
        }
    }

    public static void manageViewVisibility(final View v, final boolean makeVisible) {
        if (makeVisible) {
            v.setVisibility(0);
        }
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)v, (String)"alpha", (float[])new float[]{makeVisible ? 0.0f : 1.0f, makeVisible ? 1.0f : 0.0f});
        animator.setDuration(300L);
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (!makeVisible) {
                    v.setVisibility(8);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animator.start();
    }

    public static void manageViewVisibilityReveal(final View v, boolean makeVisible) {
        int cx = v.getWidth() / 2;
        int cy = v.getHeight() / 2;
        float radius = (float)Math.hypot(cx, cy);
        Animator anim = null;
        if (Build.VERSION.SDK_INT >= 21) {
            if (makeVisible) {
                anim = ViewAnimationUtils.createCircularReveal((View)v, (int)cx, (int)cy, (float)0.0f, (float)radius);
                v.setVisibility(0);
            } else {
                anim = ViewAnimationUtils.createCircularReveal((View)v, (int)cx, (int)cy, (float)radius, (float)0.0f);
                anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        v.setVisibility(8);
                    }
                });
            }
            anim.start();
        } else {
            Utils.manageViewVisibility(v, makeVisible);
        }
    }
}

