/*
 * Decompiled with CFR 0.152.
 */
package com.ankushgrover.superlog.db.helpers;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.content.LocalBroadcastManager;
import com.ankushgrover.superlog.SuperLog;
import com.ankushgrover.superlog.constants.SuperLogConstants;
import com.ankushgrover.superlog.db.DbHelper;
import com.ankushgrover.superlog.db.listener.DataLoadListener;
import com.ankushgrover.superlog.model.SuperLogModel;
import com.ankushgrover.superlog.utils.TimeUtils;
import com.ankushgrover.superlog.utils.Utils;
import java.util.ArrayList;

public class SuperLogDbHelper
implements SuperLogConstants {
    public static final int INSERT_LOG = 100;
    public static final int GET_ALL_LOGS = 101;
    public static final int GET_ALL_LOGS_FOR_MAIL = 102;
    private static SuperLogDbHelper mInstance;

    public static synchronized SuperLogDbHelper getInstance() {
        if (mInstance == null) {
            mInstance = new SuperLogDbHelper();
        }
        return mInstance;
    }

    private synchronized void insert(SuperLogModel log) {
        log.setTimestamp(TimeUtils.getTimeStamp());
        ContentValues values = new ContentValues();
        values.put("tag", log.getTag());
        values.put("message", log.getMessage());
        values.put("type", Integer.valueOf(log.getType()));
        values.put("timeStamp", log.getTimestamp());
        DbHelper.getInstance().getWritableDatabase().insert("SuperLogTable", null, values);
        this.sendBroadcast("actionLogInserted", log);
    }

    private synchronized ArrayList<SuperLogModel> getLogs() {
        ArrayList<SuperLogModel> logs = new ArrayList<SuperLogModel>();
        Cursor cursor = DbHelper.getInstance().getReadableDatabase().query("SuperLogTable", null, null, null, null, null, null);
        while (cursor.moveToNext()) {
            SuperLogModel log = new SuperLogModel();
            log.setTimestamp(cursor.getString(cursor.getColumnIndex("timeStamp")));
            log.setTag(cursor.getString(cursor.getColumnIndex("tag")));
            log.setMessage(cursor.getString(cursor.getColumnIndex("message")));
            log.setType(cursor.getInt(cursor.getColumnIndex("type")));
            logs.add(log);
        }
        cursor.close();
        return logs;
    }

    private synchronized String getLogsString(boolean forMail) {
        String logs = "";
        Cursor cursor = DbHelper.getInstance().getReadableDatabase().query("SuperLogTable", null, null, null, null, null, null);
        while (cursor.moveToNext()) {
            SuperLogModel log = new SuperLogModel();
            log.setTimestamp(cursor.getString(cursor.getColumnIndex("timeStamp")));
            log.setTag(cursor.getString(cursor.getColumnIndex("tag")));
            log.setMessage(cursor.getString(cursor.getColumnIndex("message")));
            log.setType(cursor.getInt(cursor.getColumnIndex("type")));
            logs = logs + Utils.getLogStringForMail(log.getTag(), log.getMessage(), log.getTimestamp(), log.getType());
        }
        cursor.close();
        if (forMail) {
            if (!Utils.isEmpty(logs)) {
                String deviceInfo = "Device: " + Build.BRAND + " " + Build.MODEL + "\nOS Version: " + Build.VERSION.RELEASE + "\n\n";
                logs = deviceInfo + logs;
            }
            DbHelper.getInstance().clear();
        }
        return logs;
    }

    private void sendBroadcast(String action, SuperLogModel log) {
        Intent intent = new Intent(action);
        intent.putExtra("log", (Parcelable)log);
        LocalBroadcastManager.getInstance((Context)SuperLog.getBuilder().getContext()).sendBroadcast(intent);
    }

    public void perform(int taskId, Bundle bundle, DataLoadListener<Object> listener) {
        new LogAsyncTask(taskId, bundle, listener);
    }

    private class LogAsyncTask
    extends AsyncTask<Void, Void, Object> {
        private final int taskId;
        private final Bundle bundle;
        private final DataLoadListener<Object> listener;

        LogAsyncTask(int taskId, Bundle bundle, DataLoadListener<Object> listener) {
            this.taskId = taskId;
            this.bundle = bundle;
            this.listener = listener;
            this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }

        protected Object doInBackground(Void ... voids) {
            switch (this.taskId) {
                case 100: {
                    SuperLogModel log = (SuperLogModel)this.bundle.getParcelable("log");
                    SuperLogDbHelper.this.insert(log);
                    break;
                }
                case 101: {
                    return SuperLogDbHelper.this.getLogs();
                }
                case 102: {
                    return SuperLogDbHelper.this.getLogsString(true);
                }
            }
            return null;
        }

        protected void onPostExecute(Object o) {
            super.onPostExecute(o);
            this.listener.onDataLoaded(o, this.taskId);
        }
    }
}

