/*
 * Decompiled with CFR 0.152.
 */
package com.ankushgrover.superlog;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.Log;
import com.ankushgrover.superlog.R;
import com.ankushgrover.superlog.constants.SuperLogConstants;
import com.ankushgrover.superlog.db.helpers.SuperLogDbHelper;
import com.ankushgrover.superlog.db.listener.DataLoadListener;
import com.ankushgrover.superlog.mail.GMailSender;
import com.ankushgrover.superlog.model.SuperLogModel;
import com.ankushgrover.superlog.utils.NetworkUtils;
import com.ankushgrover.superlog.utils.Utils;

public class SuperLog
implements SuperLogConstants {
    private static Builder BUILDER;

    public static void d(@NonNull String tag, @NonNull String msg) {
        Log.d((String)tag, (String)msg);
        SuperLog.log(0, tag, msg);
    }

    public static void e(@NonNull String tag, @NonNull String msg) {
        Log.e((String)tag, (String)msg);
        SuperLog.log(1, tag, msg);
    }

    public static void w(@NonNull String tag, @NonNull String msg) {
        Log.w((String)tag, (String)msg);
        SuperLog.log(2, tag, msg);
    }

    public static void v(@NonNull String tag, @NonNull String msg) {
        Log.v((String)tag, (String)msg);
        SuperLog.log(3, tag, msg);
    }

    public static void i(@NonNull String tag, @NonNull String msg) {
        Log.i((String)tag, (String)msg);
        SuperLog.log(5, tag, msg);
    }

    public static void log(@NonNull String msg) {
        Log.v((String)SuperLog.class.getSimpleName(), (String)msg);
        SuperLog.log(4, SuperLog.class.getSimpleName(), msg);
    }

    private static void log(int type, String tag, String msg) {
        if (!Utils.isEmpty(tag) && !Utils.isEmpty(msg)) {
            Bundle bundle = new Bundle();
            bundle.putParcelable("log", (Parcelable)new SuperLogModel(tag, msg, type));
            SuperLogDbHelper.getInstance().perform(100, bundle, new DataLoadListener<Object>(){

                @Override
                public void onDataLoaded(Object obj, int key) {
                }
            });
        }
    }

    public static void sendMail() {
        SuperLogDbHelper.getInstance().perform(102, null, new DataLoadListener<Object>(){

            @Override
            public void onDataLoaded(Object obj, int key) {
                String logs = (String)obj;
                if (Utils.isEmpty(logs)) {
                    SuperLog.v("SuperLog Db Empty", "Tried sending mail, but the db is empty.");
                } else {
                    try {
                        Intent intent = new Intent("android.intent.action.SENDTO");
                        intent.setFlags(0x10000000);
                        intent.putExtra("android.intent.extra.SUBJECT", SuperLog.class.getSimpleName());
                        intent.setData(Uri.parse((String)"mailto:"));
                        intent.putExtra("android.intent.extra.TEXT", logs);
                        if (intent.resolveActivity(BUILDER.getContext().getPackageManager()) != null) {
                            BUILDER.getContext().startActivity(intent);
                        }
                    }
                    catch (Exception e) {
                        SuperLog.e("Error Sending mail", e.getMessage());
                    }
                }
            }
        });
    }

    public static void sendMailInBackground(final String senderEmailId, final String password, final String recipientEmailId) {
        SuperLogDbHelper.getInstance().perform(102, null, new DataLoadListener<Object>(){

            @Override
            public void onDataLoaded(Object obj, int key) {
                final String logs = (String)obj;
                if (Utils.isEmpty(logs)) {
                    SuperLog.v("SuperLog Db Empty", "Tried sending mail, but the db is empty.");
                } else {
                    new AsyncTask<Void, Void, Void>(){

                        protected Void doInBackground(Void ... params) {
                            if (NetworkUtils.isNetworkAvailable((Context)BUILDER.getContext(), true)) {
                                try {
                                    GMailSender sender = new GMailSender(senderEmailId, password);
                                    sender.sendMail("SuperLogs", logs, senderEmailId, recipientEmailId);
                                }
                                catch (Exception e) {
                                    SuperLog.e("Error Sending mail", e.getMessage());
                                }
                            }
                            return null;
                        }

                        protected void onPostExecute(Void aVoid) {
                            super.onPostExecute((Object)aVoid);
                        }
                    }.execute((Object[])new Void[0]);
                }
            }
        });
    }

    public static void sendMailInBackground(String recipientEmailId) {
        String email = BUILDER.getEmail();
        String pass = BUILDER.getPass();
        if (Utils.isEmpty(email) || Utils.isEmpty(pass)) {
            SuperLog.log(BUILDER.getContext().getString(R.string.empty_credentials));
            return;
        }
        if (Utils.isEmpty(recipientEmailId)) {
            SuperLog.log(BUILDER.getContext().getString(R.string.empty_recipient_address));
            return;
        }
        SuperLog.sendMailInBackground(email, pass, recipientEmailId);
    }

    public static void init(@NonNull Builder builder) {
        BUILDER = builder;
    }

    public static Builder getBuilder() {
        return BUILDER;
    }

    public static class Builder {
        private Application context;
        private boolean superLogViewVisibility;
        private String email;
        private String pass;

        public Builder(Application context) {
            this.context = context;
            this.superLogViewVisibility = true;
        }

        public Builder setSuperLogViewVisibility(boolean isVisible) {
            this.superLogViewVisibility = isVisible;
            return this;
        }

        public Builder setCredentials(@NonNull String email, @NonNull String pass) {
            this.email = email;
            this.pass = pass;
            return this;
        }

        public boolean isSuperLogViewVisible() {
            return this.superLogViewVisibility;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getPass() {
            return this.pass;
        }

        public void setPass(String pass) {
            this.pass = pass;
        }

        public Application getContext() {
            return this.context;
        }

        public void setContext(Application context) {
            this.context = context;
        }
    }
}

