/*
 * Decompiled with CFR 0.152.
 */
package com.ankuryadav.volleylib;

import android.app.Activity;
import com.android.volley.AuthFailureError;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.StringRequest;
import com.ankuryadav.volleylib.helper.VolleyLogs;
import com.ankuryadav.volleylib.interfaces.VolleyResponseListener;
import com.ankuryadav.volleylib.request.VolleyRequestQueue;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.json.JSONObject;

public class VolleyRequest {
    Activity context;
    VolleyResponseListener res;

    public VolleyRequest(Activity context) {
        this.context = context;
        this.res = (VolleyResponseListener)context;
    }

    public void stringPostCall(final String URL, final Map<String, String> parameters, final String Type) {
        StringRequest stringRequest = new StringRequest(1, URL, (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                VolleyRequest.this.res.volleyResponse(response.toString(), Type);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError volleyError) {
                VolleyRequest.this.res.responseError(volleyError.toString());
            }
        }){

            protected Map<String, String> getParams() throws AuthFailureError {
                Hashtable<String, String> params = new Hashtable<String, String>();
                params.putAll(parameters);
                String url = "";
                for (String key : params.keySet()) {
                    String value = (String)params.get(key);
                    url = url + "&" + key + "=" + value;
                }
                VolleyLogs.display("CalledUrl", URL + url);
                return params;
            }
        };
        VolleyRequestQueue vRequestQueue = new VolleyRequestQueue();
        vRequestQueue.addStringRequet(this.context, stringRequest);
    }

    public void jsonObjectGetWithHeaderCall(String URL, final Map<String, String> parameters, final String Type) {
        HashMap jsonParams = new HashMap();
        JsonObjectRequest jsonRequest = new JsonObjectRequest(0, URL, new JSONObject(jsonParams), (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                VolleyRequest.this.res.volleyResponse(response.toString(), Type);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError volleyError) {
                VolleyRequest.this.res.responseError(volleyError.toString());
            }
        }){

            public Map<String, String> getHeaders() throws AuthFailureError {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.putAll(parameters);
                return headers;
            }
        };
        VolleyRequestQueue vRequestQueue = new VolleyRequestQueue();
        vRequestQueue.addJsonRequet(this.context, jsonRequest);
    }

    public void jsonObjectPostCall(String URL, final Map<String, String> parameters, final String Type) throws IOException {
        HashMap jsonParams = new HashMap();
        JsonObjectRequest jsonRequest = new JsonObjectRequest(1, URL, new JSONObject(jsonParams), (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                VolleyRequest.this.res.volleyResponse(response.toString(), Type);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError volleyError) {
                VolleyRequest.this.res.responseError(volleyError.toString());
            }
        }){

            public Map<String, String> getHeaders() throws AuthFailureError {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.putAll(parameters);
                return headers;
            }
        };
        VolleyRequestQueue vRequestQueue = new VolleyRequestQueue();
        vRequestQueue.addJsonRequet(this.context, jsonRequest);
    }
}

