/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage.media;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import androidx.annotation.RequiresApi;
import androidx.documentfile.provider.DocumentFile;
import com.anggrayudi.storage.extension.IOUtils;
import com.anggrayudi.storage.extension.TextUtils;
import com.anggrayudi.storage.file.CreateMode;
import com.anggrayudi.storage.file.DocumentFileCompat;
import com.anggrayudi.storage.file.DocumentFileType;
import com.anggrayudi.storage.file.DocumentFileUtils;
import com.anggrayudi.storage.file.FileUtils;
import com.anggrayudi.storage.file.MimeType;
import com.anggrayudi.storage.file.PublicDirectory;
import com.anggrayudi.storage.media.AudioMediaDirectory;
import com.anggrayudi.storage.media.FileDescription;
import com.anggrayudi.storage.media.ImageMediaDirectory;
import com.anggrayudi.storage.media.MediaFile;
import com.anggrayudi.storage.media.MediaType;
import com.anggrayudi.storage.media.VideoMediaDirectory;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J$\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J.\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00142\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J2\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J,\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J.\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u001b2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\"\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0004H\u0007J\"\u0010 \u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0002J&\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0$2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0002J\"\u0010%\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0004H\u0007J&\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0$2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0004H\u0007J\"\u0010)\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+H\u0007J\"\u0010)\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u0004H\u0007J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020\t0$2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J&\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0$2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0004H\u0007J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020\t0$2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00100\u001a\u000201H\u0007J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020\t0$2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u0004H\u0007J\"\u0010/\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0007J\u0012\u00103\u001a\u0004\u0018\u00010\u00172\u0006\u00104\u001a\u00020\u0004H\u0003J\"\u00105\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00106\u001a\u000207H\u0002R\u001a\u0010\u0003\u001a\u00020\u00048GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00068"}, d2={"Lcom/anggrayudi/storage/media/MediaStoreCompat;", "", "()V", "volumeName", "", "getVolumeName$annotations", "getVolumeName", "()Ljava/lang/String;", "createAudio", "Lcom/anggrayudi/storage/media/MediaFile;", "context", "Landroid/content/Context;", "file", "Lcom/anggrayudi/storage/media/FileDescription;", "relativeParentDirectory", "Lcom/anggrayudi/storage/media/AudioMediaDirectory;", "mode", "Lcom/anggrayudi/storage/file/CreateMode;", "createDownload", "createImage", "Lcom/anggrayudi/storage/media/ImageMediaDirectory;", "createMedia", "mediaType", "Lcom/anggrayudi/storage/media/MediaType;", "folderName", "fullPath", "createVideo", "Lcom/anggrayudi/storage/media/VideoMediaDirectory;", "deleteEmptyMediaFiles", "", "fromBasePath", "basePath", "fromCursorToMediaFile", "cursor", "Landroid/database/Cursor;", "fromCursorToMediaFiles", "", "fromFileName", "name", "fromFileNameContains", "containsName", "fromMediaId", "id", "", "fromMediaType", "fromMimeType", "mimeType", "fromRelativePath", "publicDirectory", "Lcom/anggrayudi/storage/file/PublicDirectory;", "relativePath", "mediaTypeFromRelativePath", "cleanRelativePath", "tryInsertMediaFile", "contentValues", "Landroid/content/ContentValues;", "storage_release"})
@SourceDebugExtension(value={"SMAP\nMediaStoreCompat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaStoreCompat.kt\ncom/anggrayudi/storage/media/MediaStoreCompat\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,369:1\n11335#2:370\n11670#2,3:371\n11335#2:374\n11670#2,3:375\n11335#2:378\n11670#2,3:379\n179#3,2:382\n1#4:384\n1855#5,2:385\n1549#5:387\n1620#5,3:388\n1549#5:391\n1620#5,3:392\n1549#5:395\n1620#5,2:396\n1549#5:398\n1620#5,3:399\n1622#5:402\n1549#5:403\n1620#5,2:404\n1549#5:406\n1620#5,3:407\n1622#5:410\n1549#5:411\n1620#5,2:412\n1549#5:414\n1620#5,3:415\n1622#5:418\n*S KotlinDebug\n*F\n+ 1 MediaStoreCompat.kt\ncom/anggrayudi/storage/media/MediaStoreCompat\n*L\n80#1:370\n80#1:371,3\n81#1:374\n81#1:375,3\n82#1:378\n82#1:379,3\n137#1:382,2\n184#1:385,2\n266#1:387\n266#1:388,3\n288#1:391\n288#1:392,3\n304#1:395\n304#1:396,2\n308#1:398\n308#1:399,3\n304#1:402\n321#1:403\n321#1:404,2\n325#1:406\n325#1:407,3\n321#1:410\n338#1:411\n338#1:412,2\n342#1:414\n342#1:415,3\n338#1:418\n*E\n"})
public final class MediaStoreCompat {
    @NotNull
    public static final MediaStoreCompat INSTANCE = new MediaStoreCompat();

    private MediaStoreCompat() {
    }

    @SuppressLint(value={"InlinedApi"})
    @NotNull
    public static final String getVolumeName() {
        return Build.VERSION.SDK_INT < 29 ? "external" : "external_primary";
    }

    @JvmStatic
    public static /* synthetic */ void getVolumeName$annotations() {
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createDownload(@NotNull Context context, @NotNull FileDescription file, @NotNull CreateMode mode) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        String string2 = Environment.DIRECTORY_DOWNLOADS;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DIRECTORY_DOWNLOADS");
        return INSTANCE.createMedia(context, MediaType.DOWNLOADS, string2, file, mode);
    }

    public static /* synthetic */ MediaFile createDownload$default(Context context, FileDescription fileDescription, CreateMode createMode, int n, Object object) {
        if ((n & 4) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        return MediaStoreCompat.createDownload(context, fileDescription, createMode);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createImage(@NotNull Context context, @NotNull FileDescription file, @NotNull ImageMediaDirectory relativeParentDirectory, @NotNull CreateMode mode) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)relativeParentDirectory), (String)"relativeParentDirectory");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return INSTANCE.createMedia(context, MediaType.IMAGE, relativeParentDirectory.getFolderName(), file, mode);
    }

    public static /* synthetic */ MediaFile createImage$default(Context context, FileDescription fileDescription, ImageMediaDirectory imageMediaDirectory, CreateMode createMode, int n, Object object) {
        if ((n & 4) != 0) {
            imageMediaDirectory = ImageMediaDirectory.PICTURES;
        }
        if ((n & 8) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        return MediaStoreCompat.createImage(context, fileDescription, imageMediaDirectory, createMode);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createAudio(@NotNull Context context, @NotNull FileDescription file, @NotNull AudioMediaDirectory relativeParentDirectory, @NotNull CreateMode mode) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)relativeParentDirectory), (String)"relativeParentDirectory");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return INSTANCE.createMedia(context, MediaType.AUDIO, relativeParentDirectory.getFolderName(), file, mode);
    }

    public static /* synthetic */ MediaFile createAudio$default(Context context, FileDescription fileDescription, AudioMediaDirectory audioMediaDirectory, CreateMode createMode, int n, Object object) {
        if ((n & 4) != 0) {
            audioMediaDirectory = AudioMediaDirectory.MUSIC;
        }
        if ((n & 8) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        return MediaStoreCompat.createAudio(context, fileDescription, audioMediaDirectory, createMode);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createVideo(@NotNull Context context, @NotNull FileDescription file, @NotNull VideoMediaDirectory relativeParentDirectory, @NotNull CreateMode mode) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)relativeParentDirectory), (String)"relativeParentDirectory");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return INSTANCE.createMedia(context, MediaType.VIDEO, relativeParentDirectory.getFolderName(), file, mode);
    }

    public static /* synthetic */ MediaFile createVideo$default(Context context, FileDescription fileDescription, VideoMediaDirectory videoMediaDirectory, CreateMode createMode, int n, Object object) {
        if ((n & 4) != 0) {
            videoMediaDirectory = VideoMediaDirectory.MOVIES;
        }
        if ((n & 8) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        return MediaStoreCompat.createVideo(context, fileDescription, videoMediaDirectory, createMode);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createMedia(@NotNull Context context, @NotNull String fullPath, @NotNull FileDescription file, @NotNull CreateMode mode) {
        MediaType mediaType;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        String basePath = TextUtils.trimFileSeparator(DocumentFileCompat.getBasePath(context, fullPath));
        if (((CharSequence)basePath).length() == 0) {
            return null;
        }
        String mediaFolder = StringsKt.substringBefore$default((String)basePath, (char)'/', null, (int)2, null);
        String string2 = mediaFolder;
        if (Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_DOWNLOADS)) {
            mediaType = MediaType.DOWNLOADS;
        } else {
            Enum it;
            Collection collection;
            Enum[] $this$mapTo$iv$iv;
            Enum[] $this$map$iv = ImageMediaDirectory.values();
            boolean $i$f$map = false;
            ImageMediaDirectory[] imageMediaDirectoryArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (Enum item$iv$iv : $this$mapTo$iv$iv) {
                void var16_15 = item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((ImageMediaDirectory)it).getFolderName());
            }
            if (((List)destination$iv$iv).contains(string2)) {
                mediaType = MediaType.IMAGE;
            } else {
                int n;
                Enum item$iv$iv;
                $this$map$iv = AudioMediaDirectory.values();
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList($this$map$iv.length);
                $i$f$mapTo = false;
                int n2 = $this$mapTo$iv$iv.length;
                for (n = 0; n < n2; ++n) {
                    it = item$iv$iv = $this$mapTo$iv$iv[n];
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((AudioMediaDirectory)it).getFolderName());
                }
                if (((List)destination$iv$iv).contains(string2)) {
                    mediaType = MediaType.AUDIO;
                } else {
                    $this$map$iv = VideoMediaDirectory.values();
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList($this$map$iv.length);
                    $i$f$mapTo = false;
                    n2 = $this$mapTo$iv$iv.length;
                    for (n = 0; n < n2; ++n) {
                        it = item$iv$iv = $this$mapTo$iv$iv[n];
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(((VideoMediaDirectory)it).getFolderName());
                    }
                    if (((List)destination$iv$iv).contains(string2)) {
                        mediaType = MediaType.VIDEO;
                    } else {
                        return null;
                    }
                }
            }
        }
        MediaType mediaType2 = mediaType;
        String subFolder = StringsKt.substringAfter((String)basePath, (char)'/', (String)"");
        file.setSubFolder(TextUtils.trimFileSeparator(subFolder + '/' + file.getSubFolder()));
        return INSTANCE.createMedia(context, mediaType2, mediaFolder, file, mode);
    }

    public static /* synthetic */ MediaFile createMedia$default(Context context, String string2, FileDescription fileDescription, CreateMode createMode, int n, Object object) {
        if ((n & 8) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        return MediaStoreCompat.createMedia(context, string2, fileDescription, createMode);
    }

    /*
     * WARNING - void declaration
     */
    private final MediaFile createMedia(Context context, MediaType mediaType, String folderName, FileDescription file, CreateMode mode) {
        MediaFile mediaFile;
        if (Build.VERSION.SDK_INT >= 29) {
            ContentValues contentValues;
            String fullName = file.getFullName();
            String mimeType = file.getMimeType();
            String baseName = MimeType.getBaseFileName(fullName);
            String ext = MimeType.getExtensionFromFileName(fullName);
            ContentValues $this$createMedia_u24lambda_u243 = contentValues = new ContentValues();
            boolean bl = false;
            $this$createMedia_u24lambda_u243.put("_display_name", Intrinsics.areEqual((Object)mimeType, (Object)"application/octet-stream") ? fullName : baseName);
            $this$createMedia_u24lambda_u243.put("mime_type", mimeType);
            long dateCreated = System.currentTimeMillis();
            $this$createMedia_u24lambda_u243.put("date_added", Long.valueOf(dateCreated));
            $this$createMedia_u24lambda_u243.put("date_modified", Long.valueOf(dateCreated));
            ContentValues contentValues2 = contentValues;
            String relativePath = TextUtils.trimFileName(folderName + '/' + file.getSubFolder());
            ContentValues $this$createMedia_u24lambda_u244 = $this$createMedia_u24lambda_u243 = contentValues2;
            boolean bl2 = false;
            $this$createMedia_u24lambda_u244.put("owner_package_name", context.getPackageName());
            if (!StringsKt.isBlank((CharSequence)relativePath)) {
                $this$createMedia_u24lambda_u244.put("relative_path", relativePath);
            }
            MediaFile existingMedia = MediaStoreCompat.fromBasePath(context, mediaType, relativePath + '/' + fullName);
            MediaFile mediaFile2 = existingMedia;
            boolean bl3 = mediaFile2 != null ? mediaFile2.isEmpty() : false;
            if (bl3) {
                mediaFile = existingMedia;
            } else if (existingMedia != null) {
                if (mode == CreateMode.REUSE) {
                    return existingMedia;
                }
                if (mode == CreateMode.REPLACE) {
                    existingMedia.delete();
                    return this.tryInsertMediaFile(context, mediaType, contentValues2);
                }
                if (Build.VERSION.SDK_INT == 29) {
                    Object v3;
                    block17: {
                        void $this$firstOrNull$iv;
                        String prefix = baseName + " (";
                        Sequence sequence2 = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)MediaStoreCompat.fromFileNameContains(context, mediaType, baseName)), (Function1)((Function1)new Function1<MediaFile, Boolean>(relativePath){
                            final /* synthetic */ String $relativePath;
                            {
                                this.$relativePath = $relativePath;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull MediaFile it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return StringsKt.isBlank((CharSequence)this.$relativePath) || Intrinsics.areEqual((Object)this.$relativePath, (Object)StringsKt.removeSuffix((String)it.getRelativePath(), (CharSequence)"/"));
                            }
                        })), (Function1)((Function1)new Function1<MediaFile, Boolean>(ext, prefix){
                            final /* synthetic */ String $ext;
                            final /* synthetic */ String $prefix;
                            {
                                this.$ext = $ext;
                                this.$prefix = $prefix;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull MediaFile it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                String name = it.getName();
                                CharSequence charSequence = name;
                                return charSequence == null || charSequence.length() == 0 || !Intrinsics.areEqual((Object)MimeType.getExtensionFromFileName(name), (Object)this.$ext) ? false : StringsKt.startsWith$default((String)name, (String)this.$prefix, (boolean)false, (int)2, null) && (DocumentFileCompat.INSTANCE.getFILE_NAME_DUPLICATION_REGEX_WITH_EXTENSION().matches((CharSequence)name) || DocumentFileCompat.INSTANCE.getFILE_NAME_DUPLICATION_REGEX_WITHOUT_EXTENSION().matches((CharSequence)name));
                            }
                        }));
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            MediaFile it = (MediaFile)element$iv;
                            boolean bl4 = false;
                            if (!it.getHasZeroLength()) continue;
                            v3 = element$iv;
                            break block17;
                        }
                        v3 = null;
                    }
                    MediaFile mediaFile3 = v3;
                    if (mediaFile3 != null) {
                        MediaFile it = mediaFile3;
                        boolean bl5 = false;
                        return it;
                    }
                }
                mediaFile = this.tryInsertMediaFile(context, mediaType, contentValues2);
            } else {
                mediaFile = this.tryInsertMediaFile(context, mediaType, contentValues2);
            }
        } else {
            File publicDirectory = Environment.getExternalStoragePublicDirectory((String)folderName);
            Intrinsics.checkNotNullExpressionValue((Object)publicDirectory, (String)"publicDirectory");
            if (FileUtils.canModify(publicDirectory, context)) {
                String filename = file.getFullName();
                File media = new File(publicDirectory + '/' + file.getSubFolder(), filename);
                File file2 = media.getParentFile();
                if (file2 == null) {
                    return null;
                }
                File parentFile = file2;
                parentFile.mkdirs();
                if (media.exists() && mode == CreateMode.CREATE_NEW) {
                    media = FileUtils.child(parentFile, FileUtils.autoIncrementFileName(parentFile, filename));
                }
                if (mode == CreateMode.REPLACE && !FileUtils.recreateFile(media)) {
                    return null;
                }
                mediaFile = FileUtils.createNewFileIfPossible(media) ? (media.canRead() ? new MediaFile(context, media) : null) : null;
            } else {
                mediaFile = null;
            }
        }
        return mediaFile;
    }

    private final MediaFile tryInsertMediaFile(Context context, MediaType mediaType, ContentValues contentValues) {
        MediaFile mediaFile;
        try {
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri = mediaType.getWriteUri();
            Intrinsics.checkNotNull((Object)uri);
            Uri uri2 = contentResolver.insert(uri, contentValues);
            if (uri2 == null) {
                return null;
            }
            mediaFile = new MediaFile(context, uri2);
        }
        catch (Exception e) {
            e.printStackTrace();
            mediaFile = null;
        }
        return mediaFile;
    }

    @JvmStatic
    public static final int deleteEmptyMediaFiles(@NotNull Context context, @NotNull MediaType mediaType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        int deleted = 0;
        Iterable $this$forEach$iv = MediaStoreCompat.fromMediaType(context, mediaType);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MediaFile it = (MediaFile)element$iv;
            boolean bl = false;
            if (!it.getHasZeroLength()) continue;
            it.delete();
            ++deleted;
        }
        return deleted;
    }

    @JvmStatic
    @Nullable
    public static final MediaFile fromMediaId(@NotNull Context context, @NotNull MediaType mediaType, @NotNull String id) {
        MediaFile mediaFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Uri uri = mediaType.getWriteUri();
        if (uri != null) {
            Uri it = uri;
            boolean bl = false;
            Uri uri2 = it.buildUpon().appendPath(id).build();
            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"it.buildUpon().appendPath(id).build()");
            mediaFile = new MediaFile(context, uri2);
        } else {
            mediaFile = null;
        }
        return mediaFile;
    }

    @JvmStatic
    @Nullable
    public static final MediaFile fromMediaId(@NotNull Context context, @NotNull MediaType mediaType, long id) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        return MediaStoreCompat.fromMediaId(context, mediaType, String.valueOf(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final MediaFile fromFileName(@NotNull Context context, @NotNull MediaType mediaType, @NotNull String name) {
        MediaFile mediaFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (Build.VERSION.SDK_INT < 29) {
            File it = new File(PublicDirectory.DOWNLOADS.getFile(), name);
            boolean bl = false;
            mediaFile = it.isFile() && it.canRead() ? new MediaFile(context, it) : null;
        } else {
            String selection = "_display_name = ?";
            Uri uri = mediaType.getReadUri();
            if (uri == null) {
                return null;
            }
            Object object = new String[]{"_id"};
            String[] stringArray = object;
            object = new String[]{name};
            Cursor cursor = context.getContentResolver().query(uri, stringArray, selection, object, null);
            if (cursor != null) {
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)object;
                    boolean bl = false;
                    MediaFile mediaFile2 = INSTANCE.fromCursorToMediaFile(context, mediaType, it);
                    mediaFile = mediaFile2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            } else {
                mediaFile = null;
            }
        }
        return mediaFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final MediaFile fromBasePath(@NotNull Context context, @NotNull MediaType mediaType, @NotNull String basePath) {
        MediaFile mediaFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        String cleanBasePath = TextUtils.trimFileSeparator(DocumentFileCompat.INSTANCE.removeForbiddenCharsFromFilename$storage_release(basePath));
        if (Build.VERSION.SDK_INT < 29) {
            File it = new File(Environment.getExternalStorageDirectory(), cleanBasePath);
            boolean bl = false;
            mediaFile = it.isFile() && it.canRead() ? new MediaFile(context, it) : null;
        } else {
            String relativePath = StringsKt.substringBeforeLast((String)cleanBasePath, (char)'/', (String)"");
            if (((CharSequence)relativePath).length() == 0) {
                return null;
            }
            String filename = StringsKt.substringAfterLast$default((String)cleanBasePath, (char)'/', null, (int)2, null);
            String selection = "_display_name = ? AND relative_path = ?";
            Uri uri = mediaType.getReadUri();
            if (uri == null) {
                return null;
            }
            Object object = new String[]{"_id"};
            String[] stringArray = object;
            object = new String[]{filename, relativePath + '/'};
            Cursor cursor = context.getContentResolver().query(uri, stringArray, selection, object, null);
            if (cursor != null) {
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)object;
                    boolean bl = false;
                    MediaFile mediaFile2 = INSTANCE.fromCursorToMediaFile(context, mediaType, it);
                    mediaFile = mediaFile2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            } else {
                mediaFile = null;
            }
        }
        return mediaFile;
    }

    @RequiresApi(value=29)
    private final MediaType mediaTypeFromRelativePath(String cleanRelativePath) {
        String string2 = cleanRelativePath;
        return (Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_DCIM) ? true : Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_PICTURES)) ? MediaType.IMAGE : ((Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_MOVIES) ? true : Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_DCIM)) ? MediaType.VIDEO : (((((Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_MUSIC) ? true : Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_PODCASTS)) ? true : Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_RINGTONES)) ? true : Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_ALARMS)) ? true : Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_NOTIFICATIONS)) ? MediaType.AUDIO : (Intrinsics.areEqual((Object)string2, (Object)Environment.DIRECTORY_DOWNLOADS) ? MediaType.DOWNLOADS : null)));
    }

    @JvmStatic
    @NotNull
    public static final List<MediaFile> fromRelativePath(@NotNull Context context, @NotNull PublicDirectory publicDirectory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)publicDirectory), (String)"publicDirectory");
        return MediaStoreCompat.fromRelativePath(context, publicDirectory.getFolderName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<MediaFile> fromRelativePath(@NotNull Context context, @NotNull String relativePath) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String cleanRelativePath = TextUtils.trimFileSeparator(relativePath);
        if (Build.VERSION.SDK_INT < 29) {
            void $this$mapTo$iv$iv;
            DocumentFile documentFile = DocumentFile.fromFile((File)new File(Environment.getExternalStorageDirectory(), cleanRelativePath));
            Intrinsics.checkNotNullExpressionValue((Object)documentFile, (String)"fromFile(File(Environmen\u2026ry(), cleanRelativePath))");
            Iterable $this$map$iv = DocumentFileUtils.search$default(documentFile, true, DocumentFileType.FILE, null, null, null, 28, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DocumentFile documentFile2 = (DocumentFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = it.getUri().getPath();
                Intrinsics.checkNotNull((Object)string2);
                collection.add(new MediaFile(context, new File(string2)));
            }
        } else {
            List<MediaFile> list;
            List<MediaFile> list2;
            MediaType mediaType = INSTANCE.mediaTypeFromRelativePath(cleanRelativePath);
            if (mediaType == null) {
                return CollectionsKt.emptyList();
            }
            MediaType mediaType2 = mediaType;
            char[] $this$mapTo$iv$iv = new char[]{'/'};
            String relativePathWithSlashSuffix = StringsKt.trimEnd((String)relativePath, (char[])$this$mapTo$iv$iv) + '/';
            String selection = "relative_path IN(?, ?)";
            String[] stringArray = new String[]{relativePathWithSlashSuffix, cleanRelativePath};
            String[] selectionArgs = stringArray;
            Uri uri = mediaType2.getReadUri();
            if (uri == null) {
                return CollectionsKt.emptyList();
            }
            Object object = new String[]{"_id"};
            Cursor cursor = context.getContentResolver().query(uri, object, selection, selectionArgs, null);
            if (cursor != null) {
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)object;
                    boolean bl = false;
                    List<MediaFile> list3 = INSTANCE.fromCursorToMediaFiles(context, mediaType2, it);
                    list2 = list3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final MediaFile fromRelativePath(@NotNull Context context, @NotNull String relativePath, @NotNull String name) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String cleanRelativePath = TextUtils.trimFileSeparator(relativePath);
        if (Build.VERSION.SDK_INT < 29) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            DocumentFile documentFile = DocumentFile.fromFile((File)new File(Environment.getExternalStorageDirectory(), cleanRelativePath));
            Intrinsics.checkNotNullExpressionValue((Object)documentFile, (String)"fromFile(File(Environmen\u2026ry(), cleanRelativePath))");
            Iterable iterable = DocumentFileUtils.search$default(documentFile, true, DocumentFileType.FILE, null, name, null, 20, null);
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DocumentFile documentFile2 = (DocumentFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = it.getUri().getPath();
                Intrinsics.checkNotNull((Object)string2);
                collection.add(new MediaFile(context, new File(string2)));
            }
        } else {
            MediaFile mediaFile;
            MediaType mediaType = INSTANCE.mediaTypeFromRelativePath(cleanRelativePath);
            if (mediaType == null) {
                return null;
            }
            MediaType mediaType2 = mediaType;
            char[] $this$mapTo$iv$iv = new char[]{'/'};
            String relativePathWithSlashSuffix = StringsKt.trimEnd((String)relativePath, (char[])$this$mapTo$iv$iv) + '/';
            String selection = "_display_name = ? AND relative_path IN(?, ?)";
            String[] stringArray = new String[]{name, relativePathWithSlashSuffix, cleanRelativePath};
            String[] selectionArgs = stringArray;
            Uri uri = mediaType2.getReadUri();
            if (uri == null) {
                return null;
            }
            Object object = new String[]{"_id"};
            Cursor cursor = context.getContentResolver().query(uri, object, selection, selectionArgs, null);
            if (cursor != null) {
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)object;
                    boolean bl = false;
                    MediaFile mediaFile2 = INSTANCE.fromCursorToMediaFile(context, mediaType2, it);
                    mediaFile = mediaFile2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            } else {
                mediaFile = null;
            }
            return mediaFile;
        }
        return (MediaFile)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<MediaFile> fromFileNameContains(@NotNull Context context, @NotNull MediaType mediaType, @NotNull String containsName) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        Intrinsics.checkNotNullParameter((Object)containsName, (String)"containsName");
        if (Build.VERSION.SDK_INT < 29) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = mediaType.getDirectories();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                void directory;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object = DocumentFile.fromFile((File)directory);
                Regex regex = new Regex("^.*" + containsName + ".*$");
                String[] stringArray = new String[]{mediaType.getMimeType()};
                String[] stringArray2 = stringArray;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromFile(directory)");
                object = DocumentFileUtils.search$default(object, true, null, stringArray2, null, regex, 10, null);
                boolean $i$f$map2 = false;
                stringArray2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    DocumentFile documentFile = (DocumentFile)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    String string2 = it.getUri().getPath();
                    Intrinsics.checkNotNull((Object)string2);
                    collection2.add(new MediaFile(context, new File(string2)));
                }
                collection.add((List)destination$iv$iv2);
            }
        } else {
            List<MediaFile> list;
            List<MediaFile> list2;
            String selection = "_display_name LIKE '%" + containsName + "%'";
            Uri uri = mediaType.getReadUri();
            if (uri == null) {
                return CollectionsKt.emptyList();
            }
            Object object = new String[]{"_id"};
            Cursor cursor = context.getContentResolver().query(uri, object, selection, null, null);
            if (cursor != null) {
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)object;
                    boolean bl = false;
                    List<MediaFile> list3 = INSTANCE.fromCursorToMediaFiles(context, mediaType, it);
                    list2 = list3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<MediaFile> fromMimeType(@NotNull Context context, @NotNull MediaType mediaType, @NotNull String mimeType) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        if (Build.VERSION.SDK_INT < 29) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = mediaType.getDirectories();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                void directory;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                DocumentFile documentFile = DocumentFile.fromFile((File)directory);
                Intrinsics.checkNotNullExpressionValue((Object)documentFile, (String)"fromFile(directory)");
                Object object = new String[]{mimeType};
                object = DocumentFileUtils.search$default(documentFile, true, DocumentFileType.FILE, object, null, null, 24, null);
                boolean $i$f$map2 = false;
                void var14_21 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    DocumentFile documentFile2 = (DocumentFile)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    String string2 = it.getUri().getPath();
                    Intrinsics.checkNotNull((Object)string2);
                    collection2.add(new MediaFile(context, new File(string2)));
                }
                collection.add((List)destination$iv$iv2);
            }
        } else {
            List<MediaFile> list;
            List<MediaFile> list2;
            String selection = "mime_type = ?";
            Uri uri = mediaType.getReadUri();
            if (uri == null) {
                return CollectionsKt.emptyList();
            }
            Object object = new String[]{"_id"};
            String[] stringArray = object;
            object = new String[]{mimeType};
            Cursor cursor = context.getContentResolver().query(uri, stringArray, selection, object, null);
            if (cursor != null) {
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)object;
                    boolean bl = false;
                    List<MediaFile> list3 = INSTANCE.fromCursorToMediaFiles(context, mediaType, it);
                    list2 = list3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<MediaFile> fromMediaType(@NotNull Context context, @NotNull MediaType mediaType) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        if (Build.VERSION.SDK_INT < 29) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = mediaType.getDirectories();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                void directory;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                DocumentFile documentFile = DocumentFile.fromFile((File)directory);
                Intrinsics.checkNotNullExpressionValue((Object)documentFile, (String)"fromFile(directory)");
                Object object = new String[]{mediaType.getMimeType()};
                object = DocumentFileUtils.search$default(documentFile, true, null, object, null, null, 26, null);
                boolean $i$f$map2 = false;
                void var13_19 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    DocumentFile documentFile2 = (DocumentFile)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    String string2 = it.getUri().getPath();
                    Intrinsics.checkNotNull((Object)string2);
                    collection2.add(new MediaFile(context, new File(string2)));
                }
                collection.add((List)destination$iv$iv2);
            }
        } else {
            List<MediaFile> list;
            List<MediaFile> list2;
            Uri uri = mediaType.getReadUri();
            if (uri == null) {
                return CollectionsKt.emptyList();
            }
            Object object = new String[]{"_id"};
            Cursor cursor = context.getContentResolver().query(uri, object, null, null, null);
            if (cursor != null) {
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)object;
                    boolean bl = false;
                    List<MediaFile> list3 = INSTANCE.fromCursorToMediaFiles(context, mediaType, it);
                    list2 = list3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    private final List<MediaFile> fromCursorToMediaFiles(Context context, MediaType mediaType, Cursor cursor) {
        if (cursor.moveToFirst()) {
            ArrayList<Object> mediaFiles = new ArrayList<Object>(cursor.getCount());
            do {
                String string2;
                if ((string2 = IOUtils.getString(cursor, "_id")) == null) continue;
                Object it = string2;
                boolean bl = false;
                MediaFile mediaFile = MediaStoreCompat.fromMediaId(context, mediaType, (String)it);
                if (mediaFile == null) continue;
                it = mediaFile;
                boolean bl2 = false;
                mediaFiles.add(it);
            } while (cursor.moveToNext());
            return mediaFiles;
        }
        return CollectionsKt.emptyList();
    }

    private final MediaFile fromCursorToMediaFile(Context context, MediaType mediaType, Cursor cursor) {
        MediaFile mediaFile;
        if (cursor.moveToFirst()) {
            String string2 = IOUtils.getString(cursor, "_id");
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                mediaFile = MediaStoreCompat.fromMediaId(context, mediaType, it);
            } else {
                mediaFile = null;
            }
        } else {
            mediaFile = null;
        }
        return mediaFile;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createDownload(@NotNull Context context, @NotNull FileDescription file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return MediaStoreCompat.createDownload$default(context, file, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createImage(@NotNull Context context, @NotNull FileDescription file, @NotNull ImageMediaDirectory relativeParentDirectory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)relativeParentDirectory), (String)"relativeParentDirectory");
        return MediaStoreCompat.createImage$default(context, file, relativeParentDirectory, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createImage(@NotNull Context context, @NotNull FileDescription file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return MediaStoreCompat.createImage$default(context, file, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createAudio(@NotNull Context context, @NotNull FileDescription file, @NotNull AudioMediaDirectory relativeParentDirectory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)relativeParentDirectory), (String)"relativeParentDirectory");
        return MediaStoreCompat.createAudio$default(context, file, relativeParentDirectory, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createAudio(@NotNull Context context, @NotNull FileDescription file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return MediaStoreCompat.createAudio$default(context, file, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createVideo(@NotNull Context context, @NotNull FileDescription file, @NotNull VideoMediaDirectory relativeParentDirectory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)relativeParentDirectory), (String)"relativeParentDirectory");
        return MediaStoreCompat.createVideo$default(context, file, relativeParentDirectory, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createVideo(@NotNull Context context, @NotNull FileDescription file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return MediaStoreCompat.createVideo$default(context, file, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final MediaFile createMedia(@NotNull Context context, @NotNull String fullPath, @NotNull FileDescription file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return MediaStoreCompat.createMedia$default(context, fullPath, file, null, 8, null);
    }
}

