/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage.file;

import android.webkit.MimeTypeMap;
import com.anggrayudi.storage.extension.TextUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u0011\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u0012\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\u0014\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J\u001a\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J\u0012\u0010\u0019\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/anggrayudi/storage/file/MimeType;", "", "()V", "APPLICATION", "", "AUDIO", "BINARY_FILE", "CHEMICAL", "FONT", "IMAGE", "MODEL", "TEXT", "UNKNOWN", "VIDEO", "ZIP", "getBaseFileName", "filename", "getExtensionFromFileName", "getExtensionFromMimeType", "mimeType", "getExtensionFromMimeTypeOrFileName", "getFullFileName", "name", "getMimeTypeFromExtension", "fileExtension", "getMimeTypeFromFileName", "hasExtension", "", "storage_release"})
@SourceDebugExtension(value={"SMAP\nMimeType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MimeType.kt\ncom/anggrayudi/storage/file/MimeType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class MimeType {
    @NotNull
    public static final MimeType INSTANCE = new MimeType();
    @NotNull
    public static final String UNKNOWN = "*/*";
    @NotNull
    public static final String BINARY_FILE = "application/octet-stream";
    @NotNull
    public static final String ZIP = "application/zip";
    @NotNull
    public static final String IMAGE = "image/*";
    @NotNull
    public static final String AUDIO = "audio/*";
    @NotNull
    public static final String VIDEO = "video/*";
    @NotNull
    public static final String TEXT = "text/*";
    @NotNull
    public static final String FONT = "font/*";
    @NotNull
    public static final String APPLICATION = "application/*";
    @NotNull
    public static final String CHEMICAL = "chemical/*";
    @NotNull
    public static final String MODEL = "model/*";

    private MimeType() {
    }

    @JvmStatic
    @NotNull
    public static final String getFullFileName(@NotNull String name, @Nullable String mimeType) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String cleanName = TextUtils.normalizeFileName(name);
        if (Intrinsics.areEqual((Object)mimeType, (Object)BINARY_FILE) || Intrinsics.areEqual((Object)mimeType, (Object)UNKNOWN)) {
            String extension = MimeType.getExtensionFromFileName(cleanName);
            if (((CharSequence)extension).length() > 0) {
                return cleanName;
            }
        }
        String it = MimeType.getExtensionFromMimeType(mimeType);
        boolean bl = false;
        if (((CharSequence)it).length() == 0 || StringsKt.endsWith$default((String)cleanName, (String)('.' + it), (boolean)false, (int)2, null)) {
            string2 = cleanName;
        } else {
            char[] cArray = new char[]{'.'};
            string2 = StringsKt.trimEnd((String)(cleanName + '.' + it), (char[])cArray);
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getExtensionFromMimeType(@Nullable String mimeType) {
        String string2;
        String string3;
        String string4 = mimeType;
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            string3 = Intrinsics.areEqual((Object)it, (Object)BINARY_FILE) ? "bin" : MimeTypeMap.getSingleton().getExtensionFromMimeType(it);
        } else {
            string3 = string2 = null;
        }
        if (string3 == null) {
            string2 = "";
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getBaseFileName(@Nullable String filename) {
        String string2;
        if (MimeType.hasExtension(filename)) {
            String string3 = filename;
            if (string3 == null) {
                string3 = "";
            }
            string2 = StringsKt.substringBeforeLast$default((String)string3, (char)'.', null, (int)2, null);
        } else {
            string2 = filename;
            if (string2 == null) {
                string2 = "";
            }
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getExtensionFromFileName(@Nullable String filename) {
        String string2;
        if (MimeType.hasExtension(filename)) {
            String string3 = filename;
            if (string3 == null) {
                string3 = "";
            }
            string2 = StringsKt.substringAfterLast((String)string3, (char)'.', (String)"");
        } else {
            string2 = "";
        }
        return string2;
    }

    @JvmStatic
    public static final boolean hasExtension(@Nullable String filename) {
        CharSequence charSequence;
        String string2 = filename;
        return string2 != null ? new Regex("(.*?)\\.[a-zA-Z0-9]+").matches(charSequence = (CharSequence)string2) : false;
    }

    @JvmStatic
    @NotNull
    public static final String getExtensionFromMimeTypeOrFileName(@Nullable String mimeType, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return mimeType == null || Intrinsics.areEqual((Object)mimeType, (Object)UNKNOWN) ? MimeType.getExtensionFromFileName(filename) : MimeType.getExtensionFromMimeType(mimeType);
    }

    @JvmStatic
    @NotNull
    public static final String getMimeTypeFromExtension(@NotNull String fileExtension) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)fileExtension, (String)"fileExtension");
        if (StringsKt.equals((String)fileExtension, (String)"bin", (boolean)true)) {
            string2 = BINARY_FILE;
        } else {
            string2 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtension);
            if (string2 == null) {
                string2 = UNKNOWN;
            }
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getMimeTypeFromFileName(@Nullable String filename) {
        return MimeType.getMimeTypeFromExtension(MimeType.getExtensionFromFileName(filename));
    }
}

