/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage.file;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import androidx.documentfile.provider.DocumentFile;
import com.anggrayudi.storage.SimpleStorage;
import com.anggrayudi.storage.callback.FileCallback;
import com.anggrayudi.storage.callback.FileConflictCallback;
import com.anggrayudi.storage.extension.TextUtils;
import com.anggrayudi.storage.file.CreateMode;
import com.anggrayudi.storage.file.DocumentFileCompat;
import com.anggrayudi.storage.file.MimeType;
import com.anggrayudi.storage.file.StorageType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0012\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u000b\u001a\u0012\u0010\u0014\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0002\u001a$\u0010\u0016\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0007\u001a\u0012\u0010\u0019\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u000b\u001a\n\u0010\u001b\u001a\u00020\u0006*\u00020\u0001\u001a\u0012\u0010\u001c\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0002\u001a\u0016\u0010\u001d\u001a\u00020\u0006*\u00020\u00012\b\b\u0002\u0010\u001e\u001a\u00020\u0006H\u0007\u001a\u0012\u0010\u001f\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0002\u001a\u0012\u0010 \u001a\u00020\u000b*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0002\u001a \u0010!\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00022\b\b\u0002\u0010\u0017\u001a\u00020\u0006H\u0007\u001a\u0012\u0010\"\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0002\u001a\u0012\u0010#\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0002\u001a\u0012\u0010$\u001a\u00020%*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0002\u001a\u0012\u0010&\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0002\u001a\f\u0010'\u001a\u00020\u0006*\u00020\u0001H\u0007\u001a\u001a\u0010(\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u0001\u001a\u0012\u0010*\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0002\u001a\u0012\u0010+\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0002\u001a\u0012\u0010,\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0002\u001a\u0012\u0010-\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0002\u001aF\u0010.\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010/\u001a\u00020\u000b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u00100\u001a\u0002012\u0010\b\u0002\u00102\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u000103H\u0007\u001a(\u00104\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010/\u001a\u00020\u000b2\b\b\u0002\u00100\u001a\u000201H\u0007\u001a4\u00105\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u00106\u001a\u00020\u00012\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u00108\u001a\u000209H\u0007\u001a4\u00105\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u00106\u001a\u00020\u000b2\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u00108\u001a\u000209H\u0007\u001a\n\u0010:\u001a\u00020\u0006*\u00020\u0001\u001a\u001c\u0010;\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0006H\u0007\u001a\u001e\u0010<\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0006H\u0007\u001a\u0014\u0010=\u001a\u0004\u0018\u00010>*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0002\u001a\n\u0010?\u001a\u00020\u0006*\u00020\u0001\u001a\u0012\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00010A*\u00020\u0001H\u0002\u001a\u001c\u0010B\u001a\u00020C*\u00020\u00012\u0006\u0010D\u001a\u00020\u000b2\u0006\u0010E\u001a\u00020\u000bH\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0006*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\b\"\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006F"}, d2={"dataDirectory", "Ljava/io/File;", "Landroid/content/Context;", "getDataDirectory", "(Landroid/content/Context;)Ljava/io/File;", "inPrimaryStorage", "", "getInPrimaryStorage", "(Ljava/io/File;)Z", "isEmpty", "mimeType", "", "getMimeType", "(Ljava/io/File;)Ljava/lang/String;", "writableDirs", "", "getWritableDirs", "(Landroid/content/Context;)Ljava/util/Set;", "autoIncrementFileName", "filename", "canModify", "context", "checkRequirements", "requiresWriteAccess", "considerRawFile", "child", "path", "createNewFileIfPossible", "deleteEmptyFolders", "forceDelete", "childrenOnly", "getBasePath", "getRootPath", "getRootRawFile", "getSimplePath", "getStorageId", "getStorageType", "Lcom/anggrayudi/storage/file/StorageType;", "inDataStorage", "inKitkatSdCard", "inSameMountPointWith", "file", "inSdCardStorage", "isExternalStorageManager", "isReadOnly", "isWritable", "makeFile", "name", "mode", "Lcom/anggrayudi/storage/file/CreateMode;", "onConflict", "Lcom/anggrayudi/storage/callback/FileConflictCallback;", "makeFolder", "moveTo", "targetFolder", "newFileNameInTarget", "conflictResolution", "Lcom/anggrayudi/storage/callback/FileCallback$ConflictResolution;", "recreateFile", "shouldWritable", "takeIfWritable", "toDocumentFile", "Landroidx/documentfile/provider/DocumentFile;", "tryCreateNewFile", "walkFileTreeAndDeleteEmptyFolders", "", "walkFileTreeForMove", "", "srcPath", "destFolderPath", "storage_release"})
@JvmName(name="FileUtils")
@SourceDebugExtension(value={"SMAP\nFileExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileExt.kt\ncom/anggrayudi/storage/file/FileUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 CoroutineExt.kt\ncom/anggrayudi/storage/extension/CoroutineExtKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 7 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,393:1\n1#2:394\n1#2:408\n1747#3,3:395\n1855#3,2:412\n11653#4,9:398\n13579#4:407\n13580#4:409\n11662#4:410\n13579#4,2:414\n3792#4:418\n4307#4,2:419\n13579#4,2:421\n42#5:411\n18#6:416\n26#7:417\n*S KotlinDebug\n*F\n+ 1 FileExt.kt\ncom/anggrayudi/storage/file/FileUtils\n*L\n168#1:408\n159#1:395,3\n258#1:412,2\n168#1:398,9\n168#1:407\n168#1:409\n168#1:410\n265#1:414,2\n313#1:418\n313#1:419,2\n384#1:421,2\n208#1:411\n313#1:416\n313#1:417\n*E\n"})
public final class FileUtils {
    @NotNull
    public static final String getStorageId(@NotNull File $this$getStorageId, @NotNull Context context) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$getStorageId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string3 = $this$getStorageId.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"path");
        if (StringsKt.startsWith$default((String)string3, (String)SimpleStorage.Companion.getExternalStoragePath(), (boolean)false, (int)2, null)) {
            string2 = "primary";
        } else {
            String string4 = $this$getStorageId.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"path");
            String string5 = FileUtils.getDataDirectory(context).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"context.dataDirectory.path");
            if (StringsKt.startsWith$default((String)string4, (String)string5, (boolean)false, (int)2, null)) {
                string2 = "data";
            } else {
                String string6 = $this$getStorageId.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"path");
                if (StringsKt.startsWith$default((String)string6, (String)"/storage/sdcard", (boolean)false, (int)2, null)) {
                    string2 = "sdcard";
                } else {
                    String string7 = $this$getStorageId.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"path");
                    CharSequence charSequence = string7;
                    if (DocumentFileCompat.INSTANCE.getSD_CARD_STORAGE_PATH_REGEX().matches(charSequence)) {
                        String string8 = $this$getStorageId.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"path");
                        string2 = StringsKt.substringBefore$default((String)StringsKt.substringAfter((String)string8, (String)"/storage/", (String)""), (char)'/', null, (int)2, null);
                    } else {
                        string2 = "";
                    }
                }
            }
        }
        return string2;
    }

    public static final boolean getInPrimaryStorage(@NotNull File $this$inPrimaryStorage) {
        Intrinsics.checkNotNullParameter((Object)$this$inPrimaryStorage, (String)"<this>");
        String string2 = $this$inPrimaryStorage.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
        return StringsKt.startsWith$default((String)string2, (String)SimpleStorage.Companion.getExternalStoragePath(), (boolean)false, (int)2, null);
    }

    public static final boolean inDataStorage(@NotNull File $this$inDataStorage, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$inDataStorage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = $this$inDataStorage.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
        String string3 = FileUtils.getDataDirectory(context).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.dataDirectory.path");
        return StringsKt.startsWith$default((String)string2, (String)string3, (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean inSdCardStorage(@NotNull File $this$inSdCardStorage, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$inSdCardStorage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String it = FileUtils.getStorageId($this$inSdCardStorage, context);
        boolean bl = false;
        if (Intrinsics.areEqual((Object)it, (Object)"primary")) return false;
        if (Intrinsics.areEqual((Object)it, (Object)"data")) return false;
        String string2 = $this$inSdCardStorage.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
        if (!StringsKt.startsWith$default((String)string2, (String)("/storage/" + it), (boolean)false, (int)2, null)) return false;
        return true;
    }

    public static final boolean inSameMountPointWith(@NotNull File $this$inSameMountPointWith, @NotNull Context context, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$inSameMountPointWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String storageId1 = FileUtils.getStorageId($this$inSameMountPointWith, context);
        String storageId2 = FileUtils.getStorageId(file, context);
        return Intrinsics.areEqual((Object)storageId1, (Object)storageId2) || (Intrinsics.areEqual((Object)storageId1, (Object)"primary") || Intrinsics.areEqual((Object)storageId1, (Object)"data")) && (Intrinsics.areEqual((Object)storageId2, (Object)"primary") || Intrinsics.areEqual((Object)storageId2, (Object)"data"));
    }

    @NotNull
    public static final StorageType getStorageType(@NotNull File $this$getStorageType, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$getStorageType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return FileUtils.getInPrimaryStorage($this$getStorageType) ? StorageType.EXTERNAL : (FileUtils.inDataStorage($this$getStorageType, context) ? StorageType.DATA : (FileUtils.inSdCardStorage($this$getStorageType, context) ? StorageType.SD_CARD : StorageType.UNKNOWN));
    }

    @NotNull
    public static final File child(@NotNull File $this$child, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$child, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new File($this$child, path);
    }

    @NotNull
    public static final File getDataDirectory(@NotNull Context $this$dataDirectory) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$dataDirectory, (String)"<this>");
        if (Build.VERSION.SDK_INT > 23) {
            File file2 = $this$dataDirectory.getDataDir();
            file = file2;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"dataDir");
        } else {
            File file3 = $this$dataDirectory.getFilesDir().getParentFile();
            file = file3;
            Intrinsics.checkNotNull((Object)file3);
        }
        return file;
    }

    @NotNull
    public static final String getBasePath(@NotNull File $this$getBasePath, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$getBasePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String externalStoragePath = SimpleStorage.Companion.getExternalStoragePath();
        String string2 = $this$getBasePath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
        if (StringsKt.startsWith$default((String)string2, (String)externalStoragePath, (boolean)false, (int)2, null)) {
            String string3 = $this$getBasePath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"path");
            return TextUtils.trimFileSeparator(StringsKt.substringAfter((String)string3, (String)externalStoragePath, (String)""));
        }
        String dataDir = FileUtils.getDataDirectory(context).getPath();
        String string4 = $this$getBasePath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"path");
        Intrinsics.checkNotNullExpressionValue((Object)dataDir, (String)"dataDir");
        if (StringsKt.startsWith$default((String)string4, (String)dataDir, (boolean)false, (int)2, null)) {
            String string5 = $this$getBasePath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"path");
            return TextUtils.trimFileSeparator(StringsKt.substringAfter((String)string5, (String)dataDir, (String)""));
        }
        String storageId = FileUtils.getStorageId($this$getBasePath, context);
        String string6 = $this$getBasePath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"path");
        return TextUtils.trimFileSeparator(StringsKt.substringAfter((String)string6, (String)("/storage/" + storageId), (String)""));
    }

    @NotNull
    public static final String getRootPath(@NotNull File $this$getRootPath, @NotNull Context context) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$getRootPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String storageId = FileUtils.getStorageId($this$getRootPath, context);
        if (Intrinsics.areEqual((Object)storageId, (Object)"primary") || Intrinsics.areEqual((Object)storageId, (Object)"home")) {
            string2 = SimpleStorage.Companion.getExternalStoragePath();
        } else if (Intrinsics.areEqual((Object)storageId, (Object)"data")) {
            String string3 = FileUtils.getDataDirectory(context).getPath();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.dataDirectory.path");
        } else {
            string2 = TextUtils.isKitkatSdCardStorageId(storageId) ? "/storage/sdcard" : (((CharSequence)storageId).length() > 0 ? "/storage/" + storageId : "");
        }
        return string2;
    }

    @NotNull
    public static final String getSimplePath(@NotNull File $this$getSimplePath, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$getSimplePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return StringsKt.removePrefix((String)(FileUtils.getStorageId($this$getSimplePath, context) + ':' + FileUtils.getBasePath($this$getSimplePath, context)), (CharSequence)":");
    }

    @Nullable
    public static final String getMimeType(@NotNull File $this$mimeType) {
        Intrinsics.checkNotNullParameter((Object)$this$mimeType, (String)"<this>");
        return $this$mimeType.isFile() ? MimeType.getMimeTypeFromExtension(FilesKt.getExtension((File)$this$mimeType)) : null;
    }

    @JvmOverloads
    @Nullable
    public static final File getRootRawFile(@NotNull File $this$getRootRawFile, @NotNull Context context, boolean requiresWriteAccess) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$getRootRawFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String it = FileUtils.getRootPath($this$getRootRawFile, context);
        boolean bl = false;
        if (((CharSequence)it).length() == 0) {
            file = null;
        } else {
            File $this$getRootRawFile_u24lambda_u242_u24lambda_u241 = new File(it);
            boolean bl2 = false;
            file = FileUtils.takeIfWritable($this$getRootRawFile_u24lambda_u242_u24lambda_u241, context, requiresWriteAccess);
        }
        return file;
    }

    public static /* synthetic */ File getRootRawFile$default(File file, Context context, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return FileUtils.getRootRawFile(file, context, bl);
    }

    public static final boolean isReadOnly(@NotNull File $this$isReadOnly, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$isReadOnly, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return $this$isReadOnly.canRead() && !FileUtils.isWritable($this$isReadOnly, context);
    }

    public static final boolean canModify(@NotNull File $this$canModify, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$canModify, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return $this$canModify.canRead() && FileUtils.isWritable($this$canModify, context);
    }

    public static final boolean isEmpty(@NotNull File $this$isEmpty) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        return $this$isEmpty.isFile() && $this$isEmpty.length() == 0L || $this$isEmpty.isDirectory() && ((stringArray = $this$isEmpty.list()) == null || stringArray.length == 0);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final boolean shouldWritable(@NotNull File $this$shouldWritable, @NotNull Context context, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldWritable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return requiresWriteAccess && FileUtils.isWritable($this$shouldWritable, context) || !requiresWriteAccess;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public static final File takeIfWritable(@NotNull File $this$takeIfWritable, @NotNull Context context, boolean requiresWriteAccess) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$takeIfWritable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File it = file = $this$takeIfWritable;
        boolean bl = false;
        return it.canRead() && FileUtils.shouldWritable(it, context, requiresWriteAccess) ? file : null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final boolean checkRequirements(@NotNull File $this$checkRequirements, @NotNull Context context, boolean requiresWriteAccess, boolean considerRawFile) {
        Intrinsics.checkNotNullParameter((Object)$this$checkRequirements, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return $this$checkRequirements.canRead() && FileUtils.shouldWritable($this$checkRequirements, context, requiresWriteAccess) && (considerRawFile || FileUtils.isExternalStorageManager($this$checkRequirements, context));
    }

    public static final boolean createNewFileIfPossible(@NotNull File $this$createNewFileIfPossible) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$createNewFileIfPossible, (String)"<this>");
        try {
            bl = $this$createNewFileIfPossible.isFile() || $this$createNewFileIfPossible.createNewFile();
        }
        catch (IOException e) {
            bl = false;
        }
        return bl;
    }

    public static final boolean isWritable(@NotNull File $this$isWritable, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$isWritable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return $this$isWritable.canWrite() && ($this$isWritable.isFile() || FileUtils.isExternalStorageManager($this$isWritable, context));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final boolean inKitkatSdCard(@NotNull File $this$inKitkatSdCard) {
        Intrinsics.checkNotNullParameter((Object)$this$inKitkatSdCard, (String)"<this>");
        if (Build.VERSION.SDK_INT >= 21) return false;
        String string2 = $this$inKitkatSdCard.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
        if (StringsKt.startsWith$default((String)string2, (String)"sdcard", (boolean)false, (int)2, null)) return true;
        String string3 = $this$inKitkatSdCard.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"path");
        CharSequence charSequence = string3;
        if (!DocumentFileCompat.INSTANCE.getSD_CARD_STORAGE_PATH_REGEX().matches(charSequence)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isExternalStorageManager(@NotNull File $this$isExternalStorageManager, @NotNull Context context) {
        String string2;
        String string3;
        block6: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)$this$isExternalStorageManager, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (Build.VERSION.SDK_INT > 29) {
                    if (Environment.isExternalStorageManager((File)$this$isExternalStorageManager)) return true;
                }
                if (Build.VERSION.SDK_INT >= 29) break block6;
                String string4 = $this$isExternalStorageManager.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"path");
                if (StringsKt.startsWith$default((String)string4, (String)SimpleStorage.Companion.getExternalStoragePath(), (boolean)false, (int)2, null)) break block7;
                if (Build.VERSION.SDK_INT >= 21) break block6;
                String string5 = $this$isExternalStorageManager.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"path");
                if (!StringsKt.startsWith$default((String)string5, (String)"sdcard", (boolean)false, (int)2, null)) break block6;
            }
            if (SimpleStorage.Companion.hasStoragePermission(context)) return true;
        }
        Iterable $this$any$iv = FileUtils.getWritableDirs(context);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            File it = (File)element$iv;
            boolean bl = false;
            string3 = $this$isExternalStorageManager.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"path");
            string2 = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.path");
        } while (!StringsKt.startsWith$default((String)string3, (String)string2, (boolean)false, (int)2, null));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<File> getWritableDirs(@NotNull Context $this$writableDirs) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)$this$writableDirs, (String)"<this>");
        Object[] objectArray = new File[]{FileUtils.getDataDirectory($this$writableDirs)};
        Set dirs = SetsKt.mutableSetOf((Object[])objectArray);
        File[] fileArray = ContextCompat.getObbDirs((Context)$this$writableDirs);
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"getObbDirs(this)");
        dirs.addAll(ArraysKt.filterNotNull((Object[])fileArray));
        File[] fileArray2 = ContextCompat.getExternalFilesDirs((Context)$this$writableDirs, null);
        Intrinsics.checkNotNullExpressionValue((Object)fileArray2, (String)"getExternalFilesDirs(this, null)");
        objectArray = fileArray2;
        Set set = dirs;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            File it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            File file = it;
            if ((file != null ? file.getParentFile() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        set.addAll((List)destination$iv$iv);
        return dirs;
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public static final File makeFile(@NotNull File $this$makeFile, @NotNull Context context, @NotNull String name, @Nullable String mimeType, @NotNull CreateMode mode, @Nullable FileConflictCallback<File> onConflict) {
        File file;
        File file2;
        Intrinsics.checkNotNullParameter((Object)$this$makeFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        if (!$this$makeFile.isDirectory() || !FileUtils.isWritable($this$makeFile, context)) {
            return null;
        }
        String cleanName = TextUtils.trimFileSeparator(DocumentFileCompat.INSTANCE.removeForbiddenCharsFromFilename$storage_release(name));
        String subFolder = StringsKt.substringBeforeLast((String)cleanName, (char)'/', (String)"");
        if (((CharSequence)subFolder).length() == 0) {
            file2 = $this$makeFile;
        } else {
            file2 = FileUtils.makeFolder($this$makeFile, context, subFolder, mode);
            if (file2 == null) {
                return null;
            }
        }
        File parent = file2;
        String filename = StringsKt.substringAfterLast$default((String)cleanName, (char)'/', null, (int)2, null);
        String extensionByName = MimeType.getExtensionFromFileName(cleanName);
        String extension = ((CharSequence)extensionByName).length() > 0 && (mimeType == null || Intrinsics.areEqual((Object)mimeType, (Object)"*/*") || Intrinsics.areEqual((Object)mimeType, (Object)"application/octet-stream")) ? extensionByName : MimeType.getExtensionFromMimeTypeOrFileName(mimeType, cleanName);
        String baseFileName = StringsKt.removeSuffix((String)filename, (CharSequence)('.' + extension));
        char[] cArray = new char[]{'.'};
        String fullFileName = StringsKt.trimEnd((String)(baseFileName + '.' + extension), (char[])cArray);
        CreateMode createMode = mode;
        File targetFile = new File(parent, fullFileName);
        if (onConflict != null && targetFile.exists()) {
            CoroutineScope uiScope$iv = onConflict.getUiScope();
            boolean $i$f$awaitUiResultWithPending = false;
            createMode = ((FileCallback.ConflictResolution)((Object)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FileCallback.ConflictResolution>, Object>(uiScope$iv, null, onConflict, targetFile){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ CoroutineScope $uiScope;
                final /* synthetic */ FileConflictCallback $onConflict$inlined;
                final /* synthetic */ File $targetFile$inlined;
                {
                    this.$uiScope = $uiScope;
                    this.$onConflict$inlined = fileConflictCallback;
                    this.$targetFile$inlined = file;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope coroutineScope = this.$uiScope;
                            boolean $i$f$suspendCancellableCoroutine = false;
                            this.L$0 = coroutineScope;
                            this.label = 1;
                            Continuation uCont$iv = (Continuation)this;
                            boolean bl = false;
                            CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                            cancellable$iv.initCancellability();
                            CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                            boolean bl2 = false;
                            BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this.$onConflict$inlined, this.$targetFile$inlined){
                                int label;
                                final /* synthetic */ CancellableContinuation $it;
                                final /* synthetic */ FileConflictCallback $onConflict$inlined;
                                final /* synthetic */ File $targetFile$inlined;
                                {
                                    this.$it = $it;
                                    this.$onConflict$inlined = fileConflictCallback;
                                    this.$targetFile$inlined = file;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            CancellableContinuation it = this.$it;
                                            boolean bl = false;
                                            this.$onConflict$inlined.onFileConflict(this.$targetFile$inlined, new FileCallback.FileConflictAction((CancellableContinuation<? super FileCallback.ConflictResolution>)it));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null);
                            Object object3 = cancellable$iv.getResult();
                            if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                            }
                            Object object4 = object3;
                            if (object3 != object2) return object4;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            boolean $i$f$suspendCancellableCoroutine = false;
                            CoroutineScope cfr_ignored_0 = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object4 = $result;
                            return object4;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super FileCallback.ConflictResolution> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null))).toCreateMode(true);
        }
        if (createMode != CreateMode.CREATE_NEW && targetFile.exists()) {
            File file3;
            if (createMode == CreateMode.REPLACE) {
                File it = file = targetFile;
                boolean bl = false;
                file3 = FileUtils.recreateFile(it) ? file : null;
            } else {
                file3 = createMode != CreateMode.SKIP_IF_EXISTS && targetFile.isFile() ? targetFile : null;
            }
            return file3;
        }
        try {
            File it = new File(parent, FileUtils.autoIncrementFileName($this$makeFile, fullFileName));
            boolean bl = false;
            file = it.createNewFile() ? it : null;
        }
        catch (IOException e) {
            file = null;
        }
        return file;
    }

    public static /* synthetic */ File makeFile$default(File file, Context context, String string2, String string3, CreateMode createMode, FileConflictCallback fileConflictCallback, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "*/*";
        }
        if ((n & 8) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        if ((n & 0x10) != 0) {
            fileConflictCallback = null;
        }
        return FileUtils.makeFile(file, context, string2, string3, createMode, fileConflictCallback);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public static final File makeFolder(@NotNull File $this$makeFolder, @NotNull Context context, @NotNull String name, @NotNull CreateMode mode) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$makeFolder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        if (!$this$makeFolder.isDirectory() || !FileUtils.isWritable($this$makeFolder, context)) {
            return null;
        }
        List directorySequence = CollectionsKt.toMutableList((Collection)DocumentFileCompat.INSTANCE.getDirectorySequence$storage_release(DocumentFileCompat.INSTANCE.removeForbiddenCharsFromFilename$storage_release(name)));
        String string2 = (String)CollectionsKt.removeFirstOrNull((List)directorySequence);
        if (string2 == null) {
            return null;
        }
        String folderNameLevel1 = string2;
        String incrementedFolderNameLevel1 = mode == CreateMode.CREATE_NEW ? FileUtils.autoIncrementFileName($this$makeFolder, folderNameLevel1) : folderNameLevel1;
        File folderLevel1 = FileUtils.child($this$makeFolder, incrementedFolderNameLevel1);
        if (mode == CreateMode.REPLACE) {
            FileUtils.forceDelete(folderLevel1, true);
        } else if (mode == CreateMode.SKIP_IF_EXISTS && folderLevel1.exists()) {
            return null;
        }
        folderLevel1.mkdir();
        File it = folderLevel1;
        boolean bl = false;
        if (directorySequence.isEmpty()) {
            file = it;
        } else {
            File file2;
            File $this$makeFolder_u24lambda_u2410_u24lambda_u249 = file2 = FileUtils.child(it, CollectionsKt.joinToString$default((Iterable)directorySequence, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null));
            boolean bl2 = false;
            $this$makeFolder_u24lambda_u2410_u24lambda_u249.mkdirs();
            file = file2;
        }
        File folder = file;
        return folder.isDirectory() ? folder : null;
    }

    public static /* synthetic */ File makeFolder$default(File file, Context context, String string2, CreateMode createMode, int n, Object object) {
        if ((n & 4) != 0) {
            createMode = CreateMode.CREATE_NEW;
        }
        return FileUtils.makeFolder(file, context, string2, createMode);
    }

    @Nullable
    public static final DocumentFile toDocumentFile(@NotNull File $this$toDocumentFile, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$toDocumentFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return $this$toDocumentFile.canRead() ? DocumentFileCompat.fromFile$default(context, $this$toDocumentFile, null, false, false, 28, null) : null;
    }

    public static final boolean deleteEmptyFolders(@NotNull File $this$deleteEmptyFolders, @NotNull Context context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$deleteEmptyFolders, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if ($this$deleteEmptyFolders.isDirectory() && FileUtils.isWritable($this$deleteEmptyFolders, context)) {
            Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)FileUtils.walkFileTreeAndDeleteEmptyFolders($this$deleteEmptyFolders));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl2 = false;
                it.delete();
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final List<File> walkFileTreeAndDeleteEmptyFolders(File $this$walkFileTreeAndDeleteEmptyFolders) {
        List fileTree;
        block1: {
            fileTree = new ArrayList();
            File[] fileArray = $this$walkFileTreeAndDeleteEmptyFolders.listFiles();
            if (fileArray == null) break block1;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (!it.isDirectory() || it.delete()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                fileTree.add(it);
                fileTree.addAll((Collection)FileUtils.walkFileTreeAndDeleteEmptyFolders(it));
            }
        }
        return fileTree;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public static final boolean forceDelete(@NotNull File $this$forceDelete, boolean childrenOnly) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$forceDelete, (String)"<this>");
        if ($this$forceDelete.isDirectory()) {
            boolean success = FilesKt.deleteRecursively((File)$this$forceDelete);
            if (childrenOnly) {
                String[] stringArray;
                $this$forceDelete.mkdir();
                bl = $this$forceDelete.isDirectory() && ((stringArray = $this$forceDelete.list()) == null || stringArray.length == 0);
            } else {
                void var2_2;
                bl = var2_2;
            }
        } else {
            bl = $this$forceDelete.delete() || !$this$forceDelete.exists();
        }
        return bl;
    }

    public static /* synthetic */ boolean forceDelete$default(File file, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return FileUtils.forceDelete(file, bl);
    }

    public static final boolean recreateFile(@NotNull File $this$recreateFile) {
        Intrinsics.checkNotNullParameter((Object)$this$recreateFile, (String)"<this>");
        FileUtils.forceDelete$default($this$recreateFile, false, 1, null);
        return FileUtils.tryCreateNewFile($this$recreateFile);
    }

    public static final boolean tryCreateNewFile(@NotNull File $this$tryCreateNewFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$tryCreateNewFile, (String)"<this>");
        try {
            bl = $this$tryCreateNewFile.createNewFile();
        }
        catch (IOException e) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String autoIncrementFileName(@NotNull File $this$autoIncrementFileName, @NotNull String filename) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$autoIncrementFileName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        if (FileUtils.child($this$autoIncrementFileName, filename).exists()) {
            Comparable comparable;
            void $this$filterTo$iv$iv;
            String baseName = MimeType.getBaseFileName(filename);
            String ext = MimeType.getExtensionFromFileName(filename);
            String prefix = baseName + " (";
            String[] $this$orEmpty$iv = $this$autoIncrementFileName.list();
            boolean $i$f$orEmpty = false;
            String[] stringArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                boolean $i$f$emptyArray = false;
                stringArray = new String[]{};
            }
            String[] $this$filter$iv = stringArray;
            boolean $i$f$filter = false;
            String[] $i$f$emptyArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                boolean bl2 = StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null) && (DocumentFileCompat.INSTANCE.getFILE_NAME_DUPLICATION_REGEX_WITH_EXTENSION().matches((CharSequence)it) || DocumentFileCompat.INSTANCE.getFILE_NAME_DUPLICATION_REGEX_WITHOUT_EXTENSION().matches((CharSequence)it));
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterator iterator = ((Iterable)((List)destination$iv$iv)).iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                String it = (String)iterator.next();
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Integer n2 = StringsKt.toIntOrNull((String)StringsKt.substringBefore((String)StringsKt.substringAfterLast((String)it, (char)'(', (String)""), (char)')', (String)""));
                Comparable comparable2 = Integer.valueOf(n2 != null ? n2 : 0);
                while (iterator.hasNext()) {
                    String it2 = (String)iterator.next();
                    $i$a$-maxOfOrNull-FileUtils$autoIncrementFileName$lastFileCount$2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                    Integer n3 = StringsKt.toIntOrNull((String)StringsKt.substringBefore((String)StringsKt.substringAfterLast((String)it2, (char)'(', (String)""), (char)')', (String)""));
                    Comparable comparable3 = Integer.valueOf(n3 != null ? n3 : 0);
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            Integer n4 = (Integer)comparable;
            int lastFileCount = n4 != null ? n4 : 0;
            char[] cArray = new char[]{'.'};
            string2 = StringsKt.trimEnd((String)(baseName + " (" + ++lastFileCount + ")." + ext), (char[])cArray);
        } else {
            string2 = filename;
        }
        return string2;
    }

    @JvmOverloads
    @Nullable
    public static final File moveTo(@NotNull File $this$moveTo, @NotNull Context context, @NotNull String targetFolder, @Nullable String newFileNameInTarget, @NotNull FileCallback.ConflictResolution conflictResolution) {
        Intrinsics.checkNotNullParameter((Object)$this$moveTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        Intrinsics.checkNotNullParameter((Object)((Object)conflictResolution), (String)"conflictResolution");
        return FileUtils.moveTo($this$moveTo, context, new File(targetFolder), newFileNameInTarget, conflictResolution);
    }

    public static /* synthetic */ File moveTo$default(File file, Context context, String string2, String string3, FileCallback.ConflictResolution conflictResolution, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            conflictResolution = FileCallback.ConflictResolution.CREATE_NEW;
        }
        return FileUtils.moveTo(file, context, string2, string3, conflictResolution);
    }

    @JvmOverloads
    @Nullable
    public static final File moveTo(@NotNull File $this$moveTo, @NotNull Context context, @NotNull File targetFolder, @Nullable String newFileNameInTarget, @NotNull FileCallback.ConflictResolution conflictResolution) {
        Intrinsics.checkNotNullParameter((Object)$this$moveTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        Intrinsics.checkNotNullParameter((Object)((Object)conflictResolution), (String)"conflictResolution");
        if (!$this$moveTo.exists() || !FileUtils.isWritable($this$moveTo, context)) {
            return null;
        }
        targetFolder.mkdirs();
        if (!targetFolder.isDirectory() || !FileUtils.isWritable(targetFolder, context)) {
            return null;
        }
        String string2 = newFileNameInTarget;
        if (string2 == null) {
            string2 = $this$moveTo.getName();
        }
        String filename = string2;
        Intrinsics.checkNotNullExpressionValue((Object)filename, (String)"filename");
        File dest = FileUtils.child(targetFolder, filename);
        if (Intrinsics.areEqual((Object)$this$moveTo.getParent(), (Object)targetFolder.getPath())) {
            return $this$moveTo.renameTo(dest) ? dest : null;
        }
        if (!FileUtils.inSameMountPointWith($this$moveTo, context, targetFolder)) {
            return null;
        }
        if (dest.exists()) {
            switch (WhenMappings.$EnumSwitchMapping$0[conflictResolution.ordinal()]) {
                case 1: {
                    return null;
                }
                case 2: {
                    if (FileUtils.forceDelete$default(dest, false, 1, null)) break;
                    return null;
                }
                case 3: {
                    dest = FileUtils.child(targetFolder, FileUtils.autoIncrementFileName(targetFolder, filename));
                }
            }
        }
        if ($this$moveTo.renameTo(dest)) {
            return dest;
        }
        if ($this$moveTo.isDirectory()) {
            File file;
            dest.mkdirs();
            String string3 = $this$moveTo.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"path");
            String string4 = dest.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"dest.path");
            FileUtils.walkFileTreeForMove($this$moveTo, string3, string4);
            FilesKt.deleteRecursively((File)$this$moveTo);
            File it = file = dest;
            boolean bl = false;
            return !FileUtils.isEmpty(it) ? file : null;
        }
        return null;
    }

    public static /* synthetic */ File moveTo$default(File file, Context context, File file2, String string2, FileCallback.ConflictResolution conflictResolution, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            conflictResolution = FileCallback.ConflictResolution.CREATE_NEW;
        }
        return FileUtils.moveTo(file, context, file2, string2, conflictResolution);
    }

    private static final void walkFileTreeForMove(File $this$walkFileTreeForMove, String srcPath, String destFolderPath) {
        block2: {
            File[] fileArray = $this$walkFileTreeForMove.listFiles();
            if (fileArray == null) break block2;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                String string2 = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.path");
                char[] cArray = new char[]{'/'};
                File targetFile = new File(destFolderPath, StringsKt.trim((String)StringsKt.substringAfter$default((String)string2, (String)srcPath, null, (int)2, null), (char[])cArray));
                if (it.isFile()) {
                    it.renameTo(targetFile);
                    continue;
                }
                targetFile.mkdirs();
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                FileUtils.walkFileTreeForMove(it, srcPath, destFolderPath);
            }
        }
    }

    @JvmOverloads
    @Nullable
    public static final File getRootRawFile(@NotNull File $this$getRootRawFile, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$getRootRawFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return FileUtils.getRootRawFile$default($this$getRootRawFile, context, false, 2, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public static final File makeFile(@NotNull File $this$makeFile, @NotNull Context context, @NotNull String name, @Nullable String mimeType, @NotNull CreateMode mode) {
        Intrinsics.checkNotNullParameter((Object)$this$makeFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return FileUtils.makeFile$default($this$makeFile, context, name, mimeType, mode, null, 16, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public static final File makeFile(@NotNull File $this$makeFile, @NotNull Context context, @NotNull String name, @Nullable String mimeType) {
        Intrinsics.checkNotNullParameter((Object)$this$makeFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return FileUtils.makeFile$default($this$makeFile, context, name, mimeType, null, null, 24, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public static final File makeFile(@NotNull File $this$makeFile, @NotNull Context context, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$makeFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return FileUtils.makeFile$default($this$makeFile, context, name, null, null, null, 28, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public static final File makeFolder(@NotNull File $this$makeFolder, @NotNull Context context, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$makeFolder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return FileUtils.makeFolder$default($this$makeFolder, context, name, null, 4, null);
    }

    @JvmOverloads
    public static final boolean forceDelete(@NotNull File $this$forceDelete) {
        Intrinsics.checkNotNullParameter((Object)$this$forceDelete, (String)"<this>");
        return FileUtils.forceDelete$default($this$forceDelete, false, 1, null);
    }

    @JvmOverloads
    @Nullable
    public static final File moveTo(@NotNull File $this$moveTo, @NotNull Context context, @NotNull String targetFolder, @Nullable String newFileNameInTarget) {
        Intrinsics.checkNotNullParameter((Object)$this$moveTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        return FileUtils.moveTo$default($this$moveTo, context, targetFolder, newFileNameInTarget, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public static final File moveTo(@NotNull File $this$moveTo, @NotNull Context context, @NotNull String targetFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$moveTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        return FileUtils.moveTo$default($this$moveTo, context, targetFolder, null, null, 12, null);
    }

    @JvmOverloads
    @Nullable
    public static final File moveTo(@NotNull File $this$moveTo, @NotNull Context context, @NotNull File targetFolder, @Nullable String newFileNameInTarget) {
        Intrinsics.checkNotNullParameter((Object)$this$moveTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        return FileUtils.moveTo$default($this$moveTo, context, targetFolder, newFileNameInTarget, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public static final File moveTo(@NotNull File $this$moveTo, @NotNull Context context, @NotNull File targetFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$moveTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        return FileUtils.moveTo$default($this$moveTo, context, targetFolder, null, null, 12, null);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileCallback.ConflictResolution.values().length];
            try {
                nArray[FileCallback.ConflictResolution.SKIP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileCallback.ConflictResolution.REPLACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileCallback.ConflictResolution.CREATE_NEW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

