/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage.file;

import android.content.Context;
import android.net.Uri;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.documentfile.provider.DocumentFile;
import com.anggrayudi.storage.SimpleStorage;
import com.anggrayudi.storage.extension.ContextUtils;
import com.anggrayudi.storage.extension.TextUtils;
import com.anggrayudi.storage.file.DocumentFileCompat;
import com.anggrayudi.storage.file.FileUtils;
import com.anggrayudi.storage.file.StorageType;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB!\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ \u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010!\u001a\u00020 H\u0007J\u0010\u0010\"\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0002\u001a\u00020\u0003R\u001e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u001e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Lcom/anggrayudi/storage/file/FileFullPath;", "", "context", "Landroid/content/Context;", "fullPath", "", "(Landroid/content/Context;Ljava/lang/String;)V", "storageId", "basePath", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;)V", "storageType", "Lcom/anggrayudi/storage/file/StorageType;", "(Landroid/content/Context;Lcom/anggrayudi/storage/file/StorageType;Ljava/lang/String;)V", "file", "Ljava/io/File;", "(Landroid/content/Context;Ljava/io/File;)V", "<set-?>", "absolutePath", "getAbsolutePath", "()Ljava/lang/String;", "getBasePath", "simplePath", "getSimplePath", "getStorageId", "getStorageType", "()Lcom/anggrayudi/storage/file/StorageType;", "uri", "Landroid/net/Uri;", "getUri", "()Landroid/net/Uri;", "buildAbsolutePath", "buildBaseAndAbsolutePaths", "", "checkIfStorageIdIsAccessibleInSafSelector", "toDocumentUri", "storage_release"})
@SourceDebugExtension(value={"SMAP\nFileFullPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileFullPath.kt\ncom/anggrayudi/storage/file/FileFullPath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n288#2,2:143\n*S KotlinDebug\n*F\n+ 1 FileFullPath.kt\ncom/anggrayudi/storage/file/FileFullPath\n*L\n102#1:143,2\n*E\n"})
public final class FileFullPath {
    @NotNull
    private final String storageId;
    @NotNull
    private final String basePath;
    private String absolutePath;
    private String simplePath;

    @NotNull
    public final String getStorageId() {
        return this.storageId;
    }

    @NotNull
    public final String getBasePath() {
        return this.basePath;
    }

    @NotNull
    public final String getAbsolutePath() {
        String string2 = this.absolutePath;
        if (string2 != null) {
            return string2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"absolutePath");
        return null;
    }

    @NotNull
    public final String getSimplePath() {
        String string2 = this.simplePath;
        if (string2 != null) {
            return string2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"simplePath");
        return null;
    }

    public FileFullPath(@NotNull Context context, @NotNull String fullPath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        if (StringsKt.startsWith$default((CharSequence)fullPath, (char)'/', (boolean)false, (int)2, null)) {
            if (StringsKt.startsWith$default((String)fullPath, (String)SimpleStorage.Companion.getExternalStoragePath(), (boolean)false, (int)2, null)) {
                this.storageId = "primary";
                String rootPath = SimpleStorage.Companion.getExternalStoragePath();
                this.basePath = TextUtils.trimFileSeparator(StringsKt.substringAfter((String)fullPath, (String)rootPath, (String)""));
                this.simplePath = this.storageId + ':' + this.basePath;
                char[] cArray = new char[]{'/'};
                this.absolutePath = StringsKt.trimEnd((String)(rootPath + '/' + this.basePath), (char[])cArray);
            } else {
                String string2 = FileUtils.getDataDirectory(context).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.dataDirectory.path");
                if (StringsKt.startsWith$default((String)fullPath, (String)string2, (boolean)false, (int)2, null)) {
                    this.storageId = "data";
                    String rootPath = FileUtils.getDataDirectory(context).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)rootPath, (String)"rootPath");
                    this.basePath = TextUtils.trimFileSeparator(StringsKt.substringAfter((String)fullPath, (String)rootPath, (String)""));
                    this.simplePath = this.storageId + ':' + this.basePath;
                    char[] cArray = new char[]{'/'};
                    this.absolutePath = StringsKt.trimEnd((String)(rootPath + '/' + this.basePath), (char[])cArray);
                } else if (StringsKt.startsWith$default((String)fullPath, (String)"/storage/sdcard", (boolean)false, (int)2, null)) {
                    this.storageId = "sdcard";
                    this.basePath = TextUtils.trimFileSeparator(StringsKt.substringAfter((String)fullPath, (String)"/storage/sdcard", (String)""));
                    this.simplePath = this.storageId + ':' + this.basePath;
                    char[] cArray = new char[]{'/'};
                    this.absolutePath = StringsKt.trimEnd((String)("/storage/sdcard/" + this.basePath), (char[])cArray);
                } else {
                    Object object = fullPath;
                    if (DocumentFileCompat.INSTANCE.getSD_CARD_STORAGE_PATH_REGEX().matches((CharSequence)object)) {
                        this.storageId = StringsKt.substringBefore$default((String)StringsKt.substringAfter((String)fullPath, (String)"/storage/", (String)""), (char)'/', null, (int)2, null);
                        this.basePath = TextUtils.trimFileSeparator(StringsKt.substringAfter((String)fullPath, (String)("/storage/" + this.storageId), (String)""));
                        this.simplePath = this.storageId + ':' + this.basePath;
                        object = new char[1];
                        object[0] = 47;
                        this.absolutePath = StringsKt.trimEnd((String)("/storage/" + this.storageId + '/' + this.basePath), (char[])object);
                    } else {
                        this.storageId = "";
                        this.basePath = "";
                        this.simplePath = "";
                        this.absolutePath = "";
                    }
                }
            }
        } else {
            this.simplePath = fullPath;
            this.storageId = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore((String)fullPath, (char)':', (String)""), (char)'/', null, (int)2, null);
            this.basePath = TextUtils.trimFileSeparator(StringsKt.substringAfter((String)fullPath, (char)':', (String)""));
            this.absolutePath = this.buildAbsolutePath(context, this.storageId, this.basePath);
        }
    }

    public FileFullPath(@NotNull Context context, @NotNull String storageId, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.storageId = storageId;
        this.basePath = TextUtils.trimFileSeparator(basePath);
        this.buildBaseAndAbsolutePaths(context);
    }

    /*
     * Unable to fully structure code
     */
    @RequiresApi(value=30)
    public FileFullPath(@NotNull Context context, @NotNull StorageType storageType, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageType, (String)"storageType");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        super();
        this.basePath = TextUtils.trimFileSeparator(basePath);
        v0 = context.getSystemService("storage");
        Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type android.os.storage.StorageManager");
        sm = (StorageManager)v0;
        v1 = this;
        switch (WhenMappings.$EnumSwitchMapping$0[storageType.ordinal()]) {
            case 1: {
                v2 = sm.getStorageVolumes();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"sm.storageVolumes");
                var5_5 = v2;
                var11_6 = v1;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (StorageVolume)element$iv;
                    $i$a$-firstOrNull-FileFullPath$1 = false;
                    if (!it.isRemovable()) continue;
                    v3 = element$iv;
                    ** GOTO lbl24
                }
                v3 = null;
lbl24:
                // 2 sources

                v1 = var11_6;
                v4 = v3;
                v5 = v4 != null ? v4.getMediaStoreVolumeName() : null;
                if (v5 != null) break;
                v5 = "";
                break;
            }
            case 2: {
                v5 = "primary";
                break;
            }
            case 3: {
                v5 = "data";
                break;
            }
            default: {
                v5 = "";
            }
        }
        v1.storageId = v5;
        this.buildBaseAndAbsolutePaths(context);
    }

    public /* synthetic */ FileFullPath(Context context, StorageType storageType, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        this(context, storageType, string2);
    }

    public FileFullPath(@NotNull Context context, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string2 = file.getPath();
        if (string2 == null) {
            string2 = "";
        }
        this(context, string2);
    }

    private final String buildAbsolutePath(Context context, String storageId, String basePath) {
        String string2;
        if (((CharSequence)storageId).length() == 0) {
            string2 = "";
        } else {
            String string3 = storageId;
            if (Intrinsics.areEqual((Object)string3, (Object)"primary")) {
                char[] cArray = new char[]{'/'};
                string2 = StringsKt.trimEnd((String)(SimpleStorage.Companion.getExternalStoragePath() + '/' + basePath), (char[])cArray);
            } else if (Intrinsics.areEqual((Object)string3, (Object)"data")) {
                char[] cArray = new char[]{'/'};
                string2 = StringsKt.trimEnd((String)(FileUtils.getDataDirectory(context).getPath() + '/' + basePath), (char[])cArray);
            } else {
                char[] cArray = new char[]{'/'};
                string2 = StringsKt.trimEnd((String)("/storage/" + storageId + '/' + basePath), (char[])cArray);
            }
        }
        return string2;
    }

    private final void buildBaseAndAbsolutePaths(Context context) {
        this.absolutePath = this.buildAbsolutePath(context, this.storageId, this.basePath);
        this.simplePath = ((CharSequence)this.storageId).length() == 0 ? "" : this.storageId + ':' + this.basePath;
    }

    @Nullable
    public final Uri getUri() {
        return ((CharSequence)this.storageId).length() == 0 ? null : DocumentFileCompat.createDocumentUri(this.storageId, this.basePath);
    }

    @Nullable
    public final Uri toDocumentUri(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Uri uri = this.getUri();
        if (uri == null) {
            return null;
        }
        DocumentFile documentFile = ContextUtils.fromTreeUri(context, uri);
        return documentFile != null ? documentFile.getUri() : null;
    }

    @NotNull
    public final StorageType getStorageType() {
        return StorageType.Companion.fromStorageId(this.storageId);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void checkIfStorageIdIsAccessibleInSafSelector() {
        if (((CharSequence)this.storageId).length() == 0) {
            throw new IllegalArgumentException("Empty storage ID");
        }
        if (Intrinsics.areEqual((Object)this.storageId, (Object)"data")) {
            throw new IllegalArgumentException("Cannot use StorageType.DATA because it is never available in Storage Access Framework's folder selector.");
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StorageType.values().length];
            try {
                nArray[StorageType.SD_CARD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageType.EXTERNAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageType.DATA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

