/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage.file;

import android.content.ContentResolver;
import android.content.Context;
import android.content.UriPermission;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.StatFs;
import android.system.Os;
import android.system.StructStatVfs;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import androidx.documentfile.provider.DocumentFile;
import com.anggrayudi.storage.FileWrapper;
import com.anggrayudi.storage.SimpleStorage;
import com.anggrayudi.storage.extension.ContextUtils;
import com.anggrayudi.storage.extension.TextUtils;
import com.anggrayudi.storage.extension.UriUtils;
import com.anggrayudi.storage.file.DocumentFileType;
import com.anggrayudi.storage.file.DocumentFileUtils;
import com.anggrayudi.storage.file.FileUtils;
import com.anggrayudi.storage.file.PublicDirectory;
import com.anggrayudi.storage.media.FileDescription;
import com.anggrayudi.storage.media.MediaFile;
import com.anggrayudi.storage.media.MediaStoreCompat;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u0004H\u0007J\u001a\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020#H\u0007J8\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\b\b\u0002\u0010&\u001a\u00020\u00042\b\b\u0002\u0010'\u001a\u00020\u001cH\u0007J\u001a\u0010(\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020#H\u0007J\u0018\u0010)\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u0004H\u0007J\u0018\u0010+\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u0004H\u0007J:\u0010,\u001a\u0004\u0018\u00010%2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001cH\u0002J$\u00100\u001a\b\u0012\u0004\u0012\u00020\u0004012\u0006\u0010\u0014\u001a\u00020\u00152\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000401H\u0007J$\u00103\u001a\b\u0012\u0004\u0012\u00020\u0004012\u0006\u0010\u0014\u001a\u00020\u00152\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000405H\u0007J$\u00106\u001a\b\u0012\u0004\u0012\u00020\u0004012\u0006\u0010\u0014\u001a\u00020\u00152\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000405H\u0007J8\u00107\u001a\u0004\u0018\u00010%2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u00020\u001c2\b\b\u0002\u0010'\u001a\u00020\u001cH\u0007J8\u00108\u001a\u0004\u0018\u00010%2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u00042\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u00020\u001c2\b\b\u0002\u0010'\u001a\u00020\u001cH\u0007J8\u00109\u001a\u0004\u0018\u00010%2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010:\u001a\u00020;2\b\b\u0002\u0010<\u001a\u00020\u00042\b\b\u0002\u0010/\u001a\u00020\u001c2\b\b\u0002\u0010'\u001a\u00020\u001cH\u0007JD\u0010=\u001a\u0004\u0018\u00010%2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u00042\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u00020\u001c2\b\b\u0002\u0010'\u001a\u00020\u001cH\u0007J\u001a\u0010>\u001a\u0004\u0018\u00010%2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010?\u001a\u00020 H\u0007J\"\u0010@\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040B0A2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J.\u0010C\u001a\u0004\u0018\u00010%2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u00042\b\b\u0002\u0010/\u001a\u00020\u001c2\b\b\u0002\u0010'\u001a\u00020\u001cH\u0007J\"\u0010D\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020 010A2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010E\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u0004H\u0007J\u001b\u0010F\u001a\b\u0012\u0004\u0012\u00020\u0004012\u0006\u0010G\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bHJ\u001a\u0010I\u001a\u0004\u0018\u00010%2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u0010\u0010J\u001a\u00020\u00042\u0006\u0010G\u001a\u00020\u0004H\u0002J\u0010\u0010K\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\u0004H\u0007J\u0018\u0010M\u001a\u00020N2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J\u0012\u0010O\u001a\u00020\u001e2\b\b\u0002\u0010\u0018\u001a\u00020\u0004H\u0007J\u0012\u0010P\u001a\u0004\u0018\u00010\u00042\u0006\u0010G\u001a\u00020\u0004H\u0002J.\u0010Q\u001a\u0004\u0018\u00010%2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00042\b\b\u0002\u0010/\u001a\u00020\u001c2\b\b\u0002\u0010'\u001a\u00020\u001cH\u0007J$\u0010R\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00042\b\b\u0002\u0010/\u001a\u00020\u001cH\u0007J\u0016\u0010S\u001a\b\u0012\u0004\u0012\u00020\u0004012\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010T\u001a\u00020N2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J\u0018\u0010U\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u0004H\u0007J\u0016\u0010V\u001a\b\u0012\u0004\u0012\u00020\u0004012\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010W\u001a\u00020N2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J\u0018\u0010X\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J\u0010\u0010Y\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010Z\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010[\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020 H\u0007J\"\u0010\\\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u0004H\u0007J\u0018\u0010]\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010?\u001a\u00020 H\u0002J.\u0010^\u001a\u0004\u0018\u00010%2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u00042\b\b\u0002\u0010/\u001a\u00020\u001c2\b\b\u0002\u0010'\u001a\u00020\u001cH\u0007J?\u0010^\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0_2\u0006\u0010\u0014\u001a\u00020\u00152\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0004012\b\b\u0002\u0010/\u001a\u00020\u001c2\b\b\u0002\u0010'\u001a\u00020\u001cH\u0007\u00a2\u0006\u0002\u0010`J*\u0010a\u001a\u0004\u0018\u00010%2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u001cH\u0002J8\u0010b\u001a\u0004\u0018\u00010%2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\b\b\u0002\u0010&\u001a\u00020\u00042\b\b\u0002\u0010'\u001a\u00020\u001cH\u0007J\u0011\u0010c\u001a\u00020\u0004*\u00020\u0004H\u0000\u00a2\u0006\u0002\bdR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0016\u0010\u0011\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006e"}, d2={"Lcom/anggrayudi/storage/file/DocumentFileCompat;", "", "()V", "DOCUMENTS_TREE_URI", "", "DOWNLOADS_FOLDER_AUTHORITY", "DOWNLOADS_TREE_URI", "EXTERNAL_STORAGE_AUTHORITY", "FILE_NAME_DUPLICATION_REGEX_WITHOUT_EXTENSION", "Lkotlin/text/Regex;", "getFILE_NAME_DUPLICATION_REGEX_WITHOUT_EXTENSION", "()Lkotlin/text/Regex;", "FILE_NAME_DUPLICATION_REGEX_WITH_EXTENSION", "getFILE_NAME_DUPLICATION_REGEX_WITH_EXTENSION", "MEDIA_FOLDER_AUTHORITY", "SD_CARD_STORAGE_ID_REGEX", "getSD_CARD_STORAGE_ID_REGEX", "SD_CARD_STORAGE_PATH_REGEX", "getSD_CARD_STORAGE_PATH_REGEX", "buildAbsolutePath", "context", "Landroid/content/Context;", "simplePath", "storageId", "basePath", "buildSimplePath", "absolutePath", "create", "", "file", "Ljava/io/File;", "createDocumentUri", "Landroid/net/Uri;", "createDownloadWithMediaStoreFallback", "Lcom/anggrayudi/storage/FileWrapper;", "Lcom/anggrayudi/storage/media/FileDescription;", "createFile", "Landroidx/documentfile/provider/DocumentFile;", "mimeType", "considerRawFile", "createPictureWithMediaStoreFallback", "delete", "fullPath", "doesExist", "exploreFile", "documentType", "Lcom/anggrayudi/storage/file/DocumentFileType;", "requiresWriteAccess", "findInaccessibleStorageLocations", "", "fullPaths", "findUniqueDeepestSubFolders", "folderFullPaths", "", "findUniqueParents", "fromFile", "fromFullPath", "fromPublicFolder", "type", "Lcom/anggrayudi/storage/file/PublicDirectory;", "subFile", "fromSimplePath", "fromUri", "uri", "getAccessibleAbsolutePaths", "", "", "getAccessibleRootDocumentFile", "getAccessibleUris", "getBasePath", "getDirectorySequence", "path", "getDirectorySequence$storage_release", "getDocumentFileForStorageInfo", "getFileNameFromPath", "getFileNameFromUrl", "url", "getFreeSpace", "", "getKitkatSdCardRootFile", "getParentPath", "getRootDocumentFile", "getRootRawFile", "getSdCardIds", "getStorageCapacity", "getStorageId", "getStorageIds", "getUsedSpace", "isAccessGranted", "isDocumentsUriPermissionGranted", "isDownloadsUriPermissionGranted", "isRootUri", "isStorageUriPermissionGranted", "isUriPermissionGranted", "mkdirs", "", "(Landroid/content/Context;Ljava/util/List;ZZ)[Landroidx/documentfile/provider/DocumentFile;", "mkdirsParentDirectory", "recreate", "removeForbiddenCharsFromFilename", "removeForbiddenCharsFromFilename$storage_release", "storage_release"})
@SourceDebugExtension(value={"SMAP\nDocumentFileCompat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentFileCompat.kt\ncom/anggrayudi/storage/file/DocumentFileCompat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1008:1\n1#2:1009\n1#2:1035\n766#3:1010\n857#3,2:1011\n1855#3,2:1013\n1747#3,3:1015\n1549#3:1018\n1620#3,3:1019\n766#3:1022\n857#3,2:1023\n1603#3,9:1025\n1855#3:1034\n1856#3:1036\n1612#3:1037\n766#3:1038\n857#3,2:1039\n766#3:1041\n857#3,2:1042\n1855#3,2:1044\n766#3:1046\n857#3,2:1047\n1549#3:1049\n1620#3,3:1050\n1477#3:1053\n1502#3,3:1054\n1505#3,3:1064\n1855#3,2:1074\n1549#3:1076\n1620#3,3:1077\n1864#3,3:1080\n1855#3:1083\n1864#3,3:1084\n1864#3,3:1087\n1856#3:1090\n1855#3,2:1091\n819#3:1093\n847#3,2:1094\n1549#3:1096\n1620#3,3:1097\n1855#3,2:1100\n1549#3:1102\n1620#3,3:1103\n1855#3:1106\n1747#3,3:1107\n1856#3:1110\n1549#3:1114\n1620#3,3:1115\n361#4,7:1057\n515#4:1067\n500#4,6:1068\n13644#5,3:1111\n*S KotlinDebug\n*F\n+ 1 DocumentFileCompat.kt\ncom/anggrayudi/storage/file/DocumentFileCompat\n*L\n496#1:1035\n356#1:1010\n356#1:1011,2\n357#1:1013,2\n470#1:1015,3\n481#1:1018\n481#1:1019,3\n495#1:1022\n495#1:1023,2\n496#1:1025,9\n496#1:1034\n496#1:1036\n496#1:1037\n505#1:1038\n505#1:1039,2\n517#1:1041\n517#1:1042,2\n518#1:1044,2\n554#1:1046\n554#1:1047,2\n555#1:1049\n555#1:1050,3\n556#1:1053\n556#1:1054,3\n556#1:1064,3\n592#1:1074,2\n624#1:1076\n624#1:1077,3\n630#1:1080,3\n639#1:1083\n645#1:1084,3\n653#1:1087,3\n639#1:1090\n665#1:1091,2\n839#1:1093\n839#1:1094,2\n861#1:1096\n861#1:1097,3\n863#1:1100,2\n889#1:1102\n889#1:1103,3\n891#1:1106\n892#1:1107,3\n891#1:1110\n913#1:1114\n913#1:1115,3\n556#1:1057,7\n557#1:1067\n557#1:1068,6\n906#1:1111,3\n*E\n"})
public final class DocumentFileCompat {
    @NotNull
    public static final DocumentFileCompat INSTANCE = new DocumentFileCompat();
    @NotNull
    public static final String EXTERNAL_STORAGE_AUTHORITY = "com.android.externalstorage.documents";
    @NotNull
    public static final String DOWNLOADS_FOLDER_AUTHORITY = "com.android.providers.downloads.documents";
    @NotNull
    public static final String MEDIA_FOLDER_AUTHORITY = "com.android.providers.media.documents";
    @NotNull
    public static final String DOWNLOADS_TREE_URI = "content://com.android.providers.downloads.documents/tree/downloads";
    @NotNull
    public static final String DOCUMENTS_TREE_URI = "content://com.android.externalstorage.documents/tree/home%3A";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    private static final Regex FILE_NAME_DUPLICATION_REGEX_WITH_EXTENSION = new Regex("(.*?) \\(\\d+\\)\\.[a-zA-Z0-9]+");
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    private static final Regex FILE_NAME_DUPLICATION_REGEX_WITHOUT_EXTENSION = new Regex("(.*?) \\(\\d+\\)");
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    private static final Regex SD_CARD_STORAGE_ID_REGEX = new Regex("[A-Z0-9]{4}-[A-Z0-9]{4}");
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    private static final Regex SD_CARD_STORAGE_PATH_REGEX = new Regex("/storage/" + SD_CARD_STORAGE_ID_REGEX + "(.*?)");

    private DocumentFileCompat() {
    }

    @NotNull
    public final Regex getFILE_NAME_DUPLICATION_REGEX_WITH_EXTENSION() {
        return FILE_NAME_DUPLICATION_REGEX_WITH_EXTENSION;
    }

    @NotNull
    public final Regex getFILE_NAME_DUPLICATION_REGEX_WITHOUT_EXTENSION() {
        return FILE_NAME_DUPLICATION_REGEX_WITHOUT_EXTENSION;
    }

    @NotNull
    public final Regex getSD_CARD_STORAGE_ID_REGEX() {
        return SD_CARD_STORAGE_ID_REGEX;
    }

    @NotNull
    public final Regex getSD_CARD_STORAGE_PATH_REGEX() {
        return SD_CARD_STORAGE_PATH_REGEX;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    public final File getKitkatSdCardRootFile(@NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        char[] cArray = new char[]{'/'};
        return new File("/storage/sdcard" + StringsKt.trimEnd((String)('/' + basePath), (char[])cArray));
    }

    public static /* synthetic */ File getKitkatSdCardRootFile$default(DocumentFileCompat documentFileCompat, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "";
        }
        return documentFileCompat.getKitkatSdCardRootFile(string2);
    }

    @JvmStatic
    public static final boolean isRootUri(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string2 = uri.getPath();
        if (string2 == null) {
            return false;
        }
        String path = string2;
        return UriUtils.isExternalStorageDocument(uri) && StringsKt.indexOf$default((CharSequence)path, (char)':', (int)0, (boolean)false, (int)6, null) == path.length() - 1 && !StringsKt.startsWith$default((String)path, (String)"/tree/home:", (boolean)false, (int)2, null);
    }

    @JvmStatic
    @NotNull
    public static final String getStorageId(@NotNull Context context, @NotNull String fullPath) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        if (StringsKt.startsWith$default((CharSequence)fullPath, (char)'/', (boolean)false, (int)2, null)) {
            if (StringsKt.startsWith$default((String)fullPath, (String)SimpleStorage.Companion.getExternalStoragePath(), (boolean)false, (int)2, null)) {
                string2 = "primary";
            } else {
                String string3 = FileUtils.getDataDirectory(context).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.dataDirectory.path");
                if (StringsKt.startsWith$default((String)fullPath, (String)string3, (boolean)false, (int)2, null)) {
                    string2 = "data";
                } else if (StringsKt.startsWith$default((String)fullPath, (String)"/storage/sdcard", (boolean)false, (int)2, null)) {
                    string2 = "sdcard";
                } else {
                    CharSequence charSequence = fullPath;
                    string2 = SD_CARD_STORAGE_PATH_REGEX.matches(charSequence) ? StringsKt.substringBefore$default((String)StringsKt.substringAfter((String)fullPath, (String)"/storage/", (String)""), (char)'/', null, (int)2, null) : "";
                }
            }
        } else {
            string2 = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore((String)fullPath, (char)':', (String)""), (char)'/', null, (int)2, null);
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getBasePath(@NotNull Context context, @NotNull String fullPath) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        if (StringsKt.startsWith$default((CharSequence)fullPath, (char)'/', (boolean)false, (int)2, null)) {
            String dataDir = FileUtils.getDataDirectory(context).getPath();
            String externalStoragePath = SimpleStorage.Companion.getExternalStoragePath();
            if (StringsKt.startsWith$default((String)fullPath, (String)externalStoragePath, (boolean)false, (int)2, null)) {
                string2 = StringsKt.substringAfter$default((String)fullPath, (String)externalStoragePath, null, (int)2, null);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)dataDir, (String)"dataDir");
                if (StringsKt.startsWith$default((String)fullPath, (String)dataDir, (boolean)false, (int)2, null)) {
                    string2 = StringsKt.substringAfter$default((String)fullPath, (String)dataDir, null, (int)2, null);
                } else if (StringsKt.startsWith$default((String)fullPath, (String)"/storage/sdcard", (boolean)false, (int)2, null)) {
                    string2 = StringsKt.substringAfter$default((String)fullPath, (String)"/storage/sdcard", null, (int)2, null);
                } else {
                    CharSequence charSequence = fullPath;
                    string2 = SD_CARD_STORAGE_PATH_REGEX.matches(charSequence) ? StringsKt.substringAfter((String)StringsKt.substringAfter((String)fullPath, (String)"/storage/", (String)""), (char)'/', (String)"") : "";
                }
            }
        } else {
            string2 = StringsKt.substringAfter((String)fullPath, (char)':', (String)"");
        }
        String basePath = string2;
        return INSTANCE.removeForbiddenCharsFromFilename$storage_release(TextUtils.trimFileSeparator(basePath));
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmStatic
    @Nullable
    public static final DocumentFile fromUri(@NotNull Context context, @NotNull Uri uri) {
        DocumentFile documentFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (UriUtils.isRawFile(uri)) {
            String string2 = uri.getPath();
            if (string2 == null) {
                return null;
            }
            File $this$fromUri_u24lambda_u240 = new File(string2);
            boolean bl = false;
            if (!$this$fromUri_u24lambda_u240.canRead()) return null;
            documentFile = DocumentFile.fromFile((File)$this$fromUri_u24lambda_u240);
            return documentFile;
        }
        if (UriUtils.isTreeDocumentFile(uri)) {
            DocumentFile documentFile2 = ContextUtils.fromTreeUri(context, uri);
            if (documentFile2 == null) {
                return null;
            }
            DocumentFile $this$fromUri_u24lambda_u241 = documentFile2;
            boolean bl = false;
            if (DocumentFileUtils.isDownloadsDocument($this$fromUri_u24lambda_u241)) {
                documentFile = DocumentFileUtils.toWritableDownloadsDocumentFile($this$fromUri_u24lambda_u241, context);
                return documentFile;
            }
            documentFile = $this$fromUri_u24lambda_u241;
            return documentFile;
        }
        DocumentFile documentFile3 = ContextUtils.fromSingleUri(context, uri);
        if (documentFile3 == null) {
            return null;
        }
        DocumentFile it = documentFile3;
        boolean bl = false;
        if (Build.VERSION.SDK_INT < 21) {
            CharSequence charSequence = DocumentFileUtils.getStorageId(it, context);
            if (SD_CARD_STORAGE_ID_REGEX.matches(charSequence)) {
                documentFile = DocumentFile.fromFile((File)INSTANCE.getKitkatSdCardRootFile(DocumentFileUtils.getBasePath(it, context)));
                return documentFile;
            }
        }
        documentFile = it;
        return documentFile;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromSimplePath(@NotNull Context context, @NotNull String storageId, @NotNull String basePath, @NotNull DocumentFileType documentType, boolean requiresWriteAccess, boolean considerRawFile) {
        Object object;
        block7: {
            DocumentFile file;
            block8: {
                Object object2;
                block10: {
                    block9: {
                        DocumentFile documentFile;
                        block6: {
                            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                            Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
                            Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
                            Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
                            if (Intrinsics.areEqual((Object)storageId, (Object)"data")) {
                                return DocumentFile.fromFile((File)FileUtils.child(FileUtils.getDataDirectory(context), basePath));
                            }
                            if (!(((CharSequence)basePath).length() == 0) || Intrinsics.areEqual((Object)storageId, (Object)"home")) break block6;
                            object = DocumentFileCompat.getRootDocumentFile(context, storageId, requiresWriteAccess, considerRawFile);
                            break block7;
                        }
                        file = INSTANCE.exploreFile(context, storageId, basePath, documentType, requiresWriteAccess, considerRawFile);
                        if (file != null || !Intrinsics.areEqual((Object)storageId, (Object)"primary")) break block8;
                        String string2 = Environment.DIRECTORY_DOWNLOADS;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DIRECTORY_DOWNLOADS");
                        if (!TextUtils.hasParent(basePath, string2)) break block8;
                        Uri uri = Uri.parse((String)DOWNLOADS_TREE_URI);
                        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(DOWNLOADS_TREE_URI)");
                        object2 = ContextUtils.fromTreeUri(context, uri);
                        if (object2 == null) break block9;
                        DocumentFile it = documentFile = object2;
                        boolean bl = false;
                        object2 = it.canRead() ? documentFile : null;
                        if (object2 != null) break block10;
                    }
                    return null;
                }
                DocumentFile downloads = object2;
                DocumentFile documentFile = DocumentFileUtils.child$default(downloads, context, StringsKt.substringAfter((String)basePath, (char)'/', (String)""), false, 4, null);
                if (documentFile != null) {
                    DocumentFile documentFile2;
                    DocumentFile it = documentFile2 = documentFile;
                    boolean bl = false;
                    object = documentType == DocumentFileType.ANY || documentType == DocumentFileType.FILE && it.isFile() || documentType == DocumentFileType.FOLDER && it.isDirectory() ? documentFile2 : null;
                } else {
                    object = null;
                }
                break block7;
            }
            object = file;
        }
        return object;
    }

    public static /* synthetic */ DocumentFile fromSimplePath$default(Context context, String string2, String string3, DocumentFileType documentFileType, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "primary";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            documentFileType = DocumentFileType.ANY;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return DocumentFileCompat.fromSimplePath(context, string2, string3, documentFileType, bl, bl2);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromFullPath(@NotNull Context context, @NotNull String fullPath, @NotNull DocumentFileType documentType, boolean requiresWriteAccess, boolean considerRawFile) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        return StringsKt.startsWith$default((CharSequence)fullPath, (char)'/', (boolean)false, (int)2, null) ? DocumentFileCompat.fromFile(context, new File(fullPath), documentType, requiresWriteAccess, considerRawFile) : DocumentFileCompat.fromSimplePath(context, StringsKt.substringBefore$default((String)fullPath, (char)':', null, (int)2, null), StringsKt.substringAfter$default((String)fullPath, (char)':', null, (int)2, null), documentType, requiresWriteAccess, considerRawFile);
    }

    public static /* synthetic */ DocumentFile fromFullPath$default(Context context, String string2, DocumentFileType documentFileType, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            documentFileType = DocumentFileType.ANY;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        return DocumentFileCompat.fromFullPath(context, string2, documentFileType, bl, bl2);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromFile(@NotNull Context context, @NotNull File file, @NotNull DocumentFileType documentType, boolean requiresWriteAccess, boolean considerRawFile) {
        DocumentFile documentFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        if (FileUtils.checkRequirements(file, context, requiresWriteAccess, considerRawFile || Build.VERSION.SDK_INT < 21)) {
            documentFile = documentType == DocumentFileType.FILE && !file.isFile() || documentType == DocumentFileType.FOLDER && !file.isDirectory() ? null : DocumentFile.fromFile((File)file);
        } else {
            String basePath = TextUtils.trimFileSeparator(INSTANCE.removeForbiddenCharsFromFilename$storage_release(FileUtils.getBasePath(file, context)));
            documentFile = INSTANCE.exploreFile(context, FileUtils.getStorageId(file, context), basePath, documentType, requiresWriteAccess, considerRawFile);
            if (documentFile == null) {
                documentFile = DocumentFileCompat.fromSimplePath(context, FileUtils.getStorageId(file, context), basePath, documentType, requiresWriteAccess, considerRawFile);
            }
        }
        return documentFile;
    }

    public static /* synthetic */ DocumentFile fromFile$default(Context context, File file, DocumentFileType documentFileType, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            documentFileType = DocumentFileType.ANY;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        return DocumentFileCompat.fromFile(context, file, documentFileType, bl, bl2);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromPublicFolder(@NotNull Context context, @NotNull PublicDirectory type, @NotNull String subFile, boolean requiresWriteAccess, boolean considerRawFile) {
        Object object;
        DocumentFile folder;
        DocumentFile documentFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)subFile, (String)"subFile");
        Ref.ObjectRef rawFile = new Ref.ObjectRef();
        rawFile.element = type.getFile();
        if (((CharSequence)subFile).length() > 0) {
            char[] cArray = new char[]{'/'};
            rawFile.element = new File(StringsKt.trimEnd((String)(rawFile.element + '/' + subFile), (char[])cArray));
        }
        if (FileUtils.checkRequirements((File)rawFile.element, context, requiresWriteAccess, considerRawFile)) {
            return DocumentFile.fromFile((File)((File)rawFile.element));
        }
        Function1 fileFromUriOrAbsolutePath2 = (Function1)new Function1<String, DocumentFile>(context, subFile, requiresWriteAccess, (Ref.ObjectRef<File>)rawFile){
            final /* synthetic */ Context $context;
            final /* synthetic */ String $subFile;
            final /* synthetic */ boolean $requiresWriteAccess;
            final /* synthetic */ Ref.ObjectRef<File> $rawFile;
            {
                this.$context = $context;
                this.$subFile = $subFile;
                this.$requiresWriteAccess = $requiresWriteAccess;
                this.$rawFile = $rawFile;
                super(1);
            }

            @Nullable
            public final DocumentFile invoke(@NotNull String treeRootUri) {
                DocumentFile documentFile;
                DocumentFile downloadFolder;
                Intrinsics.checkNotNullParameter((Object)treeRootUri, (String)"treeRootUri");
                Uri uri = Uri.parse((String)treeRootUri);
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(treeRootUri)");
                DocumentFile documentFile2 = downloadFolder = ContextUtils.fromTreeUri(this.$context, uri);
                boolean bl = documentFile2 != null ? documentFile2.canRead() : false;
                if (bl) {
                    documentFile = DocumentFileUtils.child(downloadFolder, this.$context, this.$subFile, this.$requiresWriteAccess);
                } else {
                    String string2 = ((File)this.$rawFile.element).getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rawFile.absolutePath");
                    documentFile = DocumentFileCompat.fromFullPath$default(this.$context, string2, null, false, false, 12, null);
                }
                return documentFile;
            }
        };
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                documentFile = (DocumentFile)fileFromUriOrAbsolutePath2.invoke((Object)DOWNLOADS_TREE_URI);
                break;
            }
            case 2: {
                documentFile = (DocumentFile)fileFromUriOrAbsolutePath2.invoke((Object)DOCUMENTS_TREE_URI);
                break;
            }
            default: {
                String string2 = ((File)rawFile.element).getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rawFile.absolutePath");
                documentFile = DocumentFileCompat.fromFullPath$default(context, string2, null, false, false, 12, null);
            }
        }
        DocumentFile documentFile2 = folder = documentFile;
        if (documentFile2 != null) {
            DocumentFile documentFile3;
            DocumentFile it = documentFile3 = documentFile2;
            boolean bl = false;
            object = it.canRead() && (requiresWriteAccess && DocumentFileUtils.isWritable(folder, context) || !requiresWriteAccess) ? documentFile3 : null;
        } else {
            object = null;
        }
        return object;
    }

    public static /* synthetic */ DocumentFile fromPublicFolder$default(Context context, PublicDirectory publicDirectory, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        return DocumentFileCompat.fromPublicFolder(context, publicDirectory, string2, bl, bl2);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile getRootDocumentFile(@NotNull Context context, @NotNull String storageId, boolean requiresWriteAccess, boolean considerRawFile) {
        Object object;
        DocumentFile file;
        Object object2;
        block7: {
            block8: {
                block9: {
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
                        if (Intrinsics.areEqual((Object)storageId, (Object)"data")) {
                            return DocumentFile.fromFile((File)FileUtils.getDataDirectory(context));
                        }
                        if (TextUtils.isKitkatSdCardStorageId(storageId)) {
                            DocumentFile documentFile;
                            DocumentFile it = documentFile = DocumentFile.fromFile((File)DocumentFileCompat.getKitkatSdCardRootFile$default(INSTANCE, null, 1, null));
                            boolean bl = false;
                            return it.canWrite() ? documentFile : null;
                        }
                        if (!Intrinsics.areEqual((Object)storageId, (Object)"home")) break block6;
                        object2 = Build.VERSION.SDK_INT == 29 ? ContextUtils.fromTreeUri(context, DocumentFileCompat.createDocumentUri$default("primary", null, 2, null)) : DocumentFile.fromFile((File)Environment.getExternalStorageDirectory());
                        break block7;
                    }
                    if (!considerRawFile) break block8;
                    object2 = DocumentFileCompat.getRootRawFile(context, storageId, requiresWriteAccess);
                    if (object2 == null) break block9;
                    Object it = object2;
                    boolean bl = false;
                    DocumentFile documentFile = DocumentFile.fromFile((File)it);
                    object2 = documentFile;
                    if (documentFile != null) break block7;
                }
                object2 = ContextUtils.fromTreeUri(context, DocumentFileCompat.createDocumentUri$default(storageId, null, 2, null));
                break block7;
            }
            object2 = ContextUtils.fromTreeUri(context, DocumentFileCompat.createDocumentUri$default(storageId, null, 2, null));
        }
        DocumentFile documentFile = file = object2;
        if (documentFile != null) {
            DocumentFile documentFile2;
            DocumentFile it = documentFile2 = documentFile;
            boolean bl = false;
            object = it.canRead() && (requiresWriteAccess && DocumentFileUtils.isWritable(it, context) || !requiresWriteAccess) ? documentFile2 : null;
        } else {
            object = null;
        }
        return object;
    }

    public static /* synthetic */ DocumentFile getRootDocumentFile$default(Context context, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return DocumentFileCompat.getRootDocumentFile(context, string2, bl, bl2);
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile getAccessibleRootDocumentFile(@NotNull Context context, @NotNull String fullPath, boolean requiresWriteAccess, boolean considerRawFile) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
            if (considerRawFile && StringsKt.startsWith$default((CharSequence)fullPath, (char)'/', (boolean)false, (int)2, null) && (rootFile = FileUtils.getRootRawFile(new File(fullPath), context, requiresWriteAccess)) != null) {
                return DocumentFile.fromFile((File)rootFile);
            }
            storageId = DocumentFileCompat.getStorageId(context, fullPath);
            if (Intrinsics.areEqual((Object)storageId, (Object)"data")) {
                return DocumentFile.fromFile((File)FileUtils.getDataDirectory(context));
            }
            if (!(((CharSequence)storageId).length() > 0)) break block9;
            cleanBasePath = DocumentFileCompat.getBasePath(context, fullPath);
            v0 = context.getContentResolver().getPersistedUriPermissions();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"context.contentResolver.persistedUriPermissions");
            var6_6 = v0;
            $i$f$filter = false;
            var8_8 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (UriPermission)element$iv$iv;
                $i$a$-filter-DocumentFileCompat$getAccessibleRootDocumentFile$1 = false;
                if (!it.isReadPermission() || !it.isWritePermission()) ** GOTO lbl-1000
                v1 = it.getUri();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it.uri");
                if (UriUtils.isTreeDocumentFile(v1)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (UriPermission)element$iv;
                $i$a$-forEach-DocumentFileCompat$getAccessibleRootDocumentFile$2 = false;
                if (Build.VERSION.SDK_INT < 30) {
                    v3 = it.getUri();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it.uri");
                    if (UriUtils.isDownloadsDocument(v3) && TextUtils.hasParent(fullPath, PublicDirectory.DOWNLOADS.getAbsolutePath())) {
                        v4 = Uri.parse((String)"content://com.android.providers.downloads.documents/tree/downloads");
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"parse(DOWNLOADS_TREE_URI)");
                        return ContextUtils.fromTreeUri(context, v4);
                    }
                    v5 = it.getUri();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it.uri");
                    if (UriUtils.isDocumentsDocument(v5) && TextUtils.hasParent(fullPath, PublicDirectory.DOCUMENTS.getAbsolutePath())) {
                        v6 = Uri.parse((String)"content://com.android.externalstorage.documents/tree/home%3A");
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"parse(DOCUMENTS_TREE_URI)");
                        return ContextUtils.fromTreeUri(context, v6);
                    }
                }
                if ((uriPath = it.getUri().getPath()) == null) continue;
                v7 = it.getUri();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"it.uri");
                if (!UriUtils.isExternalStorageDocument(v7)) continue;
                currentStorageId = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)uriPath, (char)':', null, (int)2, null), (char)'/', null, (int)2, null);
                currentRootFolder = StringsKt.substringAfter((String)uriPath, (char)':', (String)"");
                if (!Intrinsics.areEqual((Object)currentStorageId, (Object)storageId) || !(((CharSequence)currentRootFolder).length() == 0) && !TextUtils.hasParent(cleanBasePath, currentRootFolder)) continue;
                v8 = it.getUri();
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"it.uri");
                return ContextUtils.fromTreeUri(context, v8);
            }
        }
        return null;
    }

    public static /* synthetic */ DocumentFile getAccessibleRootDocumentFile$default(Context context, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return DocumentFileCompat.getAccessibleRootDocumentFile(context, string2, bl, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final File getRootRawFile(@NotNull Context context, @NotNull String storageId, boolean requiresWriteAccess) {
        File file;
        block3: {
            block2: {
                File rootFile;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
                File it = file = (rootFile = Intrinsics.areEqual((Object)storageId, (Object)"primary") || Intrinsics.areEqual((Object)storageId, (Object)"home") ? Environment.getExternalStorageDirectory() : (Intrinsics.areEqual((Object)storageId, (Object)"data") ? FileUtils.getDataDirectory(context) : (TextUtils.isKitkatSdCardStorageId(storageId) ? DocumentFileCompat.getKitkatSdCardRootFile$default(INSTANCE, null, 1, null) : new File("/storage/" + storageId))));
                boolean bl = false;
                if (!rootFile.canRead()) return null;
                if (!requiresWriteAccess) break block2;
                Intrinsics.checkNotNullExpressionValue((Object)rootFile, (String)"rootFile");
                if (FileUtils.isWritable(rootFile, context)) break block3;
            }
            if (requiresWriteAccess) return null;
        }
        boolean bl = true;
        if (!bl) return null;
        File file2 = file;
        return file2;
    }

    public static /* synthetic */ File getRootRawFile$default(Context context, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return DocumentFileCompat.getRootRawFile(context, string2, bl);
    }

    @JvmStatic
    @NotNull
    public static final String buildAbsolutePath(@NotNull Context context, @NotNull String storageId, @NotNull String basePath) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        String cleanBasePath = INSTANCE.removeForbiddenCharsFromFilename$storage_release(basePath);
        switch (storageId) {
            case "primary": {
                string2 = SimpleStorage.Companion.getExternalStoragePath();
                break;
            }
            case "data": {
                string2 = FileUtils.getDataDirectory(context).getPath();
                break;
            }
            case "home": {
                string2 = PublicDirectory.DOCUMENTS.getAbsolutePath();
                break;
            }
            default: {
                string2 = "/storage/" + storageId;
            }
        }
        String rootPath = string2;
        Object object = new char[1];
        object[0] = 47;
        return StringsKt.trimEnd((String)(rootPath + '/' + cleanBasePath), (char[])object);
    }

    @JvmStatic
    @NotNull
    public static final String buildAbsolutePath(@NotNull Context context, @NotNull String simplePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)simplePath, (String)"simplePath");
        char[] cArray = new char[]{'/'};
        String path = StringsKt.trimEnd((String)simplePath, (char[])cArray);
        return StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null) ? INSTANCE.removeForbiddenCharsFromFilename$storage_release(path) : DocumentFileCompat.buildAbsolutePath(context, DocumentFileCompat.getStorageId(context, path), DocumentFileCompat.getBasePath(context, path));
    }

    @JvmStatic
    @NotNull
    public static final String buildSimplePath(@NotNull String storageId, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        String cleanBasePath = TextUtils.trimFileSeparator(INSTANCE.removeForbiddenCharsFromFilename$storage_release(basePath));
        return storageId + ':' + cleanBasePath;
    }

    @JvmStatic
    @NotNull
    public static final String buildSimplePath(@NotNull Context context, @NotNull String absolutePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
        return DocumentFileCompat.buildSimplePath(DocumentFileCompat.getStorageId(context, absolutePath), DocumentFileCompat.getBasePath(context, absolutePath));
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Uri createDocumentUri(@NotNull String storageId, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Uri uri = Uri.parse((String)("content://com.android.externalstorage.documents/tree/" + Uri.encode((String)(storageId + ':' + basePath))));
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(\"content://$EXTERN\u2026(\"$storageId:$basePath\"))");
        return uri;
    }

    public static /* synthetic */ Uri createDocumentUri$default(String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "";
        }
        return DocumentFileCompat.createDocumentUri(string2, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isAccessGranted(@NotNull Context context, @NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        if (Intrinsics.areEqual((Object)storageId, (Object)"data")) return true;
        if (Intrinsics.areEqual((Object)storageId, (Object)"primary")) {
            if (Build.VERSION.SDK_INT < 29) return true;
        }
        if (DocumentFileCompat.getRootDocumentFile$default(context, storageId, true, false, 8, null) == null) return false;
        return true;
    }

    @JvmStatic
    public static final boolean doesExist(@NotNull Context context, @NotNull String fullPath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        DocumentFile documentFile = DocumentFileCompat.fromFullPath$default(context, fullPath, null, false, false, 28, null);
        return documentFile != null ? documentFile.exists() : false;
    }

    @JvmStatic
    public static final boolean delete(@NotNull Context context, @NotNull String fullPath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        DocumentFile documentFile = DocumentFileCompat.fromFullPath$default(context, fullPath, null, false, false, 28, null);
        return documentFile != null ? documentFile.delete() : false;
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isStorageUriPermissionGranted(@NotNull Context context, @NotNull String storageId, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        return INSTANCE.isUriPermissionGranted(context, DocumentFileCompat.createDocumentUri(storageId, basePath));
    }

    public static /* synthetic */ boolean isStorageUriPermissionGranted$default(Context context, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "";
        }
        return DocumentFileCompat.isStorageUriPermissionGranted(context, string2, string3);
    }

    @JvmStatic
    public static final boolean isDownloadsUriPermissionGranted(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Uri uri = Uri.parse((String)DOWNLOADS_TREE_URI);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(DOWNLOADS_TREE_URI)");
        return INSTANCE.isUriPermissionGranted(context, uri);
    }

    @JvmStatic
    public static final boolean isDocumentsUriPermissionGranted(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Uri uri = Uri.parse((String)DOCUMENTS_TREE_URI);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(DOCUMENTS_TREE_URI)");
        return INSTANCE.isUriPermissionGranted(context, uri);
    }

    private final boolean isUriPermissionGranted(Context context, Uri uri) {
        boolean bl;
        block3: {
            List list = context.getContentResolver().getPersistedUriPermissions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"context.contentResolver.persistedUriPermissions");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UriPermission it = (UriPermission)element$iv;
                    boolean bl2 = false;
                    if (!(it.isReadPermission() && it.isWritePermission() && Intrinsics.areEqual((Object)it.getUri(), (Object)uri))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    @NotNull
    public static final List<String> getStorageIds(@NotNull Context context) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                externalStoragePath = SimpleStorage.Companion.getExternalStoragePath();
                v0 = ContextCompat.getExternalFilesDirs((Context)context, null);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getExternalFilesDirs(context, null)");
                $this$map$iv = ArraysKt.filterNotNull((Object[])v0);
                $i$f$map = false;
                var5_5 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    var10_15 = (File)item$iv$iv;
                    var21_23 = destination$iv$iv;
                    $i$a$-map-DocumentFileCompat$getStorageIds$storageIds$1 = false;
                    path = it.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                    var21_23.add(StringsKt.startsWith$default((String)path, (String)externalStoragePath, (boolean)false, (int)2, null) ? "primary" : StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)path, (String)"/storage/", null, (int)2, null), (char)'/', null, (int)2, null));
                }
                storageIds = (List)destination$iv$iv;
                if (Build.VERSION.SDK_INT < 28) break block7;
                v1 = storageIds;
                break block8;
            }
            v2 = context.getContentResolver().getPersistedUriPermissions();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"context.contentResolver.persistedUriPermissions");
            $i$f$map = v2;
            $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (E element$iv$iv : $this$filterTo$iv$iv) {
                it = (UriPermission)element$iv$iv;
                $i$a$-filter-DocumentFileCompat$getStorageIds$persistedStorageIds$1 = false;
                if (!it.isReadPermission() || !it.isWritePermission()) ** GOTO lbl-1000
                v3 = it.getUri();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it.uri");
                if (UriUtils.isExternalStorageDocument(v3)) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                if (!v4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var11_19 = $this$forEach$iv$iv$iv.iterator();
            while (var11_19.hasNext()) {
                element$iv$iv = element$iv$iv$iv = var11_19.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                it = (UriPermission)element$iv$iv;
                $i$a$-mapNotNull-DocumentFileCompat$getStorageIds$persistedStorageIds$2 = false;
                if (it.getUri().getPath() != null) {
                    $i$a$-run-DocumentFileCompat$getStorageIds$persistedStorageIds$2$1 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$getStorageIds_u24lambda_u2416_u24lambda_u2415, (String)"getStorageIds$lambda$16$lambda$15");
                    v5 = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)$this$getStorageIds_u24lambda_u2416_u24lambda_u2415, (char)':', null, (int)2, null), (char)'/', null, (int)2, null);
                } else {
                    v5 = null;
                }
                if (v5 == null) continue;
                it$iv$iv = v5;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            persistedStorageIds = (List)destination$iv$iv;
            $this$getStorageIds_u24lambda_u2417 = CollectionsKt.toMutableList((Collection)storageIds);
            $i$a$-run-DocumentFileCompat$getStorageIds$1 = false;
            $this$getStorageIds_u24lambda_u2417.addAll(persistedStorageIds);
            v1 = CollectionsKt.distinct((Iterable)$this$getStorageIds_u24lambda_u2417);
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<String> getSdCardIds(@NotNull Context context) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$filter$iv = DocumentFileCompat.getStorageIds(context);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)"primary"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @JvmStatic
    @NotNull
    public static final Map<String, Set<String>> getAccessibleAbsolutePaths(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        storages = new LinkedHashMap<K, V>();
        storages.put("primary", new HashSet<E>());
        v0 = context.getContentResolver().getPersistedUriPermissions();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"context.contentResolver.persistedUriPermissions");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var4_5 /* !! */  = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (UriPermission)element$iv$iv;
            $i$a$-filter-DocumentFileCompat$getAccessibleAbsolutePaths$1 = false;
            if (!it.isReadPermission() || !it.isWritePermission()) ** GOTO lbl-1000
            v1 = it.getUri();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it.uri");
            if (UriUtils.isTreeDocumentFile(v1)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            it = (UriPermission)element$iv;
            $i$a$-forEach-DocumentFileCompat$getAccessibleAbsolutePaths$2 = false;
            v3 = it.getUri();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it.uri");
            if (UriUtils.isDownloadsDocument(v3)) {
                v4 = (Set)storages.get("primary");
                if (v4 != null) {
                    v4.add(PublicDirectory.DOWNLOADS.getAbsolutePath());
                }
                continue;
            }
            v5 = it.getUri();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it.uri");
            if (UriUtils.isDocumentsDocument(v5)) {
                v6 = (Set)storages.get("primary");
                if (v6 != null) {
                    v6.add(PublicDirectory.DOCUMENTS.getAbsolutePath());
                }
                continue;
            }
            Intrinsics.checkNotNull((Object)it.getUri().getPath());
            storageId = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)uriPath, (char)':', null, (int)2, null), (char)'/', null, (int)2, null);
            rootFolder = StringsKt.substringAfter((String)uriPath, (char)':', (String)"");
            if (Intrinsics.areEqual((Object)storageId, (Object)"primary")) {
                v7 = (Set)storages.get("primary");
                if (v7 != null) {
                    var11_15 = new char[]{'/'};
                    v7.add(StringsKt.trimEnd((String)(Environment.getExternalStorageDirectory() + '/' + rootFolder), (char[])var11_15));
                }
                continue;
            }
            var12_16 = storageId;
            if (!DocumentFileCompat.SD_CARD_STORAGE_ID_REGEX.matches(var12_16)) continue;
            v8 = (Set)storages.get(storageId);
            if (v8 == null) {
                v8 = new HashSet<E>();
            }
            paths = v8;
            var11_15 = new char[]{'/'};
            paths.add(StringsKt.trimEnd((String)("/storage/" + storageId + '/' + rootFolder), (char[])var11_15));
            storages.put(storageId, paths);
        }
        if (Build.VERSION.SDK_INT < 29 && SimpleStorage.Companion.hasStoragePermission(context)) {
            v9 = (Set)storages.get("primary");
            if (v9 != null) {
                v9.add(SimpleStorage.Companion.getExternalStoragePath());
            }
        }
        if (Build.VERSION.SDK_INT < 21 && new File("/storage/sdcard").canWrite()) {
            var2_2 = storages;
            var3_4 = "sdcard";
            var4_5 /* !! */  = new String[]{"/storage/sdcard"};
            var4_5 /* !! */  = SetsKt.mutableSetOf((Object[])var4_5 /* !! */ );
            var2_2.put(var3_4, var4_5 /* !! */ );
        }
        if ((var2_2 = (Collection)storages.get("primary")) == null || var2_2.isEmpty() != false) {
            storages.remove("primary");
        }
        return storages;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @JvmStatic
    @NotNull
    public static final Map<String, List<Uri>> getAccessibleUris(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        v0 = context.getContentResolver().getPersistedUriPermissions();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"context.contentResolver.persistedUriPermissions");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var3_3 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (UriPermission)element$iv$iv;
            $i$a$-filter-DocumentFileCompat$getAccessibleUris$1 = false;
            if (!it.isReadPermission() || !it.isWritePermission()) ** GOTO lbl-1000
            v1 = it.getUri();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it.uri");
            if (UriUtils.isTreeDocumentFile(v1)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (UriPermission)item$iv$iv;
            var16_10 = destination$iv$iv;
            $i$a$-map-DocumentFileCompat$getAccessibleUris$2 = false;
            var16_10.add(it.getUri());
        }
        $this$groupBy$iv = (List)destination$iv$iv;
        $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$groupByTo = false;
        var6_6 = $this$groupByTo$iv$iv.iterator();
        while (var6_6.hasNext()) {
            element$iv$iv = var6_6.next();
            it = (Uri)element$iv$iv;
            $i$a$-groupBy-DocumentFileCompat$getAccessibleUris$3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            key$iv$iv = UriUtils.getStorageId((Uri)it, context);
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                answer$iv$iv$iv = new ArrayList<E>();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                v3 /* !! */  = answer$iv$iv$iv;
            } else {
                v3 /* !! */  = value$iv$iv$iv;
            }
            list$iv$iv = (List)v3 /* !! */ ;
            list$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = destination$iv$iv;
        $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$filterTo = false;
        var6_6 = $this$filterTo$iv$iv.entrySet().iterator();
        while (var6_6.hasNext()) {
            it = element$iv$iv = (Map.Entry)var6_6.next();
            $i$a$-filter-DocumentFileCompat$getAccessibleUris$4 = false;
            v4 = ((CharSequence)it.getKey()).length() > 0;
            if (!v4) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile mkdirs(@NotNull Context context, @NotNull String fullPath, boolean requiresWriteAccess, boolean considerRawFile) {
        Function0 tryCreateWithRawFile2;
        block15: {
            DocumentFile documentFile;
            block14: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
                tryCreateWithRawFile2 = (Function0)new Function0<DocumentFile>(fullPath, requiresWriteAccess, context){
                    final /* synthetic */ String $fullPath;
                    final /* synthetic */ boolean $requiresWriteAccess;
                    final /* synthetic */ Context $context;
                    {
                        this.$fullPath = $fullPath;
                        this.$requiresWriteAccess = $requiresWriteAccess;
                        this.$context = $context;
                        super(0);
                    }

                    @Nullable
                    public final DocumentFile invoke() {
                        File file;
                        File $this$invoke_u24lambda_u240 = file = new File(DocumentFileCompat.INSTANCE.removeForbiddenCharsFromFilename$storage_release(this.$fullPath));
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.mkdirs();
                        File folder = file;
                        return folder.isDirectory() && folder.canRead() && (this.$requiresWriteAccess && FileUtils.isWritable(folder, this.$context) || !this.$requiresWriteAccess) ? DocumentFile.fromFile((File)folder) : null;
                    }
                };
                if (considerRawFile && StringsKt.startsWith$default((CharSequence)fullPath, (char)'/', (boolean)false, (int)2, null)) break block14;
                String string2 = FileUtils.getDataDirectory(context).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.dataDirectory.path");
                if (!StringsKt.startsWith$default((String)fullPath, (String)string2, (boolean)false, (int)2, null)) break block15;
            }
            if ((documentFile = (DocumentFile)tryCreateWithRawFile2.invoke()) != null) {
                DocumentFile it = documentFile;
                boolean bl = false;
                return it;
            }
        }
        DocumentFile currentDirectory = null;
        DocumentFile documentFile = DocumentFileCompat.getAccessibleRootDocumentFile(context, fullPath, requiresWriteAccess, considerRawFile);
        if (documentFile == null) {
            return null;
        }
        currentDirectory = documentFile;
        if (DocumentFileUtils.isRawFile(currentDirectory)) {
            return (DocumentFile)tryCreateWithRawFile2.invoke();
        }
        String rootBasePath = DocumentFileUtils.getAbsolutePath(currentDirectory, context);
        String nextBasePath = TextUtils.trimFileSeparator(StringsKt.replaceFirst$default((String)fullPath, (String)rootBasePath, (String)"", (boolean)false, (int)4, null));
        ContentResolver resolver = context.getContentResolver();
        Iterable $this$forEach$iv = INSTANCE.getDirectorySequence$storage_release(nextBasePath);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            try {
                DocumentFile documentFile2;
                Intrinsics.checkNotNullExpressionValue((Object)resolver, (String)"resolver");
                DocumentFile directory = DocumentFileUtils.quickFindTreeFile(currentDirectory, context, resolver, it);
                if (directory == null) {
                    DocumentFile documentFile3 = currentDirectory.createDirectory(it);
                    if (documentFile3 == null) {
                        return null;
                    }
                    documentFile2 = documentFile3;
                    Intrinsics.checkNotNullExpressionValue((Object)documentFile3, (String)"currentDirectory.createD\u2026ectory(it) ?: return null");
                } else if (directory.isDirectory() && directory.canRead()) {
                    documentFile2 = directory;
                } else {
                    return null;
                }
                currentDirectory = documentFile2;
            }
            catch (Exception e) {
                return null;
            }
        }
        return DocumentFileUtils.takeIfWritable(currentDirectory, context, requiresWriteAccess);
    }

    public static /* synthetic */ DocumentFile mkdirs$default(Context context, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return DocumentFileCompat.mkdirs(context, string2, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DocumentFile[] mkdirs(@NotNull Context context, @NotNull List<String> fullPaths, boolean requiresWriteAccess, boolean considerRawFile) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(fullPaths, (String)"fullPaths");
        String dataDir = FileUtils.getDataDirectory(context).getPath();
        Object[] results = new DocumentFile[fullPaths.size()];
        Iterable $this$map$iv = fullPaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DocumentFileCompat.buildAbsolutePath(context, (String)((Object)it)));
        }
        List cleanedFullPaths = (List)destination$iv$iv;
        boolean shouldUseRawFile = considerRawFile || Build.VERSION.SDK_INT < 21;
        for (String path : DocumentFileCompat.findUniqueDeepestSubFolders(context, cleanedFullPaths)) {
            block18: {
                block17: {
                    File $this$mkdirs_u24lambda_u2428 = $i$f$mapTo = new File(path);
                    boolean bl = false;
                    $this$mkdirs_u24lambda_u2428.mkdirs();
                    File folder = $i$f$mapTo;
                    if (shouldUseRawFile && folder.isDirectory() && folder.canRead()) break block17;
                    Intrinsics.checkNotNullExpressionValue((Object)dataDir, (String)"dataDir");
                    if (!StringsKt.startsWith$default((String)path, (String)dataDir, (boolean)false, (int)2, null)) break block18;
                }
                Iterable $this$forEachIndexed$iv = cleanedFullPaths;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void s;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string3 = (String)item$iv;
                    int index = n;
                    boolean bl = false;
                    if (!TextUtils.hasParent(path, (String)s)) continue;
                    results[index] = DocumentFile.fromFile((File)new File(CollectionsKt.joinToString$default((Iterable)INSTANCE.getDirectorySequence$storage_release((String)s), (CharSequence)"/", (CharSequence)"/", null, (int)0, null, null, (int)60, null)));
                }
                continue;
            }
            DocumentFile currentDirectory = null;
            DocumentFile documentFile = DocumentFileCompat.getAccessibleRootDocumentFile(context, path, requiresWriteAccess, shouldUseRawFile);
            if (documentFile == null) continue;
            currentDirectory = documentFile;
            boolean isRawFile = DocumentFileUtils.isRawFile(currentDirectory);
            ContentResolver resolver = context.getContentResolver();
            Iterable $this$forEach$iv = INSTANCE.getDirectorySequence$storage_release(DocumentFileCompat.getBasePath(context, path));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                try {
                    String s;
                    int index;
                    int n;
                    int index$iv;
                    boolean $i$f$forEachIndexed;
                    Iterable $this$forEachIndexed$iv;
                    String fullPath;
                    DocumentFile directory;
                    DocumentFile documentFile2;
                    if (isRawFile) {
                        documentFile2 = DocumentFileUtils.quickFindRawFile(currentDirectory, it);
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)resolver, (String)"resolver");
                        documentFile2 = directory = DocumentFileUtils.quickFindTreeFile(currentDirectory, context, resolver, it);
                    }
                    if (directory == null) {
                        DocumentFile documentFile3;
                        DocumentFile documentFile4 = documentFile3 = currentDirectory.createDirectory(it);
                        if (documentFile4 == null) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)documentFile4, (String)"currentDirectory.createD\u2026ory(it) ?: return@forEach");
                        currentDirectory = documentFile3;
                        fullPath = DocumentFileUtils.getAbsolutePath(currentDirectory, context);
                        $this$forEachIndexed$iv = cleanedFullPaths;
                        $i$f$forEachIndexed = false;
                        index$iv = 0;
                        for (Object item$iv : $this$forEachIndexed$iv) {
                            if ((n = index$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            String string4 = (String)item$iv;
                            index = n;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)fullPath, (Object)s)) continue;
                            results[index] = currentDirectory;
                        }
                        continue;
                    }
                    if (!directory.isDirectory() || !directory.canRead()) continue;
                    currentDirectory = directory;
                    fullPath = DocumentFileUtils.getAbsolutePath(directory, context);
                    $this$forEachIndexed$iv = cleanedFullPaths;
                    $i$f$forEachIndexed = false;
                    index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        s = (String)item$iv;
                        index = n;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)fullPath, (Object)s)) continue;
                        results[index] = directory;
                    }
                }
                catch (Throwable e) {
                }
            }
        }
        Iterable $this$forEach$iv = (Iterable)ArraysKt.getIndices((Object[])results);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Object object = results[index];
            results[index] = object != null ? DocumentFileUtils.takeIfWritable((DocumentFile)object, context, requiresWriteAccess) : null;
        }
        return results;
    }

    public static /* synthetic */ DocumentFile[] mkdirs$default(Context context, List list, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return DocumentFileCompat.mkdirs(context, list, bl, bl2);
    }

    @JvmStatic
    @Nullable
    public static final FileWrapper createDownloadWithMediaStoreFallback(@NotNull Context context, @NotNull FileDescription file) {
        FileWrapper fileWrapper;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        DocumentFile publicFolder = DocumentFileCompat.fromPublicFolder$default(context, PublicDirectory.DOWNLOADS, null, true, false, 20, null);
        if (publicFolder == null && Build.VERSION.SDK_INT > 28) {
            FileWrapper.Media media;
            MediaFile mediaFile = MediaStoreCompat.createDownload$default(context, file, null, 4, null);
            if (mediaFile != null) {
                MediaFile it = mediaFile;
                boolean bl = false;
                media = new FileWrapper.Media(it);
            } else {
                media = null;
            }
            fileWrapper = media;
        } else {
            FileWrapper.Document document;
            DocumentFile documentFile = publicFolder;
            if (documentFile != null && (documentFile = DocumentFileUtils.makeFile$default(documentFile, context, file.getName(), file.getMimeType(), null, null, 24, null)) != null) {
                DocumentFile it = documentFile;
                boolean bl = false;
                document = new FileWrapper.Document(it);
            } else {
                document = null;
            }
            fileWrapper = document;
        }
        return fileWrapper;
    }

    @JvmStatic
    @Nullable
    public static final FileWrapper createPictureWithMediaStoreFallback(@NotNull Context context, @NotNull FileDescription file) {
        FileWrapper fileWrapper;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        DocumentFile publicFolder = DocumentFileCompat.fromPublicFolder$default(context, PublicDirectory.PICTURES, null, true, false, 20, null);
        if (publicFolder == null && Build.VERSION.SDK_INT > 28) {
            FileWrapper.Media media;
            MediaFile mediaFile = MediaStoreCompat.createImage$default(context, file, null, null, 12, null);
            if (mediaFile != null) {
                MediaFile it = mediaFile;
                boolean bl = false;
                media = new FileWrapper.Media(it);
            } else {
                media = null;
            }
            fileWrapper = media;
        } else {
            FileWrapper.Document document;
            DocumentFile documentFile = publicFolder;
            if (documentFile != null && (documentFile = DocumentFileUtils.makeFile$default(documentFile, context, file.getName(), file.getMimeType(), null, null, 24, null)) != null) {
                DocumentFile it = documentFile;
                boolean bl = false;
                document = new FileWrapper.Document(it);
            } else {
                document = null;
            }
            fileWrapper = document;
        }
        return fileWrapper;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile createFile(@NotNull Context context, @NotNull String storageId, @NotNull String basePath, @NotNull String mimeType, boolean considerRawFile) {
        DocumentFile documentFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        if (Intrinsics.areEqual((Object)storageId, (Object)"data") || TextUtils.isKitkatSdCardStorageId(storageId) || considerRawFile && Intrinsics.areEqual((Object)storageId, (Object)"primary") && Build.VERSION.SDK_INT < 29) {
            File file = TextUtils.isKitkatSdCardStorageId(storageId) ? INSTANCE.getKitkatSdCardRootFile(basePath) : new File(DocumentFileCompat.buildAbsolutePath(context, storageId, basePath));
            File file2 = file.getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
            documentFile = INSTANCE.create(file) ? DocumentFile.fromFile((File)file) : null;
        } else {
            DocumentFile documentFile2;
            try {
                DocumentFile documentFile3;
                DocumentFile directory = INSTANCE.mkdirsParentDirectory(context, storageId, basePath, considerRawFile);
                String filename = INSTANCE.removeForbiddenCharsFromFilename$storage_release(INSTANCE.getFileNameFromPath(basePath));
                if (((CharSequence)filename).length() == 0) {
                    documentFile3 = null;
                } else {
                    DocumentFile documentFile4 = directory;
                    documentFile3 = documentFile4 != null ? DocumentFileUtils.makeFile$default(documentFile4, context, filename, mimeType, null, null, 24, null) : null;
                }
                documentFile2 = documentFile3;
            }
            catch (Exception e) {
                documentFile2 = null;
            }
            documentFile = documentFile2;
        }
        return documentFile;
    }

    public static /* synthetic */ DocumentFile createFile$default(Context context, String string2, String string3, String string4, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "primary";
        }
        if ((n & 8) != 0) {
            string4 = "*/*";
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return DocumentFileCompat.createFile(context, string2, string3, string4, bl);
    }

    private final String getParentPath(String path) {
        List<String> it = this.getDirectorySequence$storage_release(path);
        boolean bl = false;
        return (String)CollectionsKt.getOrNull(it, (int)(it.size() - 2));
    }

    private final DocumentFile mkdirsParentDirectory(Context context, String storageId, String basePath, boolean considerRawFile) {
        String parentPath = this.getParentPath(basePath);
        return parentPath != null ? DocumentFileCompat.mkdirs$default(context, DocumentFileCompat.buildAbsolutePath(context, storageId, parentPath), considerRawFile, false, 8, null) : DocumentFileCompat.getRootDocumentFile(context, storageId, true, considerRawFile);
    }

    private final String getFileNameFromPath(String path) {
        char[] cArray = new char[]{'/'};
        return StringsKt.substringAfterLast$default((String)StringsKt.trimEnd((String)path, (char[])cArray), (char)'/', null, (int)2, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile recreate(@NotNull Context context, @NotNull String storageId, @NotNull String basePath, @NotNull String mimeType, boolean considerRawFile) {
        DocumentFile documentFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        File file = TextUtils.isKitkatSdCardStorageId(storageId) ? INSTANCE.getKitkatSdCardRootFile(basePath) : new File(DocumentFileCompat.buildAbsolutePath(context, storageId, basePath));
        file.delete();
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        if ((considerRawFile || Intrinsics.areEqual((Object)storageId, (Object)"data")) && INSTANCE.create(file)) {
            return DocumentFile.fromFile((File)file);
        }
        DocumentFile directory = INSTANCE.mkdirsParentDirectory(context, storageId, basePath, considerRawFile);
        String filename = file.getName();
        CharSequence charSequence = filename;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        DocumentFile documentFile2 = directory;
        if (documentFile2 != null) {
            DocumentFile $this$recreate_u24lambda_u2439 = documentFile2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)filename, (String)"filename");
            DocumentFile documentFile3 = DocumentFileUtils.child$default($this$recreate_u24lambda_u2439, context, filename, false, 4, null);
            if (documentFile3 != null) {
                documentFile3.delete();
            }
            documentFile = DocumentFileUtils.makeFile$default($this$recreate_u24lambda_u2439, context, filename, mimeType, null, null, 24, null);
        } else {
            documentFile = null;
        }
        return documentFile;
    }

    public static /* synthetic */ DocumentFile recreate$default(Context context, String string2, String string3, String string4, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "primary";
        }
        if ((n & 8) != 0) {
            string4 = "*/*";
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return DocumentFileCompat.recreate(context, string2, string3, string4, bl);
    }

    private final boolean create(File file) {
        boolean bl;
        try {
            bl = file.isFile() && file.length() == 0L || file.createNewFile();
        }
        catch (IOException e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final String removeForbiddenCharsFromFilename$storage_release(@NotNull String $this$removeForbiddenCharsFromFilename) {
        Intrinsics.checkNotNullParameter((Object)$this$removeForbiddenCharsFromFilename, (String)"<this>");
        return TextUtils.replaceCompletely(StringsKt.replace$default((String)$this$removeForbiddenCharsFromFilename, (String)":", (String)"_", (boolean)false, (int)4, null), "//", "/");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final DocumentFile exploreFile(Context context, String storageId, String basePath, DocumentFileType documentType, boolean requiresWriteAccess, boolean considerRawFile) {
        if (TextUtils.isKitkatSdCardStorageId(storageId)) {
            it = var7_7 = DocumentFile.fromFile((File)this.getKitkatSdCardRootFile(basePath));
            $i$a$-takeIf-DocumentFileCompat$exploreFile$1 = false;
            return (it.canWrite() && (documentType == DocumentFileType.ANY || documentType == DocumentFileType.FILE && it.isFile() || documentType == DocumentFileType.FOLDER && it.isDirectory())) != false ? var7_7 : null;
        }
        rawFile = new File(DocumentFileCompat.buildAbsolutePath(context, storageId, basePath));
        if ((considerRawFile || Intrinsics.areEqual((Object)storageId, (Object)"data")) && rawFile.canRead() && FileUtils.shouldWritable(rawFile, context, requiresWriteAccess)) {
            return documentType == DocumentFileType.ANY || documentType == DocumentFileType.FILE && rawFile.isFile() != false || documentType == DocumentFileType.FOLDER && rawFile.isDirectory() != false ? DocumentFile.fromFile((File)rawFile) : null;
        }
        if (Build.VERSION.SDK_INT != 29) ** GOTO lbl-1000
        if (Intrinsics.areEqual((Object)storageId, (Object)"home")) ** GOTO lbl-1000
        if (Intrinsics.areEqual((Object)storageId, (Object)"primary")) {
            v0 = Environment.DIRECTORY_DOCUMENTS;
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"DIRECTORY_DOCUMENTS");
            ** if (!TextUtils.hasParent((String)basePath, (String)v0)) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            if ((v1 = DocumentFileCompat.getRootDocumentFile(context, storageId, requiresWriteAccess, considerRawFile)) == null || (v1 = DocumentFileUtils.child$default(v1, context, basePath, false, 4, null)) == null) {
                v2 = Uri.parse((String)"content://com.android.externalstorage.documents/tree/home%3A");
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"parse(DOCUMENTS_TREE_URI)");
                v3 = ContextUtils.fromTreeUri(context, v2);
                if (v3 != null) {
                    v4 = Environment.DIRECTORY_DOCUMENTS;
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"DIRECTORY_DOCUMENTS");
                    v5 = DocumentFileUtils.child$default(v3, context, StringsKt.substringAfter$default((String)basePath, (String)v4, null, (int)2, null), false, 4, null);
                } else {
                    v5 = v1 = null;
                }
                if (v5 == null) {
                    return null;
                }
            }
            ** GOTO lbl55
        }
lbl-1000:
        // 3 sources

        {
            if (Build.VERSION.SDK_INT < 30) {
                v1 = DocumentFileCompat.getRootDocumentFile(context, storageId, requiresWriteAccess, considerRawFile);
                if (v1 == null || (v1 = DocumentFileUtils.child$default(v1, context, basePath, false, 4, null)) == null) {
                    return null;
                }
            } else {
                directorySequence = CollectionsKt.toMutableList((Collection)this.getDirectorySequence$storage_release(basePath));
                parentTree = new ArrayList<Object>(directorySequence.size());
                grantedFile = null;
                while (((Collection)directorySequence).isEmpty() == false) {
                    parentTree.add(CollectionsKt.removeFirst((List)directorySequence));
                    folderTree = CollectionsKt.joinToString$default((Iterable)parentTree, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
                    try {
                        v6 = var13_17 = (grantedFile = ContextUtils.fromTreeUri(context, DocumentFileCompat.createDocumentUri(storageId, folderTree)));
                        v7 = v6 != null ? v6.canRead() : false;
                        if (!v7) continue;
                        break;
                    }
                    catch (SecurityException var13_18) {
                    }
                }
                if (grantedFile == null || directorySequence.isEmpty()) {
                    v1 = grantedFile;
                } else {
                    fileTree = CollectionsKt.joinToString$default((Iterable)directorySequence, (CharSequence)"/", (CharSequence)"/", null, (int)0, null, null, (int)60, null);
                    v8 = Uri.parse((String)(grantedFile.getUri().toString() + Uri.encode((String)fileTree)));
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"parse(grantedFile.uri.to\u2026) + Uri.encode(fileTree))");
                    v1 = ContextUtils.fromTreeUri(context, v8);
                }
            }
        }
lbl55:
        // 4 sources

        v9 = file = v1;
        if (v9 != null) {
            it = var9_12 = v9;
            $i$a$-takeIf-DocumentFileCompat$exploreFile$2 = false;
            v10 /* !! */  = it.canRead() && (documentType == DocumentFileType.ANY || documentType == DocumentFileType.FILE && it.isFile() || documentType == DocumentFileType.FOLDER && it.isDirectory()) ? var9_12 : null;
        } else {
            v10 /* !! */  = null;
        }
        return v10 /* !! */ ;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getDirectorySequence$storage_release(@NotNull String path) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        char[] cArray = new char[]{'/'};
        Iterable $this$filterNot$iv = StringsKt.split$default((CharSequence)path, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<String> findUniqueDeepestSubFolders(@NotNull Context context, @NotNull Collection<String> folderFullPaths) {
        Object it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(folderFullPaths, (String)"folderFullPaths");
        Iterable $this$map$iv = folderFullPaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(DocumentFileCompat.buildAbsolutePath(context, (String)it));
        }
        List paths = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        ArrayList results = new ArrayList(paths);
        Iterable $this$forEach$iv = paths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            block3: {
                String path = (String)element$iv;
                boolean bl = false;
                it = paths;
                Iterator bl2 = it.iterator();
                while (bl2.hasNext()) {
                    Object t = bl2.next();
                    String it2 = (String)t;
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual((Object)it2, (Object)path) && TextUtils.hasParent(path, it2))) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            String string3 = v0;
            if (string3 == null) continue;
            it = string3;
            boolean bl = false;
            results.remove(it);
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<String> findUniqueParents(@NotNull Context context, @NotNull Collection<String> folderFullPaths) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(folderFullPaths, (String)"folderFullPaths");
        Iterable $this$map$iv = folderFullPaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DocumentFileCompat.buildAbsolutePath(context, (String)it));
        }
        List paths = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        ArrayList<String> results = new ArrayList<String>(paths.size());
        Iterable $this$forEach$iv = paths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            String path;
            block5: {
                path = (String)element$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = paths;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        String it = (String)element$iv2;
                        boolean bl3 = false;
                        if (!(!Intrinsics.areEqual((Object)it, (Object)path) && TextUtils.hasParent(path, it))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            results.add(path);
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @WorkerThread
    @NotNull
    public static final List<String> findInaccessibleStorageLocations(@NotNull Context context, @NotNull List<String> fullPaths) {
        List list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(fullPaths, (String)"fullPaths");
        if (SimpleStorage.Companion.hasStoragePermission(context)) {
            List<String> uniqueParents = DocumentFileCompat.findUniqueParents(context, (Collection<String>)fullPaths);
            ArrayList<String> inaccessibleStorageLocations = new ArrayList<String>(uniqueParents.size());
            DocumentFile[] $this$forEachIndexed$iv = DocumentFileCompat.mkdirs$default(context, uniqueParents, false, false, 12, null);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (DocumentFile item$iv : $this$forEachIndexed$iv) {
                void folder;
                int n = index$iv++;
                DocumentFile documentFile = item$iv;
                int index = n;
                boolean bl = false;
                if (folder != null) continue;
                inaccessibleStorageLocations.add(uniqueParents.get(index));
            }
            list = inaccessibleStorageLocations;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = fullPaths;
            boolean $i$f$map = false;
            Iterable $this$forEachIndexed$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String item$iv = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DocumentFileCompat.buildAbsolutePath(context, (String)it));
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final long getFreeSpace(@NotNull Context context, @NotNull String storageId) {
        long l;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        try {
            long l2;
            DocumentFile documentFile = INSTANCE.getDocumentFileForStorageInfo(context, storageId);
            if (documentFile == null) {
                return 0L;
            }
            DocumentFile file = documentFile;
            if (DocumentFileUtils.isRawFile(file)) {
                String string2 = file.getUri().getPath();
                Intrinsics.checkNotNull((Object)string2);
                l2 = new StatFs(string2).getAvailableBytes();
            } else if (Build.VERSION.SDK_INT >= 21) {
                ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(file.getUri(), "r");
                if (parcelFileDescriptor != null) {
                    Closeable closeable = (Closeable)parcelFileDescriptor;
                    Throwable throwable = null;
                    try {
                        ParcelFileDescriptor it = (ParcelFileDescriptor)closeable;
                        boolean bl = false;
                        StructStatVfs stats = Os.fstatvfs((FileDescriptor)it.getFileDescriptor());
                        long l3 = stats.f_bavail * stats.f_frsize;
                        l2 = l3;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                } else {
                    l2 = 0L;
                }
            } else {
                l2 = 0L;
            }
            l = l2;
        }
        catch (Throwable e) {
            l = 0L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final long getUsedSpace(@NotNull Context context, @NotNull String storageId) {
        long l;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        try {
            long l2;
            DocumentFile documentFile = INSTANCE.getDocumentFileForStorageInfo(context, storageId);
            if (documentFile == null) {
                return 0L;
            }
            DocumentFile file = documentFile;
            if (DocumentFileUtils.isRawFile(file)) {
                String string2 = file.getUri().getPath();
                Intrinsics.checkNotNull((Object)string2);
                StatFs $this$getUsedSpace_u24lambda_u2453 = new StatFs(string2);
                boolean bl = false;
                l2 = $this$getUsedSpace_u24lambda_u2453.getTotalBytes() - $this$getUsedSpace_u24lambda_u2453.getAvailableBytes();
            } else if (Build.VERSION.SDK_INT >= 21) {
                ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(file.getUri(), "r");
                if (parcelFileDescriptor != null) {
                    Closeable closeable = (Closeable)parcelFileDescriptor;
                    Throwable throwable = null;
                    try {
                        ParcelFileDescriptor it = (ParcelFileDescriptor)closeable;
                        boolean bl = false;
                        StructStatVfs stats = Os.fstatvfs((FileDescriptor)it.getFileDescriptor());
                        long l3 = stats.f_blocks * stats.f_frsize - stats.f_bavail * stats.f_frsize;
                        l2 = l3;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                } else {
                    l2 = 0L;
                }
            } else {
                l2 = 0L;
            }
            l = l2;
        }
        catch (Throwable e) {
            l = 0L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final long getStorageCapacity(@NotNull Context context, @NotNull String storageId) {
        long l;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        try {
            long l2;
            DocumentFile documentFile = INSTANCE.getDocumentFileForStorageInfo(context, storageId);
            if (documentFile == null) {
                return 0L;
            }
            DocumentFile file = documentFile;
            if (DocumentFileUtils.isRawFile(file)) {
                String string2 = file.getUri().getPath();
                Intrinsics.checkNotNull((Object)string2);
                l2 = new StatFs(string2).getTotalBytes();
            } else if (Build.VERSION.SDK_INT >= 21) {
                ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(file.getUri(), "r");
                if (parcelFileDescriptor != null) {
                    Closeable closeable = (Closeable)parcelFileDescriptor;
                    Throwable throwable = null;
                    try {
                        ParcelFileDescriptor it = (ParcelFileDescriptor)closeable;
                        boolean bl = false;
                        StructStatVfs stats = Os.fstatvfs((FileDescriptor)it.getFileDescriptor());
                        long l3 = stats.f_blocks * stats.f_frsize;
                        l2 = l3;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                } else {
                    l2 = 0L;
                }
            } else {
                l2 = 0L;
            }
            l = l2;
        }
        catch (Throwable e) {
            l = 0L;
        }
        return l;
    }

    /*
     * Unable to fully structure code
     */
    private final DocumentFile getDocumentFileForStorageInfo(Context context, String storageId) {
        block10: {
            var3_3 = storageId;
            switch (var3_3.hashCode()) {
                case 3076010: {
                    if (var3_3.equals("data")) break;
                    ** break;
                }
                case -314765822: {
                    if (!var3_3.equals("primary")) {
                        ** break;
                    }
                    ** GOTO lbl12
                }
                case 3208415: {
                    if (!var3_3.equals("home")) ** break;
lbl12:
                    // 2 sources

                    v0 = context.getExternalFilesDir(null);
                    if (v0 == null) {
                        return null;
                    }
                    directory = v0;
                    v1 = DocumentFile.fromFile((File)directory);
                    break block10;
                }
            }
            v1 = DocumentFile.fromFile((File)FileUtils.getDataDirectory(context));
            break block10;
lbl20:
            // 4 sources

            if (TextUtils.isKitkatSdCardStorageId(storageId)) {
                return DocumentFile.fromFile((File)DocumentFileCompat.getKitkatSdCardRootFile$default(this, null, 1, null));
            }
            folder = new File("/storage/" + storageId + "/Android/data/" + context.getPackageName() + "/files");
            folder.mkdirs();
            if (folder.canRead()) {
                v1 = DocumentFile.fromFile((File)folder);
            } else {
                v2 = folder.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"folder.absolutePath");
                v1 = DocumentFileCompat.getAccessibleRootDocumentFile$default(context, v2, false, false, 4, null);
            }
        }
        return v1;
    }

    @JvmStatic
    @NotNull
    public static final String getFileNameFromUrl(@NotNull String url) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            String string3 = URLDecoder.decode(url, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"decode(url, \"UTF-8\")");
            string2 = StringsKt.substringAfterLast$default((String)string3, (char)'/', null, (int)2, null);
        }
        catch (Exception e) {
            string2 = url;
        }
        return string2;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromSimplePath(@NotNull Context context, @NotNull String storageId, @NotNull String basePath, @NotNull DocumentFileType documentType, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        return DocumentFileCompat.fromSimplePath$default(context, storageId, basePath, documentType, requiresWriteAccess, false, 32, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromSimplePath(@NotNull Context context, @NotNull String storageId, @NotNull String basePath, @NotNull DocumentFileType documentType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        return DocumentFileCompat.fromSimplePath$default(context, storageId, basePath, documentType, false, false, 48, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromSimplePath(@NotNull Context context, @NotNull String storageId, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        return DocumentFileCompat.fromSimplePath$default(context, storageId, basePath, null, false, false, 56, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromSimplePath(@NotNull Context context, @NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        return DocumentFileCompat.fromSimplePath$default(context, storageId, null, null, false, false, 60, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromSimplePath(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return DocumentFileCompat.fromSimplePath$default(context, null, null, null, false, false, 62, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromFullPath(@NotNull Context context, @NotNull String fullPath, @NotNull DocumentFileType documentType, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        return DocumentFileCompat.fromFullPath$default(context, fullPath, documentType, requiresWriteAccess, false, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromFullPath(@NotNull Context context, @NotNull String fullPath, @NotNull DocumentFileType documentType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        return DocumentFileCompat.fromFullPath$default(context, fullPath, documentType, false, false, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromFullPath(@NotNull Context context, @NotNull String fullPath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        return DocumentFileCompat.fromFullPath$default(context, fullPath, null, false, false, 28, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromFile(@NotNull Context context, @NotNull File file, @NotNull DocumentFileType documentType, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        return DocumentFileCompat.fromFile$default(context, file, documentType, requiresWriteAccess, false, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromFile(@NotNull Context context, @NotNull File file, @NotNull DocumentFileType documentType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)documentType), (String)"documentType");
        return DocumentFileCompat.fromFile$default(context, file, documentType, false, false, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromFile(@NotNull Context context, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return DocumentFileCompat.fromFile$default(context, file, null, false, false, 28, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromPublicFolder(@NotNull Context context, @NotNull PublicDirectory type, @NotNull String subFile, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)subFile, (String)"subFile");
        return DocumentFileCompat.fromPublicFolder$default(context, type, subFile, requiresWriteAccess, false, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromPublicFolder(@NotNull Context context, @NotNull PublicDirectory type, @NotNull String subFile) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)subFile, (String)"subFile");
        return DocumentFileCompat.fromPublicFolder$default(context, type, subFile, false, false, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile fromPublicFolder(@NotNull Context context, @NotNull PublicDirectory type) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return DocumentFileCompat.fromPublicFolder$default(context, type, null, false, false, 28, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile getRootDocumentFile(@NotNull Context context, @NotNull String storageId, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        return DocumentFileCompat.getRootDocumentFile$default(context, storageId, requiresWriteAccess, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile getRootDocumentFile(@NotNull Context context, @NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        return DocumentFileCompat.getRootDocumentFile$default(context, storageId, false, false, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile getAccessibleRootDocumentFile(@NotNull Context context, @NotNull String fullPath, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        return DocumentFileCompat.getAccessibleRootDocumentFile$default(context, fullPath, requiresWriteAccess, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile getAccessibleRootDocumentFile(@NotNull Context context, @NotNull String fullPath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        return DocumentFileCompat.getAccessibleRootDocumentFile$default(context, fullPath, false, false, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final File getRootRawFile(@NotNull Context context, @NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        return DocumentFileCompat.getRootRawFile$default(context, storageId, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Uri createDocumentUri(@NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        return DocumentFileCompat.createDocumentUri$default(storageId, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isStorageUriPermissionGranted(@NotNull Context context, @NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        return DocumentFileCompat.isStorageUriPermissionGranted$default(context, storageId, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile mkdirs(@NotNull Context context, @NotNull String fullPath, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        return DocumentFileCompat.mkdirs$default(context, fullPath, requiresWriteAccess, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile mkdirs(@NotNull Context context, @NotNull String fullPath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        return DocumentFileCompat.mkdirs$default(context, fullPath, false, false, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DocumentFile[] mkdirs(@NotNull Context context, @NotNull List<String> fullPaths, boolean requiresWriteAccess) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(fullPaths, (String)"fullPaths");
        return DocumentFileCompat.mkdirs$default(context, fullPaths, requiresWriteAccess, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DocumentFile[] mkdirs(@NotNull Context context, @NotNull List<String> fullPaths) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(fullPaths, (String)"fullPaths");
        return DocumentFileCompat.mkdirs$default(context, fullPaths, false, false, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile createFile(@NotNull Context context, @NotNull String storageId, @NotNull String basePath, @NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return DocumentFileCompat.createFile$default(context, storageId, basePath, mimeType, false, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile createFile(@NotNull Context context, @NotNull String storageId, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        return DocumentFileCompat.createFile$default(context, storageId, basePath, null, false, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile createFile(@NotNull Context context, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        return DocumentFileCompat.createFile$default(context, null, basePath, null, false, 26, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile recreate(@NotNull Context context, @NotNull String storageId, @NotNull String basePath, @NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return DocumentFileCompat.recreate$default(context, storageId, basePath, mimeType, false, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile recreate(@NotNull Context context, @NotNull String storageId, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        return DocumentFileCompat.recreate$default(context, storageId, basePath, null, false, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final DocumentFile recreate(@NotNull Context context, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        return DocumentFileCompat.recreate$default(context, null, basePath, null, false, 26, null);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PublicDirectory.values().length];
            try {
                nArray[PublicDirectory.DOWNLOADS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PublicDirectory.DOCUMENTS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

