/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage.extension;

import android.os.Build;
import androidx.annotation.RestrictTo;
import com.anggrayudi.storage.SimpleStorage;
import com.anggrayudi.storage.file.DocumentFileCompat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000b\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002\u001a\u0012\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b*\u00020\u0002H\u0002\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\n\u0010\u000b\u001a\u00020\u0002*\u00020\u0002\u001a\f\u0010\f\u001a\u00020\u0002*\u00020\u0002H\u0007\u001a\u001a\u0010\r\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002\u001a\n\u0010\u0010\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0011\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0012\u001a\u00020\u0002*\u00020\u0002\u00a8\u0006\u0013"}, d2={"childOf", "", "", "parentPath", "count", "", "text", "getFolderTree", "", "hasParent", "isKitkatSdCardStorageId", "normalizeFileName", "parent", "replaceCompletely", "match", "replaceWith", "trimFileName", "trimFileSeparator", "trimWhiteSpace", "storage_release"})
@JvmName(name="TextUtils")
@SourceDebugExtension(value={"SMAP\nTextExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextExt.kt\ncom/anggrayudi/storage/extension/TextUtils\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n107#2:87\n79#2,22:88\n107#2:110\n79#2,22:111\n1549#3:133\n1620#3,3:134\n766#3:137\n857#3,2:138\n*S KotlinDebug\n*F\n+ 1 TextExt.kt\ncom/anggrayudi/storage/extension/TextUtils\n*L\n33#1:87\n33#1:88,22\n39#1:110\n39#1:111,22\n85#1:133\n85#1:134,3\n86#1:137\n86#1:138,2\n*E\n"})
public final class TextUtils {
    public static final int count(@NotNull String $this$count, @NotNull String text) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$count, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int index = StringsKt.indexOf$default((CharSequence)$this$count, (String)text, (int)0, (boolean)false, (int)6, null);
        if (((CharSequence)text).length() == 0 || index == -1) {
            return 0;
        }
        int count = 0;
        do {
            ++count;
            if (1 <= (index = StringsKt.indexOf$default((CharSequence)$this$count, (String)text, (int)(index + text.length()), (boolean)false, (int)4, null))) {
                if (index < $this$count.length()) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (bl);
        return count;
    }

    @NotNull
    public static final String trimFileName(@NotNull String $this$trimFileName) {
        Intrinsics.checkNotNullParameter((Object)$this$trimFileName, (String)"<this>");
        String $this$trim$iv = $this$trimFileName;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0 || it == '/';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        char[] cArray = new char[]{'.'};
        return StringsKt.trimEnd((String)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (char[])cArray);
    }

    @NotNull
    public static final String normalizeFileName(@NotNull String $this$normalizeFileName) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizeFileName, (String)"<this>");
        return TextUtils.trimFileName(DocumentFileCompat.INSTANCE.removeForbiddenCharsFromFilename$storage_release($this$normalizeFileName));
    }

    @NotNull
    public static final String trimFileSeparator(@NotNull String $this$trimFileSeparator) {
        Intrinsics.checkNotNullParameter((Object)$this$trimFileSeparator, (String)"<this>");
        char[] cArray = new char[]{'/'};
        return StringsKt.trim((String)$this$trimFileSeparator, (char[])cArray);
    }

    @NotNull
    public static final String trimWhiteSpace(@NotNull String $this$trimWhiteSpace) {
        Intrinsics.checkNotNullParameter((Object)$this$trimWhiteSpace, (String)"<this>");
        String $this$trim$iv = $this$trimWhiteSpace;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    @NotNull
    public static final String replaceCompletely(@NotNull String $this$replaceCompletely, @NotNull String match, @NotNull String replaceWith) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceCompletely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        Intrinsics.checkNotNullParameter((Object)replaceWith, (String)"replaceWith");
        String it = $this$replaceCompletely;
        boolean bl = false;
        String path = it;
        while (((CharSequence)(path = StringsKt.replace$default((String)path, (String)match, (String)replaceWith, (boolean)false, (int)4, null))).length() > 0) {
            if (StringsKt.contains$default((CharSequence)path, (CharSequence)match, (boolean)false, (int)2, null)) continue;
            break;
        }
        return path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final boolean isKitkatSdCardStorageId(@NotNull String $this$isKitkatSdCardStorageId) {
        Intrinsics.checkNotNullParameter((Object)$this$isKitkatSdCardStorageId, (String)"<this>");
        if (Build.VERSION.SDK_INT >= 21) return false;
        if (Intrinsics.areEqual((Object)$this$isKitkatSdCardStorageId, (Object)"sdcard")) return true;
        CharSequence charSequence = $this$isKitkatSdCardStorageId;
        if (!DocumentFileCompat.INSTANCE.getSD_CARD_STORAGE_ID_REGEX().matches(charSequence)) return false;
        return true;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final boolean hasParent(@NotNull String $this$hasParent, @NotNull String parentPath) {
        Intrinsics.checkNotNullParameter((Object)$this$hasParent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
        List<String> parentTree = TextUtils.getFolderTree(parentPath);
        List<String> subFolderTree = TextUtils.getFolderTree($this$hasParent);
        return parentTree.size() <= subFolderTree.size() && Intrinsics.areEqual((Object)CollectionsKt.take((Iterable)subFolderTree, (int)parentTree.size()), parentTree);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final boolean childOf(@NotNull String $this$childOf, @NotNull String parentPath) {
        Intrinsics.checkNotNullParameter((Object)$this$childOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
        List<String> parentTree = TextUtils.getFolderTree(parentPath);
        List<String> subFolderTree = TextUtils.getFolderTree($this$childOf);
        return subFolderTree.size() > parentTree.size() && Intrinsics.areEqual((Object)CollectionsKt.take((Iterable)subFolderTree, (int)parentTree.size()), parentTree);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    public static final String parent(@NotNull String $this$parent) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$parent, (String)"<this>");
        List<String> folderTree = TextUtils.getFolderTree($this$parent);
        if (folderTree.isEmpty()) {
            return "";
        }
        String parentPath = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)folderTree, (int)(folderTree.size() - 1)), (CharSequence)"/", (CharSequence)"/", null, (int)0, null, null, (int)60, null);
        return StringsKt.startsWith$default((String)parentPath, (String)SimpleStorage.Companion.getExternalStoragePath(), (boolean)false, (int)2, null) || new Regex("/storage/[A-Z0-9]{4}-[A-Z0-9]{4}(.*?)").matches(charSequence = (CharSequence)parentPath) || Build.VERSION.SDK_INT < 21 && StringsKt.startsWith$default((String)parentPath, (String)"/storage/sdcard", (boolean)false, (int)2, null) ? parentPath : "";
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> getFolderTree(String $this$getFolderTree) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        char[] cArray = new char[]{'/'};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)$this$getFolderTree, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TextUtils.trimFileSeparator(it));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

