/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage.extension;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.documentfile.provider.DocumentFile;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u001a\u001a\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0010\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0014\u0010\u0011\u001a\u00020\n*\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a8\u0006\u0014"}, d2={"fromSingleUri", "Landroidx/documentfile/provider/DocumentFile;", "Landroid/content/Context;", "fileUri", "Landroid/net/Uri;", "fromTreeUri", "getAppDirectory", "", "type", "startActivityForResultSafely", "", "Landroid/app/Activity;", "requestCode", "", "intent", "Landroid/content/Intent;", "startActivitySafely", "unregisterReceiverSafely", "receiver", "Landroid/content/BroadcastReceiver;", "storage_release"})
@JvmName(name="ContextUtils")
public final class ContextUtils {
    @NotNull
    public static final String getAppDirectory(@NotNull Context $this$getAppDirectory, @Nullable String type) {
        Intrinsics.checkNotNullParameter((Object)$this$getAppDirectory, (String)"<this>");
        return String.valueOf($this$getAppDirectory.getExternalFilesDir(type));
    }

    public static /* synthetic */ String getAppDirectory$default(Context context, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return ContextUtils.getAppDirectory(context, string2);
    }

    public static final void startActivitySafely(@NotNull Context $this$startActivitySafely, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)$this$startActivitySafely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            $this$startActivitySafely.startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            // empty catch block
        }
    }

    public static final void startActivityForResultSafely(@NotNull Activity $this$startActivityForResultSafely, int requestCode, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)$this$startActivityForResultSafely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            $this$startActivityForResultSafely.startActivityForResult(intent, requestCode);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            // empty catch block
        }
    }

    public static final void unregisterReceiverSafely(@NotNull Context $this$unregisterReceiverSafely, @Nullable BroadcastReceiver receiver) {
        Intrinsics.checkNotNullParameter((Object)$this$unregisterReceiverSafely, (String)"<this>");
        try {
            BroadcastReceiver broadcastReceiver = receiver;
            if (broadcastReceiver == null) {
                return;
            }
            $this$unregisterReceiverSafely.unregisterReceiver(broadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Nullable
    public static final DocumentFile fromTreeUri(@NotNull Context $this$fromTreeUri, @NotNull Uri fileUri) {
        DocumentFile documentFile;
        Intrinsics.checkNotNullParameter((Object)$this$fromTreeUri, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        try {
            documentFile = DocumentFile.fromTreeUri((Context)$this$fromTreeUri, (Uri)fileUri);
        }
        catch (Exception e) {
            documentFile = null;
        }
        return documentFile;
    }

    @Nullable
    public static final DocumentFile fromSingleUri(@NotNull Context $this$fromSingleUri, @NotNull Uri fileUri) {
        DocumentFile documentFile;
        Intrinsics.checkNotNullParameter((Object)$this$fromSingleUri, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        try {
            documentFile = DocumentFile.fromSingleUri((Context)$this$fromSingleUri, (Uri)fileUri);
        }
        catch (Exception e) {
            documentFile = null;
        }
        return documentFile;
    }
}

