/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage.callback;

import androidx.annotation.UiThread;
import androidx.annotation.WorkerThread;
import androidx.documentfile.provider.DocumentFile;
import com.anggrayudi.storage.callback.FileConflictCallback;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0003\u001e\u001f B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0017J%\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0017\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u001d\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u001bH\u0017\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\rH\u0017\u00a8\u0006!"}, d2={"Lcom/anggrayudi/storage/callback/ZipDecompressionCallback;", "T", "Lcom/anggrayudi/storage/callback/FileConflictCallback;", "Landroidx/documentfile/provider/DocumentFile;", "uiScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "onCheckFreeSpace", "", "freeSpace", "", "zipFileSize", "onCompleted", "", "zipFile", "targetFolder", "decompressionInfo", "Lcom/anggrayudi/storage/callback/ZipDecompressionCallback$DecompressionInfo;", "(Ljava/lang/Object;Landroidx/documentfile/provider/DocumentFile;Lcom/anggrayudi/storage/callback/ZipDecompressionCallback$DecompressionInfo;)V", "onFailed", "errorCode", "Lcom/anggrayudi/storage/callback/ZipDecompressionCallback$ErrorCode;", "onReport", "report", "Lcom/anggrayudi/storage/callback/ZipDecompressionCallback$Report;", "onStart", "workerThread", "Ljava/lang/Thread;", "(Ljava/lang/Object;Ljava/lang/Thread;)J", "onValidate", "DecompressionInfo", "ErrorCode", "Report", "storage_release"})
public abstract class ZipDecompressionCallback<T>
extends FileConflictCallback<DocumentFile> {
    @JvmOverloads
    public ZipDecompressionCallback(@NotNull CoroutineScope uiScope) {
        Intrinsics.checkNotNullParameter((Object)uiScope, (String)"uiScope");
        super(uiScope);
    }

    public /* synthetic */ ZipDecompressionCallback(CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            coroutineScope = (CoroutineScope)GlobalScope.INSTANCE;
        }
        this(coroutineScope);
    }

    @UiThread
    public void onValidate() {
    }

    @UiThread
    public long onStart(T zipFile, @NotNull Thread workerThread) {
        Intrinsics.checkNotNullParameter((Object)workerThread, (String)"workerThread");
        return 0L;
    }

    @WorkerThread
    public boolean onCheckFreeSpace(long freeSpace, long zipFileSize) {
        return (double)zipFileSize * 1.2 + (double)0x6400000 < (double)freeSpace;
    }

    @UiThread
    public void onReport(@NotNull Report report) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
    }

    @UiThread
    public void onCompleted(T zipFile, @NotNull DocumentFile targetFolder, @NotNull DecompressionInfo decompressionInfo) {
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        Intrinsics.checkNotNullParameter((Object)decompressionInfo, (String)"decompressionInfo");
    }

    @UiThread
    public void onFailed(@NotNull ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
    }

    @JvmOverloads
    public ZipDecompressionCallback() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/anggrayudi/storage/callback/ZipDecompressionCallback$DecompressionInfo;", "", "bytesDecompressed", "", "skippedDecompressedBytes", "totalFilesDecompressed", "", "decompressionRate", "", "(JJIF)V", "getBytesDecompressed", "()J", "getDecompressionRate", "()F", "getSkippedDecompressedBytes", "getTotalFilesDecompressed", "()I", "storage_release"})
    public static final class DecompressionInfo {
        private final long bytesDecompressed;
        private final long skippedDecompressedBytes;
        private final int totalFilesDecompressed;
        private final float decompressionRate;

        public DecompressionInfo(long bytesDecompressed, long skippedDecompressedBytes, int totalFilesDecompressed, float decompressionRate) {
            this.bytesDecompressed = bytesDecompressed;
            this.skippedDecompressedBytes = skippedDecompressedBytes;
            this.totalFilesDecompressed = totalFilesDecompressed;
            this.decompressionRate = decompressionRate;
        }

        public final long getBytesDecompressed() {
            return this.bytesDecompressed;
        }

        public final long getSkippedDecompressedBytes() {
            return this.skippedDecompressedBytes;
        }

        public final int getTotalFilesDecompressed() {
            return this.totalFilesDecompressed;
        }

        public final float getDecompressionRate() {
            return this.decompressionRate;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/anggrayudi/storage/callback/ZipDecompressionCallback$ErrorCode;", "", "(Ljava/lang/String;I)V", "STORAGE_PERMISSION_DENIED", "CANNOT_CREATE_FILE_IN_TARGET", "MISSING_ZIP_FILE", "NOT_A_ZIP_FILE", "UNKNOWN_IO_ERROR", "CANCELED", "NO_SPACE_LEFT_ON_TARGET_PATH", "storage_release"})
    public static final class ErrorCode
    extends Enum<ErrorCode> {
        public static final /* enum */ ErrorCode STORAGE_PERMISSION_DENIED = new ErrorCode();
        public static final /* enum */ ErrorCode CANNOT_CREATE_FILE_IN_TARGET = new ErrorCode();
        public static final /* enum */ ErrorCode MISSING_ZIP_FILE = new ErrorCode();
        public static final /* enum */ ErrorCode NOT_A_ZIP_FILE = new ErrorCode();
        public static final /* enum */ ErrorCode UNKNOWN_IO_ERROR = new ErrorCode();
        public static final /* enum */ ErrorCode CANCELED = new ErrorCode();
        public static final /* enum */ ErrorCode NO_SPACE_LEFT_ON_TARGET_PATH = new ErrorCode();
        private static final /* synthetic */ ErrorCode[] $VALUES;

        public static ErrorCode[] values() {
            return (ErrorCode[])$VALUES.clone();
        }

        public static ErrorCode valueOf(String value) {
            return Enum.valueOf(ErrorCode.class, value);
        }

        static {
            $VALUES = errorCodeArray = new ErrorCode[]{ErrorCode.STORAGE_PERMISSION_DENIED, ErrorCode.CANNOT_CREATE_FILE_IN_TARGET, ErrorCode.MISSING_ZIP_FILE, ErrorCode.NOT_A_ZIP_FILE, ErrorCode.UNKNOWN_IO_ERROR, ErrorCode.CANCELED, ErrorCode.NO_SPACE_LEFT_ON_TARGET_PATH};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/anggrayudi/storage/callback/ZipDecompressionCallback$Report;", "", "bytesDecompressed", "", "writeSpeed", "", "fileCount", "(JII)V", "getBytesDecompressed", "()J", "getFileCount", "()I", "getWriteSpeed", "storage_release"})
    public static final class Report {
        private final long bytesDecompressed;
        private final int writeSpeed;
        private final int fileCount;

        public Report(long bytesDecompressed, int writeSpeed, int fileCount) {
            this.bytesDecompressed = bytesDecompressed;
            this.writeSpeed = writeSpeed;
            this.fileCount = fileCount;
        }

        public final long getBytesDecompressed() {
            return this.bytesDecompressed;
        }

        public final int getWriteSpeed() {
            return this.writeSpeed;
        }

        public final int getFileCount() {
            return this.fileCount;
        }
    }
}

