/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage.callback;

import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.documentfile.provider.DocumentFile;
import com.anggrayudi.storage.callback.BaseFileCallback;
import com.anggrayudi.storage.file.CreateMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0004\u0015\u0016\u0017\u0018B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0017J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0017\u00a8\u0006\u0019"}, d2={"Lcom/anggrayudi/storage/callback/FileCallback;", "Lcom/anggrayudi/storage/callback/BaseFileCallback;", "Lcom/anggrayudi/storage/callback/FileCallback$ErrorCode;", "Lcom/anggrayudi/storage/callback/FileCallback$Report;", "", "uiScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "onCompleted", "", "result", "onConflict", "destinationFile", "Landroidx/documentfile/provider/DocumentFile;", "action", "Lcom/anggrayudi/storage/callback/FileCallback$FileConflictAction;", "onStart", "", "file", "workerThread", "Ljava/lang/Thread;", "ConflictResolution", "ErrorCode", "FileConflictAction", "Report", "storage_release"})
public abstract class FileCallback
extends BaseFileCallback<ErrorCode, Report, Object> {
    @JvmOverloads
    public FileCallback(@NotNull CoroutineScope uiScope) {
        Intrinsics.checkNotNullParameter((Object)uiScope, (String)"uiScope");
        super(uiScope);
    }

    public /* synthetic */ FileCallback(CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            coroutineScope = (CoroutineScope)GlobalScope.INSTANCE;
        }
        this(coroutineScope);
    }

    @UiThread
    public long onStart(@NotNull Object file, @NotNull Thread workerThread) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)workerThread, (String)"workerThread");
        return 0L;
    }

    @UiThread
    public void onConflict(@NotNull DocumentFile destinationFile, @NotNull FileConflictAction action) {
        Intrinsics.checkNotNullParameter((Object)destinationFile, (String)"destinationFile");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        action.confirmResolution(ConflictResolution.CREATE_NEW);
    }

    @Override
    @UiThread
    public void onCompleted(@NotNull Object result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
    }

    @JvmOverloads
    public FileCallback() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/anggrayudi/storage/callback/FileCallback$ConflictResolution;", "", "(Ljava/lang/String;I)V", "toCreateMode", "Lcom/anggrayudi/storage/file/CreateMode;", "allowReuseFile", "", "REPLACE", "CREATE_NEW", "SKIP", "storage_release"})
    public static final class ConflictResolution
    extends Enum<ConflictResolution> {
        public static final /* enum */ ConflictResolution REPLACE = new ConflictResolution();
        public static final /* enum */ ConflictResolution CREATE_NEW = new ConflictResolution();
        public static final /* enum */ ConflictResolution SKIP = new ConflictResolution();
        private static final /* synthetic */ ConflictResolution[] $VALUES;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NotNull
        public final CreateMode toCreateMode(boolean allowReuseFile) {
            CreateMode createMode;
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    createMode = CreateMode.REPLACE;
                    break;
                }
                case 2: {
                    createMode = CreateMode.CREATE_NEW;
                    break;
                }
                case 3: {
                    if (allowReuseFile) {
                        createMode = CreateMode.REUSE;
                        break;
                    }
                    createMode = CreateMode.CREATE_NEW;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return createMode;
        }

        public static /* synthetic */ CreateMode toCreateMode$default(ConflictResolution conflictResolution, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toCreateMode");
            }
            if ((n & 1) != 0) {
                bl = false;
            }
            return conflictResolution.toCreateMode(bl);
        }

        public static ConflictResolution[] values() {
            return (ConflictResolution[])$VALUES.clone();
        }

        public static ConflictResolution valueOf(String value) {
            return Enum.valueOf(ConflictResolution.class, value);
        }

        static {
            $VALUES = conflictResolutionArray = new ConflictResolution[]{ConflictResolution.REPLACE, ConflictResolution.CREATE_NEW, ConflictResolution.SKIP};
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ConflictResolution.values().length];
                try {
                    nArray[ConflictResolution.REPLACE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConflictResolution.CREATE_NEW.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConflictResolution.SKIP.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/anggrayudi/storage/callback/FileCallback$ErrorCode;", "", "(Ljava/lang/String;I)V", "STORAGE_PERMISSION_DENIED", "CANNOT_CREATE_FILE_IN_TARGET", "SOURCE_FILE_NOT_FOUND", "TARGET_FILE_NOT_FOUND", "TARGET_FOLDER_NOT_FOUND", "UNKNOWN_IO_ERROR", "CANCELED", "TARGET_FOLDER_CANNOT_HAVE_SAME_PATH_WITH_SOURCE_FOLDER", "NO_SPACE_LEFT_ON_TARGET_PATH", "storage_release"})
    public static final class ErrorCode
    extends Enum<ErrorCode> {
        public static final /* enum */ ErrorCode STORAGE_PERMISSION_DENIED = new ErrorCode();
        public static final /* enum */ ErrorCode CANNOT_CREATE_FILE_IN_TARGET = new ErrorCode();
        public static final /* enum */ ErrorCode SOURCE_FILE_NOT_FOUND = new ErrorCode();
        public static final /* enum */ ErrorCode TARGET_FILE_NOT_FOUND = new ErrorCode();
        public static final /* enum */ ErrorCode TARGET_FOLDER_NOT_FOUND = new ErrorCode();
        public static final /* enum */ ErrorCode UNKNOWN_IO_ERROR = new ErrorCode();
        public static final /* enum */ ErrorCode CANCELED = new ErrorCode();
        public static final /* enum */ ErrorCode TARGET_FOLDER_CANNOT_HAVE_SAME_PATH_WITH_SOURCE_FOLDER = new ErrorCode();
        public static final /* enum */ ErrorCode NO_SPACE_LEFT_ON_TARGET_PATH = new ErrorCode();
        private static final /* synthetic */ ErrorCode[] $VALUES;

        public static ErrorCode[] values() {
            return (ErrorCode[])$VALUES.clone();
        }

        public static ErrorCode valueOf(String value) {
            return Enum.valueOf(ErrorCode.class, value);
        }

        static {
            $VALUES = errorCodeArray = new ErrorCode[]{ErrorCode.STORAGE_PERMISSION_DENIED, ErrorCode.CANNOT_CREATE_FILE_IN_TARGET, ErrorCode.SOURCE_FILE_NOT_FOUND, ErrorCode.TARGET_FILE_NOT_FOUND, ErrorCode.TARGET_FOLDER_NOT_FOUND, ErrorCode.UNKNOWN_IO_ERROR, ErrorCode.CANCELED, ErrorCode.TARGET_FOLDER_CANNOT_HAVE_SAME_PATH_WITH_SOURCE_FOLDER, ErrorCode.NO_SPACE_LEFT_ON_TARGET_PATH};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/anggrayudi/storage/callback/FileCallback$FileConflictAction;", "", "continuation", "Lkotlinx/coroutines/CancellableContinuation;", "Lcom/anggrayudi/storage/callback/FileCallback$ConflictResolution;", "(Lkotlinx/coroutines/CancellableContinuation;)V", "confirmResolution", "", "resolution", "storage_release"})
    public static final class FileConflictAction {
        @NotNull
        private final CancellableContinuation<ConflictResolution> continuation;

        public FileConflictAction(@NotNull CancellableContinuation<? super ConflictResolution> continuation) {
            Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
            this.continuation = continuation;
        }

        public final void confirmResolution(@NotNull ConflictResolution resolution) {
            Intrinsics.checkNotNullParameter((Object)((Object)resolution), (String)"resolution");
            this.continuation.resumeWith(Result.constructor-impl((Object)((Object)resolution)));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/anggrayudi/storage/callback/FileCallback$Report;", "", "progress", "", "bytesMoved", "", "writeSpeed", "", "(FJI)V", "getBytesMoved", "()J", "getProgress", "()F", "getWriteSpeed", "()I", "storage_release"})
    public static final class Report {
        private final float progress;
        private final long bytesMoved;
        private final int writeSpeed;

        public Report(float progress, long bytesMoved, int writeSpeed) {
            this.progress = progress;
            this.bytesMoved = bytesMoved;
            this.writeSpeed = writeSpeed;
        }

        public final float getProgress() {
            return this.progress;
        }

        public final long getBytesMoved() {
            return this.bytesMoved;
        }

        public final int getWriteSpeed() {
            return this.writeSpeed;
        }
    }
}

