/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.UriPermission;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.util.Log;
import androidx.activity.ComponentActivity;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.core.content.ContextCompat;
import androidx.documentfile.provider.DocumentFile;
import androidx.fragment.app.Fragment;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.callbacks.DialogCallbackExtKt;
import com.afollestad.materialdialogs.files.DialogFolderChooserExtKt;
import com.anggrayudi.storage.ActivityWrapper;
import com.anggrayudi.storage.ComponentActivityWrapper;
import com.anggrayudi.storage.ComponentWrapper;
import com.anggrayudi.storage.FragmentWrapper;
import com.anggrayudi.storage.SimpleStorage;
import com.anggrayudi.storage.callback.CreateFileCallback;
import com.anggrayudi.storage.callback.FilePickerCallback;
import com.anggrayudi.storage.callback.FileReceiverCallback;
import com.anggrayudi.storage.callback.FolderPickerCallback;
import com.anggrayudi.storage.callback.StorageAccessCallback;
import com.anggrayudi.storage.extension.ContextUtils;
import com.anggrayudi.storage.extension.UriUtils;
import com.anggrayudi.storage.file.DocumentFileCompat;
import com.anggrayudi.storage.file.DocumentFileUtils;
import com.anggrayudi.storage.file.FileFullPath;
import com.anggrayudi.storage.file.PublicDirectory;
import com.anggrayudi.storage.file.StorageType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\n\u0018\u0000 y2\u00020\u0001:\u0001yB\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bB\u001b\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0002\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020\u001e2\b\u0010R\u001a\u0004\u0018\u00010SH\u0002J\u0010\u0010T\u001a\u00020P2\b\u0010Q\u001a\u0004\u0018\u00010\u001eJ\b\u0010U\u001a\u00020PH\u0002J2\u0010V\u001a\u00020P2\u0006\u0010W\u001a\u00020\u001a2\n\b\u0002\u0010X\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010R\u001a\u0004\u0018\u00010S2\b\b\u0002\u0010Y\u001a\u000208H\u0007J\u0018\u0010Z\u001a\u00020P2\u0006\u0010Y\u001a\u0002082\u0006\u0010[\u001a\u00020\\H\u0002J\u0018\u0010]\u001a\u00020P2\u0006\u0010Y\u001a\u0002082\u0006\u0010^\u001a\u00020\u001eH\u0002J\u0018\u0010_\u001a\u00020P2\u0006\u0010Y\u001a\u0002082\u0006\u0010[\u001a\u00020\\H\u0002J\u0018\u0010`\u001a\u00020P2\u0006\u0010Y\u001a\u0002082\u0006\u0010[\u001a\u00020\\H\u0002J\u0018\u0010a\u001a\b\u0012\u0004\u0012\u00020c0b2\b\u0010Q\u001a\u0004\u0018\u00010\u001eH\u0002J\u000e\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020\u001aJ \u0010g\u001a\u00020P2\u0006\u0010Y\u001a\u0002082\u0006\u0010h\u001a\u0002082\b\u0010^\u001a\u0004\u0018\u00010\u001eJ\u000e\u0010i\u001a\u00020P2\u0006\u0010j\u001a\u00020\u0005J\u000e\u0010k\u001a\u00020P2\u0006\u0010l\u001a\u00020\u0005JA\u0010m\u001a\u00020P2\b\b\u0002\u0010Y\u001a\u0002082\b\b\u0002\u0010n\u001a\u00020e2\n\b\u0002\u0010R\u001a\u0004\u0018\u00010S2\u0012\u0010o\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0p\"\u00020\u001aH\u0007\u00a2\u0006\u0002\u0010qJ\u001e\u0010r\u001a\u00020P2\b\b\u0002\u0010Y\u001a\u0002082\n\b\u0002\u0010R\u001a\u0004\u0018\u00010SH\u0007J\b\u0010s\u001a\u00020PH\u0007J2\u0010t\u001a\u00020P2\b\b\u0002\u0010Y\u001a\u0002082\n\b\u0002\u0010R\u001a\u0004\u0018\u00010S2\b\b\u0002\u0010u\u001a\u00020\u001c2\b\b\u0002\u0010v\u001a\u00020\u001aH\u0007J\u0010\u0010w\u001a\u00020e2\u0006\u0010x\u001a\u00020\\H\u0002R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001c\u0010-\u001a\u0004\u0018\u00010.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0014\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b5\u00106R$\u00109\u001a\u0002082\u0006\u00107\u001a\u000208@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R$\u0010>\u001a\u0002082\u0006\u00107\u001a\u000208@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010;\"\u0004\b@\u0010=R$\u0010A\u001a\u0002082\u0006\u00107\u001a\u000208@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010;\"\u0004\bC\u0010=R$\u0010D\u001a\u0002082\u0006\u00107\u001a\u000208@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010;\"\u0004\bF\u0010=R\u0014\u0010G\u001a\u00020\u001e8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010 R\u001c\u0010I\u001a\u0004\u0018\u00010JX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006z"}, d2={"Lcom/anggrayudi/storage/SimpleStorage;", "", "activity", "Landroid/app/Activity;", "savedState", "Landroid/os/Bundle;", "(Landroid/app/Activity;Landroid/os/Bundle;)V", "Landroidx/activity/ComponentActivity;", "(Landroidx/activity/ComponentActivity;Landroid/os/Bundle;)V", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;Landroid/os/Bundle;)V", "wrapper", "Lcom/anggrayudi/storage/ComponentWrapper;", "(Lcom/anggrayudi/storage/ComponentWrapper;)V", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "createFileCallback", "Lcom/anggrayudi/storage/callback/CreateFileCallback;", "getCreateFileCallback", "()Lcom/anggrayudi/storage/callback/CreateFileCallback;", "setCreateFileCallback", "(Lcom/anggrayudi/storage/callback/CreateFileCallback;)V", "expectedBasePathForAccessRequest", "", "expectedStorageTypeForAccessRequest", "Lcom/anggrayudi/storage/file/StorageType;", "externalStorageRootAccessIntent", "Landroid/content/Intent;", "getExternalStorageRootAccessIntent", "()Landroid/content/Intent;", "filePickerCallback", "Lcom/anggrayudi/storage/callback/FilePickerCallback;", "getFilePickerCallback", "()Lcom/anggrayudi/storage/callback/FilePickerCallback;", "setFilePickerCallback", "(Lcom/anggrayudi/storage/callback/FilePickerCallback;)V", "fileReceiverCallback", "Lcom/anggrayudi/storage/callback/FileReceiverCallback;", "getFileReceiverCallback", "()Lcom/anggrayudi/storage/callback/FileReceiverCallback;", "setFileReceiverCallback", "(Lcom/anggrayudi/storage/callback/FileReceiverCallback;)V", "folderPickerCallback", "Lcom/anggrayudi/storage/callback/FolderPickerCallback;", "getFolderPickerCallback", "()Lcom/anggrayudi/storage/callback/FolderPickerCallback;", "setFolderPickerCallback", "(Lcom/anggrayudi/storage/callback/FolderPickerCallback;)V", "lastVisitedFolder", "Ljava/io/File;", "getLastVisitedFolder$annotations", "()V", "value", "", "requestCodeCreateFile", "getRequestCodeCreateFile", "()I", "setRequestCodeCreateFile", "(I)V", "requestCodeFilePicker", "getRequestCodeFilePicker", "setRequestCodeFilePicker", "requestCodeFolderPicker", "getRequestCodeFolderPicker", "setRequestCodeFolderPicker", "requestCodeStorageAccess", "getRequestCodeStorageAccess", "setRequestCodeStorageAccess", "sdCardRootAccessIntent", "getSdCardRootAccessIntent", "storageAccessCallback", "Lcom/anggrayudi/storage/callback/StorageAccessCallback;", "getStorageAccessCallback", "()Lcom/anggrayudi/storage/callback/StorageAccessCallback;", "setStorageAccessCallback", "(Lcom/anggrayudi/storage/callback/StorageAccessCallback;)V", "addInitialPathToIntent", "", "intent", "initialPath", "Lcom/anggrayudi/storage/file/FileFullPath;", "checkIfFileReceived", "checkRequestCode", "createFile", "mimeType", "fileName", "requestCode", "handleActivityResultForCreateFile", "uri", "Landroid/net/Uri;", "handleActivityResultForFilePicker", "data", "handleActivityResultForFolderPicker", "handleActivityResultForStorageAccess", "intentToDocumentFiles", "", "Landroidx/documentfile/provider/DocumentFile;", "isStorageAccessGranted", "", "storageId", "onActivityResult", "resultCode", "onRestoreInstanceState", "savedInstanceState", "onSaveInstanceState", "outState", "openFilePicker", "allowMultiple", "filterMimeTypes", "", "(IZLcom/anggrayudi/storage/file/FileFullPath;[Ljava/lang/String;)V", "openFolderPicker", "requestFullStorageAccess", "requestStorageAccess", "expectedStorageType", "expectedBasePath", "saveUriPermission", "root", "Companion", "storage_release"})
@SourceDebugExtension(value={"SMAP\nSimpleStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleStorage.kt\ncom/anggrayudi/storage/SimpleStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,653:1\n1#2:654\n1#2:669\n288#3,2:655\n288#3,2:657\n1603#3,9:659\n1855#3:668\n1856#3:670\n1612#3:671\n766#3:672\n857#3,2:673\n1726#3,3:675\n*S KotlinDebug\n*F\n+ 1 SimpleStorage.kt\ncom/anggrayudi/storage/SimpleStorage\n*L\n426#1:669\n113#1:655,2\n378#1:657,2\n426#1:659,9\n426#1:668\n426#1:670\n426#1:671\n438#1:672\n438#1:673,2\n456#1:675,3\n*E\n"})
public final class SimpleStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ComponentWrapper wrapper;
    @Nullable
    private StorageAccessCallback storageAccessCallback;
    @Nullable
    private FolderPickerCallback folderPickerCallback;
    @Nullable
    private FilePickerCallback filePickerCallback;
    @Nullable
    private CreateFileCallback createFileCallback;
    @Nullable
    private FileReceiverCallback fileReceiverCallback;
    private int requestCodeStorageAccess;
    private int requestCodeFolderPicker;
    private int requestCodeFilePicker;
    private int requestCodeCreateFile;
    @NotNull
    private StorageType expectedStorageTypeForAccessRequest;
    @Nullable
    private String expectedBasePathForAccessRequest;
    @NotNull
    private File lastVisitedFolder;
    @NotNull
    private static final String KEY_REQUEST_CODE_STORAGE_ACCESS = "com.anggrayudi.storage.requestCodeStorageAccess";
    @NotNull
    private static final String KEY_REQUEST_CODE_FOLDER_PICKER = "com.anggrayudi.storage.requestCodeFolderPicker";
    @NotNull
    private static final String KEY_REQUEST_CODE_FILE_PICKER = "com.anggrayudi.storage.requestCodeFilePicker";
    @NotNull
    private static final String KEY_REQUEST_CODE_CREATE_FILE = "com.anggrayudi.storage.requestCodeCreateFile";
    @NotNull
    private static final String KEY_REQUEST_CODE_FRAGMENT_PICKER = "com.anggrayudi.storage.requestCodeFragmentPicker";
    @NotNull
    private static final String KEY_EXPECTED_STORAGE_TYPE_FOR_ACCESS_REQUEST = "com.anggrayudi.storage.expectedStorageTypeForAccessRequest";
    @NotNull
    private static final String KEY_EXPECTED_BASE_PATH_FOR_ACCESS_REQUEST = "com.anggrayudi.storage.expectedBasePathForAccessRequest";
    @NotNull
    private static final String KEY_LAST_VISITED_FOLDER = "com.anggrayudi.storage.lastVisitedFolder";
    @NotNull
    private static final String TAG = "SimpleStorage";
    @NotNull
    public static final String KITKAT_SD_CARD_ID = "sdcard";
    @NotNull
    public static final String KITKAT_SD_CARD_PATH = "/storage/sdcard";

    private SimpleStorage(ComponentWrapper wrapper) {
        this.wrapper = wrapper;
        this.requestCodeStorageAccess = 1;
        this.requestCodeFolderPicker = 2;
        this.requestCodeFilePicker = 3;
        this.requestCodeCreateFile = 4;
        this.expectedStorageTypeForAccessRequest = StorageType.UNKNOWN;
        File file = Environment.getExternalStorageDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getExternalStorageDirectory()");
        this.lastVisitedFolder = file;
    }

    public SimpleStorage(@NotNull Activity activity, @Nullable Bundle savedState) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this(new ActivityWrapper(activity));
            Bundle bundle = savedState;
            if (bundle == null) break block0;
            Bundle it = bundle;
            boolean bl = false;
            this.onRestoreInstanceState(it);
        }
    }

    public /* synthetic */ SimpleStorage(Activity activity, Bundle bundle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bundle = null;
        }
        this(activity, bundle);
    }

    public SimpleStorage(@NotNull ComponentActivity activity, @Nullable Bundle savedState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this(new ComponentActivityWrapper(activity));
        Bundle bundle = savedState;
        if (bundle != null) {
            Bundle it = bundle;
            boolean bl = false;
            this.onRestoreInstanceState(it);
        }
        ComponentWrapper componentWrapper = this.wrapper;
        Intrinsics.checkNotNull((Object)componentWrapper, (String)"null cannot be cast to non-null type com.anggrayudi.storage.ComponentActivityWrapper");
        ((ComponentActivityWrapper)componentWrapper).setStorage(this);
    }

    public /* synthetic */ SimpleStorage(ComponentActivity componentActivity, Bundle bundle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bundle = null;
        }
        this(componentActivity, bundle);
    }

    public SimpleStorage(@NotNull Fragment fragment, @Nullable Bundle savedState) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this(new FragmentWrapper(fragment));
        Bundle bundle = savedState;
        if (bundle != null) {
            Bundle it = bundle;
            boolean bl = false;
            this.onRestoreInstanceState(it);
        }
        ComponentWrapper componentWrapper = this.wrapper;
        Intrinsics.checkNotNull((Object)componentWrapper, (String)"null cannot be cast to non-null type com.anggrayudi.storage.FragmentWrapper");
        ((FragmentWrapper)componentWrapper).setStorage(this);
    }

    public /* synthetic */ SimpleStorage(Fragment fragment, Bundle bundle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bundle = null;
        }
        this(fragment, bundle);
    }

    @Nullable
    public final StorageAccessCallback getStorageAccessCallback() {
        return this.storageAccessCallback;
    }

    public final void setStorageAccessCallback(@Nullable StorageAccessCallback storageAccessCallback) {
        this.storageAccessCallback = storageAccessCallback;
    }

    @Nullable
    public final FolderPickerCallback getFolderPickerCallback() {
        return this.folderPickerCallback;
    }

    public final void setFolderPickerCallback(@Nullable FolderPickerCallback folderPickerCallback) {
        this.folderPickerCallback = folderPickerCallback;
    }

    @Nullable
    public final FilePickerCallback getFilePickerCallback() {
        return this.filePickerCallback;
    }

    public final void setFilePickerCallback(@Nullable FilePickerCallback filePickerCallback) {
        this.filePickerCallback = filePickerCallback;
    }

    @Nullable
    public final CreateFileCallback getCreateFileCallback() {
        return this.createFileCallback;
    }

    public final void setCreateFileCallback(@Nullable CreateFileCallback createFileCallback) {
        this.createFileCallback = createFileCallback;
    }

    @Nullable
    public final FileReceiverCallback getFileReceiverCallback() {
        return this.fileReceiverCallback;
    }

    public final void setFileReceiverCallback(@Nullable FileReceiverCallback fileReceiverCallback) {
        this.fileReceiverCallback = fileReceiverCallback;
    }

    public final int getRequestCodeStorageAccess() {
        return this.requestCodeStorageAccess;
    }

    public final void setRequestCodeStorageAccess(int value) {
        this.requestCodeStorageAccess = value;
        this.checkRequestCode();
    }

    public final int getRequestCodeFolderPicker() {
        return this.requestCodeFolderPicker;
    }

    public final void setRequestCodeFolderPicker(int value) {
        this.requestCodeFolderPicker = value;
        this.checkRequestCode();
    }

    public final int getRequestCodeFilePicker() {
        return this.requestCodeFilePicker;
    }

    public final void setRequestCodeFilePicker(int value) {
        this.requestCodeFilePicker = value;
        this.checkRequestCode();
    }

    public final int getRequestCodeCreateFile() {
        return this.requestCodeCreateFile;
    }

    public final void setRequestCodeCreateFile(int value) {
        this.requestCodeCreateFile = value;
        this.checkRequestCode();
    }

    @NotNull
    public final Context getContext() {
        return this.wrapper.getContext();
    }

    private final Intent getExternalStorageRootAccessIntent() {
        Intent intent;
        if (Build.VERSION.SDK_INT >= 29) {
            Object object = this.getContext().getSystemService("storage");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.storage.StorageManager");
            StorageManager sm = (StorageManager)object;
            Intent intent2 = sm.getPrimaryStorageVolume().createOpenDocumentTreeIntent();
            Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"{\n            val sm = c\u2026entTreeIntent()\n        }");
            intent = intent2;
        } else {
            intent = Companion.getDefaultExternalStorageIntent(this.getContext());
        }
        return intent;
    }

    @RequiresApi(api=24)
    private final Intent getSdCardRootAccessIntent() {
        StorageVolume storageVolume;
        block6: {
            block5: {
                Object v2;
                block4: {
                    Object object = this.getContext().getSystemService("storage");
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.storage.StorageManager");
                    StorageManager sm = (StorageManager)object;
                    List list = sm.getStorageVolumes();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sm.storageVolumes");
                    Iterable $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        StorageVolume it = (StorageVolume)element$iv;
                        boolean bl = false;
                        if (!it.isRemovable()) continue;
                        v2 = element$iv;
                        break block4;
                    }
                    v2 = null;
                }
                if ((storageVolume = (StorageVolume)v2) == null) break block5;
                StorageVolume it = storageVolume;
                boolean bl = false;
                Intent intent = Build.VERSION.SDK_INT >= 29 ? it.createOpenDocumentTreeIntent() : (it.isPrimary() ? Companion.getDefaultExternalStorageIntent(this.getContext()) : it.createAccessIntent(null));
                storageVolume = intent;
                if (intent != null) break block6;
            }
            storageVolume = Companion.getDefaultExternalStorageIntent(this.getContext());
        }
        return storageVolume;
    }

    public final boolean isStorageAccessGranted(@NotNull String storageId) {
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        return DocumentFileCompat.isAccessGranted(this.getContext(), storageId);
    }

    @RequiresApi(value=21)
    @JvmOverloads
    public final void requestStorageAccess(int requestCode, @Nullable FileFullPath initialPath, @NotNull StorageType expectedStorageType, @NotNull String expectedBasePath) {
        block12: {
            Intent intent;
            block11: {
                Intent intent2;
                Intrinsics.checkNotNullParameter((Object)((Object)expectedStorageType), (String)"expectedStorageType");
                Intrinsics.checkNotNullParameter((Object)expectedBasePath, (String)"expectedBasePath");
                FileFullPath fileFullPath = initialPath;
                if (fileFullPath != null) {
                    fileFullPath.checkIfStorageIdIsAccessibleInSafSelector();
                }
                if (expectedStorageType == StorageType.DATA) {
                    throw new IllegalArgumentException("Cannot use StorageType.DATA because it is never available in Storage Access Framework's folder selector.");
                }
                if (Build.VERSION.SDK_INT < 29) {
                    if (Companion.hasStoragePermission(this.getContext())) {
                        if (expectedStorageType == StorageType.EXTERNAL && !Companion.isSdCardPresent()) {
                            DocumentFile documentFile = DocumentFileCompat.getRootDocumentFile$default(this.getContext(), "primary", true, false, 8, null);
                            if (documentFile == null) {
                                return;
                            }
                            DocumentFile root = documentFile;
                            Uri uri = root.getUri();
                            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"root.uri");
                            this.saveUriPermission(uri);
                            StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
                            if (storageAccessCallback != null) {
                                storageAccessCallback.onRootPathPermissionGranted(requestCode, root);
                            }
                            return;
                        }
                    } else {
                        StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
                        if (storageAccessCallback != null) {
                            storageAccessCallback.onStoragePermissionDenied(requestCode);
                        }
                        return;
                    }
                }
                if (Build.VERSION.SDK_INT >= 30) {
                    Intent intent3;
                    Intent it = intent3 = this.getExternalStorageRootAccessIntent();
                    boolean bl = false;
                    this.addInitialPathToIntent(it, initialPath);
                    intent2 = intent3;
                } else {
                    intent2 = intent = Build.VERSION.SDK_INT >= 24 && expectedStorageType == StorageType.SD_CARD ? this.getSdCardRootAccessIntent() : this.getExternalStorageRootAccessIntent();
                }
                if (!this.wrapper.startActivityForResult(intent, requestCode)) break block11;
                this.setRequestCodeStorageAccess(requestCode);
                this.expectedStorageTypeForAccessRequest = expectedStorageType;
                this.expectedBasePathForAccessRequest = expectedBasePath;
                break block12;
            }
            StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
            if (storageAccessCallback == null) break block12;
            storageAccessCallback.onActivityHandlerNotFound(requestCode, intent);
        }
    }

    public static /* synthetic */ void requestStorageAccess$default(SimpleStorage simpleStorage, int n, FileFullPath fileFullPath, StorageType storageType, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = simpleStorage.requestCodeStorageAccess;
        }
        if ((n2 & 2) != 0) {
            fileFullPath = null;
        }
        if ((n2 & 4) != 0) {
            storageType = StorageType.UNKNOWN;
        }
        if ((n2 & 8) != 0) {
            string = "";
        }
        simpleStorage.requestStorageAccess(n, fileFullPath, storageType, string);
    }

    @RequiresPermission(value="android.permission.MANAGE_EXTERNAL_STORAGE")
    @RequiresApi(value=30)
    public final void requestFullStorageAccess() {
        this.getContext().startActivity(new Intent("android.settings.MANAGE_ALL_FILES_ACCESS_PERMISSION"));
    }

    @JvmOverloads
    public final void createFile(@NotNull String mimeType, @Nullable String fileName, @Nullable FileFullPath initialPath, int requestCode) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            FileFullPath fileFullPath = initialPath;
            if (fileFullPath != null) {
                fileFullPath.checkIfStorageIdIsAccessibleInSafSelector();
            }
            this.setRequestCodeCreateFile(requestCode);
            Intent intent = new Intent("android.intent.action.CREATE_DOCUMENT").setType(mimeType);
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(Intent.ACTION_CRE\u2026CUMENT).setType(mimeType)");
            Intent intent2 = intent;
            this.addInitialPathToIntent(intent2, initialPath);
            String string = fileName;
            if (string != null) {
                String it = string;
                boolean bl = false;
                intent2.putExtra("android.intent.extra.TITLE", it);
            }
            if (this.wrapper.startActivityForResult(intent2, requestCode)) break block3;
            CreateFileCallback createFileCallback = this.createFileCallback;
            if (createFileCallback != null) {
                createFileCallback.onActivityHandlerNotFound(requestCode, intent2);
            }
        }
    }

    public static /* synthetic */ void createFile$default(SimpleStorage simpleStorage, String string, String string2, FileFullPath fileFullPath, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        if ((n2 & 4) != 0) {
            fileFullPath = null;
        }
        if ((n2 & 8) != 0) {
            n = simpleStorage.requestCodeCreateFile;
        }
        simpleStorage.createFile(string, string2, fileFullPath, n);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"InlinedApi"})
    @JvmOverloads
    public final void openFolderPicker(int requestCode, @Nullable FileFullPath initialPath) {
        block6: {
            block5: {
                FileFullPath fileFullPath = initialPath;
                if (fileFullPath != null) {
                    fileFullPath.checkIfStorageIdIsAccessibleInSafSelector();
                }
                this.setRequestCodeFolderPicker(requestCode);
                if (Build.VERSION.SDK_INT < 21) {
                    File file;
                    MaterialDialog materialDialog = new MaterialDialog(this.getContext(), null, 2, null);
                    Context context = this.getContext();
                    FileFullPath fileFullPath2 = initialPath;
                    if (fileFullPath2 != null) {
                        void it;
                        FileFullPath fileFullPath3 = fileFullPath2;
                        Context context2 = context;
                        MaterialDialog materialDialog2 = materialDialog;
                        boolean bl = false;
                        File file2 = new File(it.getAbsolutePath());
                        materialDialog = materialDialog2;
                        context = context2;
                        file = file2;
                    } else {
                        file = this.lastVisitedFolder;
                    }
                    DialogCallbackExtKt.onCancel((MaterialDialog)MaterialDialog.negativeButton$default((MaterialDialog)DialogFolderChooserExtKt.folderChooser$default((MaterialDialog)materialDialog, (Context)context, (File)file, null, (boolean)false, (int)0, (boolean)true, null, (Function2)((Function2)new Function2<MaterialDialog, File, Unit>(this, requestCode){
                        final /* synthetic */ SimpleStorage this$0;
                        final /* synthetic */ int $requestCode;
                        {
                            this.this$0 = $receiver;
                            this.$requestCode = $requestCode;
                            super(2);
                        }

                        public final void invoke(@NotNull MaterialDialog materialDialog, @NotNull File file) {
                            block0: {
                                Intrinsics.checkNotNullParameter((Object)materialDialog, (String)"<anonymous parameter 0>");
                                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                                SimpleStorage.access$setLastVisitedFolder$p(this.this$0, file);
                                FolderPickerCallback folderPickerCallback = this.this$0.getFolderPickerCallback();
                                if (folderPickerCallback == null) break block0;
                                DocumentFile documentFile = DocumentFile.fromFile((File)file);
                                Intrinsics.checkNotNullExpressionValue((Object)documentFile, (String)"fromFile(file)");
                                folderPickerCallback.onFolderSelected(this.$requestCode, documentFile);
                            }
                        }
                    }), (int)92, null), (Integer)0x1040000, null, (Function1)openFolderPicker.3.INSTANCE, (int)2, null), (Function1)((Function1)new Function1<MaterialDialog, Unit>(this, requestCode){
                        final /* synthetic */ SimpleStorage this$0;
                        final /* synthetic */ int $requestCode;
                        {
                            this.this$0 = $receiver;
                            this.$requestCode = $requestCode;
                            super(1);
                        }

                        public final void invoke(@NotNull MaterialDialog it) {
                            block0: {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                FolderPickerCallback folderPickerCallback = this.this$0.getFolderPickerCallback();
                                if (folderPickerCallback == null) break block0;
                                folderPickerCallback.onCanceledByUser(this.$requestCode);
                            }
                        }
                    })).show();
                    return;
                }
                if (Build.VERSION.SDK_INT <= 28 && !Companion.hasStoragePermission(this.getContext())) break block5;
                Intent intent = Build.VERSION.SDK_INT < 30 ? new Intent("android.intent.action.OPEN_DOCUMENT_TREE") : this.getExternalStorageRootAccessIntent();
                this.addInitialPathToIntent(intent, initialPath);
                if (this.wrapper.startActivityForResult(intent, requestCode)) break block6;
                FolderPickerCallback folderPickerCallback = this.folderPickerCallback;
                if (folderPickerCallback != null) {
                    folderPickerCallback.onActivityHandlerNotFound(requestCode, intent);
                }
                break block6;
            }
            FolderPickerCallback folderPickerCallback = this.folderPickerCallback;
            if (folderPickerCallback == null) break block6;
            folderPickerCallback.onStoragePermissionDenied(requestCode);
        }
    }

    public static /* synthetic */ void openFolderPicker$default(SimpleStorage simpleStorage, int n, FileFullPath fileFullPath, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = simpleStorage.requestCodeFolderPicker;
        }
        if ((n2 & 2) != 0) {
            fileFullPath = null;
        }
        simpleStorage.openFolderPicker(n, fileFullPath);
    }

    private static /* synthetic */ void getLastVisitedFolder$annotations() {
    }

    @JvmOverloads
    public final void openFilePicker(int requestCode, boolean allowMultiple, @Nullable FileFullPath initialPath, String ... filterMimeTypes) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)filterMimeTypes, (String)"filterMimeTypes");
            FileFullPath fileFullPath = initialPath;
            if (fileFullPath != null) {
                fileFullPath.checkIfStorageIdIsAccessibleInSafSelector();
            }
            this.setRequestCodeFilePicker(requestCode);
            Intent intent = Build.VERSION.SDK_INT < 21 ? new Intent("android.intent.action.GET_CONTENT") : new Intent("android.intent.action.OPEN_DOCUMENT");
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", allowMultiple);
            if (filterMimeTypes.length > 1) {
                intent.setType("*/*").putExtra("android.intent.extra.MIME_TYPES", filterMimeTypes);
            } else {
                String string = (String)ArraysKt.firstOrNull((Object[])filterMimeTypes);
                if (string == null) {
                    string = "*/*";
                }
                intent.setType(string);
            }
            this.addInitialPathToIntent(intent, initialPath);
            if (this.wrapper.startActivityForResult(intent, requestCode)) break block5;
            FilePickerCallback filePickerCallback = this.filePickerCallback;
            if (filePickerCallback != null) {
                filePickerCallback.onActivityHandlerNotFound(requestCode, intent);
            }
        }
    }

    public static /* synthetic */ void openFilePicker$default(SimpleStorage simpleStorage, int n, boolean bl, FileFullPath fileFullPath, String[] stringArray, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = simpleStorage.requestCodeFilePicker;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            fileFullPath = null;
        }
        simpleStorage.openFilePicker(n, bl, fileFullPath, stringArray);
    }

    private final void addInitialPathToIntent(Intent intent, FileFullPath initialPath) {
        block1: {
            if (Build.VERSION.SDK_INT < 26) break block1;
            FileFullPath fileFullPath = initialPath;
            if (fileFullPath != null && (fileFullPath = fileFullPath.toDocumentUri(this.getContext())) != null) {
                FileFullPath it = fileFullPath;
                boolean bl = false;
                intent.putExtra("android.provider.extra.INITIAL_URI", (Parcelable)it);
            }
        }
    }

    private final void handleActivityResultForStorageAccess(int requestCode, Uri uri) {
        block34: {
            CharSequence charSequence;
            String storageId;
            block35: {
                block32: {
                    block33: {
                        storageId = UriUtils.getStorageId(uri, this.getContext());
                        StorageType storageType = StorageType.Companion.fromStorageId(storageId);
                        if (Build.VERSION.SDK_INT > 29) {
                            DocumentFile documentFile = ContextUtils.fromTreeUri(this.getContext(), uri);
                            if (documentFile == null) {
                                return;
                            }
                            DocumentFile selectedFolder = documentFile;
                            if (!this.expectedStorageTypeForAccessRequest.isExpected(storageType) || !((charSequence = (CharSequence)this.expectedBasePathForAccessRequest) == null || charSequence.length() == 0) && !Intrinsics.areEqual((Object)DocumentFileUtils.getBasePath(selectedFolder, this.getContext()), (Object)this.expectedBasePathForAccessRequest)) {
                                StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
                                if (storageAccessCallback != null) {
                                    String string = this.expectedBasePathForAccessRequest;
                                    Intrinsics.checkNotNull((Object)string);
                                    storageAccessCallback.onExpectedStorageNotSelected(requestCode, selectedFolder, storageType, string, this.expectedStorageTypeForAccessRequest);
                                }
                                return;
                            }
                        } else if (!this.expectedStorageTypeForAccessRequest.isExpected(storageType)) {
                            DocumentFile documentFile = ContextUtils.fromTreeUri(this.getContext(), uri);
                            String string = documentFile != null ? DocumentFileUtils.getAbsolutePath(documentFile, this.getContext()) : null;
                            if (string == null) {
                                string = "";
                            }
                            String rootPath = string;
                            StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
                            if (storageAccessCallback != null) {
                                storageAccessCallback.onRootPathNotSelected(requestCode, rootPath, uri, storageType, this.expectedStorageTypeForAccessRequest);
                            }
                            return;
                        }
                        if (UriUtils.isDownloadsDocument(uri)) {
                            if (Intrinsics.areEqual((Object)uri.toString(), (Object)"content://com.android.providers.downloads.documents/tree/downloads")) {
                                this.saveUriPermission(uri);
                                StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
                                if (storageAccessCallback != null) {
                                    DocumentFile documentFile = ContextUtils.fromTreeUri(this.getContext(), uri);
                                    if (documentFile == null) {
                                        return;
                                    }
                                    storageAccessCallback.onRootPathPermissionGranted(requestCode, documentFile);
                                }
                            } else {
                                StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
                                if (storageAccessCallback != null) {
                                    storageAccessCallback.onRootPathNotSelected(requestCode, PublicDirectory.DOWNLOADS.getAbsolutePath(), uri, StorageType.EXTERNAL, this.expectedStorageTypeForAccessRequest);
                                }
                            }
                            return;
                        }
                        if (UriUtils.isDocumentsDocument(uri)) {
                            if (Intrinsics.areEqual((Object)uri.toString(), (Object)"content://com.android.externalstorage.documents/tree/home%3A")) {
                                this.saveUriPermission(uri);
                                StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
                                if (storageAccessCallback != null) {
                                    DocumentFile documentFile = ContextUtils.fromTreeUri(this.getContext(), uri);
                                    if (documentFile == null) {
                                        return;
                                    }
                                    storageAccessCallback.onRootPathPermissionGranted(requestCode, documentFile);
                                }
                            } else {
                                StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
                                if (storageAccessCallback != null) {
                                    storageAccessCallback.onRootPathNotSelected(requestCode, PublicDirectory.DOCUMENTS.getAbsolutePath(), uri, StorageType.EXTERNAL, this.expectedStorageTypeForAccessRequest);
                                }
                            }
                            return;
                        }
                        if (Build.VERSION.SDK_INT < 30 && !UriUtils.isExternalStorageDocument(uri)) {
                            StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
                            if (storageAccessCallback != null) {
                                storageAccessCallback.onRootPathNotSelected(requestCode, Companion.getExternalStoragePath(), uri, StorageType.EXTERNAL, this.expectedStorageTypeForAccessRequest);
                            }
                            return;
                        }
                        if (Build.VERSION.SDK_INT < 29 && Intrinsics.areEqual((Object)storageId, (Object)"primary")) {
                            this.saveUriPermission(uri);
                            StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
                            if (storageAccessCallback != null) {
                                DocumentFile documentFile = ContextUtils.fromTreeUri(this.getContext(), uri);
                                if (documentFile == null) {
                                    return;
                                }
                                storageAccessCallback.onRootPathPermissionGranted(requestCode, documentFile);
                            }
                            return;
                        }
                        if (Build.VERSION.SDK_INT < 30 && !DocumentFileCompat.isRootUri(uri)) break block32;
                        if (!this.saveUriPermission(uri)) break block33;
                        StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
                        if (storageAccessCallback == null) break block34;
                        DocumentFile documentFile = ContextUtils.fromTreeUri(this.getContext(), uri);
                        if (documentFile == null) {
                            return;
                        }
                        storageAccessCallback.onRootPathPermissionGranted(requestCode, documentFile);
                        break block34;
                    }
                    StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
                    if (storageAccessCallback == null) break block34;
                    storageAccessCallback.onStoragePermissionDenied(requestCode);
                    break block34;
                }
                if (!Intrinsics.areEqual((Object)storageId, (Object)"primary")) break block35;
                StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
                if (storageAccessCallback == null) break block34;
                storageAccessCallback.onRootPathNotSelected(requestCode, Companion.getExternalStoragePath(), uri, StorageType.EXTERNAL, this.expectedStorageTypeForAccessRequest);
                break block34;
            }
            if (Build.VERSION.SDK_INT >= 24 && Build.VERSION.SDK_INT < 29) {
                Intent intent;
                Object v21;
                block31: {
                    Object object = this.getContext().getSystemService("storage");
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.storage.StorageManager");
                    StorageManager sm = (StorageManager)object;
                    List list = sm.getStorageVolumes();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sm.storageVolumes");
                    Iterable $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        StorageVolume it = (StorageVolume)element$iv;
                        boolean bl = false;
                        if (!(!it.isPrimary())) continue;
                        v21 = element$iv;
                        break block31;
                    }
                    v21 = null;
                }
                charSequence = v21;
                if (charSequence != null && (intent = charSequence.createAccessIntent(null)) != null) {
                    Intent it = intent;
                    boolean bl = false;
                    if (!this.wrapper.startActivityForResult(it, requestCode)) {
                        StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
                        if (storageAccessCallback != null) {
                            storageAccessCallback.onActivityHandlerNotFound(requestCode, it);
                        }
                    }
                    return;
                }
            }
            StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
            if (storageAccessCallback == null) break block34;
            storageAccessCallback.onRootPathNotSelected(requestCode, "/storage/" + storageId, uri, StorageType.SD_CARD, this.expectedStorageTypeForAccessRequest);
        }
    }

    private final void handleActivityResultForFolderPicker(int requestCode, Uri uri) {
        block4: {
            StorageType storageType;
            String storageId;
            DocumentFile folder;
            block3: {
                folder = ContextUtils.fromTreeUri(this.getContext(), uri);
                storageId = UriUtils.getStorageId(uri, this.getContext());
                storageType = StorageType.Companion.fromStorageId(storageId);
                if (folder == null || !DocumentFileUtils.canModify(folder, this.getContext())) {
                    FolderPickerCallback folderPickerCallback = this.folderPickerCallback;
                    if (folderPickerCallback != null) {
                        folderPickerCallback.onStorageAccessDenied(requestCode, folder, storageType, storageId);
                    }
                    return;
                }
                String it = uri.toString();
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual((Object)it, (Object)"content://com.android.providers.downloads.documents/tree/downloads") || Intrinsics.areEqual((Object)it, (Object)"content://com.android.externalstorage.documents/tree/home%3A");
                if (bl2 || DocumentFileCompat.isRootUri(uri) && (Build.VERSION.SDK_INT < 24 && storageType == StorageType.SD_CARD || Build.VERSION.SDK_INT == 29) && !DocumentFileCompat.isStorageUriPermissionGranted$default(this.getContext(), storageId, null, 4, null)) {
                    this.saveUriPermission(uri);
                }
                if (!(Build.VERSION.SDK_INT < 29 && storageType == StorageType.EXTERNAL || Build.VERSION.SDK_INT >= 30 && this.saveUriPermission(uri) || DocumentFileUtils.canModify(folder, this.getContext()) && (UriUtils.isDocumentsDocument(uri) || !UriUtils.isExternalStorageDocument(uri))) && !DocumentFileCompat.isStorageUriPermissionGranted$default(this.getContext(), storageId, null, 4, null)) break block3;
                FolderPickerCallback folderPickerCallback = this.folderPickerCallback;
                if (folderPickerCallback == null) break block4;
                folderPickerCallback.onFolderSelected(requestCode, folder);
                break block4;
            }
            FolderPickerCallback folderPickerCallback = this.folderPickerCallback;
            if (folderPickerCallback == null) break block4;
            folderPickerCallback.onStorageAccessDenied(requestCode, folder, storageType, storageId);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<DocumentFile> intentToDocumentFiles(Intent intent) {
        block13: {
            block12: {
                v0 /* !! */  = intent;
                if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .getClipData()) == null) break block12;
                $this$intentToDocumentFiles_u24lambda_u2413 = v0 /* !! */ ;
                $i$a$-run-SimpleStorage$intentToDocumentFiles$uris$1 = false;
                list = new ArrayList<E>();
                var10_9 = $this$intentToDocumentFiles_u24lambda_u2413.getItemCount();
                for (i = 0; i < var10_9; ++i) {
                    v1 = $this$intentToDocumentFiles_u24lambda_u2413.getItemAt(i).getUri();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getItemAt(i).uri");
                    list.add(v1);
                }
                i = list;
                it = i;
                $i$a$-takeIf-SimpleStorage$intentToDocumentFiles$uris$1$1 = false;
                v2 = !((Collection)it).isEmpty() ? i : null;
                v0 /* !! */  = v2;
                if (v2 != null) break block13;
            }
            if ((v3 = intent) == null || (v3 = v3.getData()) == null) {
                return CollectionsKt.emptyList();
            }
            v0 /* !! */  = CollectionsKt.listOf((Object)v3);
        }
        uris /* !! */  = v0 /* !! */ ;
        $this$mapNotNull$iv = (Iterable)uris /* !! */ ;
        $i$f$mapNotNull = false;
        var5_16 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            block15: {
                block16: {
                    block14: {
                        element$iv$iv = element$iv$iv$iv = it.next();
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                        uri = (Uri)element$iv$iv;
                        $i$a$-mapNotNull-SimpleStorage$intentToDocumentFiles$1 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
                        if (!UriUtils.isDownloadsDocument(uri) || Build.VERSION.SDK_INT >= 28) break block14;
                        v4 = var16_21 = uri.getPath();
                        if (v4 != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"path");
                            v5 = StringsKt.startsWith$default((String)var16_21, (String)"/document/raw:", (boolean)false, (int)2, null);
                        } else {
                            v5 = false;
                        }
                        if (!v5) break block14;
                        v6 = uri.getPath();
                        if (v6 == null) {
                            v6 = "";
                        }
                        fullPath = StringsKt.substringAfterLast$default((String)v6, (String)"/document/raw:", null, (int)2, null);
                        v7 = DocumentFile.fromFile((File)new File(fullPath));
                        break block15;
                    }
                    if (ContextUtils.fromSingleUri(this.getContext(), uri) == null) break block16;
                    $i$a$-let-SimpleStorage$intentToDocumentFiles$1$1 = false;
                    if (Build.VERSION.SDK_INT >= 21) ** GOTO lbl-1000
                    var19_24 = DocumentFileUtils.getStorageId(file, this.getContext());
                    if (DocumentFileCompat.INSTANCE.getSD_CARD_STORAGE_ID_REGEX().matches(var19_24)) {
                        v7 = DocumentFile.fromFile((File)DocumentFileCompat.INSTANCE.getKitkatSdCardRootFile(DocumentFileUtils.getBasePath(file, this.getContext())));
                    } else lbl-1000:
                    // 2 sources

                    {
                        v7 = file;
                    }
                    break block15;
                }
                v7 = null;
            }
            if (v7 == null) continue;
            it$iv$iv = v7;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (DocumentFile)element$iv$iv;
            $i$a$-filter-SimpleStorage$intentToDocumentFiles$2 = false;
            if (!it.isFile()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    public final void checkIfFileReceived(@Nullable Intent intent) {
        block7: {
            v0 = intent;
            v1 = var2_2 = v0 != null ? v0.getAction() : null;
            if (var2_2 == null) break block7;
            switch (var2_2.hashCode()) {
                case -58484670: {
                    if (!var2_2.equals("android.intent.action.SEND_MULTIPLE")) {
                        break;
                    }
                    ** GOTO lbl11
                }
                case -1173264947: {
                    if (!var2_2.equals("android.intent.action.SEND")) break;
lbl11:
                    // 2 sources

                    if ((files = this.intentToDocumentFiles(intent)).isEmpty()) {
                        v2 = this.fileReceiverCallback;
                        if (v2 != null) {
                            v2.onNonFileReceived(intent);
                        }
                        break;
                    }
                    v3 = this.fileReceiverCallback;
                    if (v3 == null) break;
                    v3.onFileReceived(files);
                    break;
                }
            }
        }
    }

    private final void handleActivityResultForFilePicker(int requestCode, Intent data) {
        block5: {
            List<DocumentFile> files;
            block4: {
                boolean bl;
                block3: {
                    files = this.intentToDocumentFiles(data);
                    if (!(!((Collection)files).isEmpty())) break block4;
                    Iterable $this$all$iv = files;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            DocumentFile it = (DocumentFile)element$iv;
                            boolean bl2 = false;
                            if (it.canRead()) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block4;
                FilePickerCallback filePickerCallback = this.filePickerCallback;
                if (filePickerCallback == null) break block5;
                filePickerCallback.onFileSelected(requestCode, files);
                break block5;
            }
            FilePickerCallback filePickerCallback = this.filePickerCallback;
            if (filePickerCallback == null) break block5;
            filePickerCallback.onStoragePermissionDenied(requestCode, files);
        }
    }

    private final void handleActivityResultForCreateFile(int requestCode, Uri uri) {
        block1: {
            DocumentFile documentFile = DocumentFileCompat.fromUri(this.getContext(), uri);
            if (documentFile == null) break block1;
            DocumentFile it = documentFile;
            boolean bl = false;
            CreateFileCallback createFileCallback = this.createFileCallback;
            if (createFileCallback != null) {
                createFileCallback.onFileCreated(requestCode, it);
            }
        }
    }

    public final void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        block5: {
            block10: {
                Uri uri;
                int n;
                block8: {
                    block9: {
                        block6: {
                            block7: {
                                block3: {
                                    block4: {
                                        this.checkRequestCode();
                                        n = requestCode;
                                        if (n != this.requestCodeStorageAccess) break block3;
                                        if (resultCode != -1) break block4;
                                        Intent intent = data;
                                        if (intent == null || (intent = intent.getData()) == null) {
                                            return;
                                        }
                                        this.handleActivityResultForStorageAccess(requestCode, (Uri)intent);
                                        break block5;
                                    }
                                    StorageAccessCallback storageAccessCallback = this.storageAccessCallback;
                                    if (storageAccessCallback == null) break block5;
                                    storageAccessCallback.onCanceledByUser(requestCode);
                                    break block5;
                                }
                                if (n != this.requestCodeFolderPicker) break block6;
                                if (resultCode != -1) break block7;
                                Intent intent = data;
                                if (intent == null || (intent = intent.getData()) == null) {
                                    return;
                                }
                                this.handleActivityResultForFolderPicker(requestCode, (Uri)intent);
                                break block5;
                            }
                            FolderPickerCallback folderPickerCallback = this.folderPickerCallback;
                            if (folderPickerCallback == null) break block5;
                            folderPickerCallback.onCanceledByUser(requestCode);
                            break block5;
                        }
                        if (n != this.requestCodeFilePicker) break block8;
                        if (resultCode != -1) break block9;
                        Intent intent = data;
                        if (intent == null) {
                            return;
                        }
                        this.handleActivityResultForFilePicker(requestCode, intent);
                        break block5;
                    }
                    FilePickerCallback filePickerCallback = this.filePickerCallback;
                    if (filePickerCallback == null) break block5;
                    filePickerCallback.onCanceledByUser(requestCode);
                    break block5;
                }
                if (n != this.requestCodeCreateFile) break block5;
                Intent intent = data;
                Object object = uri = intent != null ? intent.getData() : null;
                if (uri == null) break block10;
                this.handleActivityResultForCreateFile(requestCode, uri);
                break block5;
            }
            CreateFileCallback createFileCallback = this.createFileCallback;
            if (createFileCallback == null) break block5;
            createFileCallback.onCanceledByUser(requestCode);
        }
    }

    public final void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        outState.putString(KEY_LAST_VISITED_FOLDER, this.lastVisitedFolder.getPath());
        outState.putString(KEY_EXPECTED_BASE_PATH_FOR_ACCESS_REQUEST, this.expectedBasePathForAccessRequest);
        outState.putInt(KEY_EXPECTED_STORAGE_TYPE_FOR_ACCESS_REQUEST, this.expectedStorageTypeForAccessRequest.ordinal());
        outState.putInt(KEY_REQUEST_CODE_STORAGE_ACCESS, this.requestCodeStorageAccess);
        outState.putInt(KEY_REQUEST_CODE_FOLDER_PICKER, this.requestCodeFolderPicker);
        outState.putInt(KEY_REQUEST_CODE_FILE_PICKER, this.requestCodeFilePicker);
        outState.putInt(KEY_REQUEST_CODE_CREATE_FILE, this.requestCodeCreateFile);
        if (this.wrapper instanceof FragmentWrapper) {
            outState.putInt(KEY_REQUEST_CODE_FRAGMENT_PICKER, ((FragmentWrapper)this.wrapper).getRequestCode());
        }
    }

    public final void onRestoreInstanceState(@NotNull Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)savedInstanceState, (String)"savedInstanceState");
        String string = savedInstanceState.getString(KEY_LAST_VISITED_FOLDER);
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.lastVisitedFolder = new File(it);
        }
        this.expectedBasePathForAccessRequest = savedInstanceState.getString(KEY_EXPECTED_BASE_PATH_FOR_ACCESS_REQUEST);
        this.expectedStorageTypeForAccessRequest = StorageType.values()[savedInstanceState.getInt(KEY_EXPECTED_STORAGE_TYPE_FOR_ACCESS_REQUEST)];
        this.setRequestCodeStorageAccess(savedInstanceState.getInt(KEY_REQUEST_CODE_STORAGE_ACCESS));
        this.setRequestCodeFolderPicker(savedInstanceState.getInt(KEY_REQUEST_CODE_FOLDER_PICKER));
        this.setRequestCodeFilePicker(savedInstanceState.getInt(KEY_REQUEST_CODE_FILE_PICKER));
        this.setRequestCodeCreateFile(savedInstanceState.getInt(KEY_REQUEST_CODE_CREATE_FILE));
        if (this.wrapper instanceof FragmentWrapper && savedInstanceState.containsKey(KEY_REQUEST_CODE_FRAGMENT_PICKER)) {
            ((FragmentWrapper)this.wrapper).setRequestCode(savedInstanceState.getInt(KEY_REQUEST_CODE_FRAGMENT_PICKER));
        }
    }

    private final void checkRequestCode() {
        Object[] objectArray = new Integer[]{this.requestCodeFilePicker, this.requestCodeFolderPicker, this.requestCodeStorageAccess, this.requestCodeCreateFile};
        Set set = SetsKt.setOf((Object[])objectArray);
        if (set.size() < 4) {
            throw new IllegalArgumentException("Request codes must be unique. File picker=" + this.requestCodeFilePicker + ", Folder picker=" + this.requestCodeFolderPicker + ", Storage access=" + this.requestCodeStorageAccess + ", Create file=" + this.requestCodeCreateFile);
        }
    }

    private final boolean saveUriPermission(Uri root) {
        boolean bl;
        try {
            int writeFlags = 3;
            this.getContext().getContentResolver().takePersistableUriPermission(root, writeFlags);
            Context context = this.getContext().getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context.applicationContext");
            Companion.cleanupRedundantUriPermissions(context);
            bl = true;
        }
        catch (SecurityException e) {
            bl = false;
        }
        return bl;
    }

    @RequiresApi(value=21)
    @JvmOverloads
    public final void requestStorageAccess(int requestCode, @Nullable FileFullPath initialPath, @NotNull StorageType expectedStorageType) {
        Intrinsics.checkNotNullParameter((Object)((Object)expectedStorageType), (String)"expectedStorageType");
        SimpleStorage.requestStorageAccess$default(this, requestCode, initialPath, expectedStorageType, null, 8, null);
    }

    @RequiresApi(value=21)
    @JvmOverloads
    public final void requestStorageAccess(int requestCode, @Nullable FileFullPath initialPath) {
        SimpleStorage.requestStorageAccess$default(this, requestCode, initialPath, null, null, 12, null);
    }

    @RequiresApi(value=21)
    @JvmOverloads
    public final void requestStorageAccess(int requestCode) {
        SimpleStorage.requestStorageAccess$default(this, requestCode, null, null, null, 14, null);
    }

    @RequiresApi(value=21)
    @JvmOverloads
    public final void requestStorageAccess() {
        SimpleStorage.requestStorageAccess$default(this, 0, null, null, null, 15, null);
    }

    @JvmOverloads
    public final void createFile(@NotNull String mimeType, @Nullable String fileName, @Nullable FileFullPath initialPath) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        SimpleStorage.createFile$default(this, mimeType, fileName, initialPath, 0, 8, null);
    }

    @JvmOverloads
    public final void createFile(@NotNull String mimeType, @Nullable String fileName) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        SimpleStorage.createFile$default(this, mimeType, fileName, null, 0, 12, null);
    }

    @JvmOverloads
    public final void createFile(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        SimpleStorage.createFile$default(this, mimeType, null, null, 0, 14, null);
    }

    @SuppressLint(value={"InlinedApi"})
    @JvmOverloads
    public final void openFolderPicker(int requestCode) {
        SimpleStorage.openFolderPicker$default(this, requestCode, null, 2, null);
    }

    @SuppressLint(value={"InlinedApi"})
    @JvmOverloads
    public final void openFolderPicker() {
        SimpleStorage.openFolderPicker$default(this, 0, null, 3, null);
    }

    @JvmOverloads
    public final void openFilePicker(int requestCode, boolean allowMultiple, String ... filterMimeTypes) {
        Intrinsics.checkNotNullParameter((Object)filterMimeTypes, (String)"filterMimeTypes");
        SimpleStorage.openFilePicker$default(this, requestCode, allowMultiple, null, filterMimeTypes, 4, null);
    }

    @JvmOverloads
    public final void openFilePicker(int requestCode, String ... filterMimeTypes) {
        Intrinsics.checkNotNullParameter((Object)filterMimeTypes, (String)"filterMimeTypes");
        SimpleStorage.openFilePicker$default(this, requestCode, false, null, filterMimeTypes, 6, null);
    }

    @JvmOverloads
    public final void openFilePicker(String ... filterMimeTypes) {
        Intrinsics.checkNotNullParameter((Object)filterMimeTypes, (String)"filterMimeTypes");
        SimpleStorage.openFilePicker$default(this, 0, false, null, filterMimeTypes, 7, null);
    }

    @NotNull
    public static final String getExternalStoragePath() {
        return Companion.getExternalStoragePath();
    }

    public static final boolean isSdCardPresent() {
        return Companion.isSdCardPresent();
    }

    @JvmStatic
    @SuppressLint(value={"InlinedApi"})
    @NotNull
    public static final Intent getDefaultExternalStorageIntent(@NotNull Context context) {
        return Companion.getDefaultExternalStorageIntent(context);
    }

    @JvmStatic
    public static final boolean hasStoragePermission(@NotNull Context context) {
        return Companion.hasStoragePermission(context);
    }

    @JvmStatic
    public static final boolean hasStorageReadPermission(@NotNull Context context) {
        return Companion.hasStorageReadPermission(context);
    }

    @JvmStatic
    public static final boolean hasFullDiskAccess(@NotNull Context context, @NotNull String storageId) {
        return Companion.hasFullDiskAccess(context, storageId);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean hasStorageAccess(@NotNull Context context, @NotNull String fullPath, boolean requiresWriteAccess) {
        return Companion.hasStorageAccess(context, fullPath, requiresWriteAccess);
    }

    @JvmStatic
    @NotNull
    public static final Thread cleanupRedundantUriPermissions(@NotNull Context context) {
        return Companion.cleanupRedundantUriPermissions(context);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean hasStorageAccess(@NotNull Context context, @NotNull String fullPath) {
        return Companion.hasStorageAccess(context, fullPath);
    }

    public static final /* synthetic */ void access$setLastVisitedFolder$p(SimpleStorage $this, File file) {
        $this.lastVisitedFolder = file;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0004H\u0007J\"\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00042\b\b\u0002\u0010!\u001a\u00020\u0014H\u0007J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u00148FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0013\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/anggrayudi/storage/SimpleStorage$Companion;", "", "()V", "KEY_EXPECTED_BASE_PATH_FOR_ACCESS_REQUEST", "", "KEY_EXPECTED_STORAGE_TYPE_FOR_ACCESS_REQUEST", "KEY_LAST_VISITED_FOLDER", "KEY_REQUEST_CODE_CREATE_FILE", "KEY_REQUEST_CODE_FILE_PICKER", "KEY_REQUEST_CODE_FOLDER_PICKER", "KEY_REQUEST_CODE_FRAGMENT_PICKER", "KEY_REQUEST_CODE_STORAGE_ACCESS", "KITKAT_SD_CARD_ID", "KITKAT_SD_CARD_PATH", "TAG", "externalStoragePath", "getExternalStoragePath$annotations", "getExternalStoragePath", "()Ljava/lang/String;", "isSdCardPresent", "", "isSdCardPresent$annotations", "()Z", "cleanupRedundantUriPermissions", "Ljava/lang/Thread;", "context", "Landroid/content/Context;", "getDefaultExternalStorageIntent", "Landroid/content/Intent;", "hasFullDiskAccess", "storageId", "hasStorageAccess", "fullPath", "requiresWriteAccess", "hasStoragePermission", "hasStorageReadPermission", "storage_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getExternalStoragePath() {
            String string = Environment.getExternalStorageDirectory().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalStorageDirectory().absolutePath");
            return string;
        }

        @JvmStatic
        public static /* synthetic */ void getExternalStoragePath$annotations() {
        }

        public final boolean isSdCardPresent() {
            return Intrinsics.areEqual((Object)Environment.getExternalStorageState(), (Object)"mounted");
        }

        @JvmStatic
        public static /* synthetic */ void isSdCardPresent$annotations() {
        }

        @JvmStatic
        @SuppressLint(value={"InlinedApi"})
        @NotNull
        public final Intent getDefaultExternalStorageIntent(@NotNull Context context) {
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent $this$getDefaultExternalStorageIntent_u24lambda_u240 = intent = new Intent("android.intent.action.OPEN_DOCUMENT_TREE");
            boolean bl = false;
            if (Build.VERSION.SDK_INT >= 26) {
                DocumentFile documentFile = ContextUtils.fromTreeUri(context, DocumentFileCompat.createDocumentUri$default("primary", null, 2, null));
                $this$getDefaultExternalStorageIntent_u24lambda_u240.putExtra("android.provider.extra.INITIAL_URI", (Parcelable)(documentFile != null ? documentFile.getUri() : null));
            }
            return intent;
        }

        @JvmStatic
        public final boolean hasStoragePermission(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0 && this.hasStorageReadPermission(context);
        }

        @JvmStatic
        public final boolean hasStorageReadPermission(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE") == 0;
        }

        @JvmStatic
        public final boolean hasFullDiskAccess(@NotNull Context context, @NotNull String storageId) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
            return com.anggrayudi.storage.SimpleStorage$Companion.hasStorageAccess$default(this, context, DocumentFileCompat.buildAbsolutePath(context, storageId, ""), false, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean hasStorageAccess(@NotNull Context context, @NotNull String fullPath, boolean requiresWriteAccess) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
            return DocumentFileCompat.getAccessibleRootDocumentFile$default(context, fullPath, requiresWriteAccess, false, 8, null) != null && (Build.VERSION.SDK_INT > 28 || requiresWriteAccess && this.hasStoragePermission(context) || !requiresWriteAccess && this.hasStorageReadPermission(context));
        }

        public static /* synthetic */ boolean hasStorageAccess$default(Companion companion, Context context, String string, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.hasStorageAccess(context, string, bl);
        }

        @JvmStatic
        @NotNull
        public final Thread cleanupRedundantUriPermissions(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(0);
                }

                /*
                 * Unable to fully structure code
                 */
                public final void invoke() {
                    resolver = this.$context.getContentResolver();
                    v0 = resolver.getPersistedUriPermissions();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"resolver.persistedUriPermissions");
                    $this$filter$iv = v0;
                    $i$f$filter = false;
                    var5_6 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (UriPermission)element$iv$iv;
                        $i$a$-filter-SimpleStorage$Companion$cleanupRedundantUriPermissions$1$persistedUris$1 = false;
                        if (!it.isReadPermission() || !it.isWritePermission()) ** GOTO lbl-1000
                        v1 = it.getUri();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it.uri");
                        if (UriUtils.isExternalStorageDocument(v1)) {
                            v2 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = false;
                        }
                        if (!v2) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (UriPermission)item$iv$iv;
                        var21_19 = destination$iv$iv;
                        $i$a$-map-SimpleStorage$Companion$cleanupRedundantUriPermissions$1$persistedUris$2 = false;
                        var21_19.add(it.getUri());
                    }
                    persistedUris = (List)destination$iv$iv;
                    writeFlags = 3;
                    $this$mapTo$iv$iv = persistedUris;
                    var21_19 = this.$context;
                    $i$f$mapNotNull = false;
                    $i$f$mapTo = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    var12_21 = $this$forEach$iv$iv$iv.iterator();
                    while (var12_21.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = var12_21.next();
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                        it = (Uri)element$iv$iv;
                        $i$a$-mapNotNull-SimpleStorage$Companion$cleanupRedundantUriPermissions$1$uniqueUriParents$1 = false;
                        v3 = var18_27 = it.getPath();
                        if (v3 != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"path");
                            v4 = StringsKt.substringAfter$default((String)var18_27, (String)"/tree/", null, (int)2, null);
                        } else {
                            v4 = null;
                        }
                        if (v4 == null) continue;
                        it$iv$iv = v4;
                        $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    uniqueUriParents = DocumentFileCompat.findUniqueParents((Context)var21_19, (List)destination$iv$iv);
                    $this$mapNotNull$iv = persistedUris;
                    var6_9 = this.$context;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (Uri)element$iv;
                        $i$a$-forEach-SimpleStorage$Companion$cleanupRedundantUriPermissions$1$1 = false;
                        v5 = it.getPath();
                        if (v5 == null) {
                            v5 = "";
                        }
                        if (uniqueUriParents.contains(DocumentFileCompat.buildAbsolutePath(var6_9, StringsKt.substringAfter$default((String)v5, (String)"/tree/", null, (int)2, null)))) continue;
                        resolver.releasePersistableUriPermission((Uri)it, writeFlags);
                        Log.d((String)"SimpleStorage", (String)("Removed redundant URI permission => " + it));
                    }
                }
            }), (int)31, null);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean hasStorageAccess(@NotNull Context context, @NotNull String fullPath) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
            return com.anggrayudi.storage.SimpleStorage$Companion.hasStorageAccess$default(this, context, fullPath, false, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

