/*
 * Decompiled with CFR 0.152.
 */
package com.anggrayudi.storage;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.WorkerThread;
import androidx.documentfile.provider.DocumentFile;
import com.anggrayudi.storage.file.DocumentFileUtils;
import com.anggrayudi.storage.media.MediaFile;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0002\u001d\u001eJ\b\u0010\u0010\u001a\u00020\u0011H&J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u0014H'J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u001c\u001a\u00020\u0011H'R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0014\u0010\b\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005R\u0014\u0010\n\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005R\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001f\u00c0\u0006\u0001"}, d2={"Lcom/anggrayudi/storage/FileWrapper;", "", "baseName", "", "getBaseName", "()Ljava/lang/String;", "extension", "getExtension", "mimeType", "getMimeType", "name", "getName", "uri", "Landroid/net/Uri;", "getUri", "()Landroid/net/Uri;", "delete", "", "getAbsolutePath", "context", "Landroid/content/Context;", "getBasePath", "getRelativePath", "isEmpty", "openInputStream", "Ljava/io/InputStream;", "openOutputStream", "Ljava/io/OutputStream;", "append", "Document", "Media", "storage_release"})
public interface FileWrapper {
    @NotNull
    public Uri getUri();

    @Nullable
    public String getName();

    @NotNull
    public String getBaseName();

    @NotNull
    public String getExtension();

    @Nullable
    public String getMimeType();

    public boolean isEmpty(@NotNull Context var1);

    @NotNull
    public String getAbsolutePath(@NotNull Context var1);

    @NotNull
    public String getBasePath(@NotNull Context var1);

    @NotNull
    public String getRelativePath(@NotNull Context var1);

    @WorkerThread
    @Nullable
    public OutputStream openOutputStream(@NotNull Context var1, boolean var2);

    public static /* synthetic */ OutputStream openOutputStream$default(FileWrapper fileWrapper, Context context, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openOutputStream");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return fileWrapper.openOutputStream(context, bl);
    }

    @WorkerThread
    @Nullable
    public InputStream openInputStream(@NotNull Context var1);

    public boolean delete();

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0016\u0010\r\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/anggrayudi/storage/FileWrapper$Document;", "Lcom/anggrayudi/storage/FileWrapper;", "documentFile", "Landroidx/documentfile/provider/DocumentFile;", "(Landroidx/documentfile/provider/DocumentFile;)V", "baseName", "", "getBaseName", "()Ljava/lang/String;", "getDocumentFile", "()Landroidx/documentfile/provider/DocumentFile;", "extension", "getExtension", "mimeType", "getMimeType", "name", "getName", "uri", "Landroid/net/Uri;", "getUri", "()Landroid/net/Uri;", "delete", "", "getAbsolutePath", "context", "Landroid/content/Context;", "getBasePath", "getRelativePath", "isEmpty", "openInputStream", "Ljava/io/InputStream;", "openOutputStream", "Ljava/io/OutputStream;", "append", "storage_release"})
    public static final class Document
    implements FileWrapper {
        @NotNull
        private final DocumentFile documentFile;

        public Document(@NotNull DocumentFile documentFile) {
            Intrinsics.checkNotNullParameter((Object)documentFile, (String)"documentFile");
            this.documentFile = documentFile;
        }

        @NotNull
        public final DocumentFile getDocumentFile() {
            return this.documentFile;
        }

        @Override
        @NotNull
        public Uri getUri() {
            Uri uri = this.documentFile.getUri();
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"documentFile.uri");
            return uri;
        }

        @Override
        @Nullable
        public String getName() {
            return this.documentFile.getName();
        }

        @Override
        @NotNull
        public String getBaseName() {
            return DocumentFileUtils.getBaseName(this.documentFile);
        }

        @Override
        @NotNull
        public String getExtension() {
            return DocumentFileUtils.getExtension(this.documentFile);
        }

        @Override
        @Nullable
        public String getMimeType() {
            return DocumentFileUtils.getMimeTypeByFileName(this.documentFile);
        }

        @Override
        public boolean isEmpty(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return DocumentFileUtils.isEmpty(this.documentFile, context);
        }

        @Override
        @NotNull
        public String getAbsolutePath(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return DocumentFileUtils.getAbsolutePath(this.documentFile, context);
        }

        @Override
        @NotNull
        public String getBasePath(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return DocumentFileUtils.getBasePath(this.documentFile, context);
        }

        @Override
        @NotNull
        public String getRelativePath(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return DocumentFileUtils.getRelativePath(this.documentFile, context);
        }

        @Override
        @Nullable
        public OutputStream openOutputStream(@NotNull Context context, boolean append) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return DocumentFileUtils.openOutputStream(this.documentFile, context, append);
        }

        @Override
        @Nullable
        public InputStream openInputStream(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return DocumentFileUtils.openInputStream(this.documentFile, context);
        }

        @Override
        public boolean delete() {
            return this.documentFile.delete();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/anggrayudi/storage/FileWrapper$Media;", "Lcom/anggrayudi/storage/FileWrapper;", "mediaFile", "Lcom/anggrayudi/storage/media/MediaFile;", "(Lcom/anggrayudi/storage/media/MediaFile;)V", "baseName", "", "getBaseName", "()Ljava/lang/String;", "extension", "getExtension", "getMediaFile", "()Lcom/anggrayudi/storage/media/MediaFile;", "mimeType", "getMimeType", "name", "getName", "uri", "Landroid/net/Uri;", "getUri", "()Landroid/net/Uri;", "delete", "", "getAbsolutePath", "context", "Landroid/content/Context;", "getBasePath", "getRelativePath", "isEmpty", "openInputStream", "Ljava/io/InputStream;", "openOutputStream", "Ljava/io/OutputStream;", "append", "storage_release"})
    public static final class Media
    implements FileWrapper {
        @NotNull
        private final MediaFile mediaFile;

        public Media(@NotNull MediaFile mediaFile) {
            Intrinsics.checkNotNullParameter((Object)mediaFile, (String)"mediaFile");
            this.mediaFile = mediaFile;
        }

        @NotNull
        public final MediaFile getMediaFile() {
            return this.mediaFile;
        }

        @Override
        @NotNull
        public Uri getUri() {
            return this.mediaFile.getUri();
        }

        @Override
        @Nullable
        public String getName() {
            return this.mediaFile.getName();
        }

        @Override
        @NotNull
        public String getBaseName() {
            return this.mediaFile.getBaseName();
        }

        @Override
        @NotNull
        public String getExtension() {
            return this.mediaFile.getExtension();
        }

        @Override
        @NotNull
        public String getMimeType() {
            return this.mediaFile.getMimeType();
        }

        @Override
        public boolean isEmpty(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.mediaFile.isEmpty();
        }

        @Override
        @NotNull
        public String getAbsolutePath(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.mediaFile.getAbsolutePath();
        }

        @Override
        @NotNull
        public String getBasePath(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.mediaFile.getBasePath();
        }

        @Override
        @NotNull
        public String getRelativePath(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.mediaFile.getRelativePath();
        }

        @Override
        @Nullable
        public OutputStream openOutputStream(@NotNull Context context, boolean append) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.mediaFile.openOutputStream(append);
        }

        @Override
        @Nullable
        public InputStream openInputStream(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.mediaFile.openInputStream();
        }

        @Override
        public boolean delete() {
            return this.mediaFile.delete();
        }
    }
}

