/*
 * Decompiled with CFR 0.152.
 */
package com.anees4ever.iconbutton;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.v4.content.res.ResourcesCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.anees4ever.iconbutton.R;

public class IconButton
extends LinearLayout {
    protected ImageView mIconView;
    protected TextView mTextView;
    private int mIconResourceId = 0;
    private int mIconTint = 0;
    private int mIconTintChecked = 0;
    private String mText = "";
    private int mTextColor = 0;
    private int mTextColorChecked = 0;
    private float mTextSize = 0.0f;
    private int mTextFont = 0;
    private int mMaxLines = 1;
    private boolean mChecked = false;
    private boolean mEnabled = true;

    @TargetApi(value=21)
    public IconButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context, attrs, defStyleAttr, defStyleRes);
    }

    public IconButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs, defStyleAttr, 0);
    }

    public IconButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs, 0, 0);
    }

    public IconButton(Context context) {
        super(context);
    }

    private void initView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        try {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.IconButton, defStyleAttr, defStyleRes);
            this.mIconResourceId = a.getResourceId(R.styleable.IconButton_icon, 0);
            this.mIconTint = a.getColor(R.styleable.IconButton_iconTint, 0);
            this.mIconTintChecked = a.getColor(R.styleable.IconButton_iconTintChecked, 0);
            this.mText = a.getString(R.styleable.IconButton_text);
            this.mTextColor = a.getColor(R.styleable.IconButton_textColor, context.getResources().getColor(R.color.dark_grey));
            this.mTextColorChecked = a.getColor(R.styleable.IconButton_textColorChecked, context.getResources().getColor(R.color.dark_brown));
            this.mMaxLines = a.getInt(R.styleable.IconButton_maxLines, 1);
            this.mTextSize = a.getDimensionPixelSize(R.styleable.IconButton_textSize, 0);
            this.mTextFont = a.getResourceId(R.styleable.IconButton_textFont, 0);
            this.mChecked = a.getBoolean(R.styleable.IconButton_checked, false);
            this.mEnabled = a.getBoolean(R.styleable.IconButton_enabled, true);
            this.setOrientation(1);
            if (this.mEnabled) {
                this.setClickable(true);
                this.setFocusable(true);
            }
            this.initIcon();
            this.initLabel();
            this.updateState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initIcon() {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, 0);
        params.weight = 1.0f;
        this.mIconView = new ImageView(this.getContext());
        this.mIconView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mIconView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        if (this.mIconResourceId > 0) {
            this.mIconView.setImageResource(this.mIconResourceId);
        }
        if (this.mIconTint != 0) {
            this.mIconView.setColorFilter(this.mIconTint);
        }
        this.addView((View)this.mIconView);
    }

    private void initLabel() {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.gravity = 17;
        this.mTextView = new TextView(this.getContext());
        this.mTextView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mTextView.setMaxLines(this.mMaxLines);
        this.mTextView.setLines(this.mMaxLines);
        if (this.mTextSize == 0.0f) {
            this.mTextView.setTextSize(2, 12.0f);
        } else {
            this.mTextView.setTextSize(0, this.mTextSize);
        }
        this.mTextView.setGravity(17);
        this.mTextView.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.mText) ? "" : this.mText));
        this.mTextView.setTextColor(this.mTextColor);
        if (this.mTextFont != 0) {
            this.mTextView.setTypeface(ResourcesCompat.getFont((Context)this.getContext(), (int)this.mTextFont));
        }
        this.mTextView.setVisibility(TextUtils.isEmpty((CharSequence)this.mText) ? 8 : 0);
        this.addView((View)this.mTextView);
    }

    public void toggleCheck() {
        this.mChecked = !this.mChecked;
        this.updateState();
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(boolean checked) {
        this.mChecked = checked;
        this.updateState();
    }

    public void setText(String text) {
        this.mTextView.setText((CharSequence)text);
        this.mTextView.setVisibility(TextUtils.isEmpty((CharSequence)text) ? 8 : 0);
        this.invalidate();
    }

    public void setText(int text) {
        this.mTextView.setText(text);
        this.mTextView.setVisibility(text == 0 ? 8 : 0);
        this.invalidate();
    }

    public String getText() {
        return this.mTextView.getText().toString();
    }

    public void setIcon(int icon) {
        this.mIconView.setImageResource(icon);
        this.invalidate();
    }

    public void setIcon(Drawable icon) {
        this.mIconView.setImageDrawable(icon);
        this.invalidate();
    }

    public void setIconTint(int color2) {
        this.mIconTint = color2;
        this.updateState();
    }

    private void updateState() {
        if (this.mIconTint != 0 && this.mIconTintChecked != 0) {
            this.mIconView.setColorFilter(this.mChecked ? this.mIconTintChecked : this.mIconTint);
        }
        this.mTextView.setTextColor(this.mChecked ? this.mTextColorChecked : this.mTextColor);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }
}

