/*
 * Decompiled with CFR 0.152.
 */
package com.anees4ever.googlemap.network;

import com.anees4ever.googlemap.network.Api_Calls_Custom;
import com.anees4ever.googlemap.network.OnResponseDownload;
import com.anees4ever.googlemap.network.OnResponseJSON;
import com.anees4ever.googlemap.network.OnResponseString;
import com.anees4ever.googlemap.network.RetrofitApiClass;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.ResponseBody;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class RetrofitCalls {
    public static String LAST_ERROR = "";
    public static boolean ABORT_RUNNING_CALL = false;

    private static boolean checkIfAborted() {
        if (ABORT_RUNNING_CALL) {
            ABORT_RUNNING_CALL = false;
            return true;
        }
        return false;
    }

    public static boolean getString(String url, final OnResponseString mOnResponse) {
        try {
            return RetrofitCalls.get(url, new RetrofitResponseHandler(){

                @Override
                public void onSuccess(ResponseBody response) {
                    if (mOnResponse != null) {
                        try {
                            mOnResponse.onResponse(true, response.string());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            LAST_ERROR = "Invalid Response data";
                            mOnResponse.onResponse(false, null);
                        }
                    }
                }

                @Override
                public void onFailure(String errorMessage) {
                    if (mOnResponse != null) {
                        mOnResponse.onResponse(false, null);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean getJSON(String url, final OnResponseJSON mOnResponse) {
        try {
            return RetrofitCalls.get(url, new RetrofitResponseHandler(){

                @Override
                public void onSuccess(ResponseBody response) {
                    if (mOnResponse != null) {
                        try {
                            mOnResponse.onResponse(true, new JSONObject(response.string()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            LAST_ERROR = "Invalid JSON Response: " + response;
                            mOnResponse.onResponse(false, null);
                        }
                    }
                }

                @Override
                public void onFailure(String errorMessage) {
                    if (mOnResponse != null) {
                        mOnResponse.onResponse(false, null);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean downloadUrl(String url, final File fileToSave, final OnResponseDownload mOnResponse) {
        try {
            return RetrofitCalls.get(url, new RetrofitResponseHandler(){

                @Override
                public void onSuccess(ResponseBody response) {
                    block39: {
                        try {
                            try (BufferedInputStream input = new BufferedInputStream(response.byteStream());
                                 FileOutputStream output = new FileOutputStream(fileToSave);){
                                int count;
                                long readBytes = 0L;
                                long totalBytes = ((InputStream)input).available();
                                byte[] data = new byte[0x100000];
                                while ((count = ((InputStream)input).read(data)) != -1) {
                                    readBytes += (long)count;
                                    if (RetrofitCalls.checkIfAborted()) {
                                        if (fileToSave.exists()) {
                                            fileToSave.delete();
                                        }
                                        if (mOnResponse != null) {
                                            mOnResponse.onResponse(false, fileToSave);
                                        }
                                        return;
                                    }
                                    if (mOnResponse != null) {
                                        mOnResponse.onProgress(readBytes, totalBytes);
                                    }
                                    ((OutputStream)output).write(data, 0, count);
                                }
                            }
                            if (mOnResponse != null) {
                                mOnResponse.onResponse(true, fileToSave);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            LAST_ERROR = "Invalid Response data";
                            if (mOnResponse == null) break block39;
                            mOnResponse.onResponse(false, fileToSave);
                        }
                    }
                }

                @Override
                public void onFailure(String errorMessage) {
                    if (mOnResponse != null) {
                        mOnResponse.onResponse(false, fileToSave);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean get(String url, RetrofitResponseHandler mResponseHandler) {
        try {
            String[] urlInfo = RetrofitApiClass.extractHostAndUrl(url);
            Call<ResponseBody> call = ((Api_Calls_Custom)RetrofitApiClass.getWith(urlInfo[0]).create(Api_Calls_Custom.class)).get(urlInfo[1]);
            return RetrofitCalls.call(call, mResponseHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean call(Call<ResponseBody> call, final RetrofitResponseHandler mResponseHandler) {
        try {
            ABORT_RUNNING_CALL = false;
            call.enqueue((Callback)new Callback<ResponseBody>(){

                public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                    try {
                        if (mResponseHandler != null) {
                            if (response.body() != null) {
                                mResponseHandler.onSuccess((ResponseBody)response.body());
                            } else {
                                mResponseHandler.onFailure("Response: Invalid response...");
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onFailure(Call<ResponseBody> call, Throwable t) {
                    try {
                        LAST_ERROR = "Failure:" + t.getMessage();
                        if (mResponseHandler != null) {
                            mResponseHandler.onFailure(LAST_ERROR);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (mResponseHandler != null) {
                mResponseHandler.onFailure("Call Failed: " + e.getMessage());
            }
            return false;
        }
    }

    public static interface RetrofitResponseHandler {
        public void onSuccess(ResponseBody var1);

        public void onFailure(String var1);
    }
}

