/*
 * Decompiled with CFR 0.152.
 */
package com.anees4ever.googlemap;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationProvider;
import android.os.Build;
import android.util.Log;
import com.google.android.gms.maps.model.LatLng;

public class GPS {
    private static Activity mActivity;
    private static Context mContext;
    private LocationManager mLocationManager = null;
    private LocationProvider mLocationProvider = null;
    private LocationListener mLocationListener = null;
    private String provider = "gps";
    private long mMinimumTime = 0L;
    private long mMinimumDistance = 0L;

    public GPS(Activity activity) {
        mActivity = activity;
        mContext = activity;
        this.mLocationManager = (LocationManager)mContext.getSystemService("location");
        if (this.allowed(true)) {
            this.mLocationProvider = this.mLocationManager.getProvider(this.provider);
        }
    }

    public GPS(Context context) {
        mActivity = null;
        mContext = context;
        this.mLocationManager = (LocationManager)mContext.getSystemService("location");
        if (this.allowed(true)) {
            this.mLocationProvider = this.mLocationManager.getProvider(this.provider);
        }
    }

    public GPS setListener(LocationListener locationListener) {
        this.mLocationListener = locationListener;
        return this;
    }

    public LocationListener getListener() {
        return this.mLocationListener;
    }

    public GPS setMinimumTime(long minimumTime) {
        this.mMinimumTime = minimumTime;
        return this;
    }

    public long getMinimumTime() {
        return this.mMinimumTime;
    }

    public GPS setMinimumDistance(long minimumDistance) {
        this.mMinimumDistance = minimumDistance;
        return this;
    }

    public long getMinimumDistance() {
        return this.mMinimumDistance;
    }

    public boolean allowed(boolean takeAction) {
        try {
            if (mActivity != null && !GPS.allowed(mActivity, takeAction) || !GPS.allowed(mContext)) {
                return false;
            }
            if (!this.mLocationManager.isProviderEnabled(this.provider)) {
                if (takeAction) {
                    GPS.showSettingsAlert(mContext);
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            Log.e((String)"GPS.allowed", (String)e.toString());
            return false;
        }
    }

    public Location last() {
        Location location = null;
        try {
            if (this.allowed(false)) {
                location = this.mLocationManager.getLastKnownLocation(this.provider);
            }
            if (location == null) {
                location = new Location(this.provider);
            }
        }
        catch (Exception e) {
            Log.e((String)"GPS.last", (String)e.toString());
        }
        return location;
    }

    public void listen() {
        try {
            if (this.allowed(false)) {
                this.stop();
                Log.i((String)"GPS", (String)"listen started");
                this.mLocationManager.requestLocationUpdates(this.provider, this.mMinimumTime, (float)this.mMinimumDistance, this.mLocationListener);
            }
        }
        catch (Exception e) {
            Log.e((String)"GPS.listen", (String)e.toString());
        }
    }

    public void stop() {
        try {
            if (this.allowed(false)) {
                Log.i((String)"GPS", (String)"stop");
                if (this.mLocationManager != null) {
                    this.mLocationManager.removeUpdates(this.mLocationListener);
                    try {
                        this.mLocationManager.removeGpsStatusListener((GpsStatus.Listener)this.mLocationListener);
                    }
                    catch (Exception e) {
                        Log.e((String)"GPS.stop.listener", (String)e.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            Log.e((String)"GPS.stop", (String)e.toString());
        }
    }

    public static void showSettingsAlert(Context mContext) {
        try {
            AlertDialog.Builder alertDialog = new AlertDialog.Builder(mContext);
            alertDialog.setTitle((CharSequence)"SETTINGS");
            alertDialog.setMessage((CharSequence)"Enable Location Provider! Go to settings menu?");
            alertDialog.setPositiveButton((CharSequence)"Settings", (dialog, which) -> {
                Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                mContext.startActivity(intent);
            });
            alertDialog.setNegativeButton((CharSequence)"Cancel", (dialog, which) -> dialog.cancel());
            alertDialog.show();
        }
        catch (Exception e) {
            Log.e((String)"GPS.showSettingsAlert", (String)e.toString());
        }
    }

    public static boolean allowed(Activity activity, boolean takeAction) {
        try {
            if (Build.VERSION.SDK_INT >= 23 && activity.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0) {
                if (takeAction) {
                    activity.requestPermissions(new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"}, 100);
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            Log.e((String)"GPS.allowed", (String)e.toString());
            return false;
        }
    }

    public static boolean enabled(Context context) {
        try {
            LocationManager locationManager = (LocationManager)context.getSystemService("location");
            if (!locationManager.isProviderEnabled("gps")) {
                GPS.showSettingsAlert(context);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean allowed(Context context) {
        try {
            return Build.VERSION.SDK_INT < 23 || context.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0;
        }
        catch (Exception e) {
            Log.e((String)"GPS.allowed", (String)e.toString());
            return false;
        }
    }

    public static float distanceBetween(LatLng mFrom, LatLng mTo) {
        return GPS.distanceBetween(mFrom.latitude, mFrom.longitude, mTo.latitude, mTo.longitude);
    }

    public static float distanceBetween(double latA, double lonA, double latB, double lonB) {
        try {
            Location locationA = new Location("A");
            locationA.setLatitude(latA);
            locationA.setLongitude(lonA);
            Location locationB = new Location("B");
            locationB.setLatitude(latB);
            locationB.setLongitude(lonB);
            return Math.abs(locationA.distanceTo(locationB));
        }
        catch (Exception e) {
            return 0.0f;
        }
    }
}

