/*
 * Decompiled with CFR 0.152.
 */
package com.anees4ever.googlemap;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.os.Build;
import com.anees4ever.googlemap.Settings;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;

public class LocationTracker {
    public static final int REQUEST_CODE = 38214;
    private final Context mContext;
    private final Settings mSettings;
    private LocationManager mLocationManager;
    private FusedLocationProviderClient mFusedLocationClient;
    private LocationRequest mFusedLocationRquest;
    private LocationCallback mLocationCallback;
    private boolean mIsTracking = false;

    public LocationTracker(Context context, Settings settings) {
        this.mContext = context;
        this.mSettings = settings == null ? new Settings() : settings;
        this.mLocationManager = (LocationManager)this.mContext.getSystemService("location");
        this.mFusedLocationClient = LocationServices.getFusedLocationProviderClient((Context)this.mContext);
    }

    public boolean hasPermission() {
        return this.hasPermission(false, null);
    }

    public boolean hasPermission(boolean prompt, Activity activity) {
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                boolean permission2;
                boolean bl = permission2 = this.mContext.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0 && this.mContext.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0;
                if (!permission2) {
                    if (prompt) {
                        activity.requestPermissions(new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"}, 911);
                    }
                    return false;
                }
                return true;
            }
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean enabled(boolean openPrompt) {
        if (!(this.mLocationManager.isProviderEnabled("gps") || this.mLocationManager.isProviderEnabled("network") || this.mLocationManager.isProviderEnabled("passive"))) {
            if (openPrompt) {
                Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                if (this.mContext instanceof Activity) {
                    ((Activity)this.mContext).startActivityForResult(intent, 38214);
                } else {
                    this.mContext.startActivity(intent);
                }
            }
            return false;
        }
        return true;
    }

    public boolean isTracking() {
        return this.mIsTracking;
    }

    public void start(LocationCallback locationCallback) {
        try {
            if (this.mIsTracking) {
                this.stop();
            }
            this.mLocationCallback = locationCallback;
            this.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        try {
            if (this.hasPermission() && this.mLocationCallback != null) {
                this.mFusedLocationClient.removeLocationUpdates(this.mLocationCallback);
            }
            this.mIsTracking = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void start() {
        try {
            if (this.mIsTracking) {
                this.stop();
            }
            if (this.hasPermission() && this.enabled(false)) {
                if (this.mLocationCallback == null) {
                    return;
                }
                this.createRequestObject();
                this.mFusedLocationClient.requestLocationUpdates(this.mFusedLocationRquest, this.mLocationCallback, null);
                this.mIsTracking = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createRequestObject() {
        try {
            this.mFusedLocationRquest = new LocationRequest();
            this.mFusedLocationRquest.setInterval((long)this.mSettings.UPDATE_INTERVAL);
            this.mFusedLocationRquest.setFastestInterval((long)this.mSettings.FAST_INTERVAL);
            this.mFusedLocationRquest.setPriority(this.mSettings.PRIORITY);
            this.mFusedLocationRquest.setSmallestDisplacement(this.mSettings.UPDATE_DISTANCE);
            if (this.mSettings.UPDATE_COUNT > 0) {
                this.mFusedLocationRquest.setNumUpdates(this.mSettings.UPDATE_COUNT);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void quickRequest(Context mContext, LocationCallback mLocationCallback) {
        try {
            Settings mSettings = new Settings();
            mSettings.UPDATE_DISTANCE = 0.0f;
            mSettings.UPDATE_INTERVAL = 30000;
            mSettings.FAST_INTERVAL = 30000;
            mSettings.UPDATE_COUNT = 1;
            mSettings.PRIORITY = 100;
            LocationTracker mLocationTracker = new LocationTracker(mContext, mSettings);
            if (Build.VERSION.SDK_INT >= 23 && !mLocationTracker.hasPermission()) {
                if (mLocationCallback != null) {
                    mLocationCallback.onLocationResult(null);
                }
                return;
            }
            if (!mLocationTracker.enabled(false)) {
                if (mLocationCallback != null) {
                    mLocationCallback.onLocationResult(null);
                }
                return;
            }
            mLocationTracker.start(mLocationCallback);
        }
        catch (Exception e) {
            if (mLocationCallback != null) {
                mLocationCallback.onLocationResult(null);
            }
            e.printStackTrace();
        }
    }
}

