/*
 * Decompiled with CFR 0.152.
 */
package com.anees4ever.googlemap;

import android.content.Context;
import android.location.Address;
import android.location.Geocoder;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.text.style.CharacterStyle;
import android.text.style.StyleSpan;
import android.util.Log;
import com.anees4ever.googlemap.network.RetrofitCalls;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.libraries.places.api.Places;
import com.google.android.libraries.places.api.model.AutocompletePrediction;
import com.google.android.libraries.places.api.model.AutocompleteSessionToken;
import com.google.android.libraries.places.api.model.Place;
import com.google.android.libraries.places.api.net.FetchPlaceRequest;
import com.google.android.libraries.places.api.net.FindAutocompletePredictionsRequest;
import com.google.android.libraries.places.api.net.PlacesClient;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import org.json.JSONObject;

public class LocationAddress {
    private static final String TAG = "LocationAddress";
    public static final int ERROR_NETWROK_OFFLINE = 1;
    public static final int ERROR_NETWROK_ERROR = 2;
    public static final int ERROR_EMPTY_ADDRESS = 3;
    public static final String MAP_GEOCODER_ELEVATION_URL = "https://maps.googleapis.com/maps/api/elevation/json?locations=%s,%s&key=%s";
    public static final CharacterStyle STYLE_BOLD = new StyleSpan(1);

    public static void getAddressFromLocation(Context context, double latitude, double longitude, OnAddressListener listener) {
        AsyncTaskLocationAddress locationAddress = new AsyncTaskLocationAddress(context, listener);
        locationAddress.executeOnExecutor(Executors.newSingleThreadExecutor(), new Double[]{latitude, longitude});
    }

    public static boolean findAltitude(String apiKey, double lat, double lng, OnAltitudeListener mListener) {
        try {
            String sUrl = String.format(MAP_GEOCODER_ELEVATION_URL, "" + lat, "" + lng, apiKey);
            RetrofitCalls.getJSON(sUrl, (status, object) -> {
                try {
                    if (mListener != null) {
                        if (status && object != null) {
                            JSONObject elevResult = object.getJSONArray("results").getJSONObject(0);
                            mListener.onResult(elevResult.getDouble("elevation"));
                        } else {
                            mListener.onResult(0.0);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    mListener.onResult(0.0);
                }
            });
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static class PlaceAutocomplete {
        public String placeId;
        public CharSequence primaryText;
        public CharSequence secondaryText;
        public CharSequence fullText;

        PlaceAutocomplete(String placeId, CharSequence primaryText, CharSequence secondaryText, CharSequence fullText) {
            this.placeId = placeId;
            this.primaryText = primaryText;
            this.secondaryText = secondaryText;
            this.fullText = fullText;
        }
    }

    public static class AddressSearch
    extends AsyncTask<Double, Void, Void> {
        final WeakReference<Context> mContext;
        final String API_KEY;
        final OnAddressSearch mListener;
        String mSearchStr = "";
        List<PlaceAutocomplete> mAddressList = null;
        boolean aborted = false;

        public AddressSearch(Context context, String apiKey, OnAddressSearch listener) {
            this.mContext = new WeakReference<Context>(context);
            this.API_KEY = apiKey;
            this.mListener = listener;
        }

        public void startSearch(String search) {
            this.mSearchStr = search;
            this.doInBackground(new Double[0]);
        }

        public void abort() {
            this.aborted = true;
        }

        protected Void doInBackground(Double ... params) {
            try {
                this.mAddressList = null;
                try {
                    Places.initialize((Context)((Context)this.mContext.get()).getApplicationContext(), (String)this.API_KEY);
                    PlacesClient placesClient = Places.createClient((Context)((Context)this.mContext.get()));
                    AutocompleteSessionToken token = AutocompleteSessionToken.newInstance();
                    FindAutocompletePredictionsRequest request = FindAutocompletePredictionsRequest.builder().setSessionToken(token).setQuery(this.mSearchStr).build();
                    placesClient.findAutocompletePredictions(request).addOnSuccessListener(response -> {
                        try {
                            this.mAddressList = new ArrayList<PlaceAutocomplete>();
                            for (AutocompletePrediction prediction : response.getAutocompletePredictions()) {
                                this.mAddressList.add(new PlaceAutocomplete(prediction.getPlaceId(), (CharSequence)prediction.getPrimaryText(STYLE_BOLD), (CharSequence)prediction.getSecondaryText(null), (CharSequence)prediction.getFullText(null)));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.onPostExecute(null);
                    }).addOnFailureListener(exception -> {
                        if (exception instanceof ApiException) {
                            ApiException apiException = (ApiException)exception;
                            Log.e((String)LocationAddress.TAG, (String)("Place not found: " + apiException.getStatusCode()));
                        }
                        this.onPostExecute(null);
                    });
                }
                catch (Exception exception2) {}
            }
            catch (Exception exception3) {
                // empty catch block
            }
            return null;
        }

        protected void onPostExecute(Void result) {
            if (!this.aborted && this.mListener != null) {
                this.mListener.onResult(this.mAddressList);
            }
            super.onPostExecute((Object)result);
        }
    }

    public static interface OnAddressSearch {
        public void onResult(List<PlaceAutocomplete> var1);
    }

    public static class PlaceLatLngFinder
    extends AsyncTask<String, Void, LatLng> {
        final WeakReference<Context> mContext;
        final String API_KEY;
        final OnPlaceLatLngListener mListener;

        public PlaceLatLngFinder(Context context, String apiKey, OnPlaceLatLngListener listener) {
            this.mContext = new WeakReference<Context>(context);
            this.API_KEY = apiKey;
            this.mListener = listener;
        }

        public void find(String placeID) {
            this.doInBackground(placeID);
        }

        protected LatLng doInBackground(String ... params) {
            try {
                Places.initialize((Context)((Context)this.mContext.get()).getApplicationContext(), (String)this.API_KEY);
                PlacesClient placesClient = Places.createClient((Context)((Context)this.mContext.get()));
                List<Place.Field> placeFields = Arrays.asList(Place.Field.LAT_LNG, Place.Field.NAME);
                FetchPlaceRequest request = FetchPlaceRequest.builder((String)params[0], placeFields).build();
                placesClient.fetchPlace(request).addOnSuccessListener(response -> {
                    Place place = response.getPlace();
                    if (this.mListener != null) {
                        this.mListener.onResult(place.getLatLng());
                    }
                }).addOnFailureListener(exception -> {
                    if (exception instanceof ApiException) {
                        ApiException apiException = (ApiException)exception;
                        int statusCode = apiException.getStatusCode();
                        if (this.mListener != null) {
                            this.mListener.onResult(null);
                        }
                    }
                });
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }

        protected void onPostExecute(LatLng result) {
            if (this.mListener != null) {
                this.mListener.onResult(result);
            }
            super.onPostExecute((Object)result);
        }
    }

    public static interface OnPlaceLatLngListener {
        public void onResult(LatLng var1);
    }

    public static interface OnAltitudeListener {
        public void onResult(double var1);
    }

    public static class AsyncTaskLocationAddress
    extends AsyncTask<Double, Void, Void> {
        private final WeakReference<Context> mContext;
        private final OnAddressListener mListener;
        List<Address> addressList = null;
        int error = 0;
        String errorStr = "";
        private static final String address_type_premise = "premise";
        private static final String address_type_street_number = "street_number";
        private static final String address_type_route = "route";
        private static final String address_type_sublocality_level_3 = "sublocality_level_3";
        private static final String address_type_sublocality_level_2 = "sublocality_level_2";
        private static final String address_type_sublocality_level_1 = "sublocality_level_1";
        private static final String address_type_locality = "locality";
        private static final String address_type_administrative_area_level_2 = "administrative_area_level_2";
        private static final String address_type_administrative_area_level_1 = "administrative_area_level_1";
        private static final String address_type_country = "country";
        private static final String address_type_postal_code = "postal_code";

        public AsyncTaskLocationAddress(Context context, OnAddressListener listener) {
            this.mContext = new WeakReference<Context>(context);
            this.mListener = listener;
        }

        public boolean isOnline() {
            try {
                if (Build.VERSION.SDK_INT >= 23 && ((Context)this.mContext.get()).checkSelfPermission("android.permission.ACCESS_NETWORK_STATE") != 0) {
                    return false;
                }
                ConnectivityManager connMgr = (ConnectivityManager)((Context)this.mContext.get()).getSystemService("connectivity");
                NetworkInfo networkInfo = connMgr.getActiveNetworkInfo();
                return networkInfo != null && networkInfo.isConnected();
            }
            catch (Exception e) {
                return true;
            }
        }

        protected Void doInBackground(Double ... params) {
            try {
                if (!this.isOnline()) {
                    this.error = 1;
                    this.errorStr = "No internet connection.";
                    return null;
                }
                File file = new File(((Context)this.mContext.get()).getCacheDir(), "location.json");
                if (file.exists() && file.isFile()) {
                    file.delete();
                }
                return this.getAddressWithGeoCoder(params);
            }
            catch (Exception e) {
                return null;
            }
        }

        private Void getAddressWithGeoCoder(Double ... params) {
            Geocoder geocoder = new Geocoder((Context)this.mContext.get(), Locale.getDefault());
            try {
                this.addressList = geocoder.getFromLocation(params[0].doubleValue(), params[1].doubleValue(), 1);
                this.error = 0;
                this.errorStr = "";
            }
            catch (Exception e) {
                this.error = 2;
                this.errorStr = e.toString();
            }
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            if (this.error == 0) {
                if (this.addressList != null && this.addressList.size() > 0) {
                    if (this.mListener != null) {
                        this.mListener.onAddressFound(this.addressList);
                    }
                } else if (this.mListener != null) {
                    this.mListener.onAddressNotFound(3, "Address not found.");
                }
            } else if (this.mListener != null) {
                this.mListener.onAddressNotFound(this.error, this.errorStr);
            }
            super.onPostExecute((Object)aVoid);
        }
    }

    public static interface OnAddressListener {
        public void onAddressFound(List<Address> var1);

        public void onAddressNotFound(int var1, String var2);
    }
}

