/*
 * Decompiled with CFR 0.152.
 */
package com.anees4ever.googlemap;

import android.util.Log;
import com.anees4ever.googlemap.network.RetrofitCalls;

public class GoogleTimezone {
    private static final String TIMEZONE_URL = "https://maps.googleapis.com/maps/api/timezone/json?location=%s,%s&timestamp=%s&key=%s";

    public static boolean get(String apiKey, double lat, double lng, Response asyncResponse) {
        try {
            String sUrl = String.format(TIMEZONE_URL, "" + lat, "" + lng, "" + System.currentTimeMillis() / 1000L, apiKey);
            RetrofitCalls.getJSON(sUrl, (status, object) -> {
                try {
                    if (asyncResponse != null) {
                        if (status && object != null) {
                            asyncResponse.processFinish(object.getInt("dstOffset"), object.getInt("rawOffset"), object.getString("status"), object.getString("timeZoneId"), object.getString("timeZoneName"));
                        } else {
                            asyncResponse.processFinish(0, 0, "ERROR", "", "");
                        }
                    }
                }
                catch (Exception e) {
                    Log.e((String)"Error", (String)"Cannot process JSON results", (Throwable)e);
                }
            });
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static interface Response {
        public void processFinish(int var1, int var2, String var3, String var4, String var5);
    }
}

