/*
 * Decompiled with CFR 0.152.
 */
package com.anees4ever.googlemap;

import android.app.Activity;
import android.content.Intent;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import java.util.Iterator;

public class FusedLocation {
    public Activity mActivity;
    public LocationManager mLocationManager;
    public FusedLocationProviderClient mFusedLocationClient;
    public LocationRequest mFusedLocationRquest;
    public LocationListener mLocationListener;
    public LocationCallback mLocationCallback;

    public FusedLocation(Activity activity) {
        this.mActivity = activity;
        this.mLocationManager = (LocationManager)this.mActivity.getSystemService("location");
        this.mFusedLocationClient = LocationServices.getFusedLocationProviderClient((Activity)this.mActivity);
        this.mFusedLocationRquest = new LocationRequest();
        this.mFusedLocationRquest.setInterval(100L);
        this.mFusedLocationRquest.setFastestInterval(100L);
        this.mFusedLocationRquest.setPriority(100);
        this.mLocationCallback = new LocationCallback(){

            public void onLocationResult(LocationResult locationResult) {
                block1: {
                    Iterator iterator = locationResult.getLocations().iterator();
                    if (!iterator.hasNext()) break block1;
                    Location location = (Location)iterator.next();
                    if (FusedLocation.this.mLocationListener != null) {
                        FusedLocation.this.mLocationListener.onLocationChanged(location);
                    }
                    FusedLocation.this.stop();
                }
            }
        };
    }

    public boolean enabled(boolean takeAction) {
        try {
            boolean enabled;
            boolean bl = enabled = this.mLocationManager.isProviderEnabled("gps") || this.mLocationManager.isProviderEnabled("network");
            if (!enabled && takeAction) {
                Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                this.mActivity.startActivity(intent);
            }
            return enabled;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void start() {
        try {
            this.mFusedLocationClient.requestLocationUpdates(this.mFusedLocationRquest, this.mLocationCallback, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        try {
            this.mFusedLocationClient.removeLocationUpdates(this.mLocationCallback);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mLocationManager.removeUpdates(this.mLocationListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

