/*
 * Decompiled with CFR 0.152.
 */
package com.anees4ever.googlemap;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.location.Address;
import android.location.Location;
import android.location.LocationListener;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.design.widget.FloatingActionButton;
import android.text.Editable;
import android.text.Html;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.anees4ever.dmsedit.DMS;
import com.anees4ever.googlemap.ActivityEx;
import com.anees4ever.googlemap.FusedLocation;
import com.anees4ever.googlemap.LocationAddress;
import com.anees4ever.googlemap.R;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.MapFragment;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class Activity_GoogleMap
extends ActivityEx
implements LocationListener,
OnMapReadyCallback {
    String GMAP_API_KEY_APP = "";
    FusedLocation fusedLocation;
    boolean locationReceived = false;
    GoogleMap googleMap;
    Location mLocation;
    Address mAddress;
    List<LocationAddress.PlaceAutocomplete> mAddressList;
    LocationAddress.AddressSearch mAddressSearch;
    private boolean setTextFromSearch = false;
    RelativeLayout rlSearchBar;
    ScrollView svSearchResult;
    EditText edSearch;
    ProgressBar pbProgress;
    ImageButton btnClearSearch;
    ImageButton btnMapMode;
    LinearLayout llSearchResults;
    FloatingActionButton fabClose;
    FloatingActionButton fabSelect;
    FloatingActionButton fabRetry;
    TextView tvLatLon;
    TextView tvAddress;
    Timer searchTimer;
    boolean bAllowChanges = true;
    private final Runnable handlerSearchPlaces = this::startSearch;
    private final Runnable handlerFindAddress = this::findAddress;
    private final LocationAddress.OnAddressSearch mAddressSearchListener = new LocationAddress.OnAddressSearch(){

        @Override
        public void onResult(List<LocationAddress.PlaceAutocomplete> addressList) {
            try {
                Activity_GoogleMap.this.pbProgress.setVisibility(8);
                Activity_GoogleMap.this.drawSearchResultEx(addressList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_googlemap);
        this.getAPIKeys();
        this.rlSearchBar = (RelativeLayout)this.findViewById(R.id.rlSearchBar);
        this.svSearchResult = (ScrollView)this.findViewById(R.id.svSearchResult);
        this.edSearch = (EditText)this.findViewById(R.id.edSearch);
        this.pbProgress = (ProgressBar)this.findViewById(R.id.pbProgress);
        this.btnClearSearch = (ImageButton)this.findViewById(R.id.btnClearSearch);
        this.btnMapMode = (ImageButton)this.findViewById(R.id.btnMapMode);
        this.llSearchResults = (LinearLayout)this.findViewById(R.id.llSearchResults);
        this.svSearchResult.setVisibility(8);
        this.pbProgress.setVisibility(8);
        this.btnClearSearch.setVisibility(8);
        this.fabClose = (FloatingActionButton)this.findViewById(R.id.fabClose);
        this.fabSelect = (FloatingActionButton)this.findViewById(R.id.fabSelect);
        this.fabRetry = (FloatingActionButton)this.findViewById(R.id.fabRetry);
        this.tvLatLon = (TextView)this.findViewById(R.id.tvLatLon);
        this.tvAddress = (TextView)this.findViewById(R.id.tvAddress);
        this.fabSelect.setVisibility(8);
        this.fabRetry.setVisibility(8);
        this.fusedLocation = new FusedLocation(this);
        this.fusedLocation.mLocationListener = this;
        this.edSearch.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                try {
                    Activity_GoogleMap.this.btnClearSearch.setVisibility(0);
                    if (Activity_GoogleMap.this.searchTimer != null) {
                        Activity_GoogleMap.this.searchTimer.cancel();
                        Activity_GoogleMap.this.searchTimer = null;
                    }
                    if (Activity_GoogleMap.this.edSearch.getText().length() < 3) {
                        return;
                    }
                    if (Activity_GoogleMap.this.bAllowChanges) {
                        Activity_GoogleMap.this.searchTimer = new Timer();
                        Activity_GoogleMap.this.searchTimer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                Activity_GoogleMap.this.runOnUiThread(() -> Activity_GoogleMap.this.startSearch());
                            }
                        }, 1000L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.edSearch.setOnEditorActionListener((textView, id2, keyEvent) -> {
            this.hideFocus((View)this.edSearch);
            this.startSearch();
            return true;
        });
        MapFragment mapFragment = (MapFragment)this.getFragmentManager().findFragmentById(R.id.map);
        mapFragment.getMapAsync((OnMapReadyCallback)this);
        if (this.getIntent().hasExtra("latitude")) {
            this.locationReceived = true;
            this.mLocation = new Location("gps");
            this.mLocation.setLatitude(this.getIntent().getDoubleExtra("latitude", 0.0));
            this.mLocation.setLongitude(this.getIntent().getDoubleExtra("longitude", 0.0));
        } else if (this.getIntent().hasExtra("searchfor")) {
            this.bAllowChanges = false;
            this.edSearch.setText((CharSequence)this.getIntent().getStringExtra("searchfor"));
            this.bAllowChanges = true;
            this.rlSearchBar.postDelayed(this.handlerSearchPlaces, 500L);
        }
    }

    private void getAPIKeys() {
        try {
            ApplicationInfo appInfo = this.getPackageManager().getApplicationInfo(this.getPackageName(), 128);
            this.GMAP_API_KEY_APP = appInfo.metaData.getString("com.google.android.geo.API_KEY");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.GMAP_API_KEY_APP = "";
        }
    }

    protected void onResume() {
        super.onResume();
        if (!this.locationReceived && this.fusedLocation.enabled(true)) {
            this.locationReceived = false;
            this.fusedLocation.start();
        }
    }

    protected void onPause() {
        super.onPause();
        this.fusedLocation.stop();
    }

    public void onBackPressed() {
        if (this.svSearchResult.getVisibility() == 0) {
            this.onClickClearSearch((View)this.btnClearSearch);
            return;
        }
        this.setResult(0, this.getIntent());
        super.onBackPressed();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    public void onMapReady(GoogleMap map) {
        try {
            this.btnMapMode.setImageResource(this.getMapMode() == 1 ? R.drawable.map_sattelite : R.drawable.map_normal);
            this.googleMap = map;
            this.googleMap.setMapType(this.getMapMode());
            this.googleMap.setMyLocationEnabled(true);
            this.googleMap.getUiSettings().setMyLocationButtonEnabled(true);
            this.googleMap.getUiSettings().setAllGesturesEnabled(true);
            this.googleMap.getUiSettings().setCompassEnabled(true);
            this.googleMap.getUiSettings().setZoomGesturesEnabled(true);
            this.googleMap.getUiSettings().setMapToolbarEnabled(true);
            this.googleMap.setOnCameraChangeListener(position -> {
                try {
                    this.edSearch.removeCallbacks(this.handlerFindAddress);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.edSearch.postDelayed(this.handlerFindAddress, 1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            this.googleMap.setOnPoiClickListener(poi -> {
                this.locationReceived = true;
                this.bAllowChanges = false;
                this.edSearch.setText((CharSequence)poi.name);
                this.btnClearSearch.setVisibility(0);
                this.bAllowChanges = false;
                this.setTextFromSearch = true;
                this.setLocation(new LatLng(poi.latLng.latitude, poi.latLng.longitude));
            });
            if (this.mLocation != null) {
                this.onLocationChanged(this.mLocation);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setLocation(LatLng myLocation) {
        try {
            CameraPosition cameraPosition = new CameraPosition.Builder().target(myLocation).zoom(17.0f).build();
            this.googleMap.animateCamera(CameraUpdateFactory.newCameraPosition((CameraPosition)cameraPosition));
            String localtionStr = DMS.parseDDtoDMS((double)this.mLocation.getLatitude(), (double)this.mLocation.getLongitude());
            this.tvLatLon.setText((CharSequence)localtionStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void findAddress() {
        try {
            if (this.googleMap.getCameraPosition().target.latitude == 0.0) {
                return;
            }
            try {
                this.edSearch.removeCallbacks(this.handlerFindAddress);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tvAddress.setText(R.string.loading_address);
            this.fabSelect.setVisibility(8);
            this.fabRetry.setVisibility(8);
            String localtionStr = DMS.parseDDtoDMS((double)this.googleMap.getCameraPosition().target.latitude, (double)this.googleMap.getCameraPosition().target.longitude);
            this.tvLatLon.setText((CharSequence)localtionStr);
            LocationAddress.getAddressFromLocation((Context)this, this.googleMap.getCameraPosition().target.latitude, this.googleMap.getCameraPosition().target.longitude, new LocationAddress.OnAddressListener(){

                @Override
                public void onAddressFound(List<Address> addressList) {
                    try {
                        String locality;
                        Activity_GoogleMap.this.fabSelect.setVisibility(0);
                        Activity_GoogleMap.this.fabRetry.setVisibility(8);
                        Activity_GoogleMap.this.mAddress = addressList.get(0);
                        if (Activity_GoogleMap.this.setTextFromSearch) {
                            Activity_GoogleMap.this.mAddress.setSubLocality(Activity_GoogleMap.this.edSearch.getText().toString().trim());
                        }
                        locality = (locality = Activity_GoogleMap.this.mAddress.getSubLocality()) == null || locality.isEmpty() ? "" : "<strong>" + locality + "</strong><br />";
                        Activity_GoogleMap.this.tvAddress.setText((CharSequence)Html.fromHtml((String)(locality + Activity_GoogleMap.this.mAddress.getAddressLine(0))));
                        Activity_GoogleMap.this.setTextFromSearch = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onAddressNotFound(int error, String errorStr) {
                    try {
                        Activity_GoogleMap.this.fabSelect.setVisibility(0);
                        Activity_GoogleMap.this.fabRetry.setVisibility(0);
                        Activity_GoogleMap.this.tvAddress.setText(R.string.address_not_found);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startSearch() {
        try {
            String searchStr;
            LatLng latLng;
            if (this.searchTimer != null) {
                this.searchTimer.cancel();
                this.searchTimer = null;
            }
            if (this.edSearch.getText().toString().trim().isEmpty()) {
                return;
            }
            if (this.mAddressSearch != null) {
                this.mAddressSearch.abort();
            }
            if ((latLng = DMS.parseDMStoDD((String)(searchStr = this.edSearch.getText().toString()))) != null) {
                int selStart = this.edSearch.getSelectionStart();
                this.onClickClearSearch((View)this.btnClearSearch);
                this.bAllowChanges = false;
                this.edSearch.setText((CharSequence)searchStr);
                this.edSearch.setSelection(selStart);
                this.btnClearSearch.setVisibility(0);
                this.bAllowChanges = true;
                this.setLocation(latLng);
            } else {
                this.llSearchResults.removeAllViews();
                this.pbProgress.setVisibility(0);
                this.mAddressSearch = new LocationAddress.AddressSearch((Context)this, this.GMAP_API_KEY_APP, this.mAddressSearchListener);
                this.mAddressSearch.startSearch(this.edSearch.getText().toString().trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawSearchResultEx(List<LocationAddress.PlaceAutocomplete> addressList) {
        try {
            this.mAddressList = new ArrayList<LocationAddress.PlaceAutocomplete>();
            this.svSearchResult.setVisibility(0);
            this.llSearchResults.removeAllViews();
            if (addressList != null && addressList.size() > 0) {
                this.mAddressList.addAll(addressList);
                for (int i = 0; i < this.mAddressList.size(); ++i) {
                    this.drawAddress(this.mAddressList.get(i), i);
                }
            } else {
                this.drawAddress(null, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawAddress(LocationAddress.PlaceAutocomplete placeAutocomplete, int position) {
        try {
            View view = this.getLayoutInflater().inflate(R.layout.activity_googlemap_search_item, null);
            TextView tvTitle = (TextView)view.findViewById(R.id.tvTitle);
            TextView tvDesc = (TextView)view.findViewById(R.id.tvDesc);
            this.llSearchResults.addView(view);
            if (placeAutocomplete == null) {
                tvTitle.setText(R.string.no_result_found);
                tvDesc.setVisibility(8);
            } else {
                tvTitle.setText(placeAutocomplete.primaryText);
                tvDesc.setText(placeAutocomplete.secondaryText);
                View spacer = new View((Context)this);
                spacer.setMinimumHeight(5);
                this.llSearchResults.addView(spacer);
                view.setOnClickListener((View.OnClickListener)new OnItemClick(position));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onLocationChanged(Location location) {
        try {
            if (location == null) {
                return;
            }
            this.locationReceived = true;
            this.fusedLocation.stop();
            this.mLocation = new Location(location);
            this.setLocation(new LatLng(this.mLocation.getLatitude(), this.mLocation.getLongitude()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onProviderDisabled(String arg0) {
    }

    public void onProviderEnabled(String arg0) {
    }

    public void onStatusChanged(String arg0, int arg1, Bundle arg2) {
    }

    public void onClickMapMode(View view) {
        try {
            if (this.getMapMode() == 1) {
                this.setMapMode(2);
            } else {
                this.setMapMode(1);
            }
            this.googleMap.setMapType(this.getMapMode());
            this.btnMapMode.setImageResource(this.getMapMode() == 1 ? R.drawable.map_sattelite : R.drawable.map_normal);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onClickClearSearch(View view) {
        try {
            if (this.mAddressSearch != null) {
                this.mAddressSearch.abort();
            }
            this.bAllowChanges = false;
            this.edSearch.setText((CharSequence)"");
            this.bAllowChanges = true;
            this.pbProgress.setVisibility(8);
            this.svSearchResult.setVisibility(8);
            this.btnClearSearch.setVisibility(8);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onClickClose(View view) {
        this.setResult(0, this.getIntent());
        this.finish();
    }

    public void onClickRetry(View view) {
        this.findAddress();
    }

    public void onClickSelect(View view) {
        try {
            Intent intent = new Intent();
            intent.putExtra("latitude", this.googleMap.getCameraPosition().target.latitude);
            intent.putExtra("longitude", this.googleMap.getCameraPosition().target.longitude);
            if (this.mAddress != null) {
                if (this.mAddress.getSubLocality() == null) {
                    intent.putExtra("locality", "");
                } else {
                    intent.putExtra("locality", this.mAddress.getSubLocality());
                }
                intent.putExtra("address", this.mAddress.getAddressLine(0));
            }
            this.setResult(-1, intent);
            this.finish();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getMapMode() {
        try {
            SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)this);
            return preferences.getInt("gmap_MAP_MODE", 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public void setMapMode(int mode) {
        try {
            SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)this);
            SharedPreferences.Editor editor = preferences.edit();
            editor.putInt("gmap_MAP_MODE", mode);
            editor.apply();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class OnItemClick
    implements View.OnClickListener {
        final int mPosition;

        OnItemClick(int position) {
            this.mPosition = position;
        }

        public void onClick(View v) {
            try {
                Activity_GoogleMap.this.tvLatLon.setText(R.string.loading_lat_lng);
                Activity_GoogleMap.this.tvAddress.setText(R.string.loading_address);
                Activity_GoogleMap.this.fabSelect.setVisibility(8);
                Activity_GoogleMap.this.fabRetry.setVisibility(8);
                Activity_GoogleMap.this.bAllowChanges = false;
                Activity_GoogleMap.this.edSearch.setText(Activity_GoogleMap.this.mAddressList.get((int)this.mPosition).primaryText);
                Activity_GoogleMap.this.bAllowChanges = true;
                Activity_GoogleMap.this.svSearchResult.setVisibility(8);
                Activity_GoogleMap.this.pbProgress.setVisibility(0);
                LocationAddress.PlaceLatLngFinder placeLatLngFinder = new LocationAddress.PlaceLatLngFinder((Context)Activity_GoogleMap.this, Activity_GoogleMap.this.GMAP_API_KEY_APP, latlng -> {
                    try {
                        Activity_GoogleMap.this.pbProgress.setVisibility(8);
                        if (latlng != null) {
                            Activity_GoogleMap.this.setTextFromSearch = true;
                            Activity_GoogleMap.this.setLocation(latlng);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                placeLatLngFinder.find(Activity_GoogleMap.this.mAddressList.get((int)this.mPosition).placeId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

