/*
 * Decompiled with CFR 0.152.
 */
package com.mixiaoxiao.fastscroll.helper;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.view.MotionEventCompat;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.mixiaoxiao.fastscroll.FastScrollRecyclerView;
import com.mixiaoxiao.fastscroll.R;
import com.mixiaoxiao.fastscroll.helper.ItemTouchHelperAdapter;
import com.mixiaoxiao.fastscroll.helper.ItemTouchHelperViewHolder;
import com.mixiaoxiao.fastscroll.helper.OnStartDragListener;
import com.mixiaoxiao.fastscroll.helper.SimpleItemTouchHelperCallback;
import java.util.ArrayList;
import java.util.Collections;

public class RecyclerListAdapter<T>
extends RecyclerView.Adapter<ItemViewHolder>
implements ItemTouchHelperAdapter {
    protected Context mContext;
    private int mViewID;
    public FastScrollRecyclerView mView;
    public int mLayout = 0;
    public GridLayoutManagerEx mGridLayoutManager;
    public LinearLayoutManagerEx mLinearLayoutManager;
    private OnStartDragListener mDragStartListener;
    private Binder mBinder;
    private ViewHolderListener mViewHolderListener;
    private ItemTouchHelper ithContacts;
    public ArrayList<T> mItems;
    public int handlerID = 0;
    public DividerItemDecoration mDividerItemDecoration;

    public RecyclerListAdapter() {
    }

    public RecyclerListAdapter(Context context, FastScrollRecyclerView view, int viewID, ArrayList<T> alItems, SimpleItemTouchHelperCallback.Validator validator, Binder binder) {
        this.init(context, view, viewID, alItems, 0, 1, validator, binder, null);
    }

    public RecyclerListAdapter(Context context, FastScrollRecyclerView view, int viewID, ArrayList<T> alItems, SimpleItemTouchHelperCallback.Validator validator, Binder binder, ViewHolderListener viewHolderListener) {
        this.init(context, view, viewID, alItems, 0, 1, validator, binder, viewHolderListener);
    }

    public RecyclerListAdapter(Context context, FastScrollRecyclerView view, int viewID, ArrayList<T> alItems, int noOfColumns, SimpleItemTouchHelperCallback.Validator validator, Binder binder) {
        this.init(context, view, viewID, alItems, 0, noOfColumns, validator, binder, null);
    }

    public RecyclerListAdapter(Context context, FastScrollRecyclerView view, int viewID, ArrayList<T> alItems, int noOfColumns, SimpleItemTouchHelperCallback.Validator validator, Binder binder, ViewHolderListener viewHolderListener) {
        this.init(context, view, viewID, alItems, 0, noOfColumns, validator, binder, viewHolderListener);
    }

    public RecyclerListAdapter(Context context, FastScrollRecyclerView view, int viewID, ArrayList<T> alItems, int manager, int noOfColumns, SimpleItemTouchHelperCallback.Validator validator, Binder binder) {
        this.init(context, view, viewID, alItems, manager, noOfColumns, validator, binder, null);
    }

    public RecyclerListAdapter(Context context, FastScrollRecyclerView view, int viewID, ArrayList<T> alItems, int manager, int noOfColumns, SimpleItemTouchHelperCallback.Validator validator, Binder binder, ViewHolderListener viewHolderListener) {
        this.init(context, view, viewID, alItems, manager, noOfColumns, validator, binder, viewHolderListener);
    }

    private void init(Context context, FastScrollRecyclerView view, int viewID, ArrayList<T> alItems, int layoutManager, int noOfColumns, SimpleItemTouchHelperCallback.Validator validator, Binder binder, ViewHolderListener viewHolderListener) {
        this.mContext = context;
        this.mViewID = viewID;
        this.mItems = alItems;
        this.mDragStartListener = new OnStartDragListener(){

            @Override
            public void onStartDrag(RecyclerView.ViewHolder viewHolder) {
                RecyclerListAdapter.this.ithContacts.startDrag(viewHolder);
            }
        };
        this.mBinder = binder;
        this.mViewHolderListener = viewHolderListener;
        this.mView = view;
        view.setHasFixedSize(false);
        view.setAdapter(this);
        this.mLayout = layoutManager;
        if (this.mLayout == 0) {
            this.mGridLayoutManager = new GridLayoutManagerEx(context, noOfColumns);
            this.mGridLayoutManager.setAutoMeasureEnabled(false);
            view.setLayoutManager((RecyclerView.LayoutManager)this.mGridLayoutManager);
        } else {
            this.mLinearLayoutManager = new LinearLayoutManagerEx(context);
            this.mLinearLayoutManager.setAutoMeasureEnabled(false);
            view.setLayoutManager((RecyclerView.LayoutManager)this.mLinearLayoutManager);
        }
        if (this.mLayout == 1 || noOfColumns == 1) {
            this.mDividerItemDecoration = new DividerItemDecoration(this.mView.getContext(), 1);
            this.mDividerItemDecoration.setDrawable(context.getResources().getDrawable(R.drawable.__divider_transparent_6dp));
            this.mView.addItemDecoration((RecyclerView.ItemDecoration)this.mDividerItemDecoration);
        }
        SimpleItemTouchHelperCallback callback = new SimpleItemTouchHelperCallback(this, validator);
        this.ithContacts = new ItemTouchHelper((ItemTouchHelper.Callback)callback);
        this.ithContacts.attachToRecyclerView((RecyclerView)view);
    }

    public int getItemViewType(int position) {
        return this.mViewHolderListener == null ? super.getItemViewType(position) : this.mViewHolderListener.getItemViewType(position);
    }

    public ItemViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view;
        View view2 = view = this.mViewHolderListener == null ? null : this.mViewHolderListener.onCreateViewHolder(parent, viewType);
        if (view == null) {
            view = LayoutInflater.from((Context)parent.getContext()).inflate(this.mViewID, parent, false);
        }
        RecyclerView.LayoutParams lp = new RecyclerView.LayoutParams(-1, -2);
        view.setLayoutParams((ViewGroup.LayoutParams)lp);
        ItemViewHolder holder = this.mViewHolderListener == null ? null : this.mViewHolderListener.onCreateItemHolder(this, view, this.handlerID);
        return holder == null ? new ItemViewHolder(this, view, this.handlerID) : holder;
    }

    public void onBindViewHolder(ItemViewHolder holder, int position) {
        if (this.mBinder != null) {
            this.mBinder.onBindView(this, holder, position);
        }
        if (holder.handleView != null) {
            holder.handleView.setOnTouchListener((v, event) -> {
                if (MotionEventCompat.getActionMasked((MotionEvent)event) == 0) {
                    this.mDragStartListener.onStartDrag(holder);
                }
                return false;
            });
        }
    }

    @Override
    public void onItemDismiss(int position) {
        if (this.mBinder != null) {
            if (this.mBinder.onItemDismiss(this, position)) {
                this.mItems.remove(position);
                this.notifyItemRemoved(position);
            } else {
                this.notifyItemChanged(position);
            }
        }
    }

    @Override
    public boolean onItemMove(int fromPosition, int toPosition) {
        if (this.mBinder != null && this.mBinder.onItemMove(this, fromPosition, toPosition)) {
            Collections.swap(this.mItems, fromPosition, toPosition);
            this.notifyItemMoved(fromPosition, toPosition);
        }
        return true;
    }

    public int getItemCount() {
        return this.mItems.size();
    }

    public int findFirstVisibleItem() {
        return this.mLayout == 0 ? this.mGridLayoutManager.findFirstVisibleItemPosition() : this.mLinearLayoutManager.findFirstVisibleItemPosition();
    }

    public boolean isScrolling() {
        if (this.mLayout == 0) {
            return this.getItemCount() > 0 && (this.mGridLayoutManager.findFirstCompletelyVisibleItemPosition() > 0 || this.mGridLayoutManager.findLastCompletelyVisibleItemPosition() < this.getItemCount() - 1);
        }
        return this.getItemCount() > 0 && (this.mLinearLayoutManager.findFirstCompletelyVisibleItemPosition() > 0 || this.mLinearLayoutManager.findLastCompletelyVisibleItemPosition() < this.getItemCount() - 1);
    }

    public void mergeLists(ArrayList<T> from, ArrayList<T> to) {
        if (from == null) {
            return;
        }
        if (to == null) {
            to = new ArrayList();
        }
        to.addAll(from);
    }

    public static class ItemViewHolder
    extends RecyclerView.ViewHolder
    implements ItemTouchHelperViewHolder,
    View.OnClickListener,
    View.OnLongClickListener {
        public final View mItemView;
        public final ImageView handleView;
        public final RecyclerListAdapter<?> mAdapter;
        private final Drawable initialBG;

        public ItemViewHolder(RecyclerListAdapter<?> adapter, View itemView, int handlerID) {
            super(itemView);
            this.mAdapter = adapter;
            this.mItemView = itemView;
            this.handleView = handlerID > 0 ? (ImageView)itemView.findViewById(handlerID) : null;
            this.mItemView.setOnClickListener((View.OnClickListener)this);
            this.mItemView.setOnLongClickListener((View.OnLongClickListener)this);
            this.initialBG = this.mItemView.getBackground();
        }

        @Override
        public void onItemSelected() {
        }

        @Override
        public void onItemClear() {
        }

        public void onClick(View view) {
            if (((RecyclerListAdapter)this.mAdapter).mBinder != null) {
                ((RecyclerListAdapter)this.mAdapter).mBinder.onClick(this.mAdapter, view, this.getAdapterPosition());
            }
        }

        public boolean onLongClick(View view) {
            if (((RecyclerListAdapter)this.mAdapter).mBinder != null) {
                return ((RecyclerListAdapter)this.mAdapter).mBinder.onLongClick(this.mAdapter, view, this.getAdapterPosition());
            }
            return false;
        }
    }

    public static interface Binder {
        public void onBindView(RecyclerListAdapter<?> var1, ItemViewHolder var2, int var3);

        public void onClick(RecyclerListAdapter<?> var1, View var2, int var3);

        public boolean onLongClick(RecyclerListAdapter<?> var1, View var2, int var3);

        public boolean onItemDismiss(RecyclerListAdapter<?> var1, int var2);

        public boolean onItemMove(RecyclerListAdapter<?> var1, int var2, int var3);
    }

    public static interface ViewHolderListener {
        public int getItemViewType(int var1);

        public View onCreateViewHolder(ViewGroup var1, int var2);

        public ItemViewHolder onCreateItemHolder(RecyclerListAdapter var1, View var2, int var3);
    }

    public static class LinearLayoutManagerEx
    extends LinearLayoutManager {
        public boolean mAutoMeasure = false;

        public LinearLayoutManagerEx(Context context) {
            super(context);
        }

        public void setAutoMeasureEnabled(boolean enabled) {
            this.mAutoMeasure = enabled;
            super.setAutoMeasureEnabled(enabled);
        }

        public boolean isAutoMeasureEnabled() {
            return super.isAutoMeasureEnabled();
        }
    }

    public static class GridLayoutManagerEx
    extends GridLayoutManager {
        public boolean mAutoMeasure = false;

        public GridLayoutManagerEx(Context context, int spanCount) {
            super(context, spanCount);
        }

        public void setAutoMeasureEnabled(boolean enabled) {
            this.mAutoMeasure = enabled;
            super.setAutoMeasureEnabled(enabled);
        }

        public boolean isAutoMeasureEnabled() {
            return super.isAutoMeasureEnabled();
        }
    }
}

