/*
 * Decompiled with CFR 0.152.
 */
package com.mixiaoxiao.fastscroll;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ListView;
import com.mixiaoxiao.fastscroll.FastScrollDelegate;

public class FastScrollListView
extends ListView
implements FastScrollDelegate.FastScrollable {
    private FastScrollDelegate mFastScrollDelegate;

    public FastScrollListView(Context context) {
        super(context);
        this.createFastScrollDelegate(context);
    }

    public FastScrollListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createFastScrollDelegate(context);
    }

    public FastScrollListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createFastScrollDelegate(context);
    }

    @TargetApi(value=21)
    public FastScrollListView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.createFastScrollDelegate(context);
    }

    private void createFastScrollDelegate(Context context) {
        this.mFastScrollDelegate = new FastScrollDelegate.Builder(this).build();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mFastScrollDelegate.onInterceptTouchEvent(ev)) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (this.mFastScrollDelegate.onTouchEvent(event)) {
            return true;
        }
        return super.onTouchEvent(event);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFastScrollDelegate.onAttachedToWindow();
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.mFastScrollDelegate != null) {
            this.mFastScrollDelegate.onVisibilityChanged(changedView, visibility);
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mFastScrollDelegate.onWindowVisibilityChanged(visibility);
    }

    protected boolean awakenScrollBars() {
        return this.mFastScrollDelegate.awakenScrollBars();
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.mFastScrollDelegate.dispatchDrawOver(canvas);
    }

    @Override
    public void superOnTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
    }

    @Override
    public int superComputeVerticalScrollExtent() {
        return super.computeVerticalScrollExtent();
    }

    @Override
    public int superComputeVerticalScrollOffset() {
        return super.computeVerticalScrollOffset();
    }

    @Override
    public int superComputeVerticalScrollRange() {
        return super.computeVerticalScrollRange();
    }

    @Override
    public View getFastScrollableView() {
        return this;
    }

    public FastScrollDelegate getDelegate() {
        return this.getFastScrollDelegate();
    }

    @Override
    public FastScrollDelegate getFastScrollDelegate() {
        return this.mFastScrollDelegate;
    }

    @Override
    public void setNewFastScrollDelegate(FastScrollDelegate newDelegate) {
        if (newDelegate == null) {
            throw new IllegalArgumentException("setNewFastScrollDelegate must NOT be NULL.");
        }
        this.mFastScrollDelegate.onDetachedFromWindow();
        this.mFastScrollDelegate = newDelegate;
        newDelegate.onAttachedToWindow();
    }
}

