/*
 * Decompiled with CFR 0.152.
 */
package com.mixiaoxiao.fastscroll;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Interpolator;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.StateListDrawable;
import android.support.v4.view.ViewCompat;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.widget.AbsListView;
import android.widget.PopupWindow;
import android.widget.TextView;

public class FastScrollDelegate {
    public static int FASTSCROLLER_DURATION_FADE_OUT = 300;
    public static int FASTSCROLLER_DURATION_FADE_IN = 150;
    public static long FASTSCROLLER_FADE_TIMEOUT = 1500L;
    private static final int[] DRAWABLE_STATE_PRESSED = new int[]{16842919};
    private static final int[] DRAWABLE_STATE_DEFAULT = new int[0];
    private final View mView;
    private final float mDensity;
    private float mDownY;
    private final Rect mThumbRect;
    private Drawable mThumbDrawable;
    private final FastScrollable mFastScrollable;
    private int mThumbMinHeight;
    private final ScrollabilityCache mScrollCache;
    private IndicatorPopup mIndicatorPopup;
    private boolean mThumbDynamicHeight;
    private OnFastScrollListener mFastScrollListener;
    private boolean mIsHanlingTouchEvent = false;
    public static int FASTSCROLLER_WIDTH_DP = 20;
    public static int FASTSCROLLER_MIN_HEIGHT_DP = 32;
    public static int FASTSCROLLER_THUMB_WIDTH = 4;
    public static int FASTSCROLLER_THUMB_INSET_TOP_BOTTOM_RIGHT = 4;
    public static int COLOR_THUMB_NORMAL = -2139062144;
    public static int COLOR_THUMB_PRESSED = -16537100;
    private static int FASTSCROLLER_INDICATOR_SIZE_DP = 72;
    private static int FASTSCROLLER_INDICATOR_MARINRIGHT_DP = 24;
    private static int FASTSCROLLER_INDICATOR_TEXTSIZE_DP = 36;
    private static int FASTSCROLLER_INDICATOR_POPUPANIMATIONSTYLE = 16973826;

    private void log(String msg) {
        Log.d((String)"FastScrollDelegate", (String)msg);
    }

    private FastScrollDelegate(FastScrollable fastScrollable, int width, int height, Drawable thumbDrawable, boolean isDynamicHeight) {
        this.mView = fastScrollable.getFastScrollableView();
        this.mView.setVerticalScrollBarEnabled(false);
        Context context = this.mView.getContext();
        this.mDensity = context.getResources().getDisplayMetrics().density;
        this.mThumbMinHeight = this.dp2px(FASTSCROLLER_MIN_HEIGHT_DP);
        this.mThumbRect = new Rect(0, 0, width, height);
        this.mThumbDrawable = thumbDrawable;
        this.mFastScrollable = fastScrollable;
        this.mScrollCache = new ScrollabilityCache(ViewConfiguration.get((Context)context), this.mView);
        this.mThumbDynamicHeight = isDynamicHeight;
    }

    public void setThumbDrawable(Drawable drawable) {
        if (drawable == null) {
            throw new IllegalArgumentException("setThumbDrawable must NOT be NULL");
        }
        this.mThumbDrawable = drawable;
        this.updateThumbRect(0);
    }

    public void setThumbSize(int widthDp, int heightDp) {
        this.mThumbRect.left = this.mThumbRect.right - this.dp2px(widthDp);
        this.mThumbMinHeight = this.dp2px(heightDp);
        this.updateThumbRect(0);
    }

    public void setThumbDynamicHeight(boolean isDynamicHeight) {
        if (this.mThumbDynamicHeight != isDynamicHeight) {
            this.mThumbDynamicHeight = isDynamicHeight;
            this.updateThumbRect(0);
        }
    }

    public void setOnFastScrollListener(OnFastScrollListener l) {
        this.mFastScrollListener = l;
    }

    public boolean awakenScrollBars() {
        return this.awakenScrollBars(FASTSCROLLER_FADE_TIMEOUT);
    }

    private boolean initialAwakenScrollBars() {
        return this.awakenScrollBars(this.mScrollCache.scrollBarDefaultDelayBeforeFade * 4);
    }

    public boolean awakenScrollBars(long startDelay) {
        ViewCompat.postInvalidateOnAnimation((View)this.mView);
        if (!this.mIsHanlingTouchEvent) {
            long fadeStartTime;
            if (this.mScrollCache.state == 0) {
                int KEY_REPEAT_FIRST_DELAY = 750;
                startDelay = Math.max(750L, startDelay);
            }
            this.mScrollCache.fadeStartTime = fadeStartTime = AnimationUtils.currentAnimationTimeMillis() + startDelay;
            this.mScrollCache.state = 1;
            this.mView.removeCallbacks((Runnable)this.mScrollCache);
            this.mView.postDelayed((Runnable)this.mScrollCache, fadeStartTime - AnimationUtils.currentAnimationTimeMillis());
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.onInterceptTouchEventInternal(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.onTouchEventInternal(event);
    }

    private boolean onInterceptTouchEventInternal(MotionEvent ev) {
        int action = ev.getActionMasked();
        if (action == 0) {
            return this.onTouchEventInternal(ev);
        }
        return false;
    }

    private boolean onTouchEventInternal(MotionEvent event) {
        int action = event.getActionMasked();
        float y = event.getY();
        switch (action) {
            case 0: {
                if (this.mScrollCache.state == 0) {
                    this.mIsHanlingTouchEvent = false;
                    return false;
                }
                if (this.mIsHanlingTouchEvent) break;
                this.updateThumbRect(0);
                float x = event.getX();
                if (!(y >= (float)this.mThumbRect.top) || !(y <= (float)this.mThumbRect.bottom) || !(x >= (float)this.mThumbRect.left) || !(x <= (float)this.mThumbRect.right)) break;
                this.mIsHanlingTouchEvent = true;
                this.mDownY = y;
                this.mFastScrollable.superOnTouchEvent(event);
                MotionEvent fakeCancelMotionEvent = MotionEvent.obtain((MotionEvent)event);
                fakeCancelMotionEvent.setAction(3);
                this.mFastScrollable.superOnTouchEvent(fakeCancelMotionEvent);
                fakeCancelMotionEvent.recycle();
                this.setPressedThumb(true);
                this.updateThumbRect(0, true);
                this.mView.removeCallbacks((Runnable)this.mScrollCache);
                break;
            }
            case 2: {
                int touchDeltaY;
                if (!this.mIsHanlingTouchEvent || (touchDeltaY = Math.round(y - this.mDownY)) == 0) break;
                this.updateThumbRect(touchDeltaY);
                this.mDownY = y;
                break;
            }
            case 1: 
            case 3: {
                if (!this.mIsHanlingTouchEvent) break;
                this.setPressedThumb(false);
                this.mIsHanlingTouchEvent = false;
                this.awakenScrollBars();
            }
        }
        if (this.mIsHanlingTouchEvent) {
            this.mView.invalidate();
            this.mView.getParent().requestDisallowInterceptTouchEvent(true);
            return true;
        }
        return false;
    }

    public void dispatchDrawOver(Canvas canvas) {
        this.onDrawScrollBars(canvas);
    }

    public void onAttachedToWindow() {
        this.initialAwakenScrollBars();
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void onDetachedFromWindow() {
        if (this.mIndicatorPopup != null) {
            this.mIndicatorPopup.dismiss();
        }
    }

    public void onVisibilityChanged(View changedView, int visibility) {
        if (visibility == 0 && ViewCompat.isAttachedToWindow((View)this.mView)) {
            this.initialAwakenScrollBars();
        }
    }

    public void onWindowVisibilityChanged(int visibility) {
        if (visibility == 0) {
            this.initialAwakenScrollBars();
        }
    }

    private void onDrawScrollBars(Canvas canvas) {
        boolean invalidate = false;
        if (this.mIsHanlingTouchEvent) {
            this.mThumbDrawable.setAlpha(255);
        } else {
            ScrollabilityCache cache = this.mScrollCache;
            int state = cache.state;
            if (state == 0) {
                return;
            }
            if (state == 2) {
                float[] values;
                if (cache.interpolatorValues == null) {
                    cache.interpolatorValues = new float[1];
                }
                if (cache.scrollBarInterpolator.timeToValues(values = cache.interpolatorValues) == Interpolator.Result.FREEZE_END) {
                    cache.state = 0;
                } else {
                    this.mThumbDrawable.setAlpha(Math.round(values[0]));
                }
                invalidate = true;
            } else {
                this.mThumbDrawable.setAlpha(255);
            }
        }
        if (this.updateThumbRect(0)) {
            int scrollY = this.mView.getScrollY();
            int scrollX = this.mView.getScrollX();
            this.mThumbDrawable.setBounds(this.mThumbRect.left + scrollX, this.mThumbRect.top + scrollY, this.mThumbRect.right + scrollX, this.mThumbRect.bottom + scrollY);
            this.mThumbDrawable.draw(canvas);
        }
        if (invalidate) {
            this.mView.invalidate();
        }
    }

    private void setPressedThumb(boolean pressed) {
        this.mThumbDrawable.setState(pressed ? DRAWABLE_STATE_PRESSED : DRAWABLE_STATE_DEFAULT);
        this.mView.invalidate();
        if (this.mIndicatorPopup != null) {
            if (pressed) {
                this.mIndicatorPopup.show();
            } else {
                this.mIndicatorPopup.dismiss();
            }
        }
        if (this.mFastScrollListener != null) {
            if (pressed) {
                this.mFastScrollListener.onFastScrollStart(this.mView, this);
            } else {
                this.mFastScrollListener.onFastScrollEnd(this.mView, this);
            }
        }
    }

    private boolean updateThumbRect(int touchDeltaY) {
        return this.updateThumbRect(touchDeltaY, false);
    }

    private boolean updateThumbRect(int touchDeltaY, boolean forceReportFastScrolled) {
        int thumbWidth = this.mThumbRect.width();
        this.mThumbRect.right = this.mView.getWidth();
        this.mThumbRect.left = this.mThumbRect.right - thumbWidth;
        int scrollRange = this.mFastScrollable.superComputeVerticalScrollRange();
        if (scrollRange <= 0) {
            return false;
        }
        int scrollOffset = this.mFastScrollable.superComputeVerticalScrollOffset();
        int scrollExtent = this.mFastScrollable.superComputeVerticalScrollExtent();
        int scrollMaxOffset = scrollRange - scrollExtent;
        if (scrollMaxOffset <= 0) {
            return false;
        }
        float scrollPercent = (float)scrollOffset * 1.0f / (float)scrollMaxOffset;
        float visiblePercent = (float)scrollExtent * 1.0f / (float)scrollRange;
        int viewHeight = this.mView.getHeight();
        int thumbHeight = this.mThumbDynamicHeight ? Math.max(this.mThumbMinHeight, Math.round(visiblePercent * (float)viewHeight)) : this.mThumbMinHeight;
        this.mThumbRect.bottom = this.mThumbRect.top + thumbHeight;
        int thumbTop = Math.round((float)(viewHeight - thumbHeight) * scrollPercent);
        this.mThumbRect.offsetTo(this.mThumbRect.left, thumbTop);
        if (this.mIndicatorPopup != null) {
            this.mIndicatorPopup.setOffset(this.mView.getWidth() - this.mIndicatorPopup.getPopupSize() - this.mThumbRect.width(), -viewHeight + this.mThumbRect.centerY() - this.mIndicatorPopup.getPopupSize());
        }
        if (touchDeltaY != 0) {
            int newThumbTop = thumbTop + touchDeltaY;
            boolean minThumbTop = false;
            int maxThumbTop = viewHeight - thumbHeight;
            if (newThumbTop > maxThumbTop) {
                newThumbTop = maxThumbTop;
            } else if (newThumbTop < 0) {
                newThumbTop = 0;
            }
            float newScrollPercent = (float)newThumbTop * 1.0f / (float)maxThumbTop;
            int newScrollOffset = Math.round((float)(scrollRange - scrollExtent) * newScrollPercent);
            int viewScrollDeltaY = newScrollOffset - scrollOffset;
            if (this.mView instanceof AbsListView) {
                ((AbsListView)this.mView).smoothScrollBy(viewScrollDeltaY, 0);
            } else {
                this.mView.scrollBy(0, viewScrollDeltaY);
            }
            if (this.mFastScrollListener != null) {
                this.mFastScrollListener.onFastScrolled(this.mView, this, touchDeltaY, viewScrollDeltaY, newScrollPercent);
            }
        } else if (forceReportFastScrolled && this.mFastScrollListener != null) {
            this.mFastScrollListener.onFastScrolled(this.mView, this, 0, 0, scrollPercent);
        }
        return true;
    }

    public View getView() {
        return this.mView;
    }

    private int dp2px(float dp) {
        return (int)(this.mDensity * dp + 0.5f);
    }

    public void setIndicatorText(String indicator) {
        if (this.mIndicatorPopup != null) {
            this.mIndicatorPopup.setIndicatorText(indicator);
        }
    }

    public void initIndicatorPopup(IndicatorPopup indicatorPopup) {
        this.mIndicatorPopup = indicatorPopup;
    }

    static /* synthetic */ int access$000() {
        return FASTSCROLLER_INDICATOR_POPUPANIMATIONSTYLE;
    }

    public static class Builder {
        private final float density;
        private final FastScrollable fastScrollable;
        private int width;
        private int height;
        private boolean isDynamicHeight = true;
        private Drawable thumbDrawable;
        private int thumbNormalColor = COLOR_THUMB_NORMAL;
        private int thumbPressedColor = COLOR_THUMB_PRESSED;

        public Builder(FastScrollable fastScrollable) {
            this.fastScrollable = fastScrollable;
            this.density = fastScrollable.getFastScrollableView().getContext().getResources().getDisplayMetrics().density;
            this.width = this.dp2px(FASTSCROLLER_WIDTH_DP);
            this.height = this.dp2px(FASTSCROLLER_MIN_HEIGHT_DP);
        }

        public Builder width(float widthDp) {
            this.width = this.dp2px(widthDp);
            return this;
        }

        public Builder height(float heightDp) {
            this.height = this.dp2px(heightDp);
            return this;
        }

        public Builder thumbNormalColor(int normalColor) {
            this.thumbNormalColor = normalColor;
            return this;
        }

        public Builder thumbPressedColor(int pressedColor) {
            this.thumbPressedColor = pressedColor;
            return this;
        }

        public Builder thumbDrawable(Drawable thumb) {
            this.thumbDrawable = thumb;
            return this;
        }

        public Builder dynamicHeight(boolean isDynamic) {
            this.isDynamicHeight = isDynamic;
            return this;
        }

        public FastScrollDelegate build() {
            if (this.thumbDrawable == null) {
                this.thumbDrawable = this.makeDefaultThumbDrawable();
            }
            return new FastScrollDelegate(this.fastScrollable, this.width, this.height, this.thumbDrawable, this.isDynamicHeight);
        }

        private Drawable makeDefaultThumbDrawable() {
            StateListDrawable stateListDrawable = new StateListDrawable();
            GradientDrawable pressedDrawable = new GradientDrawable();
            pressedDrawable.setColor(this.thumbPressedColor);
            float radius = (float)this.width / 2.0f;
            int inset = this.dp2px(FASTSCROLLER_THUMB_INSET_TOP_BOTTOM_RIGHT);
            int insetLeft = this.width - inset - this.dp2px(FASTSCROLLER_THUMB_WIDTH);
            pressedDrawable.setCornerRadius(radius);
            stateListDrawable.addState(DRAWABLE_STATE_PRESSED, (Drawable)new InsetDrawable((Drawable)pressedDrawable, insetLeft, inset, inset, inset));
            GradientDrawable normalDrawable = new GradientDrawable();
            normalDrawable.setColor(this.thumbNormalColor);
            normalDrawable.setCornerRadius(radius);
            stateListDrawable.addState(DRAWABLE_STATE_DEFAULT, (Drawable)new InsetDrawable((Drawable)normalDrawable, insetLeft, inset, inset, inset));
            return stateListDrawable;
        }

        public int dp2px(float dp) {
            return (int)(dp * this.density + 0.5f);
        }
    }

    private static class BubbleDrawable
    extends Drawable {
        private final Paint paint = new Paint(1);
        private final Path path = new Path();
        private final RectF rectF = new RectF();

        public BubbleDrawable(int color) {
            this.paint.setColor(color);
        }

        public void draw(Canvas canvas) {
            canvas.drawPath(this.path, this.paint);
        }

        protected void onBoundsChange(Rect bounds) {
            super.onBoundsChange(bounds);
            int w = bounds.width();
            int h = bounds.height();
            this.path.reset();
            float radius = (float)Math.min(w, h) / 2.0f - 1.0f;
            float cx = (float)w / 2.0f;
            float cy = (float)h / 2.0f;
            this.rectF.set(cx - radius, cy - radius, cx + radius, cy + radius);
            this.path.arcTo(this.rectF, 0.0f, -270.0f, true);
            this.path.lineTo(cx + radius, cy + radius);
            this.path.close();
        }

        public void setAlpha(int alpha) {
            this.paint.setAlpha(alpha);
        }

        public void setColorFilter(ColorFilter cf) {
            this.paint.setColorFilter(cf);
        }

        public int getOpacity() {
            return -3;
        }
    }

    public static class IndicatorPopup {
        final View anchor;
        final int popupSize;
        final int marginRight;
        final TextView bubbleView;
        int xOffset;
        int yOffset;
        final PopupWindow popupWindow;

        private IndicatorPopup(View anchor, int popupColor, int popupSize, int textSize, int marginRight, int popupAnimationStyle) {
            this.anchor = anchor;
            this.popupSize = popupSize;
            this.marginRight = marginRight;
            this.bubbleView = new TextView(anchor.getContext());
            this.bubbleView.setGravity(17);
            this.bubbleView.setTextColor(-1);
            this.bubbleView.setSingleLine();
            this.bubbleView.setBackgroundDrawable((Drawable)new BubbleDrawable(popupColor));
            this.bubbleView.setEllipsize(TextUtils.TruncateAt.END);
            this.bubbleView.setTextSize(0, (float)textSize);
            this.popupWindow = new PopupWindow((View)this.bubbleView, popupSize, popupSize, false);
            this.popupWindow.setAnimationStyle(popupAnimationStyle);
        }

        public int getPopupSize() {
            return this.popupSize;
        }

        public void setOffset(int xoff, int yoff) {
            this.xOffset = xoff;
            this.yOffset = yoff;
            if (this.popupWindow != null && this.popupWindow.isShowing()) {
                this.popupWindow.update(this.anchor, xoff - this.marginRight, yoff, this.popupSize, this.popupSize);
            }
        }

        public void show() {
            if (this.popupWindow != null && !this.popupWindow.isShowing()) {
                this.popupWindow.showAsDropDown(this.anchor, this.xOffset - this.marginRight, this.yOffset);
            }
        }

        public void dismiss() {
            if (this.popupWindow != null && this.popupWindow.isShowing()) {
                this.popupWindow.dismiss();
            }
        }

        public void setIndicatorText(String indicator) {
            this.bubbleView.setText((CharSequence)indicator);
        }

        public static class Builder {
            private final float density;
            private final View anchor;
            private int indicatorPopupColor = COLOR_THUMB_PRESSED;
            private int indicatorPopupSize;
            private int indicatorTextSize;
            private int indicatorMarginRight;
            private int indicatorPopupAnimationStyle = FastScrollDelegate.access$000();

            public Builder(FastScrollDelegate delegate) {
                this.anchor = delegate.getView();
                this.density = this.anchor.getContext().getResources().getDisplayMetrics().density;
                this.indicatorPopupSize = this.dp2px(FASTSCROLLER_INDICATOR_SIZE_DP);
                this.indicatorTextSize = this.dp2px(FASTSCROLLER_INDICATOR_TEXTSIZE_DP);
                this.indicatorMarginRight = this.dp2px(FASTSCROLLER_INDICATOR_MARINRIGHT_DP);
            }

            public Builder indicatorPopupColor(int popupColor) {
                this.indicatorPopupColor = popupColor;
                return this;
            }

            public Builder indicatorPopupSize(int popupSizeDp) {
                this.indicatorPopupSize = this.dp2px(popupSizeDp);
                return this;
            }

            public Builder indicatorTextSize(int textSizeDp) {
                this.indicatorTextSize = this.dp2px(textSizeDp);
                return this;
            }

            public Builder indicatorMarginRight(int marginRightDp) {
                this.indicatorMarginRight = this.dp2px(marginRightDp);
                return this;
            }

            public Builder indicatorPopupAnimationStyle(int animationStyle) {
                this.indicatorPopupAnimationStyle = animationStyle;
                return this;
            }

            private int dp2px(float dp) {
                return (int)(this.density * dp + 0.5f);
            }

            public IndicatorPopup build() {
                return new IndicatorPopup(this.anchor, this.indicatorPopupColor, this.indicatorPopupSize, this.indicatorTextSize, this.indicatorMarginRight, this.indicatorPopupAnimationStyle);
            }
        }
    }

    private static class ScrollabilityCache
    implements Runnable {
        public static final int OFF = 0;
        public static final int ON = 1;
        public static final int FADING = 2;
        public final int scrollBarDefaultDelayBeforeFade;
        public final int scrollBarFadeDuration;
        public float[] interpolatorValues;
        public View host;
        public final Interpolator scrollBarInterpolator = new Interpolator(1, 2);
        private static final float[] OPAQUE = new float[]{255.0f};
        private static final float[] TRANSPARENT = new float[]{0.0f};
        public long fadeStartTime;
        public int state = 0;

        public ScrollabilityCache(ViewConfiguration configuration, View host) {
            this.scrollBarDefaultDelayBeforeFade = ViewConfiguration.getScrollDefaultDelay();
            this.scrollBarFadeDuration = ViewConfiguration.getScrollBarFadeDuration();
            this.host = host;
        }

        @Override
        public void run() {
            long now = AnimationUtils.currentAnimationTimeMillis();
            if (now >= this.fadeStartTime) {
                int nextFrame = (int)now;
                int framesCount = 0;
                Interpolator interpolator = this.scrollBarInterpolator;
                interpolator.setKeyFrame(framesCount++, nextFrame, OPAQUE);
                interpolator.setKeyFrame(framesCount, nextFrame += this.scrollBarFadeDuration, TRANSPARENT);
                this.state = 2;
                this.host.invalidate();
            }
        }
    }

    public static interface OnFastScrollListener {
        public void onFastScrollStart(View var1, FastScrollDelegate var2);

        public void onFastScrolled(View var1, FastScrollDelegate var2, int var3, int var4, float var5);

        public void onFastScrollEnd(View var1, FastScrollDelegate var2);
    }

    public static interface FastScrollable {
        public void superOnTouchEvent(MotionEvent var1);

        public int superComputeVerticalScrollExtent();

        public int superComputeVerticalScrollOffset();

        public int superComputeVerticalScrollRange();

        public View getFastScrollableView();

        public FastScrollDelegate getFastScrollDelegate();

        public void setNewFastScrollDelegate(FastScrollDelegate var1);
    }
}

