/*
 * Decompiled with CFR 0.152.
 */
package com.androidstudy.smsverifier;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import com.androidstudy.smsverifier.OnSmsCatchListener;
import com.androidstudy.smsverifier.SmsReceiver;

public class SmsVerifyCatcher {
    private static final int PERMISSION_REQUEST_CODE = 12;
    private Activity activity;
    private Fragment fragment;
    private OnSmsCatchListener<String> onSmsCatchListener;
    private SmsReceiver smsReceiver;
    private String phoneNumber;
    private String filter;

    public SmsVerifyCatcher(Activity activity, OnSmsCatchListener<String> onSmsCatchListener) {
        this.activity = activity;
        this.onSmsCatchListener = onSmsCatchListener;
        this.smsReceiver = new SmsReceiver();
        this.smsReceiver.setCallback(this.onSmsCatchListener);
    }

    public SmsVerifyCatcher(Activity activity, Fragment fragment, OnSmsCatchListener<String> onSmsCatchListener) {
        this(activity, onSmsCatchListener);
        this.fragment = fragment;
    }

    public void onStart() {
        if (SmsVerifyCatcher.isStoragePermissionGranted(this.activity, this.fragment)) {
            this.registerReceiver();
        }
    }

    private void registerReceiver() {
        this.smsReceiver = new SmsReceiver();
        this.smsReceiver.setCallback(this.onSmsCatchListener);
        this.smsReceiver.setPhoneNumberFilter(this.phoneNumber);
        this.smsReceiver.setFilter(this.filter);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.provider.Telephony.SMS_RECEIVED");
        this.activity.registerReceiver((BroadcastReceiver)this.smsReceiver, intentFilter);
    }

    public void setPhoneNumberFilter(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void onStop() {
        try {
            this.activity.unregisterReceiver((BroadcastReceiver)this.smsReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setFilter(String regexp) {
        this.filter = regexp;
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 12 && grantResults[0] == 0 && grantResults[1] == 0) {
            this.registerReceiver();
        }
    }

    public static boolean isStoragePermissionGranted(Activity activity, Fragment fragment) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.RECEIVE_SMS") == 0 && ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.READ_SMS") == 0) {
                return true;
            }
            if (fragment == null) {
                ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.RECEIVE_SMS", "android.permission.READ_SMS"}, (int)12);
            } else {
                fragment.requestPermissions(new String[]{"android.permission.RECEIVE_SMS", "android.permission.READ_SMS"}, 12);
            }
            return false;
        }
        return true;
    }
}

