/*
 * Decompiled with CFR 0.152.
 */
package com.androidpi.literefresh.controller;

import android.support.design.widget.CoordinatorLayout;
import android.view.View;
import com.androidpi.literefresh.behavior.ScrollingContentBehavior;
import com.androidpi.literefresh.behavior.VerticalIndicatorBehavior;
import com.androidpi.literefresh.controller.VerticalIndicatorBehaviorController;

public class HeaderBehaviorController
extends VerticalIndicatorBehaviorController {
    public HeaderBehaviorController(VerticalIndicatorBehavior behavior) {
        super(behavior);
    }

    @Override
    public int computeOffsetDeltaOnDependentViewChanged(CoordinatorLayout parent, View child, View dependency, VerticalIndicatorBehavior behavior, ScrollingContentBehavior contentBehavior) {
        if (contentBehavior.isMinOffsetReached() && child.getBottom() + behavior.getConfiguration().getBottomMargin() <= contentBehavior.getConfiguration().getMinOffset()) {
            return 0;
        }
        CoordinatorLayout.LayoutParams dependencyLp = (CoordinatorLayout.LayoutParams)dependency.getLayoutParams();
        CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)child.getLayoutParams();
        return dependency.getTop() - dependencyLp.topMargin - (child.getBottom() + lp.bottomMargin);
    }

    @Override
    public int transformOffsetCoordinate(CoordinatorLayout parent, View child, VerticalIndicatorBehavior behavior, int currentOffset) {
        return currentOffset + child.getHeight();
    }

    @Override
    public float consumeOffsetOnDependentViewChanged(CoordinatorLayout parent, View child, VerticalIndicatorBehavior behavior, ScrollingContentBehavior contentBehavior, int currentOffset, int offsetDelta) {
        switch (this.mode) {
            case 1: {
                if (child.getBottom() + behavior.getConfiguration().getBottomMargin() == behavior.getConfiguration().getInitialVisibleHeight()) {
                    return 0.0f;
                }
                return offsetDelta;
            }
            case 2: {
                if (offsetDelta < 0 && child.getBottom() + behavior.getConfiguration().getBottomMargin() <= behavior.getConfiguration().getInitialVisibleHeight()) {
                    return 0.0f;
                }
                return offsetDelta;
            }
            case 3: {
                if (offsetDelta > 0 && child.getBottom() + behavior.getConfiguration().getBottomMargin() >= behavior.getConfiguration().getInitialVisibleHeight() || offsetDelta < 0 && child.getBottom() + behavior.getConfiguration().getBottomMargin() <= contentBehavior.getConfiguration().getMinOffset()) {
                    return 0.0f;
                }
                return offsetDelta;
            }
        }
        return offsetDelta;
    }

    @Override
    public boolean isHiddenPartVisible(CoordinatorLayout parent, View child, VerticalIndicatorBehavior behavior) {
        return child.getBottom() + behavior.getConfiguration().getBottomMargin() > behavior.getConfiguration().getInitialVisibleHeight();
    }
}

