/*
 * Decompiled with CFR 0.152.
 */
package com.androidpi.literefresh.controller;

import android.support.annotation.NonNull;
import android.support.design.widget.CoordinatorLayout;
import android.view.View;
import com.androidpi.literefresh.OnLoadListener;
import com.androidpi.literefresh.OnRefreshListener;
import com.androidpi.literefresh.behavior.BehaviorController;
import com.androidpi.literefresh.behavior.ScrollingContentBehavior;
import com.androidpi.literefresh.state.StateMachine;
import java.util.LinkedHashSet;
import java.util.Set;

public class ContentBehaviorController
extends BehaviorController<ScrollingContentBehavior>
implements OnRefreshListener,
OnLoadListener {
    private static final long HOLD_ON_DURATION = 500L;
    private static final long SHOW_DURATION = 300L;
    private static final long RESET_DURATION = 300L;
    private final StateMachine.StateHandler footerStateHandler = new StateMachine.StateHandler(){

        @Override
        public boolean isValidOffset(int currentOffset) {
            return this.transform(currentOffset) > ((ScrollingContentBehavior)ContentBehaviorController.this.behavior).getFooterConfig().getInitialVisibleHeight();
        }

        @Override
        public int transform(int currentOffset) {
            return -(currentOffset + ((ScrollingContentBehavior)ContentBehaviorController.this.behavior).getChild().getHeight()) + ((ScrollingContentBehavior)ContentBehaviorController.this.behavior).getParent().getHeight();
        }

        @Override
        public int readyRefreshOffset() {
            return ((ScrollingContentBehavior)ContentBehaviorController.this.behavior).getFooterConfig().getRefreshTriggerRange() + ((ScrollingContentBehavior)ContentBehaviorController.this.behavior).getFooterConfig().getInitialVisibleHeight();
        }

        @Override
        public boolean hasRefreshStateListeners() {
            return ContentBehaviorController.this.hasOnLoadListeners();
        }

        @Override
        public void resetRefreshOffset() {
            ContentBehaviorController.this.refreshFooter();
        }

        @Override
        public void resetOffset() {
            ContentBehaviorController.this.reset();
        }

        @Override
        public void onStateChanged(int state, Throwable throwable) {
            switch (state) {
                case 1: {
                    ContentBehaviorController.this.onLoadStart();
                    break;
                }
                case 3: {
                    ContentBehaviorController.this.onReleaseToLoad();
                    break;
                }
                case 2: {
                    ContentBehaviorController.this.stopScroll(false);
                    break;
                }
                case 4: {
                    ContentBehaviorController.this.onLoad();
                    ContentBehaviorController.this.refreshFooter();
                    break;
                }
                case 5: {
                    ContentBehaviorController.this.stopScroll(true);
                    ContentBehaviorController.this.onLoadEnd(throwable);
                    break;
                }
            }
        }
    };
    private StateMachine.StateHandler headerStateHandler = new StateMachine.StateHandler(){

        @Override
        public boolean isValidOffset(int currentOffset) {
            return this.transform(currentOffset) > ((ScrollingContentBehavior)ContentBehaviorController.this.behavior).getHeaderConfig().getInitialVisibleHeight();
        }

        @Override
        public int transform(int currentOffset) {
            return currentOffset;
        }

        @Override
        public int readyRefreshOffset() {
            return ((ScrollingContentBehavior)ContentBehaviorController.this.behavior).getHeaderConfig().getRefreshTriggerRange() + ((ScrollingContentBehavior)ContentBehaviorController.this.behavior).getHeaderConfig().getInitialVisibleHeight();
        }

        @Override
        public boolean hasRefreshStateListeners() {
            return ContentBehaviorController.this.hasOnRefreshListeners();
        }

        @Override
        public void resetRefreshOffset() {
            ContentBehaviorController.this.refreshHeader();
        }

        @Override
        public void resetOffset() {
            ContentBehaviorController.this.reset();
        }

        @Override
        public void onStateChanged(int state, Throwable throwable) {
            switch (state) {
                case 1: {
                    ContentBehaviorController.this.onRefreshStart();
                    break;
                }
                case 3: {
                    ContentBehaviorController.this.onReleaseToRefresh();
                    break;
                }
                case 2: {
                    ContentBehaviorController.this.stopScroll(false);
                    break;
                }
                case 4: {
                    ContentBehaviorController.this.onRefresh();
                    ContentBehaviorController.this.refreshHeader();
                    break;
                }
                case 5: {
                    ContentBehaviorController.this.stopScroll(true);
                    ContentBehaviorController.this.onRefreshEnd(throwable);
                    break;
                }
            }
        }
    };
    private StateMachine headerStateMachine = new StateMachine(this.headerStateHandler);
    private StateMachine footerStateMachine = new StateMachine(this.footerStateHandler);
    private Set<StateMachine> stateMachines = new LinkedHashSet<StateMachine>(2){
        {
            this.add(ContentBehaviorController.this.headerStateMachine);
            this.add(ContentBehaviorController.this.footerStateMachine);
        }
    };

    public ContentBehaviorController(ScrollingContentBehavior behavior) {
        super(behavior);
    }

    @Override
    public void onStartScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull View child, int initial, int trigger, int min, int max, int type) {
        for (StateMachine stateMachine : this.stateMachines) {
            stateMachine.onStartScroll(coordinatorLayout, child, initial, trigger, min, max, type);
        }
        super.onStartScroll(coordinatorLayout, child, initial, trigger, min, max, type);
    }

    @Override
    public void onPreScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull View child, int current, int initial, int trigger, int min, int max, int type) {
        for (StateMachine stateMachine : this.stateMachines) {
            stateMachine.onPreScroll(coordinatorLayout, child, current, initial, trigger, min, max, type);
        }
        super.onPreScroll(coordinatorLayout, child, current, initial, trigger, min, max, type);
    }

    @Override
    public void onScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull View child, int current, int delta, int initial, int trigger, int min, int max, int type) {
        for (StateMachine stateMachine : this.stateMachines) {
            stateMachine.onScroll(coordinatorLayout, child, current, delta, initial, trigger, min, max, type);
        }
        super.onScroll(coordinatorLayout, child, current, delta, initial, trigger, min, max, type);
    }

    @Override
    public void onStopScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull View child, int current, int initial, int trigger, int min, int max, int type) {
        for (StateMachine stateMachine : this.stateMachines) {
            stateMachine.onStopScroll(coordinatorLayout, child, current, initial, trigger, min, max, type);
        }
        super.onStopScroll(coordinatorLayout, child, current, initial, trigger, min, max, type);
    }

    @Override
    public void onLoadStart() {
        if (!this.hasOnLoadListeners()) {
            return;
        }
        for (OnLoadListener l : this.mLoadListeners) {
            l.onLoadStart();
        }
    }

    @Override
    public void onReleaseToLoad() {
        if (!this.hasOnLoadListeners()) {
            return;
        }
        for (OnLoadListener l : this.mLoadListeners) {
            l.onReleaseToLoad();
        }
    }

    @Override
    public void onLoad() {
        if (!this.hasOnLoadListeners()) {
            return;
        }
        for (OnLoadListener l : this.mLoadListeners) {
            l.onLoad();
        }
    }

    @Override
    public void onLoadEnd(Throwable throwable) {
        if (!this.hasOnLoadListeners()) {
            return;
        }
        for (OnLoadListener l : this.mLoadListeners) {
            l.onLoadEnd(throwable);
        }
    }

    @Override
    public void onRefreshStart() {
        if (!this.hasOnRefreshListeners()) {
            return;
        }
        for (OnRefreshListener l : this.mRefreshListeners) {
            l.onRefreshStart();
        }
    }

    @Override
    public void onReleaseToRefresh() {
        if (!this.hasOnRefreshListeners()) {
            return;
        }
        for (OnRefreshListener l : this.mRefreshListeners) {
            l.onReleaseToRefresh();
        }
    }

    @Override
    public void onRefresh() {
        if (!this.hasOnRefreshListeners()) {
            return;
        }
        for (OnRefreshListener l : this.mRefreshListeners) {
            l.onRefresh();
        }
    }

    @Override
    public void onRefreshEnd(Throwable throwable) {
        if (!this.hasOnRefreshListeners()) {
            return;
        }
        for (OnRefreshListener l : this.mRefreshListeners) {
            l.onRefreshEnd(throwable);
        }
    }

    @Override
    public void refresh() {
        if (this.headerStateMachine.isRefreshing()) {
            return;
        }
        this.runWithView(new Runnable(){

            @Override
            public void run() {
                ContentBehaviorController.this.headerStateMachine.refresh();
            }
        });
    }

    @Override
    public void refreshComplete() {
        this.headerStateMachine.refreshComplete();
    }

    @Override
    public void refreshError(Throwable throwable) {
        this.headerStateMachine.refreshError(throwable);
    }

    @Override
    public void load() {
        if (this.footerStateMachine.isRefreshing()) {
            return;
        }
        this.runWithView(new Runnable(){

            @Override
            public void run() {
                ContentBehaviorController.this.footerStateMachine.refresh();
            }
        });
    }

    @Override
    public void loadComplete() {
        this.footerStateMachine.refreshComplete();
    }

    @Override
    public void loadError(Throwable throwable) {
        this.footerStateMachine.refreshError(throwable);
    }

    public boolean isRefreshing() {
        return this.headerStateMachine.isRefreshing();
    }

    public boolean isLoading() {
        return this.footerStateMachine.isRefreshing();
    }

    void showHeader() {
        ((ScrollingContentBehavior)this.behavior).showHeader(300L);
    }

    void showFooter() {
        ((ScrollingContentBehavior)this.behavior).showFooter(300L);
    }

    void refreshFooter() {
        ((ScrollingContentBehavior)this.behavior).refreshFooter(300L);
    }

    void refreshHeader() {
        ((ScrollingContentBehavior)this.behavior).refreshHeader(300L);
    }

    void reset() {
        ((ScrollingContentBehavior)this.behavior).reset(300L);
    }

    void stopScroll(boolean holdOn) {
        ((ScrollingContentBehavior)this.behavior).stopScroll(holdOn);
    }
}

