/*
 * Decompiled with CFR 0.152.
 */
package com.androidpi.literefresh.behavior;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.design.widget.CoordinatorLayout;
import android.util.AttributeSet;
import android.view.View;
import com.androidpi.literefresh.R;
import com.androidpi.literefresh.behavior.AnimationOffsetBehavior;
import com.androidpi.literefresh.behavior.ScrollingContentBehavior;
import com.androidpi.literefresh.controller.VerticalIndicatorBehaviorController;
import java.util.List;

public abstract class VerticalIndicatorBehavior<V extends View, CTR extends VerticalIndicatorBehaviorController>
extends AnimationOffsetBehavior<V, CTR> {
    private final int defaultMinTriggerRange;

    public VerticalIndicatorBehavior(Context context) {
        this(context, null);
    }

    public VerticalIndicatorBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.OffsetBehavior, 0, 0);
        if (a.hasValue(R.styleable.OffsetBehavior_lr_visibleHeight)) {
            this.configuration.setVisibleHeight(Math.round(a.getDimension(R.styleable.OffsetBehavior_lr_visibleHeight, 0.0f)));
        }
        if (a.hasValue(R.styleable.OffsetBehavior_lr_visibleHeightRatio)) {
            this.configuration.setVisibleHeightRatio(a.getFraction(R.styleable.OffsetBehavior_lr_visibleHeightRatio, 1, 1, 0.0f));
            this.configuration.setVisibleHeightParentRatio(a.getFraction(R.styleable.OffsetBehavior_lr_visibleHeightRatio, 1, 2, 0.0f));
        }
        if (a.hasValue(R.styleable.OffsetBehavior_lr_showUpWhenRefresh)) {
            this.configuration.setShowUpWhenRefresh(a.getBoolean(R.styleable.OffsetBehavior_lr_showUpWhenRefresh, false));
        }
        this.configuration.setUseDefinedRefreshTriggerRange(a.hasValue(R.styleable.OffsetBehavior_lr_triggerOffset));
        this.configuration.setRefreshTriggerRange(a.getDimensionPixelOffset(R.styleable.OffsetBehavior_lr_triggerOffset, 0));
        a.recycle();
        this.defaultMinTriggerRange = context.getResources().getDimensionPixelOffset(R.dimen.lr_default_min_trigger_range);
    }

    @Override
    public boolean onMeasureChild(CoordinatorLayout parent, V child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        boolean handled = super.onMeasureChild(parent, child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
        return handled;
    }

    @Override
    public boolean onLayoutChild(CoordinatorLayout parent, V child, int layoutDirection) {
        boolean handled = super.onLayoutChild(parent, child, layoutDirection);
        if (this.configuration.getHeight() != child.getHeight()) {
            this.configuration.setHeight(child.getHeight());
            this.configuration.setSettled(false);
        }
        int visibleHeight = (int)Math.max((float)this.configuration.getVisibleHeight(), this.configuration.getVisibleHeightParentRatio() > this.configuration.getVisibleHeightRatio() ? this.configuration.getVisibleHeightRatio() * (float)parent.getHeight() : this.configuration.getVisibleHeightRatio() * (float)child.getHeight());
        int invisibleHeight = child.getHeight() - visibleHeight;
        if (this.configuration.getRefreshTriggerRange() < 0) {
            this.configuration.setRefreshTriggerRange(this.configuration.getDefaultRefreshTriggerRange());
        } else if (!this.configuration.isUseDefinedRefreshTriggerRange()) {
            if (this.defaultMinTriggerRange > 0 && invisibleHeight >= this.defaultMinTriggerRange && invisibleHeight <= this.configuration.getDefaultRefreshTriggerRange()) {
                this.configuration.setRefreshTriggerRange(invisibleHeight);
            } else {
                this.configuration.setRefreshTriggerRange(Math.max(invisibleHeight, this.configuration.getDefaultRefreshTriggerRange()));
            }
        }
        this.configuration.setVisibleHeight(visibleHeight);
        this.configuration.setInvisibleHeight(invisibleHeight);
        return handled;
    }

    public boolean onStartNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View directTargetChild, @NonNull View target, int axes, int type) {
        boolean start;
        boolean bl = start = (axes & 2) != 0;
        if (start) {
            for (AnimationOffsetBehavior.ScrollingListener l : this.mListeners) {
                l.onStartScroll(coordinatorLayout, (View)child, this.getInitialOffset(coordinatorLayout, (View)child), this.getRefreshTriggerOffset(coordinatorLayout, (View)child), this.getMinOffset(coordinatorLayout, (View)child), this.getMaxOffset(coordinatorLayout, (View)child), type);
            }
        }
        return start;
    }

    public void onStopNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, int type) {
        for (AnimationOffsetBehavior.ScrollingListener l : this.mListeners) {
            l.onStopScroll(coordinatorLayout, (View)child, ((VerticalIndicatorBehaviorController)this.controller).transformOffsetCoordinate(coordinatorLayout, (View)child, this, this.getTopAndBottomOffset()), this.getInitialOffset(coordinatorLayout, (View)child), this.getRefreshTriggerOffset(coordinatorLayout, (View)child), this.getMinOffset(coordinatorLayout, (View)child), this.getMaxOffset(coordinatorLayout, (View)child), type);
        }
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, V child, View dependency) {
        CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)dependency.getLayoutParams();
        if (null != lp) {
            CoordinatorLayout.Behavior behavior = lp.getBehavior();
            return behavior instanceof ScrollingContentBehavior;
        }
        return false;
    }

    public boolean onDependentViewChanged(final CoordinatorLayout parent, V child, View dependency) {
        CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)dependency.getLayoutParams();
        CoordinatorLayout.Behavior behavior = lp.getBehavior();
        if (behavior instanceof ScrollingContentBehavior) {
            ScrollingContentBehavior contentBehavior = (ScrollingContentBehavior)behavior;
            if (this.isLayedOut()) {
                return this.onDependenceOffsetChanged(parent, child, dependency, contentBehavior, this);
            }
            this.runWithView(new Runnable((View)child, dependency, contentBehavior){
                final /* synthetic */ View val$child;
                final /* synthetic */ View val$dependency;
                final /* synthetic */ ScrollingContentBehavior val$contentBehavior;
                {
                    this.val$child = view;
                    this.val$dependency = view2;
                    this.val$contentBehavior = scrollingContentBehavior;
                }

                @Override
                public void run() {
                    VerticalIndicatorBehavior.this.onDependenceOffsetChanged(parent, this.val$child, this.val$dependency, this.val$contentBehavior, VerticalIndicatorBehavior.this);
                }
            });
        }
        return false;
    }

    private boolean isLayedOut() {
        return this.getParent() != null && this.getChild() != null;
    }

    private boolean onDependenceOffsetChanged(CoordinatorLayout parent, V child, View dependency, ScrollingContentBehavior contentBehavior, VerticalIndicatorBehavior behavior) {
        int offsetDelta = ((VerticalIndicatorBehaviorController)this.controller).computeOffsetDeltaOnDependentViewChanged(parent, (View)child, dependency, this, contentBehavior);
        if (offsetDelta != 0) {
            this.consumeOffsetOnDependentViewChanged(parent, (View)child, contentBehavior, offsetDelta, 2);
            return true;
        }
        return false;
    }

    private void consumeOffsetOnDependentViewChanged(CoordinatorLayout coordinatorLayout, View child, ScrollingContentBehavior contentBehavior, int offsetDelta, int type) {
        int currentOffset = this.getTopAndBottomOffset();
        int height = child.getHeight();
        for (AnimationOffsetBehavior.ScrollingListener l : this.mListeners) {
            l.onPreScroll(coordinatorLayout, child, ((VerticalIndicatorBehaviorController)this.controller).transformOffsetCoordinate(coordinatorLayout, child, this, currentOffset), this.getInitialOffset(coordinatorLayout, child), this.getRefreshTriggerOffset(coordinatorLayout, child), this.getMinOffset(coordinatorLayout, child), height, type);
        }
        float consumed = ((VerticalIndicatorBehaviorController)this.controller).consumeOffsetOnDependentViewChanged(coordinatorLayout, child, this, contentBehavior, currentOffset, offsetDelta);
        currentOffset = Math.round((float)currentOffset + consumed);
        this.setTopAndBottomOffset(currentOffset);
        for (AnimationOffsetBehavior.ScrollingListener l : this.mListeners) {
            l.onScroll(coordinatorLayout, child, ((VerticalIndicatorBehaviorController)this.controller).transformOffsetCoordinate(coordinatorLayout, child, this, currentOffset), offsetDelta, this.getInitialOffset(coordinatorLayout, child), this.getRefreshTriggerOffset(coordinatorLayout, child), this.getMinOffset(coordinatorLayout, child), this.getMaxOffset(coordinatorLayout, child), type);
        }
    }

    private View findDependencyChild(CoordinatorLayout parent, View child) {
        if (parent == null || child == null) {
            return null;
        }
        List dependencies = parent.getDependencies(child);
        if (dependencies.isEmpty()) {
            return null;
        }
        for (View v : dependencies) {
            CoordinatorLayout.LayoutParams p = (CoordinatorLayout.LayoutParams)v.getLayoutParams();
            if (!(p.getBehavior() instanceof ScrollingContentBehavior)) continue;
            return v;
        }
        return null;
    }

    private ScrollingContentBehavior findDependencyBehavior(CoordinatorLayout parent, View child) {
        if (parent == null || child == null) {
            return null;
        }
        List dependencies = parent.getDependencies(child);
        if (dependencies.isEmpty()) {
            return null;
        }
        for (View v : dependencies) {
            CoordinatorLayout.LayoutParams p = (CoordinatorLayout.LayoutParams)v.getLayoutParams();
            if (!(p.getBehavior() instanceof ScrollingContentBehavior)) continue;
            return (ScrollingContentBehavior)p.getBehavior();
        }
        return null;
    }

    protected ScrollingContentBehavior getContentBehavior(CoordinatorLayout parent, View child) {
        return this.findDependencyBehavior(parent, child);
    }

    protected abstract int getInitialOffset(@NonNull CoordinatorLayout var1, @NonNull View var2);

    protected abstract int getRefreshTriggerOffset(@NonNull CoordinatorLayout var1, @NonNull View var2);

    protected abstract int getMinOffset(@NonNull CoordinatorLayout var1, @NonNull View var2);

    protected abstract int getMaxOffset(@NonNull CoordinatorLayout var1, @NonNull View var2);
}

