/*
 * Decompiled with CFR 0.152.
 */
package com.androidpi.literefresh.animator;

import android.support.animation.DynamicAnimation;
import android.support.animation.FloatValueHolder;
import android.support.animation.SpringAnimation;
import android.support.animation.SpringForce;
import com.androidpi.literefresh.animator.OffsetAnimator;

public class SpringOffsetAnimator
extends OffsetAnimator {
    private SpringAnimation springAnimation;

    @Override
    public void cancel() {
        if (null != this.springAnimation && this.springAnimation.isRunning()) {
            this.springAnimation.cancel();
        }
    }

    @Override
    public void animateOffsetWithDuration(int currentOffset, int destOffset, long duration, final OffsetAnimator.AnimationUpdateListener listener) {
        if (null == this.springAnimation) {
            this.springAnimation = new SpringAnimation(new FloatValueHolder());
        } else {
            this.springAnimation.cancel();
        }
        this.springAnimation.addUpdateListener(new DynamicAnimation.OnAnimationUpdateListener(){

            public void onAnimationUpdate(DynamicAnimation animation, float value, float velocity) {
                if (listener == null) {
                    return;
                }
                listener.onAnimationUpdate((int)value);
            }
        });
        this.springAnimation.addEndListener(new DynamicAnimation.OnAnimationEndListener(){

            public void onAnimationEnd(DynamicAnimation animation, boolean canceled, float value, float velocity) {
                SpringOffsetAnimator.this.setRunning(false);
            }
        });
        SpringForce springForce = new SpringForce().setDampingRatio(1.0f).setFinalPosition((float)destOffset);
        this.springAnimation.setSpring(springForce).setStartValue((float)currentOffset);
        this.springAnimation.start();
        this.setRunning(true);
    }
}

