/*
 * Decompiled with CFR 0.152.
 */
package com.androidpi.literefresh.behavior;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.design.widget.CoordinatorLayout;
import android.util.AttributeSet;
import android.view.View;
import com.androidpi.literefresh.Loader;
import com.androidpi.literefresh.OnLoadListener;
import com.androidpi.literefresh.OnScrollListener;
import com.androidpi.literefresh.R;
import com.androidpi.literefresh.behavior.RefreshHeaderBehavior;
import com.androidpi.literefresh.behavior.ScrollingContentBehavior;
import com.androidpi.literefresh.behavior.VerticalIndicatorBehavior;
import com.androidpi.literefresh.controller.FooterBehaviorController;

public class RefreshFooterBehavior<V extends View>
extends VerticalIndicatorBehavior<V, FooterBehaviorController>
implements Loader {
    public RefreshFooterBehavior(Context context) {
        this(context, null);
    }

    public RefreshFooterBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.controller = new FooterBehaviorController(this);
        this.addScrollListener(this.controller);
        this.runWithView(new Runnable(){

            @Override
            public void run() {
                ScrollingContentBehavior contentBehavior = RefreshFooterBehavior.this.getContentBehavior(RefreshFooterBehavior.this.getParent(), (View)RefreshFooterBehavior.this.getChild());
                if (contentBehavior != null) {
                    ((FooterBehaviorController)RefreshFooterBehavior.this.controller).setProxy(contentBehavior.getController());
                }
            }
        });
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.IndicatorBehavior, 0, 0);
        if (a.hasValue(R.styleable.IndicatorBehavior_lr_mode)) {
            int mode = a.getInt(R.styleable.IndicatorBehavior_lr_mode, 0);
            ((FooterBehaviorController)this.controller).setMode(mode);
        }
        a.recycle();
    }

    @Override
    public boolean onLayoutChild(CoordinatorLayout parent, V child, int layoutDirection) {
        boolean handled = super.onLayoutChild(parent, child, layoutDirection);
        CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)child.getLayoutParams();
        if (this.configuration.isUseDefaultMaxOffset()) {
            this.configuration.setMaxOffset(child.getHeight());
        } else {
            this.configuration.setMaxOffset((int)Math.max((float)this.configuration.getMaxOffset(), this.configuration.getMaxOffsetRatioOfParent() > this.configuration.getMaxOffsetRatio() ? this.configuration.getMaxOffsetRatio() * (float)parent.getHeight() : this.configuration.getMaxOffsetRatio() * (float)child.getHeight()));
        }
        int lastInitialVisibleHeight = this.configuration.getInitialVisibleHeight();
        int currentInitialVisibleHeight = this.getInitialVisibleHeight(parent, (View)child);
        if (lastInitialVisibleHeight != currentInitialVisibleHeight) {
            this.configuration.setSettled(false);
        }
        this.configuration.setInitialVisibleHeight(currentInitialVisibleHeight);
        if (this.configuration.getInitialVisibleHeight() <= 0) {
            this.configuration.setRefreshTriggerRange(this.configuration.getRefreshTriggerRange() + lp.topMargin);
        }
        this.configuration.setMaxOffset(Math.max(this.configuration.getMaxOffset(), this.configuration.getInitialVisibleHeight() + this.configuration.getRefreshTriggerRange()));
        if (!this.configuration.isSettled()) {
            this.configuration.setSettled(true);
            ScrollingContentBehavior contentBehavior = this.getContentBehavior(parent, (View)child);
            if (contentBehavior != null) {
                contentBehavior.setFooterConfig(this.configuration);
            }
            this.setTopAndBottomOffset(-this.configuration.getVisibleHeight() + parent.getHeight());
        }
        return handled;
    }

    public void addOnScrollListener(OnScrollListener listener) {
        ((FooterBehaviorController)this.controller).addOnScrollListener(listener);
    }

    @Override
    public void load() {
        ((FooterBehaviorController)this.controller).load();
    }

    @Override
    public void loadComplete() {
        ((FooterBehaviorController)this.controller).loadComplete();
    }

    @Override
    public void loadError(Throwable throwable) {
        ((FooterBehaviorController)this.controller).loadError(throwable);
    }

    public void addOnLoadListener(OnLoadListener listener) {
        ((FooterBehaviorController)this.controller).addOnLoadListener(listener);
    }

    @Override
    public FooterBehaviorController getController() {
        return (FooterBehaviorController)super.getController();
    }

    @Override
    protected int getInitialOffset(@NonNull CoordinatorLayout parent, @NonNull View child) {
        return this.configuration.getVisibleHeight();
    }

    @Override
    protected int getRefreshTriggerOffset(@NonNull CoordinatorLayout parent, @NonNull View child) {
        return this.configuration.getVisibleHeight() + this.configuration.getRefreshTriggerRange();
    }

    @Override
    protected int getMinOffset(@NonNull CoordinatorLayout parent, @NonNull View child) {
        return -this.configuration.getTopMargin();
    }

    @Override
    protected int getMaxOffset(@NonNull CoordinatorLayout parent, @NonNull View child) {
        ScrollingContentBehavior contentBehavior = this.getContentBehavior(parent, child);
        return contentBehavior == null ? 0 : contentBehavior.getFooterConfig().getMaxOffset() - this.configuration.getTopMargin();
    }

    private int getInitialVisibleHeight(@NonNull CoordinatorLayout parent, @NonNull View child) {
        int initialVisibleHeight = this.configuration.getHeight() <= 0 || this.configuration.getVisibleHeight() <= 0 ? this.configuration.getVisibleHeight() : (this.configuration.getVisibleHeight() >= child.getHeight() ? this.configuration.getVisibleHeight() + this.configuration.getTopMargin() + this.configuration.getBottomMargin() : this.configuration.getVisibleHeight() + this.configuration.getTopMargin());
        ScrollingContentBehavior contentBehavior = this.getContentBehavior(parent, child);
        if (contentBehavior == null || this.getParent().getHeight() == 0 || contentBehavior.getConfiguration().getHeight() == 0) {
            return initialVisibleHeight;
        }
        return Math.max(initialVisibleHeight, this.getParent().getHeight() - this.getParent().getPaddingTop() - this.getParent().getPaddingBottom() - contentBehavior.getConfiguration().getHeight() - contentBehavior.getConfiguration().getTopMargin() - contentBehavior.getConfiguration().getBottomMargin() - contentBehavior.getHeaderConfig().getInitialVisibleHeight());
    }

    @Override
    public boolean layoutDependsOn(CoordinatorLayout parent, V child, View dependency) {
        CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)dependency.getLayoutParams();
        if (null != lp) {
            CoordinatorLayout.Behavior behavior = lp.getBehavior();
            return behavior instanceof ScrollingContentBehavior || behavior instanceof RefreshHeaderBehavior;
        }
        return false;
    }
}

