/*
 * Decompiled with CFR 0.152.
 */
package com.androidpi.literefresh.behavior;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Interpolator;
import com.androidpi.literefresh.Loader;
import com.androidpi.literefresh.OnLoadListener;
import com.androidpi.literefresh.OnRefreshListener;
import com.androidpi.literefresh.OnScrollListener;
import com.androidpi.literefresh.Refresher;
import com.androidpi.literefresh.animator.ViscousFluidInterpolator;
import com.androidpi.literefresh.behavior.ScrollingContentBehavior;
import com.androidpi.literefresh.controller.ContentBehaviorController;

public class RefreshContentBehavior<V extends View>
extends ScrollingContentBehavior<V>
implements Refresher,
Loader {
    private float accumulator = 0.0f;
    private Interpolator scrollDownInterpolator = new ViscousFluidInterpolator();

    public RefreshContentBehavior(Context context) {
        this(context, null);
    }

    public RefreshContentBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void addOnScrollListener(OnScrollListener listener) {
        ((ContentBehaviorController)this.controller).addOnScrollListener(listener);
    }

    public void addOnRefreshListener(OnRefreshListener listener) {
        ((ContentBehaviorController)this.controller).addOnRefreshListener(listener);
    }

    public void addOnLoadListener(OnLoadListener listener) {
        ((ContentBehaviorController)this.controller).addOnLoadListener(listener);
    }

    @Override
    public void refresh() {
        ((ContentBehaviorController)this.controller).refresh();
    }

    @Override
    public void refreshComplete() {
        ((ContentBehaviorController)this.controller).refreshComplete();
    }

    @Override
    public void refreshError(Throwable throwable) {
        ((ContentBehaviorController)this.controller).refreshError(throwable);
    }

    @Override
    public void load() {
        ((ContentBehaviorController)this.controller).load();
    }

    @Override
    public void loadComplete() {
        ((ContentBehaviorController)this.controller).loadComplete();
    }

    @Override
    public void loadError(Throwable throwable) {
        ((ContentBehaviorController)this.controller).loadError(throwable);
    }

    @Override
    protected float onConsumeOffset(int current, int max, int delta) {
        float y;
        float consumed = delta;
        if (current >= 0 && delta > 0 && (double)(consumed = (1.0f - (y = this.scrollDownInterpolator.getInterpolation((float)current / (float)max))) * (float)delta) < 0.5) {
            this.accumulator = (float)((double)this.accumulator + 0.2);
            if (this.accumulator >= 1.0f) {
                consumed += 1.0f;
                this.accumulator = 0.0f;
            }
        }
        return consumed;
    }
}

