/*
 * Decompiled with CFR 0.152.
 */
package com.androidpi.literefresh.behavior;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.design.widget.CoordinatorLayout;
import android.util.AttributeSet;
import android.view.View;
import com.androidpi.literefresh.R;
import com.androidpi.literefresh.animator.OffsetAnimator;
import com.androidpi.literefresh.animator.SpringOffsetAnimator;
import com.androidpi.literefresh.behavior.BehaviorConfiguration;
import com.androidpi.literefresh.behavior.BehaviorController;
import com.androidpi.literefresh.behavior.ViewOffsetBehavior;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public abstract class AnimationOffsetBehavior<V extends View, CTR extends BehaviorController>
extends ViewOffsetBehavior<V>
implements Handler.Callback {
    public static final int TYPE_UNKNOWN = 2;
    static final long HOLD_ON_DURATION = 500L;
    static final long SHOW_DURATION = 300L;
    static final long RESET_DURATION = 300L;
    private static final int MSG_VIEW_INITIATED = 1;
    public static final float GOLDEN_RATIO = 0.618f;
    protected V mChild;
    protected CoordinatorLayout mParent;
    private OffsetAnimator offsetAnimator;
    protected int progressBase = 0;
    protected List<ScrollingListener> mListeners = new ArrayList<ScrollingListener>();
    protected Handler handler = new Handler((Handler.Callback)this);
    private Queue<Runnable> pendingActions = new LinkedList<Runnable>();
    protected CTR controller;
    protected BehaviorConfiguration configuration;

    public AnimationOffsetBehavior(Context context) {
        this(context, null);
    }

    public AnimationOffsetBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (this.configuration == null) {
            this.configuration = new BehaviorConfiguration();
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.OffsetBehavior, 0, 0);
        boolean hasMaxOffsetRatio = a.hasValue(R.styleable.OffsetBehavior_lr_maxOffsetRatio);
        boolean hasMaxOffset = a.hasValue(R.styleable.OffsetBehavior_lr_maxOffset);
        if (hasMaxOffsetRatio) {
            this.configuration.setMaxOffsetRatio(a.getFraction(R.styleable.OffsetBehavior_lr_maxOffsetRatio, 1, 1, 0.0f));
            this.configuration.setMaxOffsetRatioOfParent(a.getFraction(R.styleable.OffsetBehavior_lr_maxOffsetRatio, 1, 2, 0.0f));
        }
        if (hasMaxOffset) {
            this.configuration.setMaxOffset(a.getDimensionPixelOffset(R.styleable.OffsetBehavior_lr_maxOffset, 0));
        }
        this.configuration.setUseDefaultMaxOffset(!hasMaxOffsetRatio && !hasMaxOffset);
        this.configuration.setDefaultRefreshTriggerRange(context.getResources().getDimensionPixelOffset(R.dimen.lr_default_trigger_range));
        a.recycle();
    }

    public boolean onMeasureChild(CoordinatorLayout parent, V child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        parent.onMeasureChild(child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
        return true;
    }

    @Override
    public boolean onLayoutChild(CoordinatorLayout parent, V child, int layoutDirection) {
        boolean handled = super.onLayoutChild(parent, child, layoutDirection);
        if (this.mParent == null) {
            this.mParent = parent;
        }
        if (this.mChild == null) {
            this.mChild = child;
        }
        this.handler.sendEmptyMessage(1);
        return handled;
    }

    public void onAttachedToLayoutParams(@NonNull CoordinatorLayout.LayoutParams params) {
        super.onAttachedToLayoutParams(params);
        this.configuration.setTopMargin(params.topMargin);
        this.configuration.setBottomMargin(params.bottomMargin);
        this.configuration.setSettled(false);
        if (this.handler == null) {
            this.handler = new Handler((Handler.Callback)this);
        }
    }

    public void onDetachedFromLayoutParams() {
        super.onDetachedFromLayoutParams();
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
            this.handler = null;
        }
        this.pendingActions.clear();
        this.mListeners.clear();
        this.cancelAnimation();
    }

    protected void cancelAnimation() {
        if (this.offsetAnimator != null && this.offsetAnimator.isRunning()) {
            this.offsetAnimator.cancel();
        }
    }

    protected void animateOffsetDeltaWithDuration(CoordinatorLayout parent, View child, int offsetDelta, int initialOffset, int triggerOffset, int minOffset, int maxOffset, long duration, int type) {
        this.animateOffsetWithDuration(parent, child, this.getTopAndBottomOffset() + offsetDelta, initialOffset, triggerOffset, minOffset, maxOffset, duration, type);
    }

    protected void animateOffsetWithDuration(final CoordinatorLayout parent, final View child, int destOffset, final int initialOffset, final int triggerOffset, final int minOffset, final int maxOffset, long duration, final int type) {
        int current = this.getTopAndBottomOffset();
        if (destOffset == current) {
            if (this.offsetAnimator != null && this.offsetAnimator.isRunning()) {
                this.offsetAnimator.cancel();
            }
            return;
        }
        if (this.offsetAnimator == null) {
            this.offsetAnimator = new SpringOffsetAnimator();
        } else {
            this.offsetAnimator.cancel();
        }
        this.offsetAnimator.animateOffsetWithDuration(current, destOffset, duration, new OffsetAnimator.AnimationUpdateListener(){
            private int last;

            @Override
            public void onAnimationUpdate(int value) {
                boolean offsetChanged = AnimationOffsetBehavior.this.setTopAndBottomOffset(value);
                if (!offsetChanged) {
                    parent.dispatchDependentViewsChanged(child);
                }
                for (ScrollingListener l : AnimationOffsetBehavior.this.mListeners) {
                    l.onScroll(AnimationOffsetBehavior.this.getParent(), (View)AnimationOffsetBehavior.this.getChild(), value, value - this.last, initialOffset, triggerOffset, minOffset, maxOffset, type);
                }
                this.last = value;
            }

            @Override
            public void onAnimationEnd() {
            }
        });
    }

    public CoordinatorLayout getParent() {
        return this.mParent;
    }

    public V getChild() {
        return this.mChild;
    }

    protected void addScrollListener(ScrollingListener listener) {
        if (null == listener) {
            return;
        }
        this.mListeners.add(listener);
    }

    protected void removeScrollListener(ScrollingListener listener) {
        if (null == listener) {
            return;
        }
        this.mListeners.remove(listener);
    }

    protected void runWithView(Runnable action) {
        if (action == null) {
            return;
        }
        if (this.getParent() == null || this.getChild() == null) {
            this.enqueuePendingActions(action);
        } else {
            this.runOnUiThread(action);
        }
    }

    protected void runOnUiThread(Runnable action) {
        if (action == null) {
            return;
        }
        if (this.handler == null) {
            this.handler = new Handler((Handler.Callback)this);
        }
        this.handler.post(action);
    }

    protected void enqueuePendingActions(Runnable action) {
        this.pendingActions.offer(action);
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.executePendingActions();
                break;
            }
        }
        return true;
    }

    protected void executePendingActions() {
        Runnable action;
        while ((action = this.pendingActions.poll()) != null) {
            this.runOnUiThread(action);
        }
    }

    public void requestLayout() {
        this.runWithView(new Runnable(){

            @Override
            public void run() {
                AnimationOffsetBehavior.this.getChild().requestLayout();
            }
        });
    }

    public CTR getController() {
        return this.controller;
    }

    public BehaviorConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(BehaviorConfiguration configuration) {
        this.configuration = configuration;
        this.requestLayout();
    }

    public static interface ScrollingListener {
        public void onStartScroll(@NonNull CoordinatorLayout var1, @NonNull View var2, int var3, int var4, int var5, int var6, int var7);

        public void onPreScroll(@NonNull CoordinatorLayout var1, @NonNull View var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void onScroll(@NonNull CoordinatorLayout var1, @NonNull View var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

        public void onStopScroll(@NonNull CoordinatorLayout var1, @NonNull View var2, int var3, int var4, int var5, int var6, int var7, int var8);
    }
}

