/*
 * Decompiled with CFR 0.152.
 */
package com.androidpi.literefresh.animator;

import android.view.animation.Interpolator;

public class ViscousFluidInterpolator
implements Interpolator {
    private static final float VISCOUS_FLUID_SCALE = 2.0f;
    private static final float VISCOUS_FLUID_NORMALIZE = 1.0f / ViscousFluidInterpolator.viscousFluid(1.0f);
    private static final float VISCOUS_FLUID_OFFSET = 1.0f - VISCOUS_FLUID_NORMALIZE * ViscousFluidInterpolator.viscousFluid(1.0f);

    private static float viscousFluid(float x) {
        if ((x *= 2.0f) < 1.0f) {
            x -= 1.0f - (float)Math.exp(-x);
        } else {
            float start = 0.36787945f;
            x = 1.0f - (float)Math.exp(1.0f - x);
            x = start + x * (1.0f - start);
        }
        return x;
    }

    public float getInterpolation(float input) {
        float interpolated = VISCOUS_FLUID_NORMALIZE * ViscousFluidInterpolator.viscousFluid(input);
        if (interpolated > 0.0f) {
            return interpolated + VISCOUS_FLUID_OFFSET;
        }
        return interpolated;
    }
}

