/*
 * Decompiled with CFR 0.152.
 */
package com.androidpi.literefresh.animator;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.animation.DecelerateInterpolator;
import com.androidpi.literefresh.animator.OffsetAnimator;

public class DefaultOffsetAnimator
extends OffsetAnimator {
    private ValueAnimator mOffsetAnimator;

    @Override
    public void animateOffsetWithDuration(int currentOffset, int destOffset, long duration, final OffsetAnimator.AnimationUpdateListener listener) {
        if (this.mOffsetAnimator == null) {
            this.mOffsetAnimator = new ValueAnimator();
            this.mOffsetAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            this.mOffsetAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    if (listener == null) {
                        return;
                    }
                    listener.onAnimationUpdate((Integer)animation.getAnimatedValue());
                }
            });
        } else {
            this.mOffsetAnimator.cancel();
        }
        this.mOffsetAnimator.setDuration(duration);
        this.mOffsetAnimator.setIntValues(new int[]{currentOffset, destOffset});
        this.mOffsetAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                DefaultOffsetAnimator.this.setRunning(true);
            }

            public void onAnimationEnd(Animator animation) {
                DefaultOffsetAnimator.this.setRunning(false);
            }

            public void onAnimationCancel(Animator animation) {
                DefaultOffsetAnimator.this.setRunning(false);
            }

            public void onAnimationRepeat(Animator animation) {
                DefaultOffsetAnimator.this.setRunning(true);
            }
        });
        this.mOffsetAnimator.start();
    }

    @Override
    public void cancel() {
        if (this.mOffsetAnimator != null) {
            this.mOffsetAnimator.cancel();
        }
    }
}

