/*
 * Decompiled with CFR 0.152.
 */
package com.androidpi.literefresh.state;

import android.support.annotation.NonNull;
import android.support.design.widget.CoordinatorLayout;
import android.view.View;
import com.androidpi.literefresh.Refresher;
import com.androidpi.literefresh.behavior.AnimationOffsetBehavior;

public class StateMachine
implements AnimationOffsetBehavior.ScrollingListener,
Refresher {
    public static final int STATE_IDLE = 0;
    public static final int STATE_START = 1;
    public static final int STATE_CANCELLED = 2;
    public static final int STATE_READY = 3;
    public static final int STATE_REFRESH = 4;
    public static final int STATE_COMPLETE = 5;
    protected int mState = 0;
    private StateHandler mStateHandler;

    public StateMachine(StateHandler stateHandler) {
        this.mStateHandler = stateHandler;
    }

    @Override
    public void onStartScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull View child, int initial, int trigger, int min, int max, int type) {
        this.moveToState(0);
    }

    @Override
    public void onPreScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull View child, int current, int initial, int trigger, int min, int max, int type) {
        if (this.mState == 0) {
            this.moveToState(1);
        }
    }

    @Override
    public void onScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull View child, int current, int delta, int initial, int trigger, int min, int max, int type) {
        if (!this.mStateHandler.hasRefreshStateListeners() || !this.mStateHandler.isValidOffset(current)) {
            return;
        }
        if (this.mStateHandler.transform(current) >= this.mStateHandler.readyRefreshOffset()) {
            this.moveToState(3);
        } else {
            this.moveToState(1);
        }
    }

    @Override
    public void onStopScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull View child, int current, int initial, int trigger, int min, int max, int type) {
        if (!this.mStateHandler.isValidOffset(current)) {
            return;
        }
        if (!this.mStateHandler.hasRefreshStateListeners()) {
            this.moveToState(2);
            return;
        }
        if (this.mStateHandler.transform(current) >= this.mStateHandler.readyRefreshOffset()) {
            if (!this.moveToState(4)) {
                if (this.mState == 4) {
                    this.mStateHandler.resetRefreshOffset();
                } else {
                    this.moveToState(2);
                }
            }
        } else {
            this.moveToState(2);
        }
    }

    protected boolean moveToState(int state, Throwable throwable) {
        switch (state) {
            case 0: {
                if (this.mState == 5 || this.mState == 2) {
                    this.mState = state;
                    this.onStateChanged(this.mState, throwable);
                    return true;
                }
                return false;
            }
            case 1: {
                if (this.mState == 0 || this.mState == 3) {
                    this.mState = state;
                    this.onStateChanged(this.mState, throwable);
                    return true;
                }
                return false;
            }
            case 2: {
                if (this.mState == 1 || this.mState == 5) {
                    this.mState = state;
                    this.onStateChanged(this.mState, throwable);
                    return true;
                }
                return false;
            }
            case 3: {
                if (this.mState == 1) {
                    this.mState = state;
                    this.onStateChanged(this.mState, throwable);
                    return true;
                }
                return false;
            }
            case 4: {
                if (this.mState == 0 || this.mState == 3) {
                    this.mState = state;
                    this.onStateChanged(this.mState, throwable);
                    return true;
                }
                return false;
            }
            case 5: {
                if (this.mState == 4) {
                    this.mState = state;
                    this.onStateChanged(this.mState, throwable);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    protected boolean moveToState(int state) {
        return this.moveToState(state, null);
    }

    void onStateChanged(int state, Throwable throwable) {
        if (this.mStateHandler == null) {
            return;
        }
        this.mStateHandler.onStateChanged(state, throwable);
    }

    public boolean isRefreshing() {
        return this.mState == 4;
    }

    @Override
    public void refresh() {
        this.moveToState(4);
    }

    @Override
    public void refreshComplete() {
        this.refreshCompleted(null);
    }

    @Override
    public void refreshError(Throwable throwable) {
        this.refreshCompleted(throwable);
    }

    private void refreshCompleted(Throwable throwable) {
        this.moveToState(5, throwable);
    }

    public static interface StateHandler {
        public boolean isValidOffset(int var1);

        public int transform(int var1);

        public int readyRefreshOffset();

        public boolean hasRefreshStateListeners();

        public void onStateChanged(int var1, Throwable var2);

        public void resetRefreshOffset();

        public void resetOffset();
    }
}

