/*
 * Decompiled with CFR 0.152.
 */
package com.androidpi.literefresh.behavior;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.math.MathUtils;
import android.support.v4.view.AbsSavedState;
import android.util.AttributeSet;
import android.view.View;
import com.androidpi.literefresh.R;
import com.androidpi.literefresh.behavior.AnimationOffsetBehavior;
import com.androidpi.literefresh.behavior.BehaviorConfiguration;
import com.androidpi.literefresh.controller.ContentBehaviorController;

public class ScrollingContentBehavior<V extends View>
extends AnimationOffsetBehavior<V, ContentBehaviorController> {
    private static final int INVALID_OFFSET = Integer.MIN_VALUE;
    private BehaviorConfiguration headerConfig;
    private BehaviorConfiguration footerConfig;
    private int initialOffset = Integer.MIN_VALUE;
    private Runnable offsetCallback;

    public ScrollingContentBehavior(Context context) {
        this(context, null);
    }

    public ScrollingContentBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
        boolean hasMinOffsetRatio;
        TypedArray a;
        boolean hasMinOffset;
        this.controller = new ContentBehaviorController(this);
        this.addScrollListener(this.controller);
        if (this.headerConfig == null) {
            this.headerConfig = this.createIndicatorConfig();
        }
        if (this.footerConfig == null) {
            this.footerConfig = this.createIndicatorConfig();
            this.footerConfig.setUseDefaultMaxOffset(true);
        }
        if (hasMinOffset = (a = context.obtainStyledAttributes(attrs, R.styleable.ContentBehavior, 0, 0)).hasValue(R.styleable.ContentBehavior_lr_minOffset)) {
            this.configuration.setMinOffset(a.getDimensionPixelOffset(R.styleable.ContentBehavior_lr_minOffset, 0));
            this.configuration.setCachedMinOffset(this.configuration.getMinOffset());
        }
        if (hasMinOffsetRatio = a.hasValue(R.styleable.ContentBehavior_lr_minOffsetRatio)) {
            this.configuration.setMinOffsetRatio(Float.valueOf(a.getFraction(R.styleable.ContentBehavior_lr_minOffsetRatio, 1, 1, 0.0f)));
            this.configuration.setMinOffsetRatioOfParent(Float.valueOf(a.getFraction(R.styleable.ContentBehavior_lr_minOffsetRatio, 1, 2, 0.0f)));
        }
        if (!hasMinOffset && !hasMinOffsetRatio) {
            this.configuration.setUseDefaultMinOffset(true);
        }
        if (a.hasValue(R.styleable.ContentBehavior_lr_headerVisibleHeight)) {
            this.headerConfig.setVisibleHeight(a.getDimensionPixelOffset(R.styleable.ContentBehavior_lr_headerVisibleHeight, 0));
            this.headerConfig.setInitialVisibleHeight(this.getHeaderInitialVisibleHeight());
        }
        a.recycle();
    }

    @Override
    public boolean onMeasureChild(CoordinatorLayout parent, V child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        boolean handled = super.onMeasureChild(parent, child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
        int height = parent.getMeasuredHeight() - this.configuration.getMinOffset();
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
        parent.onMeasureChild(child, parentWidthMeasureSpec, widthUsed, heightSpec, heightUsed);
        return handled;
    }

    @Override
    public boolean onLayoutChild(CoordinatorLayout parent, V child, int layoutDirection) {
        boolean handled = super.onLayoutChild(parent, child, layoutDirection);
        if (this.configuration.getHeight() != child.getHeight()) {
            this.configuration.setHeight(child.getHeight());
            this.configuration.setSettled(false);
        }
        this.configFooter(parent);
        this.configMaxOffset(parent, child);
        this.configMinOffset(parent, child);
        if (!(this.configuration.isSettled() && this.headerConfig.isSettled() && this.footerConfig.isSettled())) {
            this.configuration.setMinOffset(Math.min(this.configuration.getMinOffset(), this.headerConfig.getInitialVisibleHeight()));
            child.requestLayout();
            this.configuration.setSettled(true);
            this.headerConfig.setSettled(true);
            this.footerConfig.setSettled(true);
            this.cancelAnimation();
            if (this.initialOffset != Integer.MIN_VALUE) {
                this.setContentTopAndBottomOffset(parent, child, this.initialOffset, 1);
            } else {
                this.setTopAndBottomOffset(this.headerConfig.getInitialVisibleHeight());
            }
        }
        return handled;
    }

    private void configMaxOffset(CoordinatorLayout parent, V child) {
        if (this.configuration.isUseDefaultMaxOffset()) {
            this.configuration.setMaxOffset((int)Math.max((float)this.configuration.getMaxOffset(), 0.618f * (float)parent.getHeight()));
            if (!this.headerConfig.isUseDefaultMaxOffset() && this.headerConfig.getMaxOffset() > 0) {
                this.configuration.setMaxOffset(this.headerConfig.getMaxOffset());
            }
        } else {
            this.configuration.setMaxOffset((int)Math.max((float)this.configuration.getMaxOffset(), this.configuration.getMaxOffsetRatioOfParent() > this.configuration.getMaxOffsetRatio() ? this.configuration.getMaxOffsetRatio() * (float)parent.getHeight() : this.configuration.getMaxOffsetRatio() * (float)child.getHeight()));
        }
        this.configuration.setMaxOffset(Math.max(this.configuration.getMaxOffset(), this.headerConfig.getMaxOffset()));
    }

    private void configMinOffset(CoordinatorLayout parent, V child) {
        if (!this.configuration.isUseDefaultMinOffset() && this.configuration.getMinOffsetRatio() != null && this.configuration.getMinOffsetRatioOfParent() != null) {
            this.configuration.setMinOffset((int)Math.max((float)this.configuration.getMinOffset(), this.configuration.getMinOffsetRatioOfParent().floatValue() > this.configuration.getMinOffsetRatio().floatValue() ? this.configuration.getMinOffsetRatio().floatValue() * (float)parent.getHeight() : this.configuration.getMinOffsetRatio().floatValue() * (float)child.getHeight()));
            this.configuration.setCachedMinOffset(this.configuration.getMinOffset());
        }
    }

    private void configFooter(CoordinatorLayout parent) {
        if (this.footerConfig.isUseDefaultMaxOffset() && this.footerConfig.getMaxOffset() <= 0) {
            this.footerConfig.setMaxOffset((int)(0.38200003f * (float)parent.getHeight()));
        }
    }

    public boolean onStartNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View directTargetChild, @NonNull View target, int axes, int type) {
        boolean start;
        if (this.initialOffset != Integer.MIN_VALUE && type == 0) {
            this.initialOffset = Integer.MIN_VALUE;
        }
        boolean bl = start = (axes & 2) != 0;
        if (start) {
            for (AnimationOffsetBehavior.ScrollingListener l : this.mListeners) {
                l.onStartScroll(coordinatorLayout, (View)child, this.headerConfig.getInitialVisibleHeight(), this.headerConfig.getInitialVisibleHeight() + this.headerConfig.getRefreshTriggerRange(), this.configuration.getMinOffset(), this.configuration.getMaxOffset(), type);
            }
        }
        return start;
    }

    public void onNestedPreScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, int dx, int dy, @NonNull int[] consumed, int type) {
        if (dy > 0) {
            int top = child.getTop() - this.configuration.getTopMargin();
            if (top <= this.configuration.getMinOffset()) {
                return;
            }
            int offset = MathUtils.clamp((int)(-dy), (int)(this.configuration.getMinOffset() - top), (int)0);
            if (offset != 0) {
                this.consumeOffset(coordinatorLayout, child, offset, type, true);
                consumed[1] = -offset;
            }
        } else if (dy < 0) {
            int bottom = child.getBottom() + this.configuration.getBottomMargin();
            if (bottom >= coordinatorLayout.getHeight()) {
                return;
            }
            int offset = MathUtils.clamp((int)(-dy), (int)0, (int)(coordinatorLayout.getHeight() - bottom));
            if (offset != 0) {
                this.consumeOffset(coordinatorLayout, child, offset, type, true);
                consumed[1] = -offset;
            }
        }
    }

    public void onNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type) {
        if (dyUnconsumed < 0) {
            int maxOffset;
            int top = child.getTop() - this.configuration.getTopMargin();
            if (top >= (maxOffset = this.configuration.getMaxOffset())) {
                return;
            }
            int offset = MathUtils.clamp((int)(-dyUnconsumed), (int)0, (int)(maxOffset - top));
            if (offset != 0) {
                if (top >= this.headerConfig.getInitialVisibleHeight()) {
                    if (type != 0) {
                        return;
                    }
                    this.consumeOffset(coordinatorLayout, child, offset, type, false);
                } else {
                    offset = MathUtils.clamp((int)(-dyUnconsumed), (int)0, (int)(this.headerConfig.getInitialVisibleHeight() - top));
                    this.consumeOffset(coordinatorLayout, child, offset, type, true);
                }
            }
        } else if (dyUnconsumed > 0) {
            int footerMaxOffset;
            int bottom = child.getBottom() + this.configuration.getBottomMargin();
            if (bottom <= (footerMaxOffset = coordinatorLayout.getHeight() - this.footerConfig.getMaxOffset())) {
                return;
            }
            int offset = MathUtils.clamp((int)(-dyUnconsumed), (int)(footerMaxOffset - bottom), (int)0);
            if (offset != 0) {
                if (coordinatorLayout.getHeight() - bottom >= this.footerConfig.getInitialVisibleHeight()) {
                    if (type != 0) {
                        return;
                    }
                    this.consumeOffset(coordinatorLayout, child, offset, type, false);
                } else {
                    offset = MathUtils.clamp((int)(-dyUnconsumed), (int)(-(this.footerConfig.getInitialVisibleHeight() - coordinatorLayout.getHeight() + bottom)), (int)0);
                    this.consumeOffset(coordinatorLayout, child, offset, type, true);
                }
            }
        }
    }

    public void onStopNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, int type) {
        for (AnimationOffsetBehavior.ScrollingListener l : this.mListeners) {
            l.onStopScroll(coordinatorLayout, (View)child, this.getTopAndBottomOffset(), this.headerConfig.getInitialVisibleHeight(), this.headerConfig.getInitialVisibleHeight() + this.headerConfig.getRefreshTriggerRange(), this.configuration.getMinOffset(), this.configuration.getMaxOffset(), type);
        }
    }

    public boolean onNestedPreFling(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, float velocityX, float velocityY) {
        int top = child.getTop() - this.configuration.getTopMargin();
        int bottom = child.getBottom() + this.configuration.getBottomMargin();
        if (top > this.headerConfig.getInitialVisibleHeight() || -bottom + this.getParent().getHeight() > this.footerConfig.getInitialVisibleHeight()) {
            return true;
        }
        return super.onNestedPreFling(coordinatorLayout, child, target, velocityX, velocityY);
    }

    private int consumeOffset(CoordinatorLayout coordinatorLayout, V child, int offsetDelta, int type, boolean consumeRawOffset) {
        int currentOffset = this.getTopAndBottomOffset();
        for (AnimationOffsetBehavior.ScrollingListener l : this.mListeners) {
            l.onPreScroll(coordinatorLayout, (View)child, currentOffset, this.headerConfig.getInitialVisibleHeight(), this.headerConfig.getInitialVisibleHeight() + this.headerConfig.getRefreshTriggerRange(), this.configuration.getMinOffset(), this.configuration.getMaxOffset(), type);
        }
        float consumed = consumeRawOffset ? (float)offsetDelta : this.onConsumeOffset(currentOffset, this.configuration.getMaxOffset(), offsetDelta);
        currentOffset = Math.round((float)currentOffset + consumed);
        this.setTopAndBottomOffset(currentOffset);
        coordinatorLayout.dispatchDependentViewsChanged(child);
        for (AnimationOffsetBehavior.ScrollingListener l : this.mListeners) {
            l.onScroll(coordinatorLayout, (View)child, currentOffset, offsetDelta, this.headerConfig.getInitialVisibleHeight(), this.headerConfig.getInitialVisibleHeight() + this.headerConfig.getRefreshTriggerRange(), this.configuration.getMinOffset(), this.configuration.getMaxOffset(), type);
        }
        return currentOffset;
    }

    protected float onConsumeOffset(int current, int max, int delta) {
        return delta;
    }

    public void setContentTopAndBottomOffset(CoordinatorLayout coordinatorLayout, V child, int offset, int type) {
        int currentOffset = this.getTopAndBottomOffset();
        int offsetDelta = offset - currentOffset;
        for (AnimationOffsetBehavior.ScrollingListener l : this.mListeners) {
            l.onPreScroll(coordinatorLayout, (View)child, currentOffset, this.headerConfig.getInitialVisibleHeight(), this.headerConfig.getInitialVisibleHeight() + this.headerConfig.getRefreshTriggerRange(), this.configuration.getMinOffset(), this.configuration.getMaxOffset(), type);
        }
        this.setTopAndBottomOffset(offset);
        coordinatorLayout.dispatchDependentViewsChanged(child);
        for (AnimationOffsetBehavior.ScrollingListener l : this.mListeners) {
            l.onScroll(coordinatorLayout, (View)child, currentOffset, offsetDelta, this.headerConfig.getInitialVisibleHeight(), this.headerConfig.getInitialVisibleHeight() + this.headerConfig.getRefreshTriggerRange(), this.configuration.getMinOffset(), this.configuration.getMaxOffset(), type);
        }
    }

    public void stopScroll(boolean holdOn) {
        this.cancelAnimation();
        if (null == this.getChild() || this.getParent() == null) {
            return;
        }
        if (this.getChild().getTop() - this.configuration.getTopMargin() > this.headerConfig.getInitialVisibleHeight() || this.getChild().getTop() - this.configuration.getTopMargin() < this.configuration.getMinOffset() || this.getChild().getBottom() + this.configuration.getBottomMargin() < -this.footerConfig.getInitialVisibleHeight() + this.getParent().getHeight()) {
            this.handler.removeCallbacks(this.offsetCallback);
            this.offsetCallback = new Runnable(){

                @Override
                public void run() {
                    ScrollingContentBehavior.this.reset(300L);
                }
            };
            this.handler.postDelayed(this.offsetCallback, holdOn ? 500L : 0L);
        }
    }

    public void reset(long animateDuration) {
        if (null == this.getChild() || this.getParent() == null) {
            return;
        }
        CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)this.getChild().getLayoutParams();
        int top = this.getChild().getTop() - lp.topMargin;
        int bottom = this.getChild().getBottom() + lp.bottomMargin;
        int offset = 0;
        offset = -bottom + this.getParent().getHeight() > 0 ? -this.footerConfig.getInitialVisibleHeight() + this.getParent().getHeight() - bottom : this.headerConfig.getInitialVisibleHeight() - top;
        this.animateOffsetDeltaWithDuration(this.getParent(), (View)this.getChild(), offset, this.headerConfig.getInitialVisibleHeight(), this.headerConfig.getInitialVisibleHeight() + this.headerConfig.getRefreshTriggerRange(), this.configuration.getMinOffset(), this.configuration.getMaxOffset(), animateDuration, 1);
    }

    public void refreshHeader(long animateDuration) {
        if (null == this.getChild() || null == this.getParent()) {
            return;
        }
        int top = this.getChild().getTop() - this.configuration.getTopMargin();
        int offset = 0;
        offset = this.headerConfig.getShowUpWhenRefresh() == null ? this.headerConfig.getInitialVisibleHeight() + this.headerConfig.getRefreshTriggerRange() - top : (this.headerConfig.getShowUpWhenRefresh() != false ? this.headerConfig.getHeight() - top : this.headerConfig.getInitialVisibleHeight() - top);
        this.animateOffsetDeltaWithDuration(this.getParent(), (View)this.getChild(), offset, this.headerConfig.getInitialVisibleHeight(), this.headerConfig.getInitialVisibleHeight() + this.headerConfig.getRefreshTriggerRange(), this.configuration.getMinOffset(), this.configuration.getMaxOffset(), animateDuration, 1);
    }

    public void showHeader(long animateDuration) {
        if (null == this.getChild() || null == this.getParent()) {
            return;
        }
        int offset = this.headerConfig.getHeight() + this.headerConfig.getBottomMargin() - (this.getChild().getTop() - this.configuration.getTopMargin());
        this.animateOffsetDeltaWithDuration(this.getParent(), (View)this.getChild(), offset, this.headerConfig.getInitialVisibleHeight(), this.headerConfig.getInitialVisibleHeight() + this.headerConfig.getRefreshTriggerRange(), this.configuration.getMinOffset(), this.configuration.getMaxOffset(), animateDuration, 1);
    }

    public void refreshFooter(long animationDuration) {
        if (null == this.getChild() || this.getParent() == null) {
            return;
        }
        CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)this.getChild().getLayoutParams();
        int bottom = this.getChild().getBottom() + lp.bottomMargin;
        int offset = 0;
        offset = this.footerConfig.getShowUpWhenRefresh() == null ? -(this.footerConfig.getInitialVisibleHeight() + this.footerConfig.getRefreshTriggerRange()) + this.getParent().getHeight() - bottom : (this.footerConfig.getShowUpWhenRefresh() != false ? this.getParent().getHeight() - this.footerConfig.getHeight() - bottom : -this.footerConfig.getInitialVisibleHeight() + this.getParent().getHeight() - bottom);
        this.animateOffsetDeltaWithDuration(this.getParent(), (View)this.getChild(), offset, this.headerConfig.getInitialVisibleHeight(), this.headerConfig.getInitialVisibleHeight() + this.headerConfig.getRefreshTriggerRange(), this.configuration.getMinOffset(), this.configuration.getMaxOffset(), animationDuration, 1);
    }

    public void showFooter(long animationDuration) {
        if (null == this.getChild() || this.getParent() == null) {
            return;
        }
        CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)this.getChild().getLayoutParams();
        int bottom = this.getChild().getBottom() + lp.bottomMargin;
        int offset = this.getParent().getHeight() - this.footerConfig.getHeight() - this.footerConfig.getTopMargin() - bottom;
        this.animateOffsetDeltaWithDuration(this.getParent(), (View)this.getChild(), offset, this.headerConfig.getInitialVisibleHeight(), this.headerConfig.getInitialVisibleHeight() + this.headerConfig.getRefreshTriggerRange(), this.configuration.getMinOffset(), this.configuration.getMaxOffset(), animationDuration, 1);
    }

    public boolean isMinOffsetReached() {
        int top = this.getChild().getTop() - this.configuration.getTopMargin();
        return top <= this.configuration.getMinOffset();
    }

    public BehaviorConfiguration createIndicatorConfig() {
        return new BehaviorConfiguration.Builder().setDefaultRefreshTriggerRange(this.configuration.getDefaultRefreshTriggerRange()).setRefreshTriggerRange(this.configuration.getDefaultRefreshTriggerRange()).build();
    }

    public void setHeaderConfig(BehaviorConfiguration headerConfig) {
        this.headerConfig = new BehaviorConfiguration.Builder(headerConfig).setSettled(false).build();
        this.configuration.setMinOffset(Math.min(this.configuration.getCachedMinOffset(), headerConfig.getInitialVisibleHeight()));
        this.requestLayout();
    }

    public void setFooterConfig(BehaviorConfiguration footerConfig) {
        this.footerConfig = new BehaviorConfiguration.Builder(footerConfig).setSettled(false).build();
        this.requestLayout();
    }

    private int getHeaderInitialVisibleHeight() {
        int initialVisibleHeight = this.headerConfig.getHeight() <= 0 || this.headerConfig.getVisibleHeight() <= 0 ? this.headerConfig.getVisibleHeight() : (this.headerConfig.getVisibleHeight() >= this.headerConfig.getHeight() ? this.headerConfig.getVisibleHeight() + this.headerConfig.getTopMargin() + this.headerConfig.getBottomMargin() : this.headerConfig.getVisibleHeight() + this.headerConfig.getBottomMargin());
        return initialVisibleHeight;
    }

    @Override
    public ContentBehaviorController getController() {
        return (ContentBehaviorController)super.getController();
    }

    public BehaviorConfiguration getHeaderConfig() {
        return this.headerConfig;
    }

    public BehaviorConfiguration getFooterConfig() {
        return this.footerConfig;
    }

    public Parcelable onSaveInstanceState(CoordinatorLayout parent, V child) {
        Parcelable superState = super.onSaveInstanceState(parent, child);
        int topAndBottomOffset = this.getTopAndBottomOffset();
        SavedState ss = new SavedState(superState);
        ss.topAndBottomOffset = topAndBottomOffset;
        return ss;
    }

    public void onRestoreInstanceState(CoordinatorLayout parent, V child, Parcelable state) {
        if (state instanceof SavedState) {
            super.onRestoreInstanceState(parent, child, ((SavedState)state).getSuperState());
            SavedState ss = (SavedState)state;
            this.initialOffset = ss.topAndBottomOffset;
        } else {
            super.onRestoreInstanceState(parent, child, state);
        }
    }

    protected static class SavedState
    extends AbsSavedState {
        private int topAndBottomOffset;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel source, ClassLoader loader) {
                return new SavedState(source, loader);
            }

            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(@NonNull Parcelable superState) {
            super(superState);
        }

        public SavedState(@NonNull Parcel source, @Nullable ClassLoader loader) {
            super(source, loader);
            this.topAndBottomOffset = source.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.topAndBottomOffset);
        }
    }
}

