/*
 * Decompiled with CFR 0.152.
 */
package com.androidpi.literefresh.behavior;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.design.widget.CoordinatorLayout;
import android.util.AttributeSet;
import android.view.View;
import com.androidpi.literefresh.OnRefreshListener;
import com.androidpi.literefresh.OnScrollListener;
import com.androidpi.literefresh.R;
import com.androidpi.literefresh.Refresher;
import com.androidpi.literefresh.behavior.BehaviorConfiguration;
import com.androidpi.literefresh.behavior.ScrollingContentBehavior;
import com.androidpi.literefresh.behavior.VerticalIndicatorBehavior;
import com.androidpi.literefresh.controller.HeaderBehaviorController;

public class RefreshHeaderBehavior<V extends View>
extends VerticalIndicatorBehavior<V, HeaderBehaviorController>
implements Refresher {
    public RefreshHeaderBehavior(Context context) {
        this(context, null);
    }

    public RefreshHeaderBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.controller = new HeaderBehaviorController(this);
        this.addScrollListener(this.controller);
        this.runWithView(new Runnable(){

            @Override
            public void run() {
                ScrollingContentBehavior contentBehavior = RefreshHeaderBehavior.this.getContentBehavior(RefreshHeaderBehavior.this.getParent(), (View)RefreshHeaderBehavior.this.getChild());
                if (contentBehavior != null) {
                    ((HeaderBehaviorController)RefreshHeaderBehavior.this.controller).setProxy(contentBehavior.getController());
                }
            }
        });
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.IndicatorBehavior, 0, 0);
        if (a.hasValue(R.styleable.IndicatorBehavior_lr_mode)) {
            int mode = a.getInt(R.styleable.IndicatorBehavior_lr_mode, 0);
            ((HeaderBehaviorController)this.controller).setMode(mode);
        }
        a.recycle();
    }

    @Override
    public boolean onLayoutChild(CoordinatorLayout parent, V child, int layoutDirection) {
        boolean handled = super.onLayoutChild(parent, child, layoutDirection);
        CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)child.getLayoutParams();
        if (this.configuration.isUseDefaultMaxOffset()) {
            this.configuration.setMaxOffset((int)Math.max(0.618f * (float)parent.getHeight(), (float)child.getHeight()));
        } else {
            this.configuration.setMaxOffset((int)Math.max((float)this.configuration.getMaxOffset(), this.configuration.getMaxOffsetRatioOfParent() > this.configuration.getMaxOffsetRatio() ? this.configuration.getMaxOffsetRatio() * (float)parent.getHeight() : this.configuration.getMaxOffsetRatio() * (float)child.getHeight()));
        }
        this.configuration.setInitialVisibleHeight(this.getInitialVisibleHeight());
        if (this.configuration.getInitialVisibleHeight() <= 0) {
            this.configuration.setRefreshTriggerRange(this.configuration.getRefreshTriggerRange() + lp.bottomMargin);
        }
        this.configuration.setMaxOffset(Math.max(this.configuration.getMaxOffset(), this.configuration.getInitialVisibleHeight() + this.configuration.getRefreshTriggerRange()));
        if (!this.configuration.isSettled()) {
            this.configuration.setSettled(true);
            ScrollingContentBehavior contentBehavior = this.getContentBehavior(parent, (View)child);
            if (contentBehavior != null) {
                contentBehavior.setHeaderConfig(this.configuration);
            }
            this.setTopAndBottomOffset(-this.configuration.getInvisibleHeight());
        }
        return handled;
    }

    public void addOnScrollListener(OnScrollListener listener) {
        ((HeaderBehaviorController)this.controller).addOnScrollListener(listener);
    }

    public void addOnRefreshListener(OnRefreshListener listener) {
        ((HeaderBehaviorController)this.controller).addOnRefreshListener(listener);
    }

    @Override
    public HeaderBehaviorController getController() {
        return (HeaderBehaviorController)super.getController();
    }

    @Override
    public void refresh() {
        ((HeaderBehaviorController)this.controller).refresh();
    }

    @Override
    public void refreshComplete() {
        ((HeaderBehaviorController)this.controller).refreshComplete();
    }

    @Override
    public void refreshError(Throwable throwable) {
        ((HeaderBehaviorController)this.controller).refreshError(throwable);
    }

    @Override
    protected int getInitialOffset(@NonNull CoordinatorLayout parent, @NonNull View child) {
        return this.configuration.getVisibleHeight();
    }

    @Override
    protected int getRefreshTriggerOffset(@NonNull CoordinatorLayout parent, @NonNull View child) {
        return this.configuration.getVisibleHeight() + this.configuration.getRefreshTriggerRange();
    }

    @Override
    protected int getMinOffset(@NonNull CoordinatorLayout parent, @NonNull View child) {
        BehaviorConfiguration contentConfig = this.getContentBehavior(parent, child).getConfiguration();
        return contentConfig.getMinOffset() - this.configuration.getBottomMargin();
    }

    @Override
    protected int getMaxOffset(@NonNull CoordinatorLayout parent, @NonNull View child) {
        BehaviorConfiguration contentConfig = this.getContentBehavior(parent, child).getConfiguration();
        return contentConfig.getMaxOffset() - (contentConfig.getMaxOffset() > this.configuration.getBottomMargin() ? this.configuration.getBottomMargin() : 0);
    }

    private int getInitialVisibleHeight() {
        int initialVisibleHeight = this.configuration.getHeight() <= 0 || this.configuration.getVisibleHeight() <= 0 ? this.configuration.getVisibleHeight() : (this.configuration.getVisibleHeight() >= this.configuration.getHeight() ? this.configuration.getVisibleHeight() + this.configuration.getTopMargin() + this.configuration.getBottomMargin() : this.configuration.getVisibleHeight() + this.configuration.getBottomMargin());
        return initialVisibleHeight;
    }
}

