/*
 * Decompiled with CFR 0.152.
 */
package com.androidpi.literefresh.behavior;

import android.support.annotation.NonNull;
import android.support.design.widget.CoordinatorLayout;
import android.view.View;
import com.androidpi.literefresh.Loader;
import com.androidpi.literefresh.OnLoadListener;
import com.androidpi.literefresh.OnRefreshListener;
import com.androidpi.literefresh.OnScrollListener;
import com.androidpi.literefresh.Refresher;
import com.androidpi.literefresh.behavior.AnimationOffsetBehavior;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BehaviorController<B extends AnimationOffsetBehavior>
implements AnimationOffsetBehavior.ScrollingListener,
Refresher,
Loader {
    protected BehaviorController proxy;
    protected B behavior;
    protected List<OnScrollListener> mScrollListeners;
    protected List<OnRefreshListener> mRefreshListeners;
    protected List<OnLoadListener> mLoadListeners;

    public BehaviorController(B behavior) {
        this.behavior = behavior;
    }

    @Override
    public void onStartScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull View child, int initial, int trigger, int min, int max, int type) {
        if (this.mScrollListeners == null) {
            return;
        }
        for (OnScrollListener l : this.mScrollListeners) {
            l.onStartScroll(coordinatorLayout, child, initial, trigger, min, max, type);
        }
    }

    @Override
    public void onPreScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull View child, int current, int initial, int trigger, int min, int max, int type) {
    }

    @Override
    public void onScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull View child, int current, int delta, int initial, int trigger, int min, int max, int type) {
        if (this.mScrollListeners == null) {
            return;
        }
        for (OnScrollListener l : this.mScrollListeners) {
            l.onScroll(coordinatorLayout, child, current, delta, initial, trigger, min, max, type);
        }
    }

    @Override
    public void onStopScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull View child, int current, int initial, int trigger, int min, int max, int type) {
        if (this.mScrollListeners == null) {
            return;
        }
        for (OnScrollListener l : this.mScrollListeners) {
            l.onStopScroll(coordinatorLayout, child, current, initial, trigger, min, max, type);
        }
    }

    @Override
    public void refresh() {
        if (this.proxy == null) {
            this.runWithView(new Runnable(){

                @Override
                public void run() {
                    BehaviorController.this.refresh();
                }
            });
        } else {
            this.runWithView(new Runnable(){

                @Override
                public void run() {
                    if (BehaviorController.this.proxy != null) {
                        BehaviorController.this.copyRemainListeners();
                        BehaviorController.this.proxy.refresh();
                    }
                }
            });
        }
    }

    @Override
    public void refreshComplete() {
        this.runWithView(new Runnable(){

            @Override
            public void run() {
                if (BehaviorController.this.proxy != null) {
                    BehaviorController.this.proxy.refreshComplete();
                }
            }
        });
    }

    @Override
    public void refreshError(final Throwable throwable) {
        this.runWithView(new Runnable(){

            @Override
            public void run() {
                if (BehaviorController.this.proxy != null) {
                    BehaviorController.this.proxy.refreshError(throwable);
                }
            }
        });
    }

    @Override
    public void load() {
        if (this.proxy == null) {
            this.runWithView(new Runnable(){

                @Override
                public void run() {
                    BehaviorController.this.load();
                }
            });
        } else {
            this.runWithView(new Runnable(){

                @Override
                public void run() {
                    if (BehaviorController.this.proxy != null) {
                        BehaviorController.this.copyRemainListeners();
                        BehaviorController.this.proxy.load();
                    }
                }
            });
        }
    }

    @Override
    public void loadComplete() {
        this.runWithView(new Runnable(){

            @Override
            public void run() {
                if (BehaviorController.this.proxy != null) {
                    BehaviorController.this.proxy.loadComplete();
                }
            }
        });
    }

    @Override
    public void loadError(final Throwable throwable) {
        this.runWithView(new Runnable(){

            @Override
            public void run() {
                if (BehaviorController.this.proxy != null) {
                    BehaviorController.this.proxy.loadError(throwable);
                }
            }
        });
    }

    public BehaviorController getProxy() {
        return this.proxy;
    }

    public void setProxy(BehaviorController proxy) {
        this.proxy = proxy;
        if (proxy != null) {
            this.copyRemainListeners();
            ((AnimationOffsetBehavior)((Object)this.behavior)).executePendingActions();
        }
    }

    public void copyRemainListeners() {
        if (this.mRefreshListeners != null && !this.mRefreshListeners.isEmpty()) {
            Iterator<OnRefreshListener> iterator = this.mRefreshListeners.iterator();
            while (iterator.hasNext()) {
                this.proxy.addOnRefreshListener(iterator.next());
                iterator.remove();
            }
        }
        if (this.mLoadListeners != null && !this.mLoadListeners.isEmpty()) {
            Iterator<OnLoadListener> loadListenerIterator = this.mLoadListeners.iterator();
            while (loadListenerIterator.hasNext()) {
                this.proxy.addOnLoadListener(loadListenerIterator.next());
                loadListenerIterator.remove();
            }
        }
    }

    public B getBehavior() {
        return this.behavior;
    }

    public void setBehavior(B behavior) {
        this.behavior = behavior;
    }

    public void addOnScrollListener(OnScrollListener listener) {
        if (null == listener) {
            return;
        }
        if (this.mScrollListeners != null && this.mScrollListeners.contains(listener)) {
            return;
        }
        if (this.mScrollListeners == null) {
            this.mScrollListeners = new ArrayList<OnScrollListener>();
        }
        this.mScrollListeners.add(listener);
    }

    public void addOnRefreshListener(final OnRefreshListener listener) {
        if (null == listener) {
            return;
        }
        if (this.mRefreshListeners != null && this.mRefreshListeners.contains(listener)) {
            return;
        }
        if (this.mRefreshListeners == null) {
            this.mRefreshListeners = new ArrayList<OnRefreshListener>();
        }
        this.runWithView(new Runnable(){

            @Override
            public void run() {
                if (BehaviorController.this.proxy != null) {
                    BehaviorController.this.proxy.addOnRefreshListener(listener);
                } else {
                    BehaviorController.this.mRefreshListeners.add(listener);
                }
            }
        });
    }

    public void addOnLoadListener(final OnLoadListener listener) {
        if (null == listener) {
            return;
        }
        if (this.mLoadListeners != null && this.mLoadListeners.contains(listener)) {
            return;
        }
        if (this.mLoadListeners == null) {
            this.mLoadListeners = new ArrayList<OnLoadListener>();
        }
        this.runWithView(new Runnable(){

            @Override
            public void run() {
                if (BehaviorController.this.proxy != null) {
                    BehaviorController.this.proxy.addOnLoadListener(listener);
                } else {
                    BehaviorController.this.mLoadListeners.add(listener);
                }
            }
        });
    }

    protected boolean hasOnLoadListeners() {
        return this.mLoadListeners != null && !this.mLoadListeners.isEmpty();
    }

    protected boolean hasOnRefreshListeners() {
        return this.mRefreshListeners != null && !this.mRefreshListeners.isEmpty();
    }

    protected void runWithView(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        ((AnimationOffsetBehavior)((Object)this.behavior)).runWithView(runnable);
    }

    protected void runOnUiThread(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        ((AnimationOffsetBehavior)((Object)this.behavior)).runOnUiThread(runnable);
    }
}

