/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions.lazy;

import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;

public class LazyMarker {
    private static boolean GOOGLE_PLAY_SERVICES_4_0 = true;
    private static boolean GOOGLE_PLAY_SERVICES_9_2 = true;
    private Marker marker;
    private GoogleMap map;
    private MarkerOptions markerOptions;
    private OnMarkerCreateListener listener;

    public LazyMarker(GoogleMap map, MarkerOptions options) {
        this(map, options, null);
    }

    public LazyMarker(GoogleMap map, MarkerOptions options, OnMarkerCreateListener listener) {
        if (options.isVisible()) {
            this.createMarker(map, options, listener);
        } else {
            this.map = map;
            this.markerOptions = LazyMarker.copy(options);
            this.listener = listener;
        }
    }

    public float getAlpha() {
        if (this.marker != null) {
            return this.marker.getAlpha();
        }
        return this.markerOptions.getAlpha();
    }

    @Deprecated
    public String getId() {
        this.createMarker();
        return this.marker.getId();
    }

    public Marker getMarker() {
        return this.marker;
    }

    public LatLng getPosition() {
        if (this.marker != null) {
            return this.marker.getPosition();
        }
        return this.markerOptions.getPosition();
    }

    public float getRotation() {
        if (this.marker != null) {
            return this.marker.getRotation();
        }
        return this.markerOptions.getRotation();
    }

    public String getSnippet() {
        if (this.marker != null) {
            return this.marker.getSnippet();
        }
        return this.markerOptions.getSnippet();
    }

    @Deprecated
    public Object getTag() {
        this.createMarker();
        return this.marker.getTag();
    }

    public String getTitle() {
        if (this.marker != null) {
            return this.marker.getTitle();
        }
        return this.markerOptions.getTitle();
    }

    public float getZIndex() {
        if (this.marker != null) {
            return this.marker.getZIndex();
        }
        return this.markerOptions.getZIndex();
    }

    public void hideInfoWindow() {
        if (this.marker != null) {
            this.marker.hideInfoWindow();
        }
    }

    public boolean isDraggable() {
        if (this.marker != null) {
            return this.marker.isDraggable();
        }
        return this.markerOptions.isDraggable();
    }

    public boolean isFlat() {
        if (this.marker != null) {
            return this.marker.isFlat();
        }
        return this.markerOptions.isFlat();
    }

    public boolean isInfoWindowShown() {
        if (this.marker != null) {
            return this.marker.isInfoWindowShown();
        }
        return false;
    }

    public boolean isVisible() {
        if (this.marker != null) {
            return this.marker.isVisible();
        }
        return false;
    }

    public void remove() {
        if (this.marker != null) {
            this.marker.remove();
            this.marker = null;
        } else {
            this.map = null;
            this.markerOptions = null;
            this.listener = null;
        }
    }

    public void setAlpha(float alpha) {
        if (this.marker != null) {
            this.marker.setAlpha(alpha);
        } else {
            this.markerOptions.alpha(alpha);
        }
    }

    public void setAnchor(float anchorU, float anchorV) {
        if (this.marker != null) {
            this.marker.setAnchor(anchorU, anchorV);
        } else {
            this.markerOptions.anchor(anchorU, anchorV);
        }
    }

    public void setDraggable(boolean draggable) {
        if (this.marker != null) {
            this.marker.setDraggable(draggable);
        } else {
            this.markerOptions.draggable(draggable);
        }
    }

    public void setFlat(boolean flat) {
        if (this.marker != null) {
            this.marker.setFlat(flat);
        } else {
            this.markerOptions.flat(flat);
        }
    }

    public void setIcon(BitmapDescriptor icon) {
        if (this.marker != null) {
            this.marker.setIcon(icon);
        } else {
            this.markerOptions.icon(icon);
        }
    }

    public void setInfoWindowAnchor(float anchorU, float anchorV) {
        if (this.marker != null) {
            this.marker.setInfoWindowAnchor(anchorU, anchorV);
        } else {
            this.markerOptions.infoWindowAnchor(anchorU, anchorV);
        }
    }

    public void setPosition(LatLng position) {
        if (this.marker != null) {
            this.marker.setPosition(position);
        } else {
            this.markerOptions.position(position);
        }
    }

    public void setRotation(float rotation) {
        if (this.marker != null) {
            this.marker.setRotation(rotation);
        } else {
            this.markerOptions.rotation(rotation);
        }
    }

    public void setSnippet(String snippet) {
        if (this.marker != null) {
            this.marker.setSnippet(snippet);
        } else {
            this.markerOptions.snippet(snippet);
        }
    }

    @Deprecated
    public void setTag(Object tag) {
        this.createMarker();
        this.marker.setTag(tag);
    }

    public void setTitle(String title) {
        if (this.marker != null) {
            this.marker.setTitle(title);
        } else {
            this.markerOptions.title(title);
        }
    }

    public void setVisible(boolean visible) {
        if (this.marker != null) {
            this.marker.setVisible(visible);
        } else if (visible) {
            this.markerOptions.visible(true);
            this.createMarker();
        }
    }

    public void zIndex(float zIndex) {
        if (this.marker != null) {
            this.marker.setZIndex(zIndex);
        } else {
            this.markerOptions.zIndex(zIndex);
        }
    }

    public void showInfoWindow() {
        if (this.marker != null) {
            this.marker.showInfoWindow();
        }
    }

    private void createMarker() {
        if (this.marker == null) {
            this.createMarker(this.map, this.markerOptions, this.listener);
            this.map = null;
            this.markerOptions = null;
            this.listener = null;
        }
    }

    private void createMarker(GoogleMap map, MarkerOptions options, OnMarkerCreateListener listener) {
        this.marker = map.addMarker(options);
        if (listener != null) {
            listener.onMarkerCreate(this);
        }
    }

    private static MarkerOptions copy(MarkerOptions options) {
        MarkerOptions copy = new MarkerOptions();
        if (GOOGLE_PLAY_SERVICES_4_0) {
            try {
                copy.alpha(options.getAlpha());
            }
            catch (NoSuchMethodError error) {
                GOOGLE_PLAY_SERVICES_4_0 = false;
            }
        }
        copy.anchor(options.getAnchorU(), options.getAnchorV());
        copy.draggable(options.isDraggable());
        copy.flat(options.isFlat());
        copy.icon(options.getIcon());
        copy.infoWindowAnchor(options.getInfoWindowAnchorU(), options.getInfoWindowAnchorV());
        copy.position(options.getPosition());
        copy.rotation(options.getRotation());
        copy.snippet(options.getSnippet());
        copy.title(options.getTitle());
        copy.visible(options.isVisible());
        if (GOOGLE_PLAY_SERVICES_9_2) {
            try {
                copy.zIndex(options.getZIndex());
            }
            catch (NoSuchMethodError error) {
                GOOGLE_PLAY_SERVICES_9_2 = false;
            }
        }
        return copy;
    }

    public static interface OnMarkerCreateListener {
        public void onMarkerCreate(LazyMarker var1);
    }
}

