/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions.impl;

import com.androidmapsextensions.GoogleMap;
import com.androidmapsextensions.Polygon;
import com.androidmapsextensions.PolygonOptions;
import com.androidmapsextensions.impl.DelegatingPolygon;
import com.androidmapsextensions.impl.IGoogleMap;
import com.google.android.gms.maps.GoogleMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PolygonManager {
    private final IGoogleMap factory;
    private final Map<com.google.android.gms.maps.model.Polygon, Polygon> polygons;

    public PolygonManager(IGoogleMap factory) {
        this.factory = factory;
        this.polygons = new HashMap<com.google.android.gms.maps.model.Polygon, Polygon>();
    }

    public Polygon addPolygon(PolygonOptions polygonOptions) {
        Polygon polygon = this.createPolygon(polygonOptions.real);
        polygon.setData(polygonOptions.getData());
        return polygon;
    }

    private Polygon createPolygon(com.google.android.gms.maps.model.PolygonOptions polygonOptions) {
        com.google.android.gms.maps.model.Polygon real = this.factory.addPolygon(polygonOptions);
        DelegatingPolygon polygon = new DelegatingPolygon(real, this);
        this.polygons.put(real, polygon);
        return polygon;
    }

    public void clear() {
        this.polygons.clear();
    }

    public List<Polygon> getPolygons() {
        return new ArrayList<Polygon>(this.polygons.values());
    }

    public void onRemove(com.google.android.gms.maps.model.Polygon real) {
        this.polygons.remove(real);
    }

    public void setOnPolygonClickListener(GoogleMap.OnPolygonClickListener onPolygonClickListener) {
        DelegatingOnPolygonClickListener realOnPolygonClickListener = null;
        if (onPolygonClickListener != null) {
            realOnPolygonClickListener = new DelegatingOnPolygonClickListener(onPolygonClickListener);
        }
        this.factory.setOnPolygonClickListener(realOnPolygonClickListener);
    }

    private class DelegatingOnPolygonClickListener
    implements GoogleMap.OnPolygonClickListener {
        private final GoogleMap.OnPolygonClickListener onPolygonClickListener;

        public DelegatingOnPolygonClickListener(GoogleMap.OnPolygonClickListener onPolygonClickListener) {
            this.onPolygonClickListener = onPolygonClickListener;
        }

        public void onPolygonClick(com.google.android.gms.maps.model.Polygon polygon) {
            this.onPolygonClickListener.onPolygonClick((Polygon)PolygonManager.this.polygons.get(polygon));
        }
    }
}

