/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions.impl;

import android.os.SystemClock;
import com.androidmapsextensions.AnimationSettings;
import com.androidmapsextensions.ClusteringSettings;
import com.androidmapsextensions.Marker;
import com.androidmapsextensions.MarkerOptions;
import com.androidmapsextensions.impl.ClusterRefresher;
import com.androidmapsextensions.impl.ClusteringStrategy;
import com.androidmapsextensions.impl.DelegatingMarker;
import com.androidmapsextensions.impl.DynamicNoClusteringStrategy;
import com.androidmapsextensions.impl.GridClusteringStrategy;
import com.androidmapsextensions.impl.IGoogleMap;
import com.androidmapsextensions.impl.MarkerAnimator;
import com.androidmapsextensions.impl.NoClusteringStrategy;
import com.androidmapsextensions.lazy.LazyMarker;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class MarkerManager
implements LazyMarker.OnMarkerCreateListener {
    private final IGoogleMap factory;
    private final Map<LazyMarker, DelegatingMarker> markers;
    private final Map<com.google.android.gms.maps.model.Marker, LazyMarker> createdMarkers;
    private Marker markerShowingInfoWindow;
    private ClusteringSettings clusteringSettings = new ClusteringSettings().enabled(false);
    private ClusteringStrategy clusteringStrategy = new NoClusteringStrategy(new ArrayList<DelegatingMarker>());
    private final MarkerAnimator markerAnimator = new MarkerAnimator();

    public MarkerManager(IGoogleMap factory) {
        this.factory = factory;
        this.markers = new HashMap<LazyMarker, DelegatingMarker>();
        this.createdMarkers = new HashMap<com.google.android.gms.maps.model.Marker, LazyMarker>();
    }

    public Marker addMarker(MarkerOptions markerOptions) {
        boolean visible = markerOptions.isVisible();
        markerOptions.visible(false);
        DelegatingMarker marker = this.createMarker(markerOptions.real);
        this.setExtendedOptions(marker, markerOptions);
        this.clusteringStrategy.onAdd(marker);
        marker.setVisible(visible);
        markerOptions.visible(visible);
        return marker;
    }

    private void setExtendedOptions(DelegatingMarker marker, MarkerOptions markerOptions) {
        marker.setClusterGroup(markerOptions.getClusterGroup());
        marker.setData(markerOptions.getData());
    }

    private DelegatingMarker createMarker(com.google.android.gms.maps.model.MarkerOptions markerOptions) {
        LazyMarker realMarker = new LazyMarker(this.factory.getMap(), markerOptions, this);
        DelegatingMarker marker = new DelegatingMarker(realMarker, this);
        this.markers.put(realMarker, marker);
        return marker;
    }

    public void clear() {
        this.markers.clear();
        this.createdMarkers.clear();
        this.clusteringStrategy.cleanup();
    }

    public List<Marker> getDisplayedMarkers() {
        List<Marker> displayedMarkers = this.clusteringStrategy.getDisplayedMarkers();
        if (displayedMarkers == null) {
            displayedMarkers = this.getMarkers();
            Iterator<Marker> iterator = displayedMarkers.iterator();
            while (iterator.hasNext()) {
                Marker m = iterator.next();
                if (m.isVisible()) continue;
                iterator.remove();
            }
        }
        return displayedMarkers;
    }

    public List<Marker> getMarkers() {
        return new ArrayList<Marker>(this.markers.values());
    }

    public Marker getMarkerShowingInfoWindow() {
        if (this.markerShowingInfoWindow != null && !this.markerShowingInfoWindow.isInfoWindowShown()) {
            this.markerShowingInfoWindow = null;
        }
        return this.markerShowingInfoWindow;
    }

    public float getMinZoomLevelNotClustered(Marker marker) {
        return this.clusteringStrategy.getMinZoomLevelNotClustered(marker);
    }

    public void onAnimateMarkerPosition(DelegatingMarker marker, LatLng target, AnimationSettings settings, Marker.AnimationCallback callback) {
        this.markerAnimator.cancelAnimation(marker, Marker.AnimationCallback.CancelReason.ANIMATE_POSITION);
        this.markerAnimator.animate(marker, marker.getPosition(), target, SystemClock.uptimeMillis(), settings, callback);
    }

    public void onCameraChange(CameraPosition cameraPosition) {
        this.clusteringStrategy.onCameraChange(cameraPosition);
    }

    public void onClusterGroupChange(DelegatingMarker marker) {
        this.clusteringStrategy.onClusterGroupChange(marker);
    }

    public void onDragStart(DelegatingMarker marker) {
        this.markerAnimator.cancelAnimation(marker, Marker.AnimationCallback.CancelReason.DRAG_START);
    }

    public void onPositionChange(DelegatingMarker marker) {
        this.clusteringStrategy.onPositionChange(marker);
        this.markerAnimator.cancelAnimation(marker, Marker.AnimationCallback.CancelReason.SET_POSITION);
    }

    public void onPositionDuringAnimationChange(DelegatingMarker marker) {
        this.clusteringStrategy.onPositionChange(marker);
    }

    public void onRemove(DelegatingMarker marker) {
        this.markers.remove(marker.getReal());
        this.createdMarkers.remove(marker.getReal().getMarker());
        this.clusteringStrategy.onRemove(marker);
        this.markerAnimator.cancelAnimation(marker, Marker.AnimationCallback.CancelReason.REMOVE);
    }

    public void onShowInfoWindow(DelegatingMarker marker) {
        this.clusteringStrategy.onShowInfoWindow(marker);
    }

    public void onVisibilityChangeRequest(DelegatingMarker marker, boolean visible) {
        this.clusteringStrategy.onVisibilityChangeRequest(marker, visible);
    }

    public void setClustering(ClusteringSettings clusteringSettings) {
        if (clusteringSettings == null) {
            clusteringSettings = new ClusteringSettings().enabled(false);
        }
        if (!this.clusteringSettings.equals(clusteringSettings)) {
            this.clusteringSettings = clusteringSettings;
            this.clusteringStrategy.cleanup();
            ArrayList<DelegatingMarker> list = new ArrayList<DelegatingMarker>(this.markers.values());
            this.clusteringStrategy = clusteringSettings.isEnabled() ? new GridClusteringStrategy(clusteringSettings, this.factory, list, new ClusterRefresher()) : (clusteringSettings.isAddMarkersDynamically() ? new DynamicNoClusteringStrategy(this.factory, list) : new NoClusteringStrategy(list));
        }
    }

    public void setMarkerShowingInfoWindow(Marker marker) {
        this.markerShowingInfoWindow = marker;
    }

    @Override
    public void onMarkerCreate(LazyMarker marker) {
        this.createdMarkers.put(marker.getMarker(), marker);
    }

    public Marker map(com.google.android.gms.maps.model.Marker marker) {
        Marker cluster = this.clusteringStrategy.map(marker);
        if (cluster != null) {
            return cluster;
        }
        return this.mapToDelegatingMarker(marker);
    }

    public DelegatingMarker mapToDelegatingMarker(com.google.android.gms.maps.model.Marker marker) {
        LazyMarker lazy = this.createdMarkers.get(marker);
        DelegatingMarker delegating = this.markers.get(lazy);
        return delegating;
    }
}

