/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions.impl;

import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.view.animation.Interpolator;
import com.androidmapsextensions.AnimationSettings;
import com.androidmapsextensions.Marker;
import com.androidmapsextensions.impl.DelegatingMarker;
import com.google.android.gms.maps.model.LatLng;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class MarkerAnimator {
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            MarkerAnimator.this.calculatePositions();
            return true;
        }
    });
    private Map<DelegatingMarker, AnimationData> queue = new HashMap<DelegatingMarker, AnimationData>();

    MarkerAnimator() {
    }

    private void calculatePositions() {
        long now = SystemClock.uptimeMillis();
        Iterator<DelegatingMarker> iterator = this.queue.keySet().iterator();
        while (iterator.hasNext()) {
            DelegatingMarker marker = iterator.next();
            AnimationData data = this.queue.get(marker);
            long time = now - data.start;
            if (time <= 0L) {
                marker.setPositionDuringAnimation(data.from);
                continue;
            }
            if (time >= data.duration) {
                marker.setPositionDuringAnimation(data.to);
                if (data.callback != null) {
                    data.callback.onFinish(marker);
                }
                iterator.remove();
                continue;
            }
            float t = (float)time / (float)data.duration;
            t = data.interpolator.getInterpolation(t);
            double lat = (double)(1.0f - t) * ((AnimationData)data).from.latitude + (double)t * ((AnimationData)data).to.latitude;
            double lng = (double)(1.0f - t) * ((AnimationData)data).from.longitude + (double)t * ((AnimationData)data).to.longitude;
            marker.setPositionDuringAnimation(new LatLng(lat, lng));
        }
        if (this.queue.size() > 0) {
            this.handler.sendEmptyMessage(0);
        }
    }

    public void animate(DelegatingMarker marker, LatLng from, LatLng to, long start, AnimationSettings settings, Marker.AnimationCallback callback) {
        AnimationData data = new AnimationData();
        data.from = from;
        data.to = to;
        data.start = start;
        data.duration = settings.getDuration();
        data.interpolator = settings.getInterpolator();
        data.callback = callback;
        this.queue.put(marker, data);
        this.handler.removeMessages(0);
        this.handler.sendEmptyMessage(0);
    }

    public void cancelAnimation(DelegatingMarker marker, Marker.AnimationCallback.CancelReason reason) {
        AnimationData data = this.queue.remove(marker);
        if (data != null && data.callback != null) {
            data.callback.onCancel(marker, reason);
        }
    }

    private static class AnimationData {
        private LatLng from;
        private LatLng to;
        private long start;
        private long duration;
        private Interpolator interpolator;
        private Marker.AnimationCallback callback;

        private AnimationData() {
        }
    }
}

