/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions.impl;

import com.androidmapsextensions.GoogleMap;
import com.androidmapsextensions.GroundOverlay;
import com.androidmapsextensions.GroundOverlayOptions;
import com.androidmapsextensions.impl.DelegatingGroundOverlay;
import com.androidmapsextensions.impl.IGoogleMap;
import com.google.android.gms.maps.GoogleMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class GroundOverlayManager {
    private final IGoogleMap factory;
    private final Map<com.google.android.gms.maps.model.GroundOverlay, GroundOverlay> groundOverlays;

    public GroundOverlayManager(IGoogleMap factory) {
        this.factory = factory;
        this.groundOverlays = new HashMap<com.google.android.gms.maps.model.GroundOverlay, GroundOverlay>();
    }

    public GroundOverlay addGroundOverlay(GroundOverlayOptions groundOverlayOptions) {
        GroundOverlay groundOverlay = this.createGroundOverlay(groundOverlayOptions.real);
        groundOverlay.setData(groundOverlayOptions.getData());
        return groundOverlay;
    }

    private GroundOverlay createGroundOverlay(com.google.android.gms.maps.model.GroundOverlayOptions groundOverlayOptions) {
        com.google.android.gms.maps.model.GroundOverlay real = this.factory.addGroundOverlay(groundOverlayOptions);
        DelegatingGroundOverlay groundOverlay = new DelegatingGroundOverlay(real, this);
        this.groundOverlays.put(real, groundOverlay);
        return groundOverlay;
    }

    public void clear() {
        this.groundOverlays.clear();
    }

    public List<GroundOverlay> getGroundOverlays() {
        return new ArrayList<GroundOverlay>(this.groundOverlays.values());
    }

    public void onRemove(com.google.android.gms.maps.model.GroundOverlay real) {
        this.groundOverlays.remove(real);
    }

    public void setOnGroundOverlayClickListener(GoogleMap.OnGroundOverlayClickListener onGroundOverlayClickListener) {
        DelegatingOnGroundOverlayClickListener realOnGroundOverlayClickListener = null;
        if (onGroundOverlayClickListener != null) {
            realOnGroundOverlayClickListener = new DelegatingOnGroundOverlayClickListener(onGroundOverlayClickListener);
        }
        this.factory.setOnGroundOverlayClickListener(realOnGroundOverlayClickListener);
    }

    private class DelegatingOnGroundOverlayClickListener
    implements GoogleMap.OnGroundOverlayClickListener {
        private final GoogleMap.OnGroundOverlayClickListener onGroundOverlayClickListener;

        public DelegatingOnGroundOverlayClickListener(GoogleMap.OnGroundOverlayClickListener onGroundOverlayClickListener) {
            this.onGroundOverlayClickListener = onGroundOverlayClickListener;
        }

        public void onGroundOverlayClick(com.google.android.gms.maps.model.GroundOverlay groundOverlay) {
            this.onGroundOverlayClickListener.onGroundOverlayClick((GroundOverlay)GroundOverlayManager.this.groundOverlays.get(groundOverlay));
        }
    }
}

