/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions.impl;

import com.androidmapsextensions.ClusterOptions;
import com.androidmapsextensions.ClusterOptionsProvider;
import com.androidmapsextensions.ClusteringSettings;
import com.androidmapsextensions.Marker;
import com.androidmapsextensions.impl.ClusterMarker;
import com.androidmapsextensions.impl.ClusterRefresher;
import com.androidmapsextensions.impl.ClusteringStrategy;
import com.androidmapsextensions.impl.DebugHelper;
import com.androidmapsextensions.impl.DelegatingMarker;
import com.androidmapsextensions.impl.IGoogleMap;
import com.androidmapsextensions.impl.IProjection;
import com.androidmapsextensions.utils.SphericalMercator;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.VisibleRegion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class GridClusteringStrategy
implements ClusteringStrategy {
    private static boolean GOOGLE_PLAY_SERVICES_4_0 = true;
    private static boolean GOOGLE_PLAY_SERVICES_9_2 = true;
    private static final boolean DEBUG_GRID = false;
    private DebugHelper debugHelper;
    private final MarkerOptions markerOptions = new MarkerOptions();
    private boolean addMarkersDynamically;
    private double baseClusterSize;
    private int minMarkersCount;
    private IGoogleMap map;
    private Map<DelegatingMarker, ClusterMarker> markers;
    private double clusterSize;
    private int oldZoom;
    private int zoom;
    private int[] visibleClusters = new int[4];
    private Map<ClusterKey, ClusterMarker> clusters = new HashMap<ClusterKey, ClusterMarker>();
    private ClusterRefresher refresher;
    private ClusterOptionsProvider clusterOptionsProvider;

    public GridClusteringStrategy(ClusteringSettings settings, IGoogleMap map, List<DelegatingMarker> markers, ClusterRefresher refresher) {
        this.clusterOptionsProvider = settings.getClusterOptionsProvider();
        this.addMarkersDynamically = settings.isAddMarkersDynamically();
        this.baseClusterSize = settings.getClusterSize();
        this.minMarkersCount = settings.getMinMarkersCount();
        this.map = map;
        this.markers = new HashMap<DelegatingMarker, ClusterMarker>();
        this.refresher = refresher;
        this.zoom = Math.round(map.getCameraPosition().zoom);
        this.clusterSize = this.calculateClusterSize(this.zoom);
        this.addVisibleMarkers(markers);
    }

    @Override
    public void cleanup() {
        for (ClusterMarker cluster : this.clusters.values()) {
            cluster.cleanup();
        }
        this.clusters.clear();
        this.markers.clear();
        this.refresher.cleanup();
    }

    @Override
    public void onCameraChange(CameraPosition cameraPosition) {
        this.oldZoom = this.zoom;
        this.zoom = Math.round(cameraPosition.zoom);
        double clusterSize = this.calculateClusterSize(this.zoom);
        if (this.clusterSize != clusterSize) {
            this.clusterSize = clusterSize;
            this.recalculate();
        } else if (this.addMarkersDynamically) {
            this.addMarkersInVisibleRegion();
        }
    }

    @Override
    public void onClusterGroupChange(DelegatingMarker marker) {
        if (!marker.isVisible()) {
            return;
        }
        ClusterMarker oldCluster = this.markers.get(marker);
        if (oldCluster != null) {
            oldCluster.remove(marker);
            this.refresh(oldCluster);
        }
        this.addMarker(marker);
    }

    @Override
    public void onAdd(DelegatingMarker marker) {
        if (!marker.isVisible()) {
            return;
        }
        this.addMarker(marker);
    }

    private void addMarker(DelegatingMarker marker) {
        int clusterGroup = marker.getClusterGroup();
        if (clusterGroup < 0) {
            this.markers.put(marker, null);
            marker.changeVisible(true);
        } else {
            LatLng position = marker.getPosition();
            ClusterKey key = this.calculateClusterKey(clusterGroup, position);
            ClusterMarker cluster = this.findClusterById(key);
            cluster.add(marker);
            this.markers.put(marker, cluster);
            if (!this.addMarkersDynamically || this.isPositionInVisibleClusters(position)) {
                this.refresh(cluster);
            }
        }
    }

    private boolean isPositionInVisibleClusters(LatLng position) {
        int y = this.convLat(position.latitude);
        int x = this.convLng(position.longitude);
        int[] b = this.visibleClusters;
        return b[0] <= y && y <= b[2] && (b[1] <= x && x <= b[3] || b[1] > b[3] && (b[1] <= x || x <= b[3]));
    }

    @Override
    public void onRemove(DelegatingMarker marker) {
        if (!marker.isVisible()) {
            return;
        }
        this.removeMarker(marker);
    }

    private void removeMarker(DelegatingMarker marker) {
        ClusterMarker cluster = this.markers.remove(marker);
        if (cluster != null) {
            cluster.remove(marker);
            this.refresh(cluster);
        }
    }

    @Override
    public void onPositionChange(DelegatingMarker marker) {
        if (!marker.isVisible()) {
            return;
        }
        ClusterMarker oldCluster = this.markers.get(marker);
        if (oldCluster != null) {
            oldCluster.remove(marker);
            this.refresh(oldCluster);
        }
        this.addMarker(marker);
    }

    @Override
    public Marker map(com.google.android.gms.maps.model.Marker original) {
        for (ClusterMarker cluster : this.clusters.values()) {
            if (!original.equals((Object)cluster.getVirtual())) continue;
            return cluster;
        }
        return null;
    }

    @Override
    public List<Marker> getDisplayedMarkers() {
        ArrayList<Marker> displayedMarkers = new ArrayList<Marker>();
        for (ClusterMarker cluster : this.clusters.values()) {
            List<? extends Marker> clusterDisplayedMarkers = cluster.getDisplayedMarkers();
            if (clusterDisplayedMarkers == null) continue;
            displayedMarkers.addAll(clusterDisplayedMarkers);
        }
        for (DelegatingMarker marker : this.markers.keySet()) {
            if (this.markers.get(marker) != null) continue;
            displayedMarkers.add(marker);
        }
        return displayedMarkers;
    }

    @Override
    public float getMinZoomLevelNotClustered(Marker marker) {
        int zoom;
        if (!this.markers.containsKey(marker)) {
            throw new UnsupportedOperationException("marker is not visible or is a cluster");
        }
        for (zoom = 0; zoom <= 25 && this.hasCollision(marker, zoom); ++zoom) {
        }
        if (zoom > 25) {
            return Float.POSITIVE_INFINITY;
        }
        return zoom;
    }

    private boolean hasCollision(Marker marker, int zoom) {
        double clusterSize = this.calculateClusterSize(zoom);
        LatLng position = marker.getPosition();
        int x = (int)(SphericalMercator.scaleLongitude(position.longitude) / clusterSize);
        int y = (int)(SphericalMercator.scaleLatitude(position.latitude) / clusterSize);
        for (DelegatingMarker m : this.markers.keySet()) {
            int mY;
            if (m.equals(marker)) continue;
            LatLng mPosition = m.getPosition();
            int mX = (int)(SphericalMercator.scaleLongitude(mPosition.longitude) / clusterSize);
            if (x != mX || y != (mY = (int)(SphericalMercator.scaleLatitude(mPosition.latitude) / clusterSize))) continue;
            return true;
        }
        return false;
    }

    private ClusterMarker findClusterById(ClusterKey key) {
        ClusterMarker cluster = this.clusters.get(key);
        if (cluster == null) {
            cluster = new ClusterMarker(this);
            this.clusters.put(key, cluster);
        }
        return cluster;
    }

    @Override
    public void onVisibilityChangeRequest(DelegatingMarker marker, boolean visible) {
        if (visible) {
            this.addMarker(marker);
        } else {
            this.removeMarker(marker);
            marker.changeVisible(false);
        }
    }

    @Override
    public void onShowInfoWindow(DelegatingMarker marker) {
        if (!marker.isVisible()) {
            return;
        }
        ClusterMarker cluster = this.markers.get(marker);
        if (cluster == null) {
            marker.forceShowInfoWindow();
        } else if (cluster.getMarkersInternal().size() < this.minMarkersCount) {
            cluster.refresh();
            marker.forceShowInfoWindow();
        }
    }

    private void refresh(ClusterMarker cluster) {
        if (cluster != null) {
            this.refresher.refresh(cluster);
        }
    }

    private void addVisibleMarkers(List<DelegatingMarker> markers) {
        if (this.addMarkersDynamically) {
            this.calculateVisibleClusters();
        }
        for (DelegatingMarker marker : markers) {
            if (!marker.isVisible()) continue;
            this.addMarker(marker);
        }
        this.refresher.refreshAll();
    }

    private void recalculate() {
        if (this.addMarkersDynamically) {
            this.calculateVisibleClusters();
        }
        if (this.zoomedIn()) {
            this.splitClusters();
        } else {
            this.joinClusters();
        }
        this.refresher.refreshAll();
    }

    private boolean zoomedIn() {
        return this.zoom > this.oldZoom;
    }

    private void splitClusters() {
        HashMap<ClusterKey, ClusterMarker> newClusters = new HashMap<ClusterKey, ClusterMarker>();
        for (ClusterMarker cluster : this.clusters.values()) {
            int j;
            List<DelegatingMarker> ms = cluster.getMarkersInternal();
            if (ms.isEmpty()) {
                cluster.removeVirtual();
                continue;
            }
            ClusterKey[] clusterIds = new ClusterKey[ms.size()];
            boolean allSame = true;
            for (j = 0; j < ms.size(); ++j) {
                clusterIds[j] = this.calculateClusterKey(ms.get(j).getClusterGroup(), ms.get(j).getPosition());
                if (clusterIds[j].equals(clusterIds[0])) continue;
                allSame = false;
            }
            if (allSame) {
                newClusters.put(clusterIds[0], cluster);
                if (!this.addMarkersDynamically || !this.isPositionInVisibleClusters(cluster.getMarkersInternal().get(0).getPosition())) continue;
                this.refresh(cluster);
                continue;
            }
            cluster.removeVirtual();
            for (j = 0; j < ms.size(); ++j) {
                cluster = (ClusterMarker)newClusters.get(clusterIds[j]);
                if (cluster == null) {
                    cluster = new ClusterMarker(this);
                    newClusters.put(clusterIds[j], cluster);
                    if (!this.addMarkersDynamically || this.isPositionInVisibleClusters(ms.get(j).getPosition())) {
                        this.refresh(cluster);
                    }
                }
                cluster.add(ms.get(j));
                this.markers.put(ms.get(j), cluster);
            }
        }
        this.clusters = newClusters;
    }

    private void joinClusters() {
        HashMap<ClusterKey, ClusterMarker> newClusters = new HashMap<ClusterKey, ClusterMarker>();
        HashMap<ClusterKey, ArrayList<ClusterMarker>> oldClusters = new HashMap<ClusterKey, ArrayList<ClusterMarker>>();
        for (ClusterMarker cluster : this.clusters.values()) {
            List<DelegatingMarker> ms = cluster.getMarkersInternal();
            if (ms.isEmpty()) {
                cluster.removeVirtual();
                continue;
            }
            ClusterKey clusterId = this.calculateClusterKey(ms.get(0).getClusterGroup(), ms.get(0).getPosition());
            ArrayList<ClusterMarker> clusterList = (ArrayList<ClusterMarker>)oldClusters.get(clusterId);
            if (clusterList == null) {
                clusterList = new ArrayList<ClusterMarker>();
                oldClusters.put(clusterId, clusterList);
            }
            clusterList.add(cluster);
        }
        for (ClusterKey key : oldClusters.keySet()) {
            ClusterMarker cluster;
            List clusterList = (List)oldClusters.get(key);
            if (clusterList.size() == 1) {
                cluster = (ClusterMarker)clusterList.get(0);
                newClusters.put(key, cluster);
                if (!this.addMarkersDynamically || !this.isPositionInVisibleClusters(cluster.getMarkersInternal().get(0).getPosition())) continue;
                this.refresh(cluster);
                continue;
            }
            cluster = new ClusterMarker(this);
            newClusters.put(key, cluster);
            if (!this.addMarkersDynamically || this.isPositionInVisibleClusters(((ClusterMarker)clusterList.get(0)).getMarkersInternal().get(0).getPosition())) {
                this.refresh(cluster);
            }
            for (ClusterMarker old : clusterList) {
                old.removeVirtual();
                List<DelegatingMarker> ms = old.getMarkersInternal();
                for (DelegatingMarker m : ms) {
                    cluster.add(m);
                    this.markers.put(m, cluster);
                }
            }
        }
        this.clusters = newClusters;
    }

    private void addMarkersInVisibleRegion() {
        this.calculateVisibleClusters();
        for (DelegatingMarker marker : this.markers.keySet()) {
            LatLng position = marker.getPosition();
            if (!this.isPositionInVisibleClusters(position)) continue;
            ClusterMarker cluster = this.markers.get(marker);
            this.refresh(cluster);
        }
        this.refresher.refreshAll();
    }

    private void calculateVisibleClusters() {
        IProjection projection = this.map.getProjection();
        VisibleRegion visibleRegion = projection.getVisibleRegion();
        LatLngBounds bounds = visibleRegion.latLngBounds;
        this.visibleClusters[0] = this.convLat(bounds.southwest.latitude);
        this.visibleClusters[1] = this.convLng(bounds.southwest.longitude);
        this.visibleClusters[2] = this.convLat(bounds.northeast.latitude);
        this.visibleClusters[3] = this.convLng(bounds.northeast.longitude);
    }

    private ClusterKey calculateClusterKey(int group, LatLng position) {
        int y = this.convLat(position.latitude);
        int x = this.convLng(position.longitude);
        return new ClusterKey(group, y, x);
    }

    private int convLat(double lat) {
        return (int)(SphericalMercator.scaleLatitude(lat) / this.clusterSize);
    }

    private int convLng(double lng) {
        return (int)(SphericalMercator.scaleLongitude(lng) / this.clusterSize);
    }

    private double calculateClusterSize(int zoom) {
        return this.baseClusterSize / (double)(1 << zoom);
    }

    com.google.android.gms.maps.model.Marker createMarker(List<Marker> markers, LatLng position) {
        this.markerOptions.position(position);
        ClusterOptions opts = this.clusterOptionsProvider.getClusterOptions(markers);
        this.markerOptions.icon(opts.getIcon());
        if (GOOGLE_PLAY_SERVICES_4_0) {
            try {
                this.markerOptions.alpha(opts.getAlpha());
            }
            catch (NoSuchMethodError error) {
                GOOGLE_PLAY_SERVICES_4_0 = false;
            }
        }
        this.markerOptions.anchor(opts.getAnchorU(), opts.getAnchorV());
        this.markerOptions.flat(opts.isFlat());
        this.markerOptions.infoWindowAnchor(opts.getInfoWindowAnchorU(), opts.getInfoWindowAnchorV());
        this.markerOptions.rotation(opts.getRotation());
        if (GOOGLE_PLAY_SERVICES_9_2) {
            try {
                this.markerOptions.zIndex(opts.getZIndex());
            }
            catch (NoSuchMethodError error) {
                GOOGLE_PLAY_SERVICES_9_2 = false;
            }
        }
        return this.map.addMarker(this.markerOptions);
    }

    int getMinMarkersCount() {
        return this.minMarkersCount;
    }

    private static class ClusterKey {
        private final int group;
        private final int latitudeId;
        private final int longitudeId;

        public ClusterKey(int group, int latitudeId, int longitudeId) {
            this.group = group;
            this.latitudeId = latitudeId;
            this.longitudeId = longitudeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterKey that = (ClusterKey)o;
            if (this.group != that.group) {
                return false;
            }
            if (this.latitudeId != that.latitudeId) {
                return false;
            }
            return this.longitudeId == that.longitudeId;
        }

        public int hashCode() {
            int result = this.group;
            result = 31 * result + this.latitudeId;
            result = 31 * result + this.longitudeId;
            return result;
        }
    }
}

