/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions.impl;

import com.androidmapsextensions.AnimationSettings;
import com.androidmapsextensions.Marker;
import com.androidmapsextensions.impl.MarkerManager;
import com.androidmapsextensions.lazy.LazyMarker;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import java.util.List;

class DelegatingMarker
implements Marker {
    private LazyMarker real;
    private MarkerManager manager;
    private int clusterGroup;
    private Object data;
    private LatLng position;
    private boolean visible;

    DelegatingMarker(LazyMarker real, MarkerManager manager) {
        this.real = real;
        this.manager = manager;
        this.position = real.getPosition();
        this.visible = real.isVisible();
    }

    @Override
    public void animatePosition(LatLng target) {
        this.animatePosition(target, new AnimationSettings(), null);
    }

    @Override
    public void animatePosition(LatLng target, AnimationSettings settings) {
        this.animatePosition(target, settings, null);
    }

    @Override
    public void animatePosition(LatLng target, Marker.AnimationCallback callback) {
        this.animatePosition(target, new AnimationSettings(), callback);
    }

    @Override
    public void animatePosition(LatLng target, AnimationSettings settings, Marker.AnimationCallback callback) {
        if (target == null || settings == null) {
            throw new IllegalArgumentException();
        }
        this.manager.onAnimateMarkerPosition(this, target, settings, callback);
    }

    @Override
    public float getAlpha() {
        return this.real.getAlpha();
    }

    @Override
    public int getClusterGroup() {
        return this.clusterGroup;
    }

    public Object getData() {
        return this.data;
    }

    @Override
    @Deprecated
    public String getId() {
        return this.real.getId();
    }

    @Override
    public List<Marker> getMarkers() {
        return null;
    }

    @Override
    public LatLng getPosition() {
        if (this.position == null) {
            this.position = this.real.getPosition();
        }
        return this.position;
    }

    @Override
    public float getRotation() {
        return this.real.getRotation();
    }

    @Override
    public String getSnippet() {
        return this.real.getSnippet();
    }

    @Override
    @Deprecated
    public Object getTag() {
        return this.real.getTag();
    }

    @Override
    public String getTitle() {
        return this.real.getTitle();
    }

    @Override
    public float getZIndex() {
        return this.real.getZIndex();
    }

    @Override
    public void hideInfoWindow() {
        this.real.hideInfoWindow();
    }

    @Override
    public boolean isCluster() {
        return false;
    }

    @Override
    public boolean isDraggable() {
        return this.real.isDraggable();
    }

    @Override
    public boolean isFlat() {
        return this.real.isFlat();
    }

    @Override
    public boolean isInfoWindowShown() {
        return this.real.isInfoWindowShown();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void remove() {
        this.manager.onRemove(this);
        this.real.remove();
    }

    @Override
    public void setAlpha(float alpha) {
        this.real.setAlpha(alpha);
    }

    @Override
    public void setAnchor(float anchorU, float anchorV) {
        this.real.setAnchor(anchorU, anchorV);
    }

    @Override
    public void setClusterGroup(int clusterGroup) {
        if (this.clusterGroup != clusterGroup) {
            this.clusterGroup = clusterGroup;
            this.manager.onClusterGroupChange(this);
        }
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public void setDraggable(boolean draggable) {
        this.real.setDraggable(draggable);
    }

    @Override
    public void setFlat(boolean flat) {
        this.real.setFlat(flat);
    }

    @Override
    public void setIcon(BitmapDescriptor icon) {
        this.real.setIcon(icon);
    }

    @Override
    public void setInfoWindowAnchor(float anchorU, float anchorV) {
        this.real.setInfoWindowAnchor(anchorU, anchorV);
    }

    @Override
    public void setPosition(LatLng position) {
        this.position = position;
        this.real.setPosition(position);
        this.manager.onPositionChange(this);
    }

    void setPositionDuringAnimation(LatLng position) {
        this.position = position;
        this.real.setPosition(position);
        this.manager.onPositionDuringAnimationChange(this);
    }

    @Override
    public void setRotation(float rotation) {
        this.real.setRotation(rotation);
    }

    @Override
    public void setSnippet(String snippet) {
        this.real.setSnippet(snippet);
    }

    @Override
    @Deprecated
    public void setTag(Object tag) {
        this.real.setTag(tag);
    }

    @Override
    public void setTitle(String title) {
        this.real.setTitle(title);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            this.manager.onVisibilityChangeRequest(this, visible);
        }
    }

    @Override
    public void setZIndex(float zIndex) {
        this.real.zIndex(zIndex);
    }

    @Override
    public void showInfoWindow() {
        this.manager.onShowInfoWindow(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DelegatingMarker)) {
            return false;
        }
        DelegatingMarker other = (DelegatingMarker)o;
        return this.real.equals(other.real);
    }

    public int hashCode() {
        return this.real.hashCode();
    }

    public String toString() {
        return this.real.toString();
    }

    LazyMarker getReal() {
        return this.real;
    }

    void changeVisible(boolean visible) {
        this.real.setVisible(this.visible && visible);
    }

    void clearCachedPosition() {
        this.position = null;
    }

    void forceShowInfoWindow() {
        this.real.showInfoWindow();
    }

    void setVirtualPosition(LatLng position) {
        this.real.setPosition(position);
    }
}

