/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions.impl;

import android.content.Context;
import android.graphics.Bitmap;
import android.location.Location;
import android.view.View;
import com.androidmapsextensions.Circle;
import com.androidmapsextensions.CircleOptions;
import com.androidmapsextensions.ClusteringSettings;
import com.androidmapsextensions.DefaultClusterOptionsProvider;
import com.androidmapsextensions.GoogleMap;
import com.androidmapsextensions.GroundOverlay;
import com.androidmapsextensions.GroundOverlayOptions;
import com.androidmapsextensions.Marker;
import com.androidmapsextensions.MarkerOptions;
import com.androidmapsextensions.Polygon;
import com.androidmapsextensions.PolygonOptions;
import com.androidmapsextensions.Polyline;
import com.androidmapsextensions.PolylineOptions;
import com.androidmapsextensions.TileOverlay;
import com.androidmapsextensions.TileOverlayOptions;
import com.androidmapsextensions.impl.CircleManager;
import com.androidmapsextensions.impl.DelegatingMarker;
import com.androidmapsextensions.impl.GroundOverlayManager;
import com.androidmapsextensions.impl.IGoogleMap;
import com.androidmapsextensions.impl.MarkerManager;
import com.androidmapsextensions.impl.PolygonManager;
import com.androidmapsextensions.impl.PolylineManager;
import com.androidmapsextensions.impl.TileOverlayManager;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.LocationSource;
import com.google.android.gms.maps.Projection;
import com.google.android.gms.maps.UiSettings;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.MapStyleOptions;
import java.util.List;

class DelegatingGoogleMap
implements GoogleMap {
    private IGoogleMap real;
    private Context context;
    private GoogleMap.InfoWindowAdapter infoWindowAdapter;
    private GoogleMap.OnCameraChangeListener onCameraChangeListener;
    private GoogleMap.OnMarkerDragListener onMarkerDragListener;
    private MarkerManager markerManager;
    private PolylineManager polylineManager;
    private PolygonManager polygonManager;
    private CircleManager circleManager;
    private GroundOverlayManager groundOverlayManager;
    private TileOverlayManager tileOverlayManager;

    DelegatingGoogleMap(IGoogleMap real, Context context) {
        this.real = real;
        this.context = context;
        this.createManagers();
        this.assignMapListeners();
    }

    @Override
    public Circle addCircle(CircleOptions circleOptions) {
        return this.circleManager.addCircle(circleOptions);
    }

    @Override
    public GroundOverlay addGroundOverlay(GroundOverlayOptions groundOverlayOptions) {
        return this.groundOverlayManager.addGroundOverlay(groundOverlayOptions);
    }

    @Override
    public Marker addMarker(MarkerOptions markerOptions) {
        return this.markerManager.addMarker(markerOptions);
    }

    @Override
    public Polygon addPolygon(PolygonOptions polygonOptions) {
        return this.polygonManager.addPolygon(polygonOptions);
    }

    @Override
    public Polyline addPolyline(PolylineOptions polylineOptions) {
        return this.polylineManager.addPolyline(polylineOptions);
    }

    @Override
    public TileOverlay addTileOverlay(TileOverlayOptions tileOverlayOptions) {
        return this.tileOverlayManager.addTileOverlay(tileOverlayOptions);
    }

    @Override
    public void animateCamera(CameraUpdate cameraUpdate, GoogleMap.CancelableCallback cancelableCallback) {
        this.real.animateCamera(cameraUpdate, cancelableCallback);
    }

    @Override
    public void animateCamera(CameraUpdate cameraUpdate, int time, GoogleMap.CancelableCallback cancelableCallback) {
        this.real.animateCamera(cameraUpdate, time, cancelableCallback);
    }

    @Override
    public void animateCamera(CameraUpdate cameraUpdate) {
        this.real.animateCamera(cameraUpdate);
    }

    @Override
    public void clear() {
        this.real.clear();
        this.clearManagers();
    }

    @Override
    public CameraPosition getCameraPosition() {
        return this.real.getCameraPosition();
    }

    @Override
    public List<Marker> getDisplayedMarkers() {
        return this.markerManager.getDisplayedMarkers();
    }

    @Override
    public int getMapType() {
        return this.real.getMapType();
    }

    @Override
    public List<Circle> getCircles() {
        return this.circleManager.getCircles();
    }

    @Override
    public List<GroundOverlay> getGroundOverlays() {
        return this.groundOverlayManager.getGroundOverlays();
    }

    @Override
    public List<Marker> getMarkers() {
        return this.markerManager.getMarkers();
    }

    @Override
    public Marker getMarkerShowingInfoWindow() {
        return this.markerManager.getMarkerShowingInfoWindow();
    }

    @Override
    public List<Polygon> getPolygons() {
        return this.polygonManager.getPolygons();
    }

    @Override
    public List<Polyline> getPolylines() {
        return this.polylineManager.getPolylines();
    }

    @Override
    public List<TileOverlay> getTileOverlays() {
        return this.tileOverlayManager.getTileOverlays();
    }

    @Override
    public float getMaxZoomLevel() {
        return this.real.getMaxZoomLevel();
    }

    @Override
    public float getMinZoomLevel() {
        return this.real.getMinZoomLevel();
    }

    @Override
    public float getMinZoomLevelNotClustered(Marker marker) {
        return this.markerManager.getMinZoomLevelNotClustered(marker);
    }

    @Override
    public Location getMyLocation() {
        return this.real.getMyLocation();
    }

    @Override
    public Projection getProjection() {
        return this.real.getProjection().getProjection();
    }

    @Override
    public UiSettings getUiSettings() {
        return this.real.getUiSettings();
    }

    @Override
    public boolean isBuildingsEnabled() {
        return this.real.isBuildingsEnabled();
    }

    @Override
    public boolean isIndoorEnabled() {
        return this.real.isIndoorEnabled();
    }

    @Override
    public boolean isMyLocationEnabled() {
        return this.real.isMyLocationEnabled();
    }

    @Override
    public boolean isTrafficEnabled() {
        return this.real.isTrafficEnabled();
    }

    @Override
    public void moveCamera(CameraUpdate cameraUpdate) {
        this.real.moveCamera(cameraUpdate);
    }

    @Override
    public void resetMinMaxZoomPreference() {
        this.real.resetMinMaxZoomPreference();
    }

    @Override
    public void setBuildingsEnabled(boolean buildingsEnabled) {
        this.real.setBuildingsEnabled(buildingsEnabled);
    }

    @Override
    public void setClustering(ClusteringSettings clusteringSettings) {
        if (clusteringSettings != null && clusteringSettings.isEnabled() && clusteringSettings.getClusterOptionsProvider() == null) {
            clusteringSettings.clusterOptionsProvider(new DefaultClusterOptionsProvider(this.context.getResources()));
        }
        this.markerManager.setClustering(clusteringSettings);
    }

    @Override
    public boolean setIndoorEnabled(boolean indoorEnabled) {
        return this.real.setIndoorEnabled(indoorEnabled);
    }

    @Override
    public void setInfoWindowAdapter(GoogleMap.InfoWindowAdapter infoWindowAdapter) {
        this.infoWindowAdapter = infoWindowAdapter;
    }

    @Override
    public void setLatLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.real.setLatLngBoundsForCameraTarget(latLngBounds);
    }

    @Override
    public void setLocationSource(LocationSource locationSource) {
        this.real.setLocationSource(locationSource);
    }

    @Override
    public boolean setMapStyle(MapStyleOptions mapStyleOptions) {
        return this.real.setMapStyle(mapStyleOptions);
    }

    @Override
    public void setMapType(int mapType) {
        this.real.setMapType(mapType);
    }

    @Override
    public void setMaxZoomPreference(float maxZoomPreference) {
        this.real.setMaxZoomPreference(maxZoomPreference);
    }

    @Override
    public void setMinZoomPreference(float minZoomPreference) {
        this.real.setMinZoomPreference(minZoomPreference);
    }

    @Override
    public void setMyLocationEnabled(boolean myLocationEnabled) {
        this.real.setMyLocationEnabled(myLocationEnabled);
    }

    @Override
    public void setOnCameraChangeListener(GoogleMap.OnCameraChangeListener onCameraChangeListener) {
        this.onCameraChangeListener = onCameraChangeListener;
    }

    @Override
    public void setOnCameraIdleListener(GoogleMap.OnCameraIdleListener onCameraIdleListener) {
        this.real.setOnCameraIdleListener(onCameraIdleListener);
    }

    @Override
    public void setOnCameraMoveCanceledListener(GoogleMap.OnCameraMoveCanceledListener onCameraMoveCanceledListener) {
        this.real.setOnCameraMoveCanceledListener(onCameraMoveCanceledListener);
    }

    @Override
    public void setOnCameraMoveListener(GoogleMap.OnCameraMoveListener onCameraMoveListener) {
        this.real.setOnCameraMoveListener(onCameraMoveListener);
    }

    @Override
    public void setOnCameraMoveStartedListener(GoogleMap.OnCameraMoveStartedListener onCameraMoveStartedListener) {
        this.real.setOnCameraMoveStartedListener(onCameraMoveStartedListener);
    }

    @Override
    public void setOnCircleClickListener(GoogleMap.OnCircleClickListener onCircleClickListener) {
        this.circleManager.setOnCircleClickListener(onCircleClickListener);
    }

    @Override
    public void setOnGroundOverlayClickListener(GoogleMap.OnGroundOverlayClickListener onGroundOverlayClickListener) {
        this.groundOverlayManager.setOnGroundOverlayClickListener(onGroundOverlayClickListener);
    }

    @Override
    public void setOnInfoWindowClickListener(GoogleMap.OnInfoWindowClickListener onInfoWindowClickListener) {
        DelegatingOnInfoWindowClickListener realOnInfoWindowClickListener = null;
        if (onInfoWindowClickListener != null) {
            realOnInfoWindowClickListener = new DelegatingOnInfoWindowClickListener(onInfoWindowClickListener);
        }
        this.real.setOnInfoWindowClickListener(realOnInfoWindowClickListener);
    }

    @Override
    public void setOnInfoWindowCloseListener(GoogleMap.OnInfoWindowCloseListener onInfoWindowCloseListener) {
        DelegatingOnInfoWindowCloseListener realOnInfoWindowCloseListener = null;
        if (onInfoWindowCloseListener != null) {
            realOnInfoWindowCloseListener = new DelegatingOnInfoWindowCloseListener(onInfoWindowCloseListener);
        }
        this.real.setOnInfoWindowCloseListener(realOnInfoWindowCloseListener);
    }

    @Override
    public void setOnInfoWindowLongClickListener(GoogleMap.OnInfoWindowLongClickListener onInfoWindowLongClickListener) {
        DelegatingOnInfoWindowLongClickListener realOnInfoWindowLongClickListener = null;
        if (onInfoWindowLongClickListener != null) {
            realOnInfoWindowLongClickListener = new DelegatingOnInfoWindowLongClickListener(onInfoWindowLongClickListener);
        }
        this.real.setOnInfoWindowLongClickListener(realOnInfoWindowLongClickListener);
    }

    @Override
    public void setOnMapClickListener(GoogleMap.OnMapClickListener onMapClickListener) {
        this.real.setOnMapClickListener(onMapClickListener);
    }

    @Override
    public void setOnMapLoadedCallback(GoogleMap.OnMapLoadedCallback onMapLoadedCallback) {
        this.real.setOnMapLoadedCallback(onMapLoadedCallback);
    }

    @Override
    public void setOnMapLongClickListener(GoogleMap.OnMapLongClickListener onMapLongClickListener) {
        this.real.setOnMapLongClickListener(onMapLongClickListener);
    }

    @Override
    public void setOnMarkerClickListener(GoogleMap.OnMarkerClickListener onMarkerClickListener) {
        DelegatingOnMarkerClickListener realOnMarkerClickListener = null;
        if (onMarkerClickListener != null) {
            realOnMarkerClickListener = new DelegatingOnMarkerClickListener(onMarkerClickListener);
        }
        this.real.setOnMarkerClickListener(realOnMarkerClickListener);
    }

    @Override
    public void setOnMarkerDragListener(GoogleMap.OnMarkerDragListener onMarkerDragListener) {
        this.onMarkerDragListener = onMarkerDragListener;
    }

    @Override
    public void setOnMyLocationButtonClickListener(GoogleMap.OnMyLocationButtonClickListener listener) {
        this.real.setOnMyLocationButtonClickListener(listener);
    }

    @Override
    public void setOnMyLocationChangeListener(GoogleMap.OnMyLocationChangeListener onMyLocationChangeListener) {
        this.real.setOnMyLocationChangeListener(onMyLocationChangeListener);
    }

    @Override
    public void setOnPoiClickListener(GoogleMap.OnPoiClickListener onPoiClickListener) {
        this.real.setOnPoiClickListener(onPoiClickListener);
    }

    @Override
    public void setOnPolygonClickListener(GoogleMap.OnPolygonClickListener onPolygonClickListener) {
        this.polygonManager.setOnPolygonClickListener(onPolygonClickListener);
    }

    @Override
    public void setOnPolylineClickListener(GoogleMap.OnPolylineClickListener onPolylineClickListener) {
        this.polylineManager.setOnPolylineClickListener(onPolylineClickListener);
    }

    @Override
    public void setPadding(int left, int top, int right, int bottom) {
        this.real.setPadding(left, top, right, bottom);
    }

    @Override
    public void setTrafficEnabled(boolean trafficEnabled) {
        this.real.setTrafficEnabled(trafficEnabled);
    }

    @Override
    public void snapshot(GoogleMap.SnapshotReadyCallback callback) {
        this.real.snapshot(callback);
    }

    @Override
    public void snapshot(GoogleMap.SnapshotReadyCallback callback, Bitmap bitmap) {
        this.real.snapshot(callback, bitmap);
    }

    @Override
    public void stopAnimation() {
        this.real.stopAnimation();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DelegatingGoogleMap)) {
            return false;
        }
        DelegatingGoogleMap other = (DelegatingGoogleMap)o;
        return this.real.equals(other.real);
    }

    public int hashCode() {
        return this.real.hashCode();
    }

    public String toString() {
        return this.real.toString();
    }

    private void createManagers() {
        this.markerManager = new MarkerManager(this.real);
        this.polylineManager = new PolylineManager(this.real);
        this.polygonManager = new PolygonManager(this.real);
        this.circleManager = new CircleManager(this.real);
        this.groundOverlayManager = new GroundOverlayManager(this.real);
        this.tileOverlayManager = new TileOverlayManager(this.real);
    }

    private void clearManagers() {
        this.markerManager.clear();
        this.polylineManager.clear();
        this.polygonManager.clear();
        this.circleManager.clear();
        this.groundOverlayManager.clear();
        this.tileOverlayManager.clear();
    }

    private void assignMapListeners() {
        this.real.setInfoWindowAdapter(new DelegatingInfoWindowAdapter());
        this.real.setOnCameraChangeListener(new DelegatingOnCameraChangeListener());
        this.real.setOnMarkerDragListener(new DelegatingOnMarkerDragListener());
    }

    private class DelegatingOnMarkerDragListener
    implements GoogleMap.OnMarkerDragListener {
        private DelegatingOnMarkerDragListener() {
        }

        public void onMarkerDragStart(com.google.android.gms.maps.model.Marker marker) {
            DelegatingMarker delegating = DelegatingGoogleMap.this.markerManager.mapToDelegatingMarker(marker);
            delegating.clearCachedPosition();
            DelegatingGoogleMap.this.markerManager.onDragStart(delegating);
            if (DelegatingGoogleMap.this.onMarkerDragListener != null) {
                DelegatingGoogleMap.this.onMarkerDragListener.onMarkerDragStart(delegating);
            }
        }

        public void onMarkerDrag(com.google.android.gms.maps.model.Marker marker) {
            DelegatingMarker delegating = DelegatingGoogleMap.this.markerManager.mapToDelegatingMarker(marker);
            delegating.clearCachedPosition();
            if (DelegatingGoogleMap.this.onMarkerDragListener != null) {
                DelegatingGoogleMap.this.onMarkerDragListener.onMarkerDrag(delegating);
            }
        }

        public void onMarkerDragEnd(com.google.android.gms.maps.model.Marker marker) {
            DelegatingMarker delegating = DelegatingGoogleMap.this.markerManager.mapToDelegatingMarker(marker);
            delegating.clearCachedPosition();
            DelegatingGoogleMap.this.markerManager.onPositionChange(delegating);
            if (DelegatingGoogleMap.this.onMarkerDragListener != null) {
                DelegatingGoogleMap.this.onMarkerDragListener.onMarkerDragEnd(delegating);
            }
        }
    }

    private class DelegatingOnMarkerClickListener
    implements GoogleMap.OnMarkerClickListener {
        private final GoogleMap.OnMarkerClickListener onMarkerClickListener;

        public DelegatingOnMarkerClickListener(GoogleMap.OnMarkerClickListener onMarkerClickListener) {
            this.onMarkerClickListener = onMarkerClickListener;
        }

        public boolean onMarkerClick(com.google.android.gms.maps.model.Marker marker) {
            return this.onMarkerClickListener.onMarkerClick(DelegatingGoogleMap.this.markerManager.map(marker));
        }
    }

    private class DelegatingOnInfoWindowLongClickListener
    implements GoogleMap.OnInfoWindowLongClickListener {
        private final GoogleMap.OnInfoWindowLongClickListener onInfoWindowLongClickListener;

        public DelegatingOnInfoWindowLongClickListener(GoogleMap.OnInfoWindowLongClickListener onInfoWindowLongClickListener) {
            this.onInfoWindowLongClickListener = onInfoWindowLongClickListener;
        }

        public void onInfoWindowLongClick(com.google.android.gms.maps.model.Marker marker) {
            this.onInfoWindowLongClickListener.onInfoWindowLongClick(DelegatingGoogleMap.this.markerManager.map(marker));
        }
    }

    private class DelegatingOnInfoWindowCloseListener
    implements GoogleMap.OnInfoWindowCloseListener {
        private final GoogleMap.OnInfoWindowCloseListener onInfoWindowCloseListener;

        public DelegatingOnInfoWindowCloseListener(GoogleMap.OnInfoWindowCloseListener onInfoWindowCloseListener) {
            this.onInfoWindowCloseListener = onInfoWindowCloseListener;
        }

        public void onInfoWindowClose(com.google.android.gms.maps.model.Marker marker) {
            this.onInfoWindowCloseListener.onInfoWindowClose(DelegatingGoogleMap.this.markerManager.map(marker));
        }
    }

    private class DelegatingOnInfoWindowClickListener
    implements GoogleMap.OnInfoWindowClickListener {
        private final GoogleMap.OnInfoWindowClickListener onInfoWindowClickListener;

        public DelegatingOnInfoWindowClickListener(GoogleMap.OnInfoWindowClickListener onInfoWindowClickListener) {
            this.onInfoWindowClickListener = onInfoWindowClickListener;
        }

        public void onInfoWindowClick(com.google.android.gms.maps.model.Marker marker) {
            this.onInfoWindowClickListener.onInfoWindowClick(DelegatingGoogleMap.this.markerManager.map(marker));
        }
    }

    private class DelegatingInfoWindowAdapter
    implements GoogleMap.InfoWindowAdapter {
        private DelegatingInfoWindowAdapter() {
        }

        public View getInfoWindow(com.google.android.gms.maps.model.Marker marker) {
            Marker mapped = DelegatingGoogleMap.this.markerManager.map(marker);
            DelegatingGoogleMap.this.markerManager.setMarkerShowingInfoWindow(mapped);
            if (DelegatingGoogleMap.this.infoWindowAdapter != null) {
                return DelegatingGoogleMap.this.infoWindowAdapter.getInfoWindow(mapped);
            }
            return null;
        }

        public View getInfoContents(com.google.android.gms.maps.model.Marker marker) {
            if (DelegatingGoogleMap.this.infoWindowAdapter != null) {
                return DelegatingGoogleMap.this.infoWindowAdapter.getInfoContents(DelegatingGoogleMap.this.markerManager.map(marker));
            }
            return null;
        }
    }

    private class DelegatingOnCameraChangeListener
    implements GoogleMap.OnCameraChangeListener {
        private DelegatingOnCameraChangeListener() {
        }

        public void onCameraChange(CameraPosition cameraPosition) {
            DelegatingGoogleMap.this.markerManager.onCameraChange(cameraPosition);
            if (DelegatingGoogleMap.this.onCameraChangeListener != null) {
                DelegatingGoogleMap.this.onCameraChangeListener.onCameraChange(cameraPosition);
            }
        }
    }
}

