/*
 * Decompiled with CFR 0.152.
 */
package com.androidmapsextensions.impl;

import com.androidmapsextensions.impl.IGoogleMap;
import com.androidmapsextensions.impl.IProjection;
import com.androidmapsextensions.utils.SphericalMercator;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import java.util.ArrayList;
import java.util.List;

class DebugHelper {
    private List<Polyline> gridLines = new ArrayList<Polyline>();

    DebugHelper() {
    }

    void drawDebugGrid(IGoogleMap map, double clusterSize) {
        double x;
        this.cleanup();
        IProjection projection = map.getProjection();
        LatLngBounds bounds = projection.getVisibleRegion().latLngBounds;
        double minY = -180.0 + clusterSize * (double)((int)(SphericalMercator.scaleLatitude(bounds.southwest.latitude) / clusterSize));
        double minX = -180.0 + clusterSize * (double)((int)(SphericalMercator.scaleLongitude(bounds.southwest.longitude) / clusterSize));
        double maxY = -180.0 + clusterSize * (double)((int)(SphericalMercator.scaleLatitude(bounds.northeast.latitude) / clusterSize));
        double maxX = -180.0 + clusterSize * (double)((int)(SphericalMercator.scaleLongitude(bounds.northeast.longitude) / clusterSize));
        for (double y = minY; y <= maxY; y += clusterSize) {
            this.gridLines.add(map.addPolyline(new PolylineOptions().width(1.0f).add(new LatLng[]{new LatLng(SphericalMercator.toLatitude(y), bounds.southwest.longitude), new LatLng(SphericalMercator.toLatitude(y), bounds.northeast.longitude)})));
        }
        if (minX <= maxX) {
            for (x = minX; x <= maxX; x += clusterSize) {
                this.gridLines.add(map.addPolyline(new PolylineOptions().width(1.0f).add(new LatLng[]{new LatLng(bounds.southwest.latitude, x), new LatLng(bounds.northeast.latitude, x)})));
            }
        } else {
            for (x = -180.0; x <= minX; x += clusterSize) {
                this.gridLines.add(map.addPolyline(new PolylineOptions().width(1.0f).add(new LatLng[]{new LatLng(bounds.southwest.latitude, x), new LatLng(bounds.northeast.latitude, x)})));
            }
            for (x = maxX; x < 180.0; x += clusterSize) {
                this.gridLines.add(map.addPolyline(new PolylineOptions().width(1.0f).add(new LatLng[]{new LatLng(bounds.southwest.latitude, x), new LatLng(bounds.northeast.latitude, x)})));
            }
        }
    }

    void cleanup() {
        for (Polyline polyline : this.gridLines) {
            polyline.remove();
        }
        this.gridLines.clear();
    }
}

